/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import ctool.Loader;
import java.awt.Component;
import java.awt.Cursor;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.JLayeredPane;
import util.Common;
import util.gui.frames.CFrame;
import util.gui.frames.CSplitLayout;
import util.gui.frames.FFileInfoRender;
import util.gui.frames.FFileTreeRender;
import util.struct.DArchive;
import util.struct.DFormat;
import util.struct.DPath;

public class CArchiveFrame
extends CFrame {
    private CLayoutPane layoutPane = new CLayoutPane();
    private FFileTreeRender treePane;
    private FFileInfoRender infoPane;

    public CArchiveFrame(DFormat format) {
        super(format);
        this.add(this.layoutPane);
        this.treePane = new FFileTreeRender();
        this.treePane.addPropertyChangeListener("selected", new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CArchiveFrame.this.infoPane.setPath(CArchiveFrame.this.treePane.getSelectedPath());
            }
        });
        this.layoutPane.add(this.treePane);
        this.infoPane = new FFileInfoRender();
        this.layoutPane.add((Component)this.infoPane, "South");
        this.getToolBar().addButton(5000);
    }

    public DArchive getFormat() {
        return (DArchive)super.getFormat();
    }

    public void setProperties() {
        super.setProperties();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (!name.equals("")) {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
    }

    private boolean isLoaded() {
        return this.treePane.getSelectedPath() != null;
    }

    public void update() {
        if (!this.isLoaded()) {
            this.refresh();
        }
    }

    private void refresh() {
        this.treePane.setData(this.getFormat());
    }

    public boolean doAction(int action) {
        DPath path = this.treePane.getSelectedPath();
        boolean accept = true;
        switch (action) {
            case 4000: {
                if (!path.getFile().isFile() || path.getPathName().equals(this.getFormat().getPath().getPathName())) break;
                Common.msg("Opening..." + path);
                Loader.add(path);
                break;
            }
            case 5000: {
                DPath formatPath = this.getFormat().getPath();
                String saveFolder = formatPath.getParentName();
                if (this.treePane.getSelectedIndex() == 0) {
                    this.getFormat().extractFolder(saveFolder + "\\" + formatPath.getFile().getName(), this.getFormat().getFolder(0), 1);
                } else if (path.getFile().isFolder()) {
                    this.getFormat().extractFolder(saveFolder, this.getFormat().getFolder(path.getFile().getReference()), 1);
                } else {
                    this.getFormat().extractFile(saveFolder, path, 0);
                }
                this.getFormat().resetSettings();
                break;
            }
            default: {
                accept = false;
            }
        }
        return accept;
    }

    private class CLayoutPane
    extends JLayeredPane {
        public CLayoutPane() {
            this.setLayout(new CSplitLayout(this));
            this.setBorder(BorderFactory.createEmptyBorder(4, 3, 4, 3));
        }

        public void setCursor(Cursor cursor) {
            CArchiveFrame.this.getFrame().setCursor(cursor);
        }
    }
}

