/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.Graphics;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import util.CAction;
import util.CClipboard;
import util.CProperty;
import util.gui.CDesktop;
import util.gui.frames.CFrame;
import util.gui.frames.FImageRender;
import util.struct.CAnimBank;
import util.struct.CAnimBuffer;
import util.struct.CCellBuffer;
import util.struct.DAnim;
import util.struct.DCell;
import util.struct.DFormat;
import util.struct.DGraphic;
import util.struct.DPalette;

public class CAnimFrame
extends CFrame {
    private FImageRender display;
    private Thread playbackThread;
    private boolean toggleAlpha = true;
    private boolean toggleOutline = false;
    private boolean toggleRender = true;
    private int selectedFrame;
    private CAnimBuffer buffer = new CAnimBuffer();

    public CAnimFrame(DFormat format) {
        super(format);
        this.display = new FImageRender();
        this.playbackThread = new PlaybackThread();
        this.add(this.display);
        this.setAnim(this.getFormat());
        this.setCell((DCell)this.getAsset(7, null));
        this.setImage((DGraphic)this.getAsset(6, null));
        this.setPalette((DPalette)this.getAsset(5, null));
        this.getToolBar().addComboBox(CProperty.SELECTED_ANIM_INDEX, "Animation", "Animation Index");
        this.getToolBar().addSeparator();
        this.getToolBar().addToggle(2000, CProperty.ALPHA);
        this.getToolBar().addToggle(3002, CProperty.CELL_OUTLINE);
        this.getToolBar().addToggle(3003, CProperty.CELL_RENDER);
    }

    public DAnim getFormat() {
        return (DAnim)super.getFormat();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (name.equals(CProperty.ALPHA.getName())) {
            this.toggleAlpha = (Boolean)value;
            this.buffer();
        } else if (name.equals(CProperty.CELL_OUTLINE.getName())) {
            this.toggleOutline = (Boolean)value;
        } else if (name.equals(CProperty.CELL_RENDER.getName())) {
            this.toggleRender = (Boolean)value;
        } else if (!name.equals(CProperty.FRAMES.getName()) && !name.equals(CProperty.TOTAL_FRAMES.getName())) {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
        boolean paletteChange = name.equals(CProperty.SELECTED_PALETTE.getName());
        boolean imageChange = name.equals(CProperty.SELECTED_TILE.getName());
        boolean cellChange = name.equals(CProperty.SELECTED_CELL.getName());
        if (paletteChange || imageChange || cellChange) {
            this.buffer();
        }
        if (name.equals(CProperty.SELECTED_ANIM_INDEX.getName())) {
            CDesktop.PANEL_INFO.setModel(this.getAnimBank().getModel());
            this.buffer();
            CProperty.TOTAL_FRAMES.setValue(this.getAnimBank().getItemCount());
            CProperty.SELECTED_FRAME.setValue(0);
            this.update();
        }
        if (name.equals(CProperty.SELECTED_FRAME.getName())) {
            this.selectedFrame = (Integer)value;
        }
    }

    public void setProperties() {
        super.setProperties();
        CProperty.ALPHA.setValue(this.toggleAlpha);
        CProperty.CELL_OUTLINE.setValue(this.toggleOutline);
        CProperty.CELL_RENDER.setValue(this.toggleRender);
        CDesktop.PANEL_INFO.addModel(this.getAnimBank().getModel());
        CProperty.SELECTED_FRAME.setValue(this.selectedFrame);
        this.buffer();
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            case 50: {
                CClipboard.setImage(this.display.getImage());
                break;
            }
            default: {
                accept = false;
            }
        }
        return accept;
    }

    private boolean isTransparent() {
        return this.toggleAlpha;
    }

    private boolean isOutlineEnabled() {
        return this.toggleOutline;
    }

    private boolean isRenderEnabled() {
        return this.toggleRender;
    }

    public void update() {
        if (this.getSelectedIndex() > this.getAnimBank().getItemCount() - 1) {
            this.setSelectedIndex(this.getAnimBank().getItemCount() - 1);
        } else if (this.getSelectedIndex() < 0) {
            this.setSelectedIndex(0);
        }
        if (this.buffer.getFrameCount() > 0 && this.getSelectedIndex() < this.buffer.getFrameCount()) {
            CCellBuffer frame = this.buffer.getFrame(this.getSelectedIndex());
            BufferedImage image = new BufferedImage(frame.getWidth(), frame.getHeight(), 2);
            Graphics g = image.getGraphics();
            if (this.getPaletteBank() != null && this.getImageBank() != null && this.isRenderEnabled()) {
                g.drawImage(frame.getImage(), 0, 0, null);
            }
            if (this.getPaletteBank() == null || this.getImageBank() == null || !this.isRenderEnabled() || this.isOutlineEnabled()) {
                g.drawImage(frame.getOutline(), 0, 0, null);
            }
            this.display.setImage(image);
        }
        CAction.getAction(201).setEnabled(this.getSelectedIndex() > 0);
        CAction.getAction(202).setEnabled(this.getSelectedIndex() > 0);
        CAction.getAction(203).setEnabled(this.getSelectedIndex() < this.getAnimBank().getItemCount() - 1);
        CAction.getAction(204).setEnabled(this.getSelectedIndex() < this.getAnimBank().getItemCount() - 1);
    }

    private void buffer() {
        CAnimBank bank = this.getAnimBank();
        CProperty.TOTAL_FRAMES.setValue(this.getAnimBank().getItemCount());
        this.buffer = this.getAnimBank().getBuffer(this.getPaletteAsset(), this.getImageAsset(), this.getCellAsset(), this.toggleAlpha);
        this.display.setImageSize(this.buffer.getBounds().getSize());
        CProperty.FRAMES.setValue(this.buffer.getThumbs());
    }

    private void setSelectedIndex(int index) {
        CProperty.SELECTED_FRAME.setValue(index);
    }

    private int getSelectedIndex() {
        return (Integer)CProperty.SELECTED_FRAME.getValue();
    }

    private boolean getPlayback() {
        return (Boolean)CProperty.PLAYBACK.getValue();
    }

    private class PlaybackThread
    extends Thread {
        private boolean running = true;

        public PlaybackThread() {
            this.start();
        }

        public void run() {
            while (this.running) {
                if (CAnimFrame.this.isSelected() && CAnimFrame.this.getPlayback() && CAnimFrame.this.buffer.getFrameCount() > 0) {
                    int index = CAnimFrame.this.getSelectedIndex();
                    index = index == CAnimFrame.this.getAnimBank().getItemCount() - 1 ? 0 : ++index;
                    CAnimFrame.this.setSelectedIndex(index);
                    this.doSleep(CAnimFrame.this.getAnimBank().getSelected().getLength());
                    continue;
                }
                this.doSleep(1000L);
            }
        }

        public void doSleep(long millis) {
            try {
                PlaybackThread.sleep(millis);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

