/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.BorderFactory;
import javax.swing.ComboBoxModel;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import util.CAction;
import util.CImageIcon;
import util.CProperty;
import util.gui.panels.CComboBoxModel;

public class CToolBar
extends JToolBar {
    private int dock;
    private int bar;
    private static Font FONT = new Font("Tahoma", 0, 11);

    public CToolBar() {
        this(1);
    }

    public CToolBar(int dock) {
        this.setDock(dock);
        this.setFloatable(false);
        this.setMinimumSize(new Dimension(29, 29));
        this.setPreferredSize(this.getMinimumSize());
        int left = 2;
        int top = 2;
        switch (dock) {
            case 1: {
                top = 2;
                break;
            }
            case 3: {
                left = 3;
            }
        }
        this.setLayout(new FlowLayout(0, left, top));
    }

    public void setDock(int dock) {
        this.dock = dock;
    }

    public int getDock() {
        return this.dock;
    }

    public void setBar(int bar) {
        this.bar = bar;
    }

    public int getBar() {
        return this.bar;
    }

    public void paintComponent(Graphics g) {
        CImageIcon image = new CImageIcon("frame");
        BufferedImage hbar = image.getSubImage(0, 0, 4, 32);
        g.drawImage(hbar, 0, 0, this.getWidth(), this.getHeight(), null);
        this.paintComponents(g);
    }

    public void addSeparator() {
        this.addSeparator(new Dimension(3, 24));
    }

    public CToolBar addLabel(String text) {
        this.add(new CLabel(this, text));
        return this;
    }

    public CToolBar addButton(int action) {
        this.add(new CButton(this, action));
        return this;
    }

    public CToolBar addToggle(int action, CProperty.CPropertyOption property) {
        this.add(new CToggle(this, action, property));
        return this;
    }

    public CToolBar addComboBox(CProperty.CPropertyOption property) {
        this.add(new CComboBox(this, property, null, null));
        return this;
    }

    public CToolBar addComboBox(CProperty.CPropertyOption property, String label, String toolTipText) {
        this.add(new CComboBox(this, property, label, toolTipText));
        return this;
    }

    public void lockSize(JComponent target, int width, int height) {
        target.setSize(width, height);
        target.setPreferredSize(target.getSize());
        target.setMinimumSize(target.getSize());
        target.setMaximumSize(target.getSize());
    }

    public class CComboBox
    extends JComboBox {
        public CComboBox(CToolBar parent, final CProperty.CPropertyOption property, String label, String toolTipText) {
            if (label != null) {
                parent.addLabel(label);
            }
            this.setToolTipText(toolTipText);
            this.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 2));
            CToolBar.this.lockSize(this, 100, 22);
            this.setModel((ComboBoxModel)((CComboBoxModel)property.getValue()));
            this.addItemListener(new ItemListener(){

                public void itemStateChanged(ItemEvent e) {
                    if (e.getStateChange() == 1) {
                        CComboBox combo = (CComboBox)e.getSource();
                        CComboBoxModel model = (CComboBoxModel)combo.getModel();
                        property.setValue(new CComboBoxModel(model));
                    }
                }
            });
            property.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    CComboBox.this.setModel((ComboBoxModel)((CComboBoxModel)evt.getNewValue()));
                }
            });
        }

        public void setModel(ComboBoxModel model) {
            super.setModel(model);
            int width = 0;
            for (int i = 0; i < model.getSize(); ++i) {
                Object value = model.getElementAt(i);
                int twidth = this.getFontMetrics(FONT).stringWidth("" + value);
                if (twidth <= width) continue;
                width = twidth + 35 + this.getInsets().left + this.getInsets().right;
            }
            if (width == 0) {
                width = 100;
            }
            CToolBar.this.lockSize(this, width, this.getHeight());
            if (model.getSize() > 1) {
                this.setEnabled(true);
            } else {
                this.setEnabled(false);
            }
        }
    }

    public class CToggle
    extends JToggleButton {
        public CToggle(CToolBar parent, int action, CProperty.CPropertyOption property) {
            this.setOpaque(false);
            this.setFocusable(false);
            this.setHorizontalAlignment(0);
            this.setAction(CAction.getAction(action));
            this.setSelected((Boolean)property.getValue());
            CToolBar.this.lockSize(this, 22, 24);
            property.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    CToggle.this.setSelected((Boolean)evt.getNewValue());
                }
            });
        }

        public void setText(String text) {
            super.setText("");
        }
    }

    private class CButton
    extends JButton {
        public CButton(CToolBar parent, int action) {
            this.setOpaque(false);
            this.setFocusable(false);
            this.setHorizontalAlignment(0);
            this.setAction(CAction.getAction(action));
            CToolBar.this.lockSize(this, 22, 24);
        }

        public void setText(String text) {
            super.setText("");
        }
    }

    private class CLabel
    extends JLabel {
        public CLabel(CToolBar parent, String text) {
            this.setText(text);
            this.setFont(FONT);
            this.setForeground(new Color(35, 35, 35));
            this.setBorder(BorderFactory.createEmptyBorder(2, 4, 0, 2));
            CToolBar.this.lockSize(this, this.getFontMetrics(FONT).stringWidth(this.getText()) + this.getInsets().left + this.getInsets().right, 22);
        }
    }
}

