/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.event.ContainerAdapter;
import java.awt.event.ContainerEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import util.CImageIcon;
import util.Common;
import util.gui.CButtonBox;
import util.gui.CDesktop;
import util.gui.CDock;
import util.gui.CTab;
import util.gui.CTabPane;
import util.gui.panels.CPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CGroup
extends JLayeredPane {
    private JLayeredPane panelPane;
    private JLayeredPane disablePane;
    private CTabPane tabPane;
    private CGroupButtonBox buttonBox;
    private int dock;
    private int bar;
    private int group;
    private int selectIndex;
    private CPanel selectPanel;
    private Insets insets = new Insets(t.getHeight() + 1, 3, 3, 3);
    private ArrayList<CPanel> panels = new ArrayList();
    private static CImageIcon image = new CImageIcon("group");
    private static BufferedImage tl = image.getSubImage(0, 0, 5, 28);
    private static BufferedImage t = image.getSubImage(6, 0, 5, 28);
    private static BufferedImage tr = image.getSubImage(12, 0, 5, 28);
    private static BufferedImage l = image.getSubImage(0, 29, 5, 4);
    private static BufferedImage fill = image.getSubImage(6, 29, 5, 4);
    private static BufferedImage r = image.getSubImage(12, 29, 5, 4);
    private static BufferedImage bl = image.getSubImage(0, 34, 5, 4);
    private static BufferedImage b = image.getSubImage(6, 34, 5, 4);
    private static BufferedImage br = image.getSubImage(12, 34, 5, 4);

    public CGroup(int dock, int bar, int group) {
        this.dock = dock;
        this.bar = bar;
        this.group = group;
        this.tabPane = new CTabPane();
        this.panelPane = new JLayeredPane();
        this.buttonBox = new CGroupButtonBox(1);
        this.add(this.buttonBox);
        this.add(this.tabPane);
        this.add(this.panelPane);
        this.setMinimumSize(new Dimension(320, 240));
        this.setPreferredSize(this.getMinimumSize());
        this.setSize(this.getPreferredSize());
        this.listeners();
    }

    private void listeners() {
        this.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                return CGroup.this.getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container parent) {
                return CGroup.this.getMinimumSize();
            }

            public void layoutContainer(Container parent) {
                CGroup.this.tabPane.setBounds(((CGroup)CGroup.this).insets.left, 4, CGroup.this.getWidth() - ((CGroup)CGroup.this).insets.left - ((CGroup)CGroup.this).insets.right - 25, t.getHeight() - 4);
                CGroup.this.tabPane.doLayout();
                CGroup.this.panelPane.setBounds(((CGroup)CGroup.this).insets.left, ((CGroup)CGroup.this).insets.top, CGroup.this.getWidth() - ((CGroup)CGroup.this).insets.left - ((CGroup)CGroup.this).insets.right, CGroup.this.getHeight() - ((CGroup)CGroup.this).insets.top - ((CGroup)CGroup.this).insets.bottom);
                CGroup.this.buttonBox.setLocation(CGroup.this.getWidth() - CGroup.this.buttonBox.getWidth() - ((CGroup)CGroup.this).insets.right, 3);
                if (CGroup.this.selectPanel != null) {
                    CGroup.this.selectPanel.setSize(CGroup.this.panelPane.getWidth(), CGroup.this.selectPanel.getHeight());
                    CGroup.this.selectPanel.revalidate();
                }
            }
        });
        this.panelPane.addContainerListener(new ContainerAdapter(){

            public void componentRemoved(ContainerEvent e) {
                if (e.getContainer().getComponentCount() == 0) {
                    CGroup.this.getParentDock().removeGroup(CGroup.this.getThis());
                } else {
                    CGroup.this.setSelectedIndex(CGroup.this.getSelectedIndex());
                }
            }
        });
    }

    @Override
    public String toString() {
        return "Group: " + CDock.getName(this.dock) + "-" + this.bar + "-" + this.group;
    }

    @Override
    public Dimension getMinimumSize() {
        Dimension size = new Dimension(0, 0);
        if (this.selectPanel != null) {
            Dimension panelSize = this.selectPanel.getSize();
            if (panelSize.width > size.width) {
                size.width = panelSize.width;
            }
            if (panelSize.height > size.height) {
                size.height = panelSize.height;
            }
        }
        size.width += this.insets.left + this.insets.right;
        size.height += this.insets.top + this.insets.bottom;
        CDock parent = (CDock)this.getParent();
        if (parent != null && (this.dock == 1 || this.dock == 4)) {
            size.width = parent.getInnerSize().width;
        }
        return size;
    }

    public void addPanel(CPanel panel) {
        if (panel.getParentGroup() != null) {
            panel.getParentGroup().removePanel(panel);
        }
        this.addTab(panel);
        panel.setLocation(this.dock, this.bar, this.group);
        panel.setIndex(this.getPanelCount());
        this.panels.add(panel);
        this.panelPane.add(panel);
        if (this.getPanelCount() == 1) {
            this.setSelected(panel);
            this.setSize(this.getMinimumSize());
        }
        this.revalidate();
    }

    public void removePanel(CPanel panel) {
        this.setSelected(panel);
        this.tabPane.remove(this.getTab(panel));
        this.panels.remove(panel);
        this.panelPane.remove(panel);
        this.checkPanels();
        if (this.getSelected() == panel) {
            this.setSelectedIndex(this.getSelectedIndex());
        }
    }

    private void checkPanels() {
        for (int i = 0; i < this.getPanelCount(); ++i) {
            this.getPanel(i).setIndex(i);
            this.getTab(this.getPanel(i)).setIndex(i);
        }
        this.tabPane.doLayout();
    }

    public CTabPane getTabPane() {
        return this.tabPane;
    }

    public Component getPanelPane() {
        return this.panelPane;
    }

    public void setDock(int dock) {
        this.dock = dock;
        this.setPanels();
    }

    public void setBar(int bar) {
        this.bar = bar;
        this.setPanels();
    }

    public void setGroup(int group) {
        this.group = group;
        this.setPanels();
    }

    private void setPanels() {
        for (CPanel panel : this.panels) {
            panel.setLocation(this.dock, this.bar, this.group);
        }
    }

    public int getDock() {
        return this.dock;
    }

    public int getBar() {
        return this.bar;
    }

    public int getGroup() {
        return this.group;
    }

    public CDesktop getDesktop() {
        if (this.getParentDock() != null) {
            return this.getParentDock().getDesktop();
        }
        return null;
    }

    public CDock getParentDock() {
        return (CDock)this.getParent();
    }

    public CGroup getThis() {
        return this;
    }

    public void moveTo(CPanel panel, int index) {
        Common.msg("Move " + panel + " > " + index);
        if (index < this.getPanelCount()) {
            CPanel oldPanel = this.getPanel(index);
            this.setPanel(panel, index);
            this.setPanel(oldPanel, this.getSelectedIndex());
            this.checkPanels();
            this.setSelected(panel);
        }
    }

    public void setWidth(int diff) {
        for (CPanel panel : this.getPanels()) {
            int width = panel.getWidth() + diff;
            if (width < panel.getMinimumSize().width) {
                width = panel.getMinimumSize().width;
            }
            panel.setSize(width, panel.getHeight());
        }
    }

    public CPanel getSelected() {
        return this.selectPanel;
    }

    private void addTab(CPanel panel) {
        CTab tab = new CTab(this.tabPane, panel);
        tab.setIndex(panel.getIndex());
        tab.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ArrayList<CTab> tabs = CGroup.this.getTabs();
                for (int i = 0; i < tabs.size(); ++i) {
                    if (e.getComponent() != tabs.get(i)) continue;
                    CGroup.this.setSelectedIndex(i);
                }
            }
        });
        this.tabPane.add(tab);
        DragGestureRecognizer dragGesture = this.getDesktop().getDragSource().createDefaultDragGestureRecognizer(tab, 2, this.getDesktop().getDragDrop());
    }

    public ArrayList<CPanel> getPanels() {
        return this.panels;
    }

    public CPanel getPanel(int index) {
        return this.getPanels().get(index);
    }

    public int getPanelCount() {
        return this.panels.size();
    }

    private void setPanel(CPanel panel, int index) {
        this.getPanels().set(index, panel);
    }

    public void setSelected(CPanel selectPanel) {
        for (CPanel panel : this.panels) {
            panel.setSelected(false);
        }
        this.selectPanel = selectPanel;
        selectPanel.setSelected(true);
        this.tabPane.doLayout();
    }

    public void setSelectedIndex(int index) {
        if (index >= this.getPanelCount()) {
            index = this.getPanelCount() - 1;
        }
        if (this.getPanelCount() > 0) {
            this.setSelected(this.getPanels().get(index));
        }
    }

    public int getSelectedIndex() {
        for (int i = 0; i < this.getPanels().size(); ++i) {
            if (this.getPanels().get(i) != this.selectPanel) continue;
            this.selectIndex = i;
            break;
        }
        return this.selectIndex;
    }

    public CTab getTab(CPanel panel) {
        for (CTab tab : this.getTabs()) {
            if (!tab.getName().equals(panel.getName())) continue;
            return tab;
        }
        return null;
    }

    public CTab getSelectedTab() {
        if (this.getSelectedIndex() != -1 && this.getSelectedIndex() < this.getTabs().size()) {
            return this.getTabs().get(this.getSelectedIndex());
        }
        return null;
    }

    public ArrayList<CTab> getTabs() {
        ArrayList<CTab> tabs = new ArrayList<CTab>();
        for (CPanel panel : this.getPanels()) {
            for (Component component : this.tabPane.getComponents()) {
                CTab tab = (CTab)component;
                if (!panel.getName().equals(tab.getName())) continue;
                tabs.add(tab);
            }
        }
        return tabs;
    }

    @Override
    public void paintComponent(Graphics g) {
        CGroup.paintGroup(g, new Rectangle(0, 0, this.getWidth(), this.getHeight()));
    }

    public static void paintGroup(Graphics g, Rectangle bounds) {
        g.drawImage(tl, bounds.x, bounds.y, null);
        g.drawImage(t, bounds.x + tl.getWidth(), bounds.y, bounds.width - tl.getWidth() - tr.getWidth(), t.getHeight(), null);
        g.drawImage(tr, bounds.x + bounds.width - tr.getWidth(), bounds.y, null);
        g.drawImage(l, bounds.x, bounds.y + tl.getHeight(), l.getWidth(), bounds.height - tl.getHeight() - bl.getHeight(), null);
        g.drawImage(r, bounds.x + bounds.width - r.getWidth(), bounds.y + tr.getHeight(), r.getWidth(), bounds.height - tr.getHeight() - br.getHeight(), null);
        g.drawImage(fill, bounds.x + l.getWidth(), bounds.y + t.getHeight(), bounds.width - l.getWidth() - r.getWidth(), bounds.height - t.getHeight() - b.getHeight(), null);
        g.drawImage(bl, bounds.x, bounds.y + bounds.height - bl.getHeight(), null);
        g.drawImage(b, bounds.x + bl.getWidth(), bounds.y + bounds.height - br.getHeight(), bounds.width - bl.getWidth() - br.getWidth(), b.getHeight(), null);
        g.drawImage(br, bounds.x + bounds.width - br.getWidth(), bounds.y + bounds.height - br.getHeight(), null);
    }

    private class CGroupButtonBox
    extends CButtonBox {
        public CGroupButtonBox(int mode) {
            super(mode);
        }

        private CImageIcon getImage() {
            return new CImageIcon("groupbox");
        }

        public BufferedImage getOffImage() {
            return this.getImage().getSubImage(0, 0, 11, 11);
        }

        public BufferedImage getOverImage() {
            return this.getImage().getSubImage(11, 0, 11, 11);
        }

        public BufferedImage getOnImage() {
            return this.getImage().getSubImage(22, 0, 11, 11);
        }

        public BufferedImage getButtonImage(int type, int state) {
            int stateOffset = 0;
            if (state > 0) {
                stateOffset = 33;
            }
            switch (type) {
                case 1: {
                    return this.getImage().getSubImage(33 + stateOffset, 0, 11, 11);
                }
                case 2: {
                    return this.getImage().getSubImage(44 + stateOffset, 0, 11, 11);
                }
                case 0: {
                    return this.getImage().getSubImage(55 + stateOffset, 0, 11, 11);
                }
            }
            return new BufferedImage(16, 16, 2);
        }

        public void doAction(int type) {
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    for (Object panel : CGroup.this.getPanels().toArray()) {
                        ((CPanel)panel).setEnabled(false);
                    }
                    break;
                }
            }
        }
    }
}

