/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import ctool.Loader;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import util.CAction;
import util.CIcon;
import util.CImageIcon;
import util.Common;
import util.gui.CButtonBox;
import util.gui.CDesktop;
import util.gui.CDock;
import util.gui.CFrameTab;
import util.gui.CGroup;
import util.gui.CTab;
import util.gui.CTabPane;
import util.gui.frames.CFrame;
import util.gui.frames.CHexFrame;
import util.struct.DFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CFrameBox
extends JLayeredPane {
    private CTabPane tabPane;
    private JLayeredPane framePane;
    private CFrameButtonBox frameButtonBox;
    private ArrayList<CFrame> frames = new ArrayList();
    private Insets insets = new Insets(30, 6, 6, 6);
    private CFrame selectFrame;

    public CFrameBox() {
        this.tabPane = new CTabPane();
        this.framePane = new JLayeredPane();
        this.frameButtonBox = new CFrameButtonBox(0);
        this.add(this.frameButtonBox);
        this.add(this.tabPane);
        this.add(this.framePane);
        this.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                return CFrameBox.this.getPreferredSize();
            }

            public Dimension minimumLayoutSize(Container parent) {
                return CFrameBox.this.getMinimumSize();
            }

            public void layoutContainer(Container parent) {
                CFrameBox.this.tabPane.setBounds(((CFrameBox)CFrameBox.this).insets.left + 1, 4, CFrameBox.this.getWidth() - ((CFrameBox)CFrameBox.this).insets.left - ((CFrameBox)CFrameBox.this).insets.right - 25 - 1, ((CFrameBox)CFrameBox.this).insets.top - 2);
                CFrameBox.this.tabPane.doLayout();
                CFrameBox.this.framePane.setBounds(((CFrameBox)CFrameBox.this).insets.left, ((CFrameBox)CFrameBox.this).insets.top + 1, CFrameBox.this.getWidth() - ((CFrameBox)CFrameBox.this).insets.left - ((CFrameBox)CFrameBox.this).insets.right, CFrameBox.this.getHeight() - ((CFrameBox)CFrameBox.this).insets.top - ((CFrameBox)CFrameBox.this).insets.bottom);
                for (CFrame frame : CFrameBox.this.getFrames()) {
                    frame.setSize(CFrameBox.this.framePane.getSize());
                }
                if (CFrameBox.this.getDesktop().isOpened()) {
                    CFrameBox.this.frameButtonBox.setVisible(true);
                    CFrameBox.this.frameButtonBox.setLocation(CFrameBox.this.getWidth() - CFrameBox.this.frameButtonBox.getWidth() - ((CFrameBox)CFrameBox.this).insets.right - 2, 10);
                } else {
                    CFrameBox.this.frameButtonBox.setVisible(false);
                }
            }
        });
        this.setSelected(null);
    }

    public void setSelected(int index) {
        if (index >= this.getFrameCount()) {
            index = this.getFrameCount() - 1;
        }
        this.setSelected(this.getFrame(index));
    }

    public void setSelectedByFormat(DFormat format) {
        for (CFrame frame : this.frames) {
            if (frame.getFormat().getPath() != format.getPath()) continue;
            this.setSelected(frame);
        }
    }

    public void setSelected(CFrame selectFrame) {
        CAction.getAction(20).setEnabled(false);
        CAction.getAction(21).setEnabled(false);
        CAction.getAction(22).setEnabled(false);
        CAction.getAction(23).setEnabled(false);
        CAction.getAction(24).setEnabled(selectFrame != null);
        if (selectFrame != null) {
            this.selectFrame = selectFrame;
            for (CFrame frame : this.getFrames()) {
                if (frame == selectFrame) continue;
                frame.setSelected(false);
            }
            selectFrame.setSelected(true);
            this.tabPane.doLayout();
        }
    }

    public CFrame getSelected() {
        return this.selectFrame;
    }

    public void addFrame(CFrame frame, boolean selected) {
        frame.setVisible(false);
        frame.setIndex(this.getFrameCount());
        frame.setSize(this.framePane.getSize());
        this.frames.add(frame);
        this.framePane.add(frame);
        CFrameTab tab = new CFrameTab(this.tabPane, frame);
        tab.setIndex(frame.getIndex());
        tab.setIcon(frame.getFormat().getPath().getPlugin().getIcon().getIcon());
        if (frame instanceof CHexFrame) {
            tab.setIcon(CIcon.HEX.getIcon());
        }
        tab.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                ArrayList<CTab> tabs = CFrameBox.this.getTabs();
                CTab target = (CTab)e.getComponent();
                CFrameBox.this.setSelected((CFrame)target.getTarget());
            }
        });
        this.tabPane.add(tab);
        if (selected) {
            this.setSelected(frame);
        }
        this.getDesktop().setOpened(true);
    }

    public void removeFrame(CFrame frame) {
        this.tabPane.remove(this.getTab(frame));
        this.framePane.remove(frame);
        this.frames.remove(frame);
        boolean accept = true;
        for (CFrame target : this.getFrames()) {
            if (frame.getFormat() != target.getFormat()) continue;
            accept = false;
        }
        if (accept) {
            Common.msg("Removed Path: " + frame.getFormat().getPath());
            Loader.remove(frame.getFormat());
        }
        this.checkFrames();
        this.setSelected(frame.getIndex());
        this.getDesktop().setOpened(this.getFrameCount() > 0);
        this.getDesktop().doLayout();
    }

    private void checkFrames() {
        for (int i = 0; i < this.getFrameCount(); ++i) {
            CFrame frame = this.getFrames().get(i);
            frame.setIndex(i);
            this.getTab(frame).setIndex(i);
        }
        this.tabPane.doLayout();
    }

    public CTab getTab(CFrame frame) {
        for (CTab tab : this.getTabs()) {
            if (tab.getTarget() != frame) continue;
            return tab;
        }
        return null;
    }

    public ArrayList<CTab> getTabs() {
        ArrayList<CTab> tabs = new ArrayList<CTab>();
        for (CFrame frame : this.getFrames()) {
            for (Component component : this.tabPane.getComponents()) {
                CTab tab = (CTab)component;
                if (frame != tab.getTarget()) continue;
                tabs.add(tab);
            }
        }
        return tabs;
    }

    public ArrayList<CFrame> getFrames() {
        return this.frames;
    }

    public CFrame getFrame(int index) {
        if (index >= 0 && index < this.getFrameCount()) {
            return this.getFrames().get(index);
        }
        return null;
    }

    public int getFrameCount() {
        return this.frames.size();
    }

    public CDesktop getDesktop() {
        return (CDesktop)this.getParent();
    }

    @Override
    public void paintComponent(Graphics g) {
        if (this.getDesktop().isOpened()) {
            CDock.paintBox(g, this.getSize());
            CGroup.paintGroup(g, new Rectangle(4, 4, this.getWidth() - 8, this.getHeight() - 8));
        }
    }

    private class CFrameButtonBox
    extends CButtonBox {
        public CFrameButtonBox(int mode) {
            super(mode);
        }

        private CImageIcon getImage() {
            return new CImageIcon("framebox");
        }

        public BufferedImage getOffImage() {
            return this.getImage().getSubImage(0, 0, 16, 16);
        }

        public BufferedImage getOverImage() {
            return this.getImage().getSubImage(16, 0, 16, 16);
        }

        public BufferedImage getOnImage() {
            return this.getImage().getSubImage(32, 0, 16, 16);
        }

        public BufferedImage getButtonImage(int type, int state) {
            switch (type) {
                case 1: {
                    return this.getImage().getSubImage(48, 0, 16, 16);
                }
                case 2: {
                    return this.getImage().getSubImage(64, 0, 16, 16);
                }
                case 0: {
                    return this.getImage().getSubImage(80, 0, 16, 16);
                }
            }
            return new BufferedImage(16, 16, 2);
        }

        public void doAction(int type) {
            switch (type) {
                case 1: {
                    break;
                }
                case 2: {
                    break;
                }
                case 0: {
                    CFrameBox.this.getSelected().setEnabled(false);
                }
            }
        }
    }
}

