/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.dnd.DragGestureRecognizer;
import java.awt.dnd.DropTarget;
import java.awt.event.ContainerEvent;
import java.awt.event.ContainerListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.ImageIcon;
import javax.swing.JLayeredPane;
import util.CImageIcon;
import util.gui.CDesktop;
import util.gui.CGroup;
import util.gui.panels.CPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CDock
extends JLayeredPane {
    private Rectangle resizeRect = new Rectangle(0, 0, 0, 0);
    private Rectangle expandRect = new Rectangle(0, 0, 0, 0);
    private boolean resizable = true;
    private boolean selected = false;
    private boolean resizing;
    private static int topHeight = 18;
    private Point mouseStart;
    private int dock;
    private int bar;
    private static ImageIcon tl = new CImageIcon("dock_tl");
    private static ImageIcon t = new CImageIcon("dock_t");
    private static ImageIcon tr = new CImageIcon("dock_tr");
    private static ImageIcon l = new CImageIcon("dock_l");
    private static ImageIcon r = new CImageIcon("dock_r");
    private static ImageIcon bl = new CImageIcon("dock_bl");
    private static ImageIcon b = new CImageIcon("dock_b");
    private static ImageIcon br = new CImageIcon("dock_br");

    public CDock(int dock, int bar) {
        this.dock = dock;
        this.bar = bar;
        this.listeners();
    }

    private void listeners() {
        this.addContainerListener(new ContainerListener(){

            public void componentAdded(ContainerEvent e) {
            }

            public void componentRemoved(ContainerEvent e) {
                if (CDock.this.getThis().getComponentCount() == 0) {
                    CDock.this.getThis().getParent().remove(CDock.this.getThis());
                }
            }
        });
        this.addMouseMotionListener(new MouseAdapter(){

            public void mouseMoved(MouseEvent e) {
                Point mouse = e.getPoint();
                if (CDock.this.isSide() && !CDock.this.getDesktop().isResizing()) {
                    if (CDock.this.resizeRect.contains(mouse)) {
                        if (CDock.this.getDock() == 3) {
                            CDock.this.getDesktop().setCursor(new Cursor(11));
                        } else {
                            CDock.this.getDesktop().setCursor(new Cursor(10));
                        }
                        CDock.this.setSelected(false);
                    } else if (CDock.this.expandRect.contains(mouse)) {
                        CDock.this.getDesktop().setCursor(new Cursor(12));
                        CDock.this.setSelected(true);
                    } else {
                        CDock.this.getDesktop().setCursor(null);
                        CDock.this.setSelected(false);
                    }
                }
            }

            public void mouseDragged(MouseEvent e) {
                if (CDock.this.resizing) {
                    CDock.this.resize(e);
                }
            }
        });
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                if (CDock.this.isSide() && CDock.this.resizeRect.contains(e.getPoint())) {
                    CDock.this.mouseStart = e.getLocationOnScreen();
                    CDock.this.setResizing(true);
                }
            }

            public void mouseReleased(MouseEvent e) {
                if (CDock.this.resizing) {
                    CDock.this.resize(e);
                    CDock.this.setResizing(false);
                }
            }

            public void mouseExited(MouseEvent e) {
                if (!CDock.this.getDesktop().isResizing()) {
                    CDock.this.getDesktop().setCursor(null);
                    CDock.this.setSelected(false);
                }
            }
        });
    }

    @Override
    public void doLayout() {
        int y = 4;
        if (this.isSide()) {
            y = topHeight;
        }
        for (CGroup group : this.getGroups()) {
            Dimension size = group.getSize();
            size.width = this.getInnerSize().width;
            group.setBounds(4, y, size.width, size.height);
            group.doLayout();
            y += group.getHeight();
        }
    }

    private int getMinimumWidth() {
        int width = 0;
        for (CGroup group : this.getGroups()) {
            int nwidth = group.getMinimumSize().width;
            if (nwidth <= width) continue;
            width = nwidth;
        }
        return width;
    }

    public void addGroup(CGroup group) {
        this.addGroup(group, this.getNextGroup());
    }

    public void addGroup(CGroup group, int index) {
        group.setDock(this.dock);
        group.setBar(this.bar);
        for (CPanel panel : group.getPanels()) {
            panel.setDock(this.dock);
            panel.setBar(this.bar);
        }
        this.add((Component)group, index);
    }

    public void removeGroup(CGroup group) {
        this.remove(group);
        this.setGroups();
    }

    private int getUsedHeight() {
        int height = 0;
        for (CGroup group : this.getGroups()) {
            height += group.getHeight();
        }
        return height;
    }

    public void moveTo(CGroup group, int index) {
        if (group.getGroup() != index) {
            this.remove(group);
            this.addGroup(group, index);
            this.setGroups();
        }
    }

    private void setGroups() {
        for (int i = 0; i < this.getGroupCount(); ++i) {
            CGroup group = this.getGroups().get(i);
            group.setGroup(i);
        }
    }

    private CDock getThis() {
        return this;
    }

    private void resize(MouseEvent e) {
        Point mouse = e.getLocationOnScreen();
        Point diff = new Point(mouse.x - this.mouseStart.x, mouse.y - this.mouseStart.y);
        if (this.dock == 3) {
            diff = new Point(this.mouseStart.x - mouse.x, this.mouseStart.y - mouse.y);
        }
        this.mouseStart = mouse;
        for (CGroup group : this.getGroups()) {
            group.setWidth(diff.x);
        }
        this.getDesktop().doLayout();
    }

    @Override
    public void paintComponent(Graphics g) {
        CDock.paintBox(g, this.getSize());
        this.paintControl(g);
    }

    public void paintControl(Graphics g) {
        int cx = 2;
        int cy = 2;
        int cwidth = this.getWidth() - cx * 2;
        int cheight = this.getHeight() - cy * 2;
        String tselect = "off";
        if (this.selected) {
            tselect = "on";
        }
        String texpand = "left";
        if (this.getDock() == 3) {
            texpand = "right";
        }
        CImageIcon button = new CImageIcon("dock_bar_" + tselect);
        CImageIcon resize = new CImageIcon("dock_resize_" + tselect);
        CImageIcon expand = new CImageIcon("dock_" + texpand + "_" + tselect);
        int side = 6;
        this.resizeRect = new Rectangle(0, 0, 0, 0);
        this.expandRect = new Rectangle(cx, cy, cwidth, topHeight);
        switch (this.dock) {
            case 2: {
                g.drawImage(button.getImage(), cx, cy, cwidth, button.getIconHeight(), null);
                if (this.resizable) {
                    g.drawImage(resize.getImage(), this.getWidth() - resize.getIconWidth() - side, cy, null);
                    this.resizeRect = new Rectangle(this.getWidth() - resize.getIconWidth() - side, cy, resize.getIconWidth(), resize.getIconHeight());
                    this.expandRect = new Rectangle(this.expandRect.x, this.expandRect.y, this.resizeRect.x - side, this.resizeRect.height);
                }
                g.drawImage(expand.getImage(), side, cy, null);
                break;
            }
            case 3: {
                g.drawImage(button.getImage(), cx, cy, cwidth, button.getIconHeight(), null);
                if (this.resizable) {
                    g.drawImage(resize.getImage(), side, cy, null);
                    this.resizeRect = new Rectangle(side, cy, resize.getIconWidth(), resize.getIconHeight());
                    this.expandRect = new Rectangle(this.expandRect.x + this.resizeRect.width, this.expandRect.y, this.expandRect.width - this.resizeRect.x - this.resizeRect.width, this.resizeRect.height);
                }
                g.drawImage(expand.getImage(), this.getWidth() - expand.getIconWidth() - side, cy, null);
            }
        }
    }

    public static void paintBox(Graphics g, Dimension size) {
        int cx = 2;
        int cy = 2;
        int cwidth = size.width - cx * 2;
        int cheight = size.height - cy * 2;
        g.setColor(new Color(99, 99, 99));
        g.fillRect(0, 0, size.width, size.height);
        g.drawImage(t.getImage(), tl.getIconWidth(), 0, cwidth, t.getIconHeight(), null);
        g.drawImage(b.getImage(), bl.getIconWidth(), size.height - b.getIconHeight(), cwidth, b.getIconHeight(), null);
        g.drawImage(tl.getImage(), 0, 0, null);
        g.drawImage(l.getImage(), 0, tl.getIconHeight(), l.getIconHeight(), cheight, null);
        g.drawImage(bl.getImage(), 0, size.height - bl.getIconHeight(), null);
        g.drawImage(tr.getImage(), size.width - tr.getIconWidth(), 0, null);
        g.drawImage(r.getImage(), size.width - tr.getIconWidth(), tl.getIconHeight(), l.getIconHeight(), cheight, null);
        g.drawImage(br.getImage(), size.width - br.getIconWidth(), size.height - bl.getIconHeight(), null);
    }

    public static String getName(int dock) {
        String[] names = new String[]{"FLOAT", "TOP", "LEFT", "RIGHT", "BOTTOM"};
        return names[dock];
    }

    @Override
    public String toString() {
        return "Dock: " + CDock.getName(this.dock) + "-" + this.bar;
    }

    @Override
    public Dimension getMinimumSize() {
        int width = 0;
        int height = 0;
        for (CGroup group : this.getGroups()) {
            if (this.isSide() && width < group.getMinimumSize().width) {
                width = group.getMinimumSize().width;
            }
            height += group.getMinimumSize().height;
        }
        return new Dimension(width + 8, height + 8);
    }

    public Dimension getInnerSize() {
        Dimension innerSize = new Dimension(this.getWidth() - 8, this.getHeight() - 8);
        if (this.isSide()) {
            innerSize.height -= topHeight - 4;
        }
        return innerSize;
    }

    public int getDock() {
        return this.dock;
    }

    public int getBar() {
        return this.bar;
    }

    public int getNextGroup() {
        int groupId = 0;
        for (CGroup group : this.getGroups()) {
            if (group.getGroup() <= groupId) continue;
            groupId = group.getGroup();
        }
        return groupId + 1;
    }

    public boolean isFloating() {
        return 0 == this.dock;
    }

    public boolean isSide() {
        return 2 == this.dock || 3 == this.dock;
    }

    public void setSelected(boolean selected) {
        if (this.selected != selected) {
            this.repaint();
        }
        this.selected = selected;
    }

    public void setResizing(boolean resizing) {
        this.resizing = resizing;
        this.getDesktop().setResizing(resizing);
    }

    public CGroup getGroup(int group) {
        for (Component component : this.getComponents()) {
            CGroup target = (CGroup)component;
            if (target.getGroup() != group) continue;
            return target;
        }
        CGroup target = new CGroup(this.dock, this.bar, group);
        DropTarget dropTarget = new DropTarget(target, 2, this.getDesktop().getDragDrop());
        DragGestureRecognizer dragGesture = this.getDesktop().getDragSource().createDefaultDragGestureRecognizer(target, 2, this.getDesktop().getDragDrop());
        this.addGroup(target);
        return target;
    }

    public ArrayList<CGroup> getGroups() {
        ArrayList<CGroup> groups = new ArrayList<CGroup>();
        for (Component component : this.getComponents()) {
            groups.add((CGroup)component);
        }
        return groups;
    }

    public int getGroupCount() {
        return this.getComponentCount();
    }

    public CDesktop getDesktop() {
        return (CDesktop)this.getParent().getParent();
    }
}

