/*
 * Decompiled with CFR 0.152.
 */
package ctool;

import ctool.Main;
import java.io.File;
import java.util.ArrayList;
import util.Plugin;
import util.gui.frames.CAnimFrame;
import util.gui.frames.CArchiveFrame;
import util.gui.frames.CCellFrame;
import util.gui.frames.CFrame;
import util.gui.frames.CHexFrame;
import util.gui.frames.CMapAnimFrame;
import util.gui.frames.CMapCellFrame;
import util.gui.frames.CMapFrame;
import util.gui.frames.CPaletteFrame;
import util.gui.frames.CTileFrame;
import util.struct.DFormat;
import util.struct.DHex;
import util.struct.DPalette;
import util.struct.DPath;
import util.struct.formats.AdobeClut;
import util.struct.formats.NitroNanr;
import util.struct.formats.NitroNarc;
import util.struct.formats.NitroNcer;
import util.struct.formats.NitroNcgr;
import util.struct.formats.NitroNclr;
import util.struct.formats.NitroNmar;
import util.struct.formats.NitroNmcr;
import util.struct.formats.NitroNscr;
import util.struct.formats.NitroRom;
import util.struct.formats.RiffPalette;
import util.struct.formats.UsentiClrx;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Loader {
    private static ArrayList<DFormat> formats = new ArrayList();
    private static DPalette defaultPalette = new DPalette();
    private static ArrayList<DFormat> cache = new ArrayList();

    public static ArrayList<DFormat> getFormats() {
        return formats;
    }

    public static ArrayList<DFormat> getFormats(int type) {
        ArrayList<DFormat> results = new ArrayList<DFormat>();
        if (type == 5) {
            results.add(defaultPalette);
        }
        for (DFormat format : formats) {
            if (format.getType() != type) continue;
            results.add(format);
        }
        return results;
    }

    public static DFormat getSelectedFormat(int type, DFormat selected) {
        DFormat cacheFormat = Loader.getCache(type);
        if (cacheFormat != null && selected == null) {
            Loader.add(cacheFormat.getPath(), false);
            return cacheFormat;
        }
        ArrayList<DFormat> items = Loader.getFormats(type);
        if (!items.contains(selected)) {
            selected = null;
        }
        if (selected == null && items.size() > 0) {
            selected = items.get(items.size() - 1);
        }
        return selected;
    }

    public static void add(String file) {
        Loader.add(file, true);
    }

    public static void add(String file, boolean selected) {
        Loader.add(new File(file), selected);
    }

    public static void add(File file) {
        Loader.add(file, true);
    }

    public static void add(File file, boolean selected) {
        Loader.add(new DPath(file), selected);
    }

    public static void add(DPath path) {
        Loader.add(path, true);
    }

    public static void add(DPath path, boolean selected) {
        boolean opened = false;
        for (DFormat format : Loader.getFormats()) {
            if (!path.getPathName().equals(format.getPath().getPathName())) continue;
            opened = true;
            if (!selected) continue;
            Main.getWindow().getDesktop().getFrameBox().setSelectedByFormat(format);
        }
        if (!opened) {
            DFormat format = Loader.getFormat(path, path.getPlugin());
            format.open();
            CFrame frame = null;
            switch (format.getType()) {
                case 5: {
                    frame = new CPaletteFrame(format);
                    break;
                }
                case 6: {
                    frame = new CTileFrame(format);
                    break;
                }
                case 7: {
                    frame = new CCellFrame(format);
                    break;
                }
                case 8: {
                    frame = new CAnimFrame(format);
                    break;
                }
                case 50: {
                    frame = new CMapCellFrame(format);
                    break;
                }
                case 51: {
                    frame = new CMapAnimFrame(format);
                    break;
                }
                case 9: {
                    frame = new CMapFrame(format);
                    break;
                }
                case 3: {
                    frame = new CArchiveFrame(format);
                    break;
                }
                default: {
                    frame = new CHexFrame(format);
                }
            }
            if (frame != null) {
                formats.add(format);
                Main.getWindow().getDesktop().addFrame(frame, selected);
            }
        }
    }

    public static void remove(DFormat format) {
        Loader.getFormats().remove(format);
    }

    public static DFormat getFormat(DPath path) {
        return Loader.getFormat(path, path.getPlugin());
    }

    public static DFormat getFormat(DPath path, Plugin plugin) {
        DFormat format = Loader.getHex(path);
        String id = plugin.getId();
        if (id.equals("adobe-clut")) {
            format = new AdobeClut(path);
        }
        if (id.equals("riff-pal")) {
            format = new RiffPalette(path);
        }
        if (id.equals("usenti-pal")) {
            format = new UsentiClrx(path);
        }
        if (id.equals("rom-nds")) {
            format = new NitroRom(path);
        }
        if (id.equals("nitro-nclr")) {
            format = new NitroNclr(path);
        }
        if (id.equals("nitro-ncgr")) {
            format = new NitroNcgr(path);
        }
        if (id.equals("nitro-ncer")) {
            format = new NitroNcer(path);
        }
        if (id.equals("nitro-nanr")) {
            format = new NitroNanr(path);
        }
        if (id.equals("nitro-nscr")) {
            format = new NitroNscr(path);
        }
        if (id.equals("nitro-nmcr")) {
            format = new NitroNmcr(path);
        }
        if (id.equals("nitro-nmar")) {
            format = new NitroNmar(path);
        }
        if (id.equals("nitro-narc")) {
            format = new NitroNarc(path);
        }
        if (format.getType() != 0) {
            Loader.setCache(format);
        }
        return format;
    }

    public static DFormat getHex(DPath path) {
        return new DHex(path);
    }

    public static void setCache(DFormat format) {
        for (int i = 0; i < cache.size(); ++i) {
            DFormat cacheFormat = cache.get(i);
            if (cacheFormat.getType() != format.getType()) continue;
            if (cacheFormat.getPath() != format.getPath()) {
                cache.set(i, format);
            }
            return;
        }
        cache.add(format);
    }

    public static DFormat getCache(int type) {
        for (DFormat format : cache) {
            if (format.getType() != type) continue;
            return format;
        }
        return null;
    }
}

