/*
 * Decompiled with CFR 0.152.
 */
package ctool;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.WindowEvent;
import java.awt.event.WindowStateListener;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import util.CIcon;
import util.Common;
import util.Settings;
import util.gui.CDesktop;
import util.gui.CMenuBar;
import util.gui.CStatusBar;
import util.gui.panels.CPanel;

public class CWindow
extends JFrame {
    private CDesktop desktop;
    private CMenuBar menuBar;
    private CStatusBar statusBar;

    public CWindow() {
        this.initComponents();
        this.setLocation(290, 100);
        this.setSize(896, 649);
        this.setIconImage(CIcon.FILE_ROOT.getImage());
        this.listeners();
        this.loadSettings();
        this.desktop.setOpened(false);
        this.setVisible(true);
    }

    private void initComponents() {
        this.setDefaultCloseOperation(3);
        this.setTitle("Console Tool 3.0");
        this.menuBar = new CMenuBar();
        this.menuBar.setBackground(new Color(100, 100, 100));
        this.menuBar.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(100, 100, 100)));
        this.setJMenuBar(this.menuBar);
        this.desktop = new CDesktop(this);
        this.add((Component)this.desktop, "Center");
    }

    private void listeners() {
        this.addWindowStateListener(new WindowStateListener(){

            public void windowStateChanged(WindowEvent e) {
                Settings.saveSetting("window-state", e.getNewState());
            }
        });
        this.addComponentListener(new ComponentAdapter(){

            public void componentResized(ComponentEvent e) {
                if (CWindow.this.getThis().getExtendedState() == 0) {
                    Settings.saveSetting("window-width", CWindow.this.getThis().getWidth());
                    Settings.saveSetting("window-height", CWindow.this.getThis().getHeight());
                }
            }

            public void componentMoved(ComponentEvent e) {
                if (CWindow.this.getThis().getExtendedState() == 0) {
                    Settings.saveSetting("window-x", CWindow.this.getThis().getX());
                    Settings.saveSetting("window-y", CWindow.this.getThis().getY());
                }
            }
        });
    }

    private void loadSettings() {
        String name;
        Settings.setLoaded(false);
        int windowWidth = Settings.loadInteger("window-width", this.getWidth());
        int windowHeight = Settings.loadInteger("window-height", this.getHeight());
        int windowX = Settings.loadInteger("window-x", this.getX());
        int windowY = Settings.loadInteger("window-y", this.getY());
        int windowState = Settings.loadInteger("window-state", this.getExtendedState());
        this.setBounds(windowX, windowY, windowWidth, windowHeight);
        this.setExtendedState(windowState);
        for (CPanel panel : this.desktop.getPanels()) {
            name = Common.trimName(panel.getName());
            int dock = Settings.loadInteger(name + ".dock", panel.getDock());
            int bar = Settings.loadInteger(name + ".bar", panel.getBar());
            int group = Settings.loadInteger(name + ".group", panel.getGroup());
            int width = Settings.loadInteger(name + ".width", panel.getWidth());
            int height = Settings.loadInteger(name + ".height", panel.getHeight());
            panel.setSize(new Dimension(width, height));
            panel.setLocation(dock, bar, group);
        }
        for (CPanel panel : this.desktop.getPanels()) {
            name = Common.trimName(panel.getName());
            boolean selected = Settings.loadBoolean(name + ".selected", false);
            boolean enabled = Settings.loadBoolean(name + ".enabled", true);
            panel.setSelected(selected);
            panel.setEnabled(enabled);
        }
        Settings.setLoaded(true);
    }

    public void saveSettings() {
        Settings.saveSetting("window-x", this.getX());
        Settings.saveSetting("window-y", this.getY());
        Settings.saveSetting("window-width", this.getWidth());
        Settings.saveSetting("window-height", this.getHeight());
        Settings.saveSetting("window-state", this.getExtendedState());
        for (CPanel panel : this.desktop.getPanels()) {
            String name = panel.getName();
            Settings.saveSetting(name + ".dock", panel.getDock());
            Settings.saveSetting(name + ".bar", panel.getBar());
            Settings.saveSetting(name + ".group", panel.getGroup());
            Settings.saveSetting(name + ".selected", panel.isSelected());
            Settings.saveSetting(name + ".enabled", panel.isEnabled());
            Settings.saveSetting(name + ".width", panel.getSize().width);
            Settings.saveSetting(name + ".height", panel.getSize().height);
        }
    }

    private CWindow getThis() {
        return this;
    }

    public CDesktop getDesktop() {
        return this.desktop;
    }

    public CMenuBar getMenu() {
        return this.menuBar;
    }

    public CStatusBar getStatus() {
        return this.statusBar;
    }
}

