/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import util.Common;
import util.struct.DArchive;
import util.struct.DFile;
import util.struct.DPath;
import util.struct.formats.Nitro;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NitroNarc
extends DArchive {
    public NitroNarc(DPath path) {
        super(path);
    }

    @Override
    public void open() {
        Nitro blocks = new Nitro(this.getPath());
        int[][] fatTable = NitroNarc.readFATB(Common.getBytes(blocks.getBlockData("BTAF"), 12));
        ArrayList<DPath> dirPaths = new ArrayList<DPath>();
        dirPaths.add(this.getPath());
        NitroNarc.readFNTB(this, dirPaths, Common.getBytes(blocks.getBlockData("BTNF"), 8), fatTable, blocks.getBlockOffset("GMIF") + 8);
    }

    public static int[][] readFATB(byte[] data) {
        int fatCount = data.length / 8;
        int[][] fatTable = new int[fatCount][2];
        for (int i = 0; i < fatCount; ++i) {
            int offset = i * 8;
            int startOffset = Common.getInt(data, offset, 4);
            int endOffset = Common.getInt(data, offset + 4, 4);
            fatTable[i] = new int[]{startOffset, endOffset - startOffset};
            if (fatTable[i][1] > 0) continue;
            Common.msg("#" + Common.padNum(i, 4) + " | Start: " + Common.getHex(startOffset, 2) + " | End: " + Common.getHex(endOffset, 2) + " | Size: " + (endOffset - startOffset));
        }
        return fatTable;
    }

    public static void readFNTB(DArchive archive, ArrayList<DPath> dirPaths, byte[] data, int[][] fatTable, int dataOffset) {
        int startOffset = Common.getInt(data, 0, 4);
        int firstPos = Common.getInt(data, 4, 2);
        int dirCount = Common.getInt(data, 6, 2);
        int folderPos = dirPaths.size() - 1;
        if (data.length == 8) {
            int width = 0;
            int divide = fatTable.length;
            while (divide > 0) {
                divide /= 10;
                ++width;
            }
            ArrayList<DFile> folder = new ArrayList<DFile>();
            for (int i = 0; i < fatTable.length; ++i) {
                String fileName = Common.padNum(i, width);
                folder.add(new DFile(fileName, dataOffset + fatTable[i][0], fatTable[i][1]));
            }
            archive.addFolder(folderPos, archive.getPath(), folder);
        } else {
            for (int i = 0; i < dirCount; ++i) {
                int jump = i * 8;
                int offset = Common.getInt(data, jump, 4);
                int filePos = Common.getInt(data, jump + 4, 2);
                int parent = Common.getInt(data, jump + 6, 2) - 61440;
                jump = offset;
                boolean end = false;
                ArrayList<DFile> folder = new ArrayList<DFile>();
                while (!end) {
                    int header;
                    if ((header = Common.getInt(data, jump++, 1)) != 0) {
                        int nameSize = header & 0x7F;
                        String name = Common.getString(data, jump, nameSize);
                        boolean isFolder = (header & 0x80) != 0;
                        int id = 0;
                        jump += nameSize;
                        DFile file = null;
                        if (isFolder) {
                            id = Common.getInt(data, jump, 2) - 61440;
                            jump += 2;
                            file = new DFile(name);
                            file.setReference(folderPos + id);
                            DPath folderPath = new DPath(dirPaths.get(folderPos + i), file);
                            dirPaths.add(folderPath);
                        } else {
                            file = new DFile(name, dataOffset + fatTable[filePos][0], fatTable[filePos][1]);
                            ++filePos;
                        }
                        folder.add(file);
                        continue;
                    }
                    end = true;
                }
                archive.addFolder(folderPos + i, dirPaths.get(folderPos + i), folder);
            }
        }
    }
}

