/*
 * Decompiled with CFR 0.152.
 */
package util.struct.formats;

import java.util.ArrayList;
import java.util.Iterator;
import util.Common;
import util.struct.DFormat;
import util.struct.DPath;
import util.struct.formats.NitroBlock;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Nitro {
    public static final String PLTT = "TTLP";
    public static final String CHAR = "RAHC";
    public static final String CPOS = "SOPC";
    public static final String CEBK = "KBEC";
    public static final String ABNK = "KNBA";
    public static final String SCRN = "NRCS";
    public static final String LABL = "LBAL";
    public static final String UEXT = "TXEU";
    public static final String FATB = "BTAF";
    public static final String FNTB = "BTNF";
    public static final String FIMG = "GMIF";
    private DPath path;
    private String fileMagic;
    private int constant;
    private int fileSize;
    private int headerSize;
    private int sectionCount;
    private ArrayList<NitroBlock> blocks = new ArrayList();

    public Nitro(DPath path) {
        String[] types;
        this.path = path;
        byte[] data = path.read();
        this.fileMagic = Common.getString(data, 0, 4);
        this.constant = Common.getInt(data, 4, 4);
        this.fileSize = Common.getInt(data, 8, 4);
        this.headerSize = Common.getInt(data, 12, 2);
        this.sectionCount = Common.getInt(data, 14, 2);
        boolean show = true;
        for (String type : types = new String[]{"NARC", "RLCN", "RGCN", "RECN", "RNAN", "RCSN", "RCMN", "RAMN"}) {
            if (!type.equals(this.fileMagic)) continue;
            show = false;
        }
        if (show) {
            Common.msg("Magic: " + this.fileMagic + " (" + Common.getHex(this.fileMagic) + ")");
            Common.msg("Constant: " + Common.getHex(this.constant, 4));
            Common.msg("File Size: " + this.fileSize);
            Common.msg("Header Size: " + this.headerSize);
            Common.msg("# Sections: " + this.sectionCount);
            Common.line();
        }
        int jump = this.headerSize;
        String[] magics = new String[]{PLTT, CHAR, CPOS, SCRN, CEBK, ABNK, LABL, UEXT, FATB, FNTB, FIMG};
        for (int i = 0; i < this.sectionCount; ++i) {
            String magic = Common.getString(data, jump, 4);
            int sectionSize = Common.getInt(data, jump + 4, 4);
            this.blocks.add(new NitroBlock(magic, jump, sectionSize));
            boolean known = false;
            for (String check : magics) {
                if (!check.equals(magic)) continue;
                known = true;
            }
            if (!known) {
                Common.msg("Magic: " + magic + " (" + Common.getHex(magic) + ") | Offset: " + Common.getHex(jump, 2) + " | Size: " + sectionSize);
                Common.line();
            }
            jump += sectionSize;
        }
    }

    public ArrayList<NitroBlock> getBlocks() {
        return this.blocks;
    }

    public NitroBlock getBlock(String magic) {
        for (NitroBlock block : this.getBlocks()) {
            if (!block.getMagic().equals(magic)) continue;
            return block;
        }
        return null;
    }

    public int getBlockOffset(String magic) {
        NitroBlock block = this.getBlock(magic);
        if (block != null) {
            return block.getOffset();
        }
        return 0;
    }

    public byte[] getBlockData(String magic) {
        NitroBlock block = this.getBlock(magic);
        if (block != null) {
            return this.path.read(block.getOffset(), block.getSize());
        }
        return null;
    }

    public static int getDepth(int depth) {
        switch (depth) {
            case 3: {
                return 4;
            }
        }
        return 8;
    }

    public ArrayList<String> getLabels() {
        byte[] data = this.getBlockData(LABL);
        ArrayList<String> labels = new ArrayList<String>();
        ArrayList<Integer> offsets = new ArrayList<Integer>();
        if (data != null) {
            int jump;
            int readOffset;
            for (readOffset = 8; readOffset < data.length && (jump = Common.getInt(data, readOffset, 4)) + readOffset <= data.length; readOffset += 4) {
                offsets.add(jump);
            }
            Iterator i$ = offsets.iterator();
            while (i$.hasNext()) {
                int offset = (Integer)i$.next();
                String name = Common.getString(data, offset + readOffset);
                labels.add(name);
            }
        }
        return labels;
    }

    public void readUEXT(DFormat format) {
        byte[] data = this.getBlockData(UEXT);
        if (data != null) {
            format.getModel().addRow("UEXT", Common.getInt(data, 8, 4), false);
        }
    }
}

