/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import util.Common;
import util.gui.panels.CComboBoxModel;
import util.gui.panels.CTableModel;
import util.struct.CBank;
import util.struct.CColorFormat;

public class CPalette
extends CBank {
    public static final int ERROR = -65536;
    private static final int A = 0;
    private static final int R = 1;
    private static final int G = 2;
    private static final int B = 3;
    private static final int I = 4;
    private static final int X = 5;
    public static final CColorFormat BGR888 = new CColorFormat("BGR888", 0, 24, new int[]{3, 2, 1, 8, 8, 8});
    public static final CColorFormat XBGR8888 = new CColorFormat("XBGR8888", 1, 32, new int[]{5, 3, 2, 1, 8, 8, 8, 8});
    public static final CColorFormat BGRA8888 = new CColorFormat("BGRA8888", 2, 32, new int[]{3, 2, 1, 0, 8, 8, 8, 8});
    public static final CColorFormat BGR555 = new CColorFormat("BGR555", 10, 16, new int[]{3, 2, 1, 5, 5, 5});
    private String name;
    private CColorFormat format = BGRA8888;
    private int[] colors;
    private CComboBoxModel bitDepth = new CComboBoxModel(new Integer[]{4, 8}, 8);
    private CTableModel model = new CTableModel("Bank Properties");
    private static final String FIELD_NAME = "Bank Name";
    private static final String FIELD_FORMAT = "Format";
    private static final String FIELD_COLORS = "Colors";
    private static final String FIELD_DEPTH = "Bit Depth";
    private static int[][] shiftList = new int[][]{{0, 0}, {1, 255}, {3, 85}, {7, 36}, {15, 17}, {31, 8}, {63, 4}, {127, 2}, {255, 1}};
    private static int[] defaultColors = new int[]{-16777216, -16777165, -16777114, -16777063, -16777012, -16776961, -16764160, -16764109, -16764058, -16764007, -16763956, -16763905, -16751104, -16751053, -16751002, -16750951, -16750900, -16750849, -16738048, -16737997, -16737946, -16737895, -16737844, -16737793, -16724992, -16724941, -16724890, -16724839, -16724788, -16724737, -16711936, -16711885, -16711834, -16711783, -16711732, -16711681, -13434880, -13434829, -13434778, -13434727, -13434676, -13434625, -13421824, -13421773, -13421722, -13421671, -13421620, -13421569, -13408768, -13408717, -13408666, -13408615, -13408564, -13408513, -13395712, -13395661, -13395610, -13395559, -13395508, -13395457, -13382656, -13382605, -13382554, -13382503, -13382452, -13382401, -13369600, -13369549, -13369498, -13369447, -13369396, -13369345, -10092544, -10092493, -10092442, -10092391, -10092340, -10092289, -10079488, -10079437, -10079386, -10079335, -10079284, -10079233, -10066432, -10066381, -10066330, -10066279, -10066228, -10066177, -10053376, -10053325, -10053274, -10053223, -10053172, -10053121, -10040320, -10040269, -10040218, -10040167, -10040116, -10040065, -10027264, -10027213, -10027162, -10027111, -10027060, -10027009, -6750208, -6750157, -6750106, -6750055, -6750004, -6749953, -6737152, -6737101, -6737050, -6736999, -6736948, -6736897, -6724096, -6724045, -6723994, -6723943, -6723892, -6723841, -6711040, -6710989, -6710938, -6710887, -6710836, -6710785, -6697984, -6697933, -6697882, -6697831, -6697780, -6697729, -6684928, -6684877, -6684826, -6684775, -6684724, -6684673, -3407872, -3407821, -3407770, -3407719, -3407668, -3407617, -3394816, -3394765, -3394714, -3394663, -3394612, -3394561, -3381760, -3381709, -3381658, -3381607, -3381556, -3381505, -3368704, -3368653, -3368602, -3368551, -3368500, -3368449, -3355648, -3355597, -3355546, -3355495, -3355444, -3355393, -3342592, -3342541, -3342490, -3342439, -3342388, -3342337, -65536, -65485, -65434, -65383, -65332, -65281, -52480, -52429, -52378, -52327, -52276, -52225, -39424, -39373, -39322, -39271, -39220, -39169, -26368, -26317, -26266, -26215, -26164, -26113, -13312, -13261, -13210, -13159, -13108, -13057, -256, -205, -154, -103, -52, -1, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216, -16777216};

    public CPalette() {
        if (this.colors == null) {
            this.colors = defaultColors;
        }
        this.checkModel();
    }

    public CPalette(int[] colors) {
        this.colors = colors;
        this.checkModel();
    }

    public CPalette(byte[] data, CColorFormat format) {
        this(null, data, format);
    }

    public CPalette(byte[] data, CColorFormat format, int bitDepth) {
        this(null, data, format);
        this.setDepth(bitDepth);
    }

    public CPalette(String name, byte[] data, CColorFormat format) {
        this.name = name;
        this.format = format;
        this.parseColors(data);
        this.checkModel();
    }

    public static CPalette getDefault() {
        CPalette palette = new CPalette(defaultColors);
        palette.setName("Default");
        return palette;
    }

    private void checkModel() {
        if (this.name == null) {
            this.name = "";
        }
        this.model.addRow(FIELD_NAME, this.name);
        this.model.addRow(FIELD_FORMAT, this.format, false);
        this.model.addRow(FIELD_COLORS, this.colors.length, false);
        this.model.addRow(FIELD_DEPTH, this.bitDepth);
    }

    public String toString() {
        return this.getName();
    }

    public CTableModel getModel() {
        return this.model;
    }

    public String getName() {
        this.name = (String)this.getModel().getRow(FIELD_NAME);
        if (this.name.replace(" ", "").length() == 0) {
            return "(no name)";
        }
        return this.name;
    }

    public int getDepth() {
        return (Integer)this.bitDepth.getSelectedItem();
    }

    public void setDepth(int bitDepth) {
        this.bitDepth.setSelectedItem(bitDepth);
    }

    public CColorFormat getColorFormat() {
        return this.format;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void moveTo(int oldIndex, int newIndex) {
        int oldColor = this.colors[oldIndex];
        if (oldIndex >= 0 && oldIndex < this.colors.length && newIndex >= 0 && newIndex < this.colors.length) {
            this.removeColor(oldIndex);
            this.addColor(oldColor, newIndex);
        } else {
            Common.msg("Out of Bounds Move: " + oldIndex + " > " + newIndex);
        }
    }

    public void addColor(int color) {
        this.addColor(color, this.colors.length);
    }

    public void addColor(int color, int index) {
        if (index >= 0) {
            if (index >= this.colors.length) {
                index = this.colors.length;
            }
            int[] temp = this.colors;
            this.colors = new int[this.colors.length + 1];
            int count = 0;
            for (int i = 0; i < temp.length; ++i) {
                if (count == index) {
                    // empty if block
                }
                int n = ++count;
                ++count;
                this.colors[n] = temp[i];
            }
            this.colors[index] = color;
        } else {
            Common.msg("Negative Add Index: " + index);
        }
        this.getModel().setRow(FIELD_COLORS, this.colors.length);
    }

    public void removeColor(int index) {
        if (index >= 0 && index < this.colors.length) {
            int[] temp = this.colors;
            this.colors = new int[this.colors.length - 1];
            int count = 0;
            for (int i = 0; i < temp.length; ++i) {
                if (i == index) continue;
                this.colors[count++] = temp[i];
            }
        } else {
            Common.msg("Out of Bounds Remove Index: " + index);
        }
        this.getModel().setRow(FIELD_COLORS, this.colors.length);
    }

    private void parseColors(byte[] data) {
        int[] raw;
        this.colors = defaultColors;
        if (data != null && (raw = Common.toIntArray(data, this.format.getDepth())) != null) {
            this.colors = new int[raw.length];
            for (int i = 0; i < raw.length; ++i) {
                this.colors[i] = CPalette.decodeColor(raw[i], this.format);
            }
        }
    }

    public int[] getColors() {
        return this.colors;
    }

    public int[] getColors(int offset) {
        int[] subColors = new int[16];
        for (int i = 0; i < subColors.length; ++i) {
            subColors[i] = -65536;
            int colorIndex = offset + i;
            if (colorIndex >= this.colors.length) continue;
            subColors[i] = this.colors[colorIndex];
        }
        return subColors;
    }

    public int getColorCount() {
        return this.colors.length;
    }

    public int getColor(int index) {
        return this.colors[index];
    }

    public void setColor(int index, int r, int g, int b) {
        int rs = shiftList[this.format.getWidth(1)][1];
        int gs = shiftList[this.format.getWidth(2)][1];
        int bs = shiftList[this.format.getWidth(3)][1];
        int red = (int)Math.floor((double)r / (double)rs) * rs;
        int green = (int)Math.floor((double)g / (double)gs) * gs;
        int blue = (int)Math.floor((double)b / (double)bs) * gs;
        this.colors[index] = red << 16 | green << 8 | blue;
    }

    public void setColor(int index, int color) {
        this.colors[index] = color;
    }

    public static int encodeColor(int value, CColorFormat format) {
        int[] res = format.getResolution();
        int rgb = 0;
        int shift = 0;
        int length = res.length / 2;
        for (int i = 0; i < length; ++i) {
            int mode = res[length - i - 1];
            int nshift = res[length * 2 - i - 1];
            int mult = shiftList[nshift][1];
            int and = shiftList[nshift][0];
            int n = 0;
            switch (mode) {
                case 0: {
                    n = value >> 24 & 0xFF;
                    break;
                }
                case 1: {
                    n = value >> 16 & 0xFF;
                    break;
                }
                case 2: {
                    n = value >> 8 & 0xFF;
                    break;
                }
                case 3: {
                    n = value & 0xFF;
                    break;
                }
                case 4: {
                    n = value & 0xFF;
                }
            }
            rgb |= (n / mult & and) << shift;
            shift += nshift;
        }
        return rgb;
    }

    public static int decodeColor(int value, CColorFormat format) {
        int[] res = format.getResolution();
        int rgb = -16777216;
        int shift = 0;
        int length = res.length / 2;
        for (int i = 0; i < length; ++i) {
            int mode = res[length - i - 1];
            int nshift = res[length * 2 - i - 1];
            int mult = shiftList[nshift][1];
            int and = shiftList[nshift][0];
            int n = (value >> shift & and) * mult;
            switch (mode) {
                case 0: {
                    rgb |= n << 24;
                    break;
                }
                case 1: {
                    rgb |= n << 16;
                    break;
                }
                case 2: {
                    rgb |= n << 8;
                    break;
                }
                case 3: {
                    rgb |= n;
                    break;
                }
                case 4: {
                    rgb = n << 16 | n << 8 | n;
                }
            }
            shift += nshift;
        }
        return rgb;
    }
}

