/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.util.ArrayList;
import util.struct.DFile;
import util.struct.DPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CArchiveFolder {
    private int id;
    private DPath parent;
    private ArrayList<DPath> paths = new ArrayList();

    public CArchiveFolder(int id, DPath parent) {
        this.id = id;
        this.parent = parent;
    }

    public CArchiveFolder(int id, DPath parent, ArrayList<DFile> files) {
        this.id = id;
        this.parent = parent;
        for (DFile file : files) {
            this.paths.add(new DPath(parent, file));
        }
    }

    public int getId() {
        return this.id;
    }

    public int getPathCount() {
        return this.paths.size();
    }

    public DPath getPath(int index) {
        return this.paths.get(index);
    }

    public ArrayList<DPath> getPaths() {
        return this.paths;
    }

    public void add(DFile file) {
        this.paths.add(new DPath(this.parent, file));
    }

    public String toString() {
        return "Folder: " + this.parent + " | # Files: " + this.paths.size();
    }
}

