/*
 * Decompiled with CFR 0.152.
 */
package util.struct;

import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import util.gui.panels.CTableModel;
import util.struct.CAnim;
import util.struct.CAnimBuffer;
import util.struct.CBank;
import util.struct.CBankItem;
import util.struct.CCell;
import util.struct.CCellBuffer;
import util.struct.DCell;
import util.struct.DGraphic;
import util.struct.DPalette;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CAnimBank
extends CBank {
    @Override
    public CTableModel getModel() {
        CTableModel model = super.getModel();
        model.addRow("Frames", this.getItemCount(), false);
        return model;
    }

    public ArrayList<CAnim> getFrames() {
        ArrayList<CAnim> items = new ArrayList<CAnim>();
        for (CBankItem item : this.getItems()) {
            items.add((CAnim)item);
        }
        return items;
    }

    @Override
    public CAnim get(int index) {
        return (CAnim)super.get(index);
    }

    @Override
    public CAnim getSelected() {
        return (CAnim)super.getSelected();
    }

    public CAnimBuffer getBuffer(DPalette palAsset, DGraphic imageAsset, DCell cellAsset, boolean alpha) {
        CAnimBuffer animBuffer = new CAnimBuffer();
        int count = 0;
        Rectangle bounds = null;
        for (CAnim cAnim : this.getFrames()) {
            CCellBuffer frameBuffer = new CCellBuffer(cAnim.getCellOffset());
            if (cellAsset != null) {
                if (cAnim.getCellOffset() < cellAsset.getItemCount()) {
                    CCell cellBank = cellAsset.get(cAnim.getCellOffset());
                    frameBuffer = cellBank.getBuffer(palAsset.getSelected(), imageAsset.getSelected(), cellAsset.isSubImage(), alpha);
                } else {
                    frameBuffer = new CCellBuffer(cAnim.getCellOffset());
                }
            }
            animBuffer.add(frameBuffer, count++, cAnim.getLength());
            bounds = CCellBuffer.checkBounds(bounds, frameBuffer.getBounds());
        }
        for (int i = 0; i < animBuffer.getFrameCount(); ++i) {
            CCellBuffer cCellBuffer = animBuffer.getFrame(i);
            BufferedImage image = new BufferedImage(bounds.width, bounds.height, 2);
            BufferedImage outline = new BufferedImage(bounds.width, bounds.height, 2);
            image.getGraphics().drawImage(cCellBuffer.getImage(), cCellBuffer.getX() - bounds.x, cCellBuffer.getY() - bounds.y, null);
            outline.getGraphics().drawImage(cCellBuffer.getOutline(), cCellBuffer.getX() - bounds.x, cCellBuffer.getY() - bounds.y, null);
            cCellBuffer.setBounds(bounds);
            cCellBuffer.setImage(image);
            cCellBuffer.setOutline(outline);
            animBuffer.setThumb(i);
        }
        animBuffer.setBounds(bounds);
        return animBuffer;
    }
}

