/*
 * Decompiled with CFR 0.152.
 */
package util.gui.panels;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.table.DefaultTableModel;
import util.Common;

public class CTableModel
extends DefaultTableModel {
    private String name;
    private boolean enabled;
    private String[] names;
    private Class[][] types;
    private boolean[][] editable;
    private Object[][] data;
    private PropertyChangeSupport pcs = new PropertyChangeSupport(this);

    public CTableModel(String name) {
        this.name = name;
        this.setEnabled(true);
        this.setColumns(new String[]{"Property", "Value"});
        this.data = new Object[0][];
        this.editable = new boolean[0][];
        this.types = new Class[0][];
        this.setDataVector(this.data, this.names);
    }

    public String toString() {
        return "TableModel: " + this.getName();
    }

    public String getName() {
        return this.name;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setColumns(String[] names) {
        this.names = names;
    }

    public void setValueAt(Object value, int row, int column) {
        Object oldValue = this.getValueAt(row, column);
        if (column > 0) {
            super.setValueAt(value, row, column);
            this.pcs.firePropertyChange(Common.trimName(this.getRowName(row) + "." + this.getColumnName(column)), oldValue, value);
        }
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(listener);
    }

    public void addPropertyChangeListener(String propertyName, PropertyChangeListener listener) {
        this.pcs.addPropertyChangeListener(propertyName, listener);
    }

    public void setRow(String rowName, Object value) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getRowName(i).equals(rowName)) continue;
            this.setValueAt(value, i, 1);
            return;
        }
    }

    public Object getRow(String rowName) {
        return this.getRow(rowName, null);
    }

    public Object getRow(String rowName, Object defaultValue) {
        for (int i = 0; i < this.getRowCount(); ++i) {
            if (!this.getRowName(i).equals(rowName)) continue;
            return this.getValueAt(i, 1);
        }
        return defaultValue;
    }

    public void addRow(String name, Object value) {
        this.addRow(name, value, true);
    }

    public void addRow(String name, Object value, boolean editable) {
        this.addRow(name, new Object[]{value}, new boolean[]{editable});
    }

    public void addRow(String name, Object[] values) {
        boolean[] editList = new boolean[values.length];
        for (int i = 0; i < editList.length; ++i) {
            editList[i] = true;
        }
        this.addRow(name, values, editList);
    }

    public void addRow(String name, Object[] values, boolean[] editable) {
        Object[] list = new Object[values.length + 1];
        boolean[] editList = new boolean[values.length + 1];
        Class[] typeList = new Class[values.length + 1];
        list[0] = name;
        editList[0] = false;
        typeList[0] = String.class;
        for (int i = 0; i < values.length; ++i) {
            list[i + 1] = values[i];
            editList[i + 1] = editable[i];
            typeList[i + 1] = values[i] != null ? values[i].getClass() : Object.class;
        }
        this.data = Common.addItem(this.data, list);
        this.editable = Common.addItem(this.editable, editList);
        this.types = Common.addItem(this.types, typeList);
        this.setDataVector(this.data, this.names);
    }

    public void removeAll() {
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            this.removeRow(0);
        }
    }

    public Class getColumnClass(int column) {
        if (column == 0) {
            return String.class;
        }
        return Object.class;
    }

    public boolean isCellEditable(int row, int column) {
        return this.editable[row][column];
    }

    public Class getCellClass(int row, int column) {
        return this.types[row][column];
    }

    public String getRowName(int row) {
        return (String)this.getValueAt(row, 0);
    }
}

