/*
 * Decompiled with CFR 0.152.
 */
package util.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseWheelEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.AbstractCellEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import util.CProperty;
import util.TextFilter;
import util.gui.panels.CComboBoxModel;
import util.gui.panels.CInfoPanel;
import util.gui.panels.CTableModel;

public class CTable
extends JTable {
    private CInfoPanel parent;

    public CTable(CInfoPanel parent) {
        this.parent = parent;
        this.setGridColor(new Color(180, 180, 180));
        this.setIntercellSpacing(new Dimension(0, 0));
        this.setRowHeight(19);
        this.setRowMargin(1);
        this.setFocusable(false);
        this.setOpaque(false);
        this.setSelectionMode(0);
        this.setDefaultRenderer(Object.class, new CRenderer());
        this.setDefaultEditor(Object.class, new CEditor());
        this.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                int width = 80;
                CTable.this.getColumnModel().getColumn(0).setResizable(false);
                CTable.this.getColumnModel().getColumn(0).setWidth(width);
                CTable.this.getColumnModel().getColumn(0).setPreferredWidth(width);
                CTable.this.getColumnModel().getColumn(0).setMinWidth(width);
                CTable.this.getColumnModel().getColumn(0).setMaxWidth(width);
                CTable.this.setPreferredSize(new Dimension(CTable.this.getPreferredSize().width, CTable.this.getRowCount() * CTable.this.getRowHeight()));
            }
        });
    }

    public static class CBorder
    implements Border {
        private Insets insets = new Insets(1, 1, 1, 1);
        private boolean[] colored;
        private Color color;

        public CBorder(int top, int left, int bottom, int right, boolean[] colored, Color color) {
            this.insets = new Insets(top, left, bottom, right);
            this.colored = colored;
            this.color = color;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
            g.setColor(this.color);
            if (this.colored[0]) {
                g.fillRect(0, 0, c.getWidth(), this.insets.top);
            }
            if (this.colored[1]) {
                g.fillRect(0, 0, this.insets.left, c.getHeight());
            }
            if (this.colored[2]) {
                g.fillRect(0, c.getHeight() - this.insets.bottom, c.getWidth(), this.insets.bottom);
            }
            if (this.colored[3]) {
                g.fillRect(c.getWidth() - this.insets.right, 0, this.insets.right, c.getHeight());
            }
        }

        public Insets getBorderInsets(Component c) {
            return this.insets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    private class CEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private JComponent component = null;
        private Class type;
        private CProperty.CPropertyOption property;
        protected boolean error = false;

        public CEditor() {
            CTable.this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    CTable.this.parent.changeFocus(e);
                }

                public void mouseWheelMoved(MouseWheelEvent e) {
                }
            });
        }

        public Component getTableCellEditorComponent(final JTable table, Object value, boolean isSelected, final int row, final int column) {
            CTableModel model = (CTableModel)table.getModel();
            this.type = model.getCellClass(row, column);
            this.property = null;
            String text = "" + value;
            this.component = new JTextField(text);
            this.setTextField(this.component);
            Class<?> typeClass = this.type;
            Object data = value;
            if (typeClass == CProperty.CPropertyOption.class) {
                this.property = (CProperty.CPropertyOption)data;
                data = this.property.getValue();
                typeClass = data.getClass();
            }
            if (typeClass == CComboBoxModel.class) {
                CComboBoxModel comboModel = (CComboBoxModel)data;
                JComboBox combo = new JComboBox(comboModel);
                combo.setSelectedItem(comboModel.getSelectedItem());
                int cspace = 1;
                if (column == table.getColumnCount() - 1) {
                    cspace = 0;
                }
                combo.setBorder(new CBorder(1 - cspace, 1, 0, cspace, new boolean[]{false, false, true, true}, CTable.this.getGridColor()));
                combo.setFocusable(false);
                combo.addItemListener(new ItemListener(){

                    public void itemStateChanged(ItemEvent e) {
                        if (e.getStateChange() == 1) {
                            table.setValueAt(CEditor.this.getCellEditorValue(), row, column);
                        }
                    }
                });
                this.component = combo;
            }
            if (typeClass == Integer.class) {
                ((JTextField)this.component).setDocument(new TextFilter("0123456789"));
                ((JTextField)this.component).setText(text);
            }
            return this.component;
        }

        public Object getCellEditorValue() {
            Class<?> typeClass = this.type;
            Object value = null;
            if (typeClass == CProperty.CPropertyOption.class) {
                typeClass = this.property.getValue().getClass();
            }
            if (typeClass == Integer.class) {
                value = Integer.parseInt(((JTextField)this.component).getText());
            }
            if (typeClass == Float.class) {
                value = Float.valueOf(Float.parseFloat(((JTextField)this.component).getText()));
            }
            if (typeClass == CComboBoxModel.class) {
                JComboBox combo = (JComboBox)this.component;
                Object[] list = new Object[combo.getItemCount()];
                for (int i = 0; i < list.length; ++i) {
                    list[i] = combo.getItemAt(i);
                }
                value = new CComboBoxModel(list, combo.getSelectedItem());
            }
            if (value == null && this.component instanceof JTextField) {
                value = ((JTextField)this.component).getText();
            }
            if (this.property != null) {
                this.property.setValue(value);
                return this.property;
            }
            return value;
        }

        private void setTextField(JComponent target) {
            target.setBorder(new EBorder(1, 5, 1, 1));
            target.addFocusListener(new FocusListener(){

                public void focusGained(FocusEvent e) {
                    JTextField source = (JTextField)e.getComponent();
                    if (CEditor.this.type == Float.class && !source.getText().contains(".")) {
                        source.setText(source.getText() + ".0");
                        source.setCaretPosition(source.getText().length() - 2);
                    }
                }

                public void focusLost(FocusEvent e) {
                }
            });
            target.addKeyListener(new KeyListener(){

                public void keyTyped(KeyEvent e) {
                }

                public void keyPressed(KeyEvent e) {
                }

                public void keyReleased(KeyEvent e) {
                    this.keyAction(e);
                }

                private void keyAction(KeyEvent e) {
                    JTextField source = (JTextField)e.getComponent();
                    int pos = source.getCaretPosition();
                    int start = source.getSelectionStart();
                    int end = source.getSelectionEnd();
                    String text = source.getText();
                    text = text.substring(0, start) + text.substring(end);
                    if ((CEditor.this.type == Integer.class || CEditor.this.type == Float.class) && text.length() == 0) {
                        text = "0";
                        pos = 1;
                    }
                    if (CEditor.this.type == Integer.class) {
                        text = "" + Integer.parseInt(text);
                    }
                    if (CEditor.this.type == Float.class) {
                        text = "" + Float.parseFloat(text);
                    }
                    if (text.length() < source.getText().length()) {
                        pos -= source.getText().length() - text.length();
                    }
                    source.setText(text);
                    if (pos > text.length()) {
                        pos = text.length();
                    }
                    if (pos < 0) {
                        pos = 0;
                    }
                    source.setCaretPosition(pos);
                }
            });
        }

        private class EBorder
        implements Border {
            private Insets insets = new Insets(1, 1, 1, 1);

            public EBorder(int top, int left, int bottom, int right) {
                this.insets = new Insets(top, left, bottom, right);
            }

            public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
                g.setColor(Color.black);
                if (CEditor.this.error) {
                    g.setColor(Color.red);
                }
                g.fillRect(0, 0, c.getWidth(), 1);
                g.fillRect(0, 0, 1, c.getHeight());
                g.fillRect(0, c.getHeight() - 1, c.getWidth(), 1);
                g.fillRect(c.getWidth() - 1, 0, 1, c.getHeight());
            }

            public Insets getBorderInsets(Component c) {
                return this.insets;
            }

            public boolean isBorderOpaque() {
                return true;
            }
        }
    }

    private class CRenderer
    implements TableCellRenderer {
        public CRenderer() {
            CTable.this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    CTable.this.parent.changeFocus(e);
                }
            });
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            CTableModel model = (CTableModel)table.getModel();
            Class<?> type = model.getCellClass(row, column);
            JLabel target = new JLabel("" + value);
            Object data = value;
            if (type == CProperty.CPropertyOption.class) {
                CProperty.CPropertyOption property = (CProperty.CPropertyOption)value;
                data = property.getValue();
                type = data.getClass();
            }
            if (type == CComboBoxModel.class) {
                CComboBoxModel combo = (CComboBoxModel)data;
                target = new JLabel("" + combo.getSelectedItem());
            }
            int cspace = 1;
            if (column == table.getColumnCount() - 1) {
                cspace = 0;
            }
            target.setBorder(new CBorder(1 - cspace, 5, 0, cspace, new boolean[]{false, false, true, true}, CTable.this.getGridColor()));
            if (column == 0) {
                target.setBackground(new Color(240, 240, 240));
            } else {
                target.setBackground(new Color(255, 255, 255));
            }
            target.setForeground(new Color(0, 0, 0));
            if (isSelected) {
                target.setBackground(new Color(51, 153, 255));
                target.setForeground(new Color(255, 255, 255));
            }
            target.setOpaque(true);
            return target;
        }
    }
}

