/*
 * Decompiled with CFR 0.152.
 */
package util.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JLayeredPane;
import util.CProperty;
import util.Settings;
import util.gui.CDesktop;
import util.gui.CDock;
import util.gui.CGroup;
import util.gui.CTab;

public class CPanel
extends JLayeredPane {
    public static final int FLOAT = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    private String name;
    private int dock;
    private int bar;
    private int group;
    private int index;
    private Dimension panelSize = new Dimension(0, 0);
    private boolean selected = false;
    private CProperty.CPropertyOption property;

    public CPanel(String name, int dock) {
        this(name, dock, 0, 0);
    }

    public CPanel(String name, int dock, int bar) {
        this(name, dock, bar, 0);
    }

    public CPanel(String name, int dock, int bar, int group) {
        this.name = name;
        this.dock = dock;
        this.bar = bar;
        this.group = group;
        this.setLayout(new BorderLayout());
        this.setMinimumSize(new Dimension(100, 100));
        this.setBackground(new Color(237, 237, 237));
        this.setOpaque(true);
    }

    public String toString() {
        return "Panel-" + this.getName() + ": " + CDock.getName(this.dock) + "-" + this.bar + "-" + this.group + " Selected: " + this.isSelected();
    }

    public void setSize(int width, int height) {
        if (width < this.getMinimumSize().width) {
            width = this.getMinimumSize().width;
        }
        if (height < this.getMinimumSize().height) {
            height = this.getMinimumSize().height;
        }
        super.setSize(width, height);
    }

    public void setMinimumSize(Dimension minimumSize) {
        super.setMinimumSize(minimumSize);
        Dimension size = this.getPanelSize();
        if (size.width > minimumSize.width) {
            size.width = minimumSize.width;
        }
        if (size.height > minimumSize.height) {
            size.height = minimumSize.height;
        }
        this.setPanelSize(size);
    }

    public void setPanelSize(Dimension panelSize) {
        Dimension minimumSize = this.getMinimumSize();
        if (minimumSize.width > panelSize.width) {
            panelSize.width = minimumSize.width;
        }
        if (minimumSize.height > panelSize.height) {
            panelSize.height = minimumSize.height;
        }
        this.panelSize = panelSize;
        this.setSize(panelSize);
    }

    public Dimension getPanelSize() {
        return this.panelSize;
    }

    public void setProperty(CProperty.CPropertyOption property) {
        this.property = property;
        property.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                CPanel.this.setEnabled((Boolean)evt.getNewValue());
            }
        });
    }

    public String getName() {
        return this.name;
    }

    public int getDock() {
        return this.dock;
    }

    public int getBar() {
        return this.bar;
    }

    public int getGroup() {
        return this.group;
    }

    public int getIndex() {
        return this.index;
    }

    public boolean isSelected() {
        return this.selected;
    }

    public CGroup getParentGroup() {
        if (this.getParent() != null) {
            return (CGroup)this.getParent().getParent();
        }
        return null;
    }

    public CDock getParentDock() {
        if (this.getParentGroup() != null) {
            return this.getParentGroup().getParentDock();
        }
        return null;
    }

    public CDesktop getDesktop() {
        if (this.getParentGroup() != null) {
            return this.getParentGroup().getDesktop();
        }
        return null;
    }

    public void setLocation(int dock, int bar, int group) {
        this.dock = dock;
        this.bar = bar;
        this.group = group;
        this.checkLocation();
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.setVisible(selected);
        if (this.getParentGroup() != null) {
            if (this.getParentGroup().getSelected() != this && selected) {
                this.getParentGroup().setSelected(this);
            }
            CTab tab = this.getParentGroup().getTab(this);
            if (selected) {
                tab.setState(2);
            } else {
                tab.setState(0);
            }
        }
        Settings.saveSetting(this.getName() + ".selected", selected);
    }

    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        this.property.setValue(enabled);
        if (!enabled) {
            // empty if block
        }
        Settings.saveSetting(this.getName() + ".enabled", enabled);
    }

    public void setDock(int dock) {
        this.dock = dock;
    }

    public void setBar(int bar) {
        this.bar = bar;
    }

    public void setGroup(int group) {
        this.group = group;
    }

    public void setIndex(int index) {
        int oldIndex = this.index;
        this.index = index;
        this.firePropertyChange("index", oldIndex, index);
    }

    private void checkLocation() {
        if (this.getDesktop() != null) {
            boolean isParent;
            boolean isDock = this.getParentGroup().getDock() == this.dock;
            boolean isBar = this.getParentGroup().getBar() == this.bar;
            boolean isGroup = this.getParentGroup().getGroup() == this.group;
            boolean bl = isParent = isDock && isBar && isGroup;
            if (!isParent) {
                CGroup parent = this.getDesktop().getPanelBox().getDock(this.dock, this.bar).getGroup(this.group);
                parent.addPanel(this);
            }
        }
    }
}

