/*
 * Decompiled with CFR 0.152.
 */
package util.gui.panels;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JLayeredPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import util.CImageIcon;
import util.gui.panels.CPanel;
import util.gui.panels.CTable;
import util.gui.panels.CTableModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CInfoPanel
extends CPanel {
    private ArrayList<CTableModel> modelList = new ArrayList();
    private JScrollPane scrollPane;
    private CContentPane contentPane;

    public CInfoPanel(String name, int dock) {
        this(name, dock, 0, 0);
    }

    public CInfoPanel(String name, int dock, int bar) {
        this(name, dock, bar, 0);
    }

    public CInfoPanel(String name, int dock, int bar, int group) {
        super(name, dock, bar, group);
        this.setMinimumSize(new Dimension(150, 99));
        this.scrollPane = new JScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(22);
        this.scrollPane.setHorizontalScrollBarPolicy(31);
        this.scrollPane.getVerticalScrollBar().setUnitIncrement(5);
        this.add(this.scrollPane);
        this.contentPane = new CContentPane();
        this.scrollPane.setViewportView(this.contentPane);
    }

    public void addModel(CTableModel model) {
        this.modelList.add(model);
        this.init();
    }

    public void setModel(ArrayList<CTableModel> modelList) {
        this.modelList = modelList;
        this.init();
    }

    public void setModel(CTableModel model) {
        for (CTableModel item : this.modelList) {
            if (!item.getName().equals(model.getName())) continue;
            this.modelList.set(this.modelList.indexOf(item), model);
            this.init();
            return;
        }
        this.addModel(model);
    }

    public ArrayList<CTableModel> getModel() {
        return this.modelList;
    }

    public void removeModel() {
        this.contentPane.removeAll();
        this.modelList = new ArrayList();
    }

    public void changeFocus(MouseEvent e) {
        CTable table = (CTable)e.getComponent();
        for (Component comp : this.contentPane.getComponents()) {
            CAttribute attr = (CAttribute)comp;
            if (attr.getTable() == table) continue;
            attr.getTable().clearSelection();
            attr.getTable().getDefaultEditor(Object.class).stopCellEditing();
            attr.getTable().getDefaultEditor(Object.class).cancelCellEditing();
        }
    }

    private CInfoPanel getThis() {
        return this;
    }

    public void init() {
        this.contentPane.removeAll();
        for (CTableModel data : this.getModel()) {
            this.contentPane.add(new CAttribute(data));
        }
        this.contentPane.resize();
    }

    public class CAttribute
    extends JLayeredPane {
        private static final int HEIGHT = 22;
        private JPanel header;
        private JLabel headerLabel;
        private CTable table;
        private CImageIcon open = new CImageIcon("node_open");
        private CImageIcon close = new CImageIcon("node_close");
        private CTableModel dataModel;

        public CAttribute(CTableModel data) {
            this.dataModel = data;
            this.setLayout(new BorderLayout());
            this.setSize(this.getWidth(), 22);
            this.header = new JPanel();
            this.header.setLayout(new BorderLayout());
            this.header.setBackground(new Color(213, 213, 213));
            this.header.setPreferredSize(new Dimension(0, 22));
            this.header.setBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, new Color(180, 180, 180)));
            this.header.addMouseListener(new MouseAdapter(){

                public void mouseReleased(MouseEvent e) {
                    if (CAttribute.this.isEnabled()) {
                        CAttribute.this.setEnabled(false);
                    } else {
                        CAttribute.this.setEnabled(true);
                    }
                    CInfoPanel.this.contentPane.resize();
                }

                public void mouseEntered(MouseEvent e) {
                    CInfoPanel.this.getDesktop().setCursor(new Cursor(12));
                }

                public void mouseExited(MouseEvent e) {
                    CInfoPanel.this.getDesktop().setCursor(null);
                }
            });
            this.add((Component)this.header, "North");
            this.headerLabel = new JLabel(data.getName());
            this.headerLabel.setBorder(BorderFactory.createEmptyBorder(1, 0, 0, 0));
            this.header.add(this.headerLabel);
            this.table = new CTable(CInfoPanel.this.getThis());
            this.table.setModel(data);
            this.add(this.table);
            this.setEnabled(data.isEnabled());
        }

        public void setEnabled(boolean enabled) {
            super.setEnabled(enabled);
            this.dataModel.setEnabled(enabled);
            if (enabled) {
                this.setSize(this.getWidth(), 22 + this.table.getRowCount() * this.table.getRowHeight());
                this.headerLabel.setIcon(this.open);
            } else {
                this.setSize(this.getWidth(), 22);
                this.headerLabel.setIcon(this.close);
            }
            this.doLayout();
        }

        public CTable getTable() {
            return this.table;
        }
    }

    private class CContentPane
    extends JLayeredPane {
        public void doLayout() {
            int height = 0;
            for (Component component : this.getComponents()) {
                component.setBounds(0, height, this.getWidth(), component.getHeight());
                if (component.getHeight() <= 22 && (height += component.getHeight()) < CInfoPanel.this.scrollPane.getHeight()) continue;
                --height;
            }
        }

        public void resize() {
            int height = 0;
            for (Component component : this.getComponents()) {
                component.setBounds(0, height, this.getWidth(), component.getHeight());
                if (component.getHeight() <= 22 && (height += component.getHeight()) < CInfoPanel.this.scrollPane.getHeight()) continue;
                --height;
            }
            this.setPreferredSize(new Dimension(this.getWidth(), height));
            this.setSize(this.getWidth(), height);
        }
    }
}

