/*
 * Decompiled with CFR 0.152.
 */
package util.gui.panels;

import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import util.CProperty;
import util.Common;
import util.gui.CToolBar;
import util.gui.frames.FFrameRender;
import util.gui.frames.FImageRender;
import util.gui.panels.CPanel;

public class CFramesPanel
extends CPanel {
    private FScrollPane scrollPane;
    private FContentPane contentPane;
    private FToolBar toolBar;

    public CFramesPanel(String name, int dock) {
        this(name, dock, 0, 0);
    }

    public CFramesPanel(String name, int dock, int bar) {
        this(name, dock, bar, 0);
    }

    public CFramesPanel(String name, int dock, int bar, int group) {
        super(name, dock, bar, group);
        this.setMinimumSize(new Dimension(300, 100));
        this.scrollPane = new FScrollPane();
        this.scrollPane.setVerticalScrollBarPolicy(21);
        this.scrollPane.setHorizontalScrollBarPolicy(32);
        this.scrollPane.getHorizontalScrollBar().setUnitIncrement(10);
        this.scrollPane.setBorder(null);
        this.add(this.scrollPane);
        this.contentPane = new FContentPane();
        this.scrollPane.setViewportView(this.contentPane);
        this.toolBar = new FToolBar();
        this.toolBar.setPreferredSize(new Dimension(200, 0));
        this.toolBar.addButton(201);
        this.toolBar.addButton(202);
        this.toolBar.addToggle(200, CProperty.PLAYBACK);
        this.toolBar.addButton(203);
        this.toolBar.addButton(204);
        this.scrollPane.setCorner("LOWER_LEFT_CORNER", this.toolBar);
        CProperty.addPropertyChangeListener(new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent evt) {
                String name = evt.getPropertyName();
                if (name.equals(CProperty.FRAMES.getName())) {
                    ArrayList frames = (ArrayList)CProperty.FRAMES.getValue();
                    CFramesPanel.this.contentPane.removeAll();
                    for (FFrameRender frame : frames) {
                        CFramesPanel.this.contentPane.add(new FFrameButton(frame));
                    }
                    CFramesPanel.this.contentPane.revalidate();
                } else if (name.equals(CProperty.SELECTED_FRAME.getName())) {
                    CFramesPanel.this.revalidate();
                }
            }
        });
    }

    public void setSelectedFrame(int frameIndex) {
        CProperty.SELECTED_FRAME.setValue(frameIndex);
        this.revalidate();
    }

    public int getSelectedFrame() {
        return (Integer)CProperty.SELECTED_FRAME.getValue();
    }

    private boolean isSelected(int frameIndex) {
        return frameIndex == this.getSelectedFrame();
    }

    private class FToolBar
    extends CToolBar {
        public FToolBar() {
            this.setLayout(new FlowLayout(0, 2, -1));
        }

        public void paintComponent(Graphics g) {
            g.setColor(this.getBackground());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
        }

        public void lockSize(JComponent target, int width, int height) {
            if (height > 20) {
                height = 20;
            }
            super.lockSize(target, width, height);
        }
    }

    private class FFrameButton
    extends JPanel {
        private final Color SELECTED = new Color(51, 153, 255);
        private FFrameRender frame;

        public FFrameButton(FFrameRender frame) {
            this.frame = frame;
            this.setPreferredSize(new Dimension(69, 80));
            this.addMouseListener(new MouseAdapter(){

                public void mousePressed(MouseEvent e) {
                    CFramesPanel.this.setSelectedFrame(FFrameButton.this.getIndex());
                }

                public void mouseReleased(MouseEvent e) {
                }

                public void mouseEntered(MouseEvent e) {
                    CFramesPanel.this.getDesktop().setCursor(new Cursor(12));
                }

                public void mouseExited(MouseEvent e) {
                    CFramesPanel.this.getDesktop().setCursor(null);
                }
            });
        }

        public void paintComponent(Graphics g) {
            Color BG;
            Color bg = BG = new Color(237, 237, 237);
            Color outline = new Color(200, 200, 200);
            Color border = new Color(160, 160, 160);
            Color text = new Color(30, 30, 30);
            if (CFramesPanel.this.isSelected(this.getIndex())) {
                bg = this.SELECTED;
                outline = Color.WHITE;
                text = Color.WHITE;
            }
            g.setColor(bg);
            g.fillRect(0, 0, this.getWidth(), this.getHeight() - 1);
            int width = this.getWidth() - 2;
            g.setColor(new Color(160, 160, 160));
            g.drawLine(this.getWidth() - 1, 0, width + 1, this.getHeight());
            int size = 4;
            g.setColor(outline);
            g.drawRect(size, size, width - size * 2, width - size * 2);
            size = 7;
            g.drawImage(FImageRender.drawGrid(4, 4, width - size * 2, width - size * 2), size + 1, size + 1, this);
            g.drawImage(this.frame.getImage(), size + 1, size + 1, this);
            String num = "" + (this.getIndex() + 1);
            int numWidth = num.length() * 5 + 7;
            g.setColor(BG);
            g.fillRect(size, size, numWidth, 14);
            g.setColor(border);
            g.drawRect(size, size, width - size * 2, width - size * 2);
            g.drawRect(size, size, numWidth, 14);
            g.setColor(new Color(100, 100, 100));
            g.setFont(new Font("Tahoma", 0, 9));
            g.drawString(num, size + 4, size + 11);
            g.setColor(text);
            g.drawString(Common.calTime(this.getTime()), size + 2, size + width + 1);
        }

        public int getIndex() {
            return this.frame.getIndex();
        }

        public int getTime() {
            return this.frame.getTime();
        }
    }

    private class FContentPane
    extends JPanel {
        public final Color LINE = new Color(160, 160, 160);

        public FContentPane() {
            this.setLayout(new FlowLayout(0, 0, 0));
            this.setBorder(BorderFactory.createMatteBorder(1, 0, 1, 0, this.LINE));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            g.setColor(this.LINE);
            int y = this.getVisibleRect().height - 1;
            g.drawLine(0, y, this.getWidth(), y);
        }
    }

    private class FScrollPane
    extends JScrollPane {
        private FScrollPane() {
        }

        public void doLayout() {
            super.doLayout();
            JScrollBar hscroll = this.getHorizontalScrollBar();
            Component bottom = this.getCorner("LOWER_LEFT_CORNER");
            bottom.setSize(bottom.getPreferredSize().width, hscroll.getHeight());
            hscroll.setBounds(bottom.getWidth(), hscroll.getY(), hscroll.getWidth() - bottom.getWidth(), hscroll.getHeight());
        }
    }
}

