/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import javax.swing.JComponent;

public class CSplitLayout
extends BorderLayout {
    private static final int NONE = 0;
    private static final int VERTICAL = 1;
    private static final int HORIZONTAL = 2;
    private int mode = 0;
    private Component ca;
    private Component cb;
    private Point mouseStart;
    private boolean resizing = false;
    private JComponent target;

    public CSplitLayout(JComponent component) {
        super(4, 4);
        this.target = component;
        this.target.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent e) {
                CSplitLayout.this.mouseStart = e.getPoint();
                CSplitLayout.this.resizing = CSplitLayout.this.mode != 0;
            }

            public void mouseReleased(MouseEvent e) {
                CSplitLayout.this.resizing = false;
                CSplitLayout.this.checkLocation(e);
            }

            public void mouseExited(MouseEvent e) {
                if (!CSplitLayout.this.resizing) {
                    CSplitLayout.this.target.setCursor(null);
                }
            }
        });
        this.target.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent e) {
                Point diff = new Point(e.getX() - ((CSplitLayout)CSplitLayout.this).mouseStart.x, ((CSplitLayout)CSplitLayout.this).mouseStart.y - e.getY());
                Component c2 = CSplitLayout.this.cb;
                Component c = CSplitLayout.this.ca;
                switch (CSplitLayout.this.mode) {
                    case 2: {
                        if (c.getPreferredSize().width == 0) {
                            c2 = CSplitLayout.this.ca;
                            c = CSplitLayout.this.cb;
                        }
                        if (diff.x > c2.getWidth() - c2.getMinimumSize().width) {
                            diff.x = c2.getWidth() - c2.getMinimumSize().width;
                        }
                        Dimension pref = c.getPreferredSize();
                        pref = new Dimension(pref.width + diff.x, pref.height);
                        if (pref.width < c.getMinimumSize().width) {
                            pref.width = c.getMinimumSize().width;
                        }
                        c.setPreferredSize(pref);
                        break;
                    }
                    case 1: {
                        if (c.getPreferredSize().height == 0) {
                            c2 = CSplitLayout.this.ca;
                            c = CSplitLayout.this.cb;
                        }
                        if (diff.y > c2.getHeight() - c2.getMinimumSize().height) {
                            diff.y = c2.getHeight() - c2.getMinimumSize().height;
                        }
                        Dimension pref = c.getPreferredSize();
                        pref = new Dimension(pref.width, pref.height + diff.y);
                        if (pref.height < c.getMinimumSize().height) {
                            pref.height = c.getMinimumSize().height;
                        }
                        c.setPreferredSize(pref);
                    }
                }
                CSplitLayout.this.target.revalidate();
                CSplitLayout.this.mouseStart = e.getPoint();
            }

            public void mouseMoved(MouseEvent e) {
                CSplitLayout.this.checkLocation(e);
            }
        });
    }

    private void checkLocation(MouseEvent e) {
        Component[] comp = this.target.getComponents();
        Component left = null;
        Component right = null;
        Component top = null;
        Component bottom = null;
        Point mouse = e.getPoint();
        for (Component c : comp) {
            Rectangle bounds = c.getBounds();
            if (bounds.contains(new Point(mouse.x - 4, mouse.y))) {
                left = c;
            }
            if (bounds.contains(new Point(mouse.x + 4, mouse.y))) {
                right = c;
            }
            if (bounds.contains(new Point(mouse.x, mouse.y - 4))) {
                top = c;
            }
            if (!bounds.contains(new Point(mouse.x, mouse.y + 4))) continue;
            bottom = c;
        }
        if (left != null && right != null && left != right) {
            this.target.setCursor(new Cursor(10));
            this.mode = 2;
            this.ca = left;
            this.cb = right;
        } else if (top != null && bottom != null && top != bottom) {
            this.target.setCursor(new Cursor(8));
            this.mode = 1;
            this.ca = top;
            this.cb = bottom;
        } else {
            this.target.setCursor(null);
            this.mode = 0;
            this.ca = null;
            this.cb = null;
        }
    }
}

