/*
 * Decompiled with CFR 0.152.
 */
package util.gui.frames;

import java.awt.Rectangle;
import java.beans.PropertyChangeEvent;
import java.util.ArrayList;
import util.CClipboard;
import util.CProperty;
import util.gui.CDesktop;
import util.gui.frames.CFrame;
import util.gui.frames.FFrameRender;
import util.gui.frames.FImageRender;
import util.struct.CAnim;
import util.struct.CAnimBank;
import util.struct.CCellBuffer;
import util.struct.DFormat;
import util.struct.DMapAnim;

public class CMapAnimFrame
extends CFrame {
    private FImageRender display;
    private Thread playbackThread;
    private boolean toggleAlpha = true;
    private boolean toggleOutline = false;
    private boolean toggleRender = true;
    private int selectedFrame;
    private ArrayList<CCellBuffer> frames = new ArrayList();
    private ArrayList<FFrameRender> frameThumbs = new ArrayList();

    public CMapAnimFrame(DFormat format) {
        super(format);
        this.display = new FImageRender();
        this.playbackThread = new PlaybackThread();
        this.add(this.display);
        this.setMapAnim(this.getFormat());
        this.getToolBar().addComboBox(CProperty.SELECTED_MAP_ANIM_INDEX, "Animation", "Animation Index");
        this.getToolBar().addSeparator();
        this.getToolBar().addToggle(2000, CProperty.ALPHA);
    }

    public DMapAnim getFormat() {
        return (DMapAnim)super.getFormat();
    }

    public void checkProperty(PropertyChangeEvent evt, boolean ignored) {
        ignored = true;
        String name = evt.getPropertyName();
        Object value = evt.getNewValue();
        if (name.equals(CProperty.ALPHA.getName())) {
            this.toggleAlpha = (Boolean)value;
            this.buffer();
        } else if (!name.equals(CProperty.FRAMES.getName()) && !name.equals(CProperty.TOTAL_FRAMES.getName())) {
            ignored = false;
        }
        super.checkProperty(evt, ignored);
        boolean paletteChange = name.equals(CProperty.SELECTED_PALETTE.getName());
        boolean imageChange = name.equals(CProperty.SELECTED_TILE.getName());
        boolean cellChange = name.equals(CProperty.SELECTED_CELL.getName());
        if (paletteChange || imageChange || cellChange) {
            this.buffer();
        }
        if (name.equals(CProperty.SELECTED_MAP_ANIM_INDEX.getName())) {
            CDesktop.PANEL_INFO.setModel(this.getMapAnimBank().getModel());
            this.buffer();
            CProperty.TOTAL_FRAMES.setValue(this.getMapAnimBank().getItemCount());
            CProperty.SELECTED_FRAME.setValue(0);
            this.update();
        }
        if (name.equals(CProperty.SELECTED_FRAME.getName())) {
            this.selectedFrame = (Integer)value;
        }
    }

    public void setProperties() {
        super.setProperties();
        CProperty.ALPHA.setValue(this.toggleAlpha);
        CDesktop.PANEL_INFO.addModel(this.getMapAnimBank().getModel());
        CProperty.SELECTED_FRAME.setValue(this.selectedFrame);
        this.buffer();
    }

    public boolean doAction(int action) {
        boolean accept = true;
        switch (action) {
            case 50: {
                CClipboard.setImage(this.display.getImage());
                break;
            }
            default: {
                accept = false;
            }
        }
        return accept;
    }

    private boolean isTransparent() {
        return this.toggleAlpha;
    }

    private boolean isOutlineEnabled() {
        return this.toggleOutline;
    }

    private boolean isRenderEnabled() {
        return this.toggleRender;
    }

    public void update() {
    }

    private void buffer() {
        CAnimBank bank = this.getMapAnimBank();
        this.frames = new ArrayList();
        this.frameThumbs = new ArrayList();
        CProperty.TOTAL_FRAMES.setValue(bank.getItemCount());
        int count = 0;
        Rectangle bounds = null;
        for (CAnim frame : bank.getFrames()) {
            CCellBuffer frameBuffer = new CCellBuffer(frame.getCellOffset());
            this.frames.add(frameBuffer);
            this.frameThumbs.add(new FFrameRender(count++, frame.getLength(), frameBuffer.getImage()));
            bounds = CCellBuffer.checkBounds(bounds, frameBuffer.getBounds());
        }
        CProperty.FRAMES.setValue(this.frameThumbs);
    }

    private void setSelectedIndex(int index) {
        CProperty.SELECTED_FRAME.setValue(index);
    }

    private int getSelectedIndex() {
        return (Integer)CProperty.SELECTED_FRAME.getValue();
    }

    private boolean getPlayback() {
        return (Boolean)CProperty.PLAYBACK.getValue();
    }

    private class PlaybackThread
    extends Thread {
        private boolean running = true;

        public PlaybackThread() {
            this.start();
        }

        public void run() {
            while (this.running) {
                if (CMapAnimFrame.this.isSelected() && CMapAnimFrame.this.getPlayback() && CMapAnimFrame.this.frames.size() > 0) {
                    int index = CMapAnimFrame.this.getSelectedIndex();
                    index = index == CMapAnimFrame.this.getMapAnimBank().getItemCount() - 1 ? 0 : ++index;
                    CMapAnimFrame.this.setSelectedIndex(index);
                    this.doSleep(CMapAnimFrame.this.getMapAnimBank().getSelected().getLength());
                    continue;
                }
                this.doSleep(1000L);
            }
        }

        public void doSleep(long millis) {
            try {
                PlaybackThread.sleep(millis);
            }
            catch (InterruptedException ex) {
                ex.printStackTrace();
            }
        }
    }
}

