/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.Rectangle;
import java.util.ArrayList;
import javax.swing.JLayeredPane;
import util.gui.CDesktop;
import util.gui.CToolBar;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CToolBox
extends JLayeredPane {
    public static final int FLOAT = 0;
    public static final int TOP = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    public static final int BOTTOM = 4;
    private ArrayList<CToolBar> tools = new ArrayList();

    public CToolBox() {
        this.setLayout(new LayoutManager(){

            public void addLayoutComponent(String name, Component comp) {
            }

            public void removeLayoutComponent(Component comp) {
            }

            public Dimension preferredLayoutSize(Container parent) {
                return new Dimension(20, 20);
            }

            public Dimension minimumLayoutSize(Container parent) {
                return new Dimension(20, 20);
            }

            public void layoutContainer(Container parent) {
                int i;
                int height = 29;
                int width = 29;
                int topHeight = CToolBox.this.getTopCount() * height;
                int bottomHeight = CToolBox.this.getBottomCount() * height;
                int leftWidth = CToolBox.this.getLeftCount() * width;
                int rightWidth = CToolBox.this.getRightCount() * width;
                int frameWidth = CToolBox.this.getWidth() - leftWidth - rightWidth;
                int frameHeight = CToolBox.this.getHeight() - topHeight - bottomHeight;
                Rectangle groupSize = new Rectangle(leftWidth, topHeight, frameWidth, frameHeight);
                for (i = 0; i < CToolBox.this.getTopCount(); ++i) {
                    CToolBox.this.getTools(1).get(i).setBounds(0, i * height, CToolBox.this.getWidth(), height);
                }
                for (i = 0; i < CToolBox.this.getLeftCount(); ++i) {
                    CToolBox.this.getTools(2).get(i).setBounds(i * width, topHeight, width, frameHeight);
                }
                for (i = 0; i < CToolBox.this.getRightCount(); ++i) {
                    CToolBox.this.getTools(3).get(i).setBounds(CToolBox.this.getWidth() - (CToolBox.this.getRightCount() - i) * width, topHeight, width, frameHeight);
                }
                for (i = 0; i < CToolBox.this.getBottomCount(); ++i) {
                    CToolBox.this.getTools(4).get(i).setBounds(0, CToolBox.this.getHeight() - (CToolBox.this.getBottomCount() - i) * height, CToolBox.this.getWidth(), height);
                }
                CToolBox.this.getDesktop().getPanelBox().setBounds(groupSize);
                CToolBox.this.getDesktop().getPanelBox().doLayout();
            }
        });
    }

    private CDesktop getDesktop() {
        return (CDesktop)this.getParent();
    }

    public int getTopCount() {
        return this.getTools(1).size();
    }

    public int getBottomCount() {
        return this.getTools(4).size();
    }

    public int getLeftCount() {
        return this.getTools(2).size();
    }

    public int getRightCount() {
        return this.getTools(3).size();
    }

    public int getFloatCount() {
        return this.getTools(0).size();
    }

    public ArrayList<CToolBar> getTools(int dock) {
        ArrayList<CToolBar> results = new ArrayList<CToolBar>();
        for (CToolBar tool : this.tools) {
            if (tool.getDock() != dock) continue;
            results.add(tool);
        }
        return results;
    }

    public void addTool(CToolBar toolbar) {
        this.tools.add(toolbar);
        if (toolbar.getDock() != 0) {
            this.add(toolbar);
        }
    }
}

