/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import util.CAction;
import util.CIcon;
import util.CProperty;

public class CMenuBar
extends JMenuBar {
    public CMenuBar() {
        this.setMenu();
    }

    private void setMenu() {
        CMenu menuFile = new CMenu("File");
        CMenu menuNew = new CMenu("New", CIcon.NEW);
        CMenu menuRecent = new CMenu("Open Recent...");
        menuFile.add(menuNew);
        menuFile.addSeparator();
        menuFile.add(21);
        menuFile.addSeparator();
        menuFile.add(19);
        menuFile.add(menuRecent);
        menuFile.addSeparator();
        menuFile.add(22);
        menuFile.add(23);
        menuFile.addSeparator();
        menuFile.add(1);
        this.add(menuFile);
        menuNew.setEnabled(false);
        menuNew.add("Palette", CIcon.FILE_PALETTE);
        menuNew.add("Image", CIcon.FILE_IMAGE);
        menuNew.add("Map", CIcon.FILE_MAP);
        menuNew.add("Sprite Table", CIcon.FILE_CELL);
        menuNew.add("Sprite Animation", CIcon.FILE_IMAGEANIM);
        menuNew.addSeparator();
        menuNew.add("Texture", CIcon.FILE_TEXTURE);
        menuNew.add("Texture Animation");
        menuNew.add("Model", CIcon.FILE_MODEL);
        menuNew.add("Model Animation");
        menuNew.addSeparator();
        menuNew.add("Sound", CIcon.FILE_AUDIO);
        menuNew.add("Video", CIcon.FILE_VIDEO);
        menuNew.addSeparator();
        menuNew.add("Archive", CIcon.FILE_ARCHIVE);
        menuRecent.setEnabled(false);
        menuRecent.add("Clear Recent History");
        CMenu menuWindow = new CMenu("Window");
        menuWindow.addCheck("Info", CProperty.TOGGLE_INFO);
        menuWindow.addCheck("Frames", CProperty.TOGGLE_FRAMES);
        menuWindow.addSeparator();
        menuWindow.addCheck("Color", CProperty.TOGGLE_COLOR);
        this.add(menuWindow);
        CMenu menuHelp = new CMenu("Help");
        menuHelp.add(80);
        this.add(menuHelp);
    }

    public class CCheckItem
    extends JCheckBoxMenuItem {
        public CCheckItem(String text, final CProperty.CPropertyOption property) {
            this.setText(text);
            this.setSelected((Boolean)property.getValue());
            property.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    CCheckItem.this.setSelected((Boolean)evt.getNewValue());
                }
            });
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    property.setValue(CCheckItem.this.isSelected());
                }
            });
        }
    }

    private class CItem
    extends JMenuItem {
        public CItem(int actionId) {
            this.setAction(CAction.getAction(actionId));
        }
    }

    private class CMenu
    extends JMenu {
        public CMenu(String text) {
            this(text, null);
        }

        public CMenu(String text, CIcon icon) {
            this.setText(text);
            if (icon != null) {
                this.setIcon(icon.getIcon());
            }
        }

        public JMenuItem add(String text) {
            return this.add(new JMenuItem(text));
        }

        public JMenuItem add(String text, CIcon icon) {
            return this.add(new JMenuItem(text, icon.getIcon()));
        }

        public JMenuItem add(int actionId) {
            return this.add(new CItem(actionId));
        }

        public JMenuItem addCheck(String text, CProperty.CPropertyOption property) {
            return this.add(new CCheckItem(text, property));
        }
    }
}

