/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.RoundRectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import util.gui.CDesktop;

public class CDragBox
extends JPanel {
    public static final int GROUP = 10;
    public static final int GROUP_TOP = 11;
    public static final int GROUP_BOTTOM = 12;
    public static final int GROUP_MIDDLE = 13;
    private CDesktop desktop;
    private Rectangle dragRect = new Rectangle(0, 0, 0, 0);
    private int mode;

    public CDragBox(CDesktop desktop) {
        this.desktop = desktop;
    }

    public void paintComponent(Graphics g) {
        Rectangle rect = new Rectangle(this.dragRect.x, this.dragRect.y, this.dragRect.width, this.dragRect.height);
        int left = rect.x;
        int right = rect.x + rect.width;
        int top = rect.y;
        int bottom = rect.y + rect.height;
        int width = rect.width;
        int height = rect.height;
        BufferedImage rend = new BufferedImage(this.getWidth(), this.getHeight(), 2);
        Graphics g2 = rend.getGraphics();
        switch (this.mode) {
            case 1: {
                rect.x += 25;
                rect.width -= 50;
                this.drawBox(g2, this.mode, rect);
                this.drawHighlight(g2, this.mode, rect);
                break;
            }
            case 4: {
                rect.x += 25;
                rect.width -= 50;
                this.drawBox(g2, this.mode, rect);
                this.drawHighlight(g2, this.mode, rect);
                break;
            }
            case 2: {
                rect.y += 25;
                rect.height -= 50;
                this.drawBox(g2, this.mode, rect);
                this.drawHighlight(g2, this.mode, rect);
                break;
            }
            case 3: {
                rect.y += 25;
                rect.height -= 50;
                this.drawBox(g2, this.mode, rect);
                this.drawHighlight(g2, this.mode, rect);
                break;
            }
            case 10: {
                this.drawRectHighlight(g2, rect);
                break;
            }
            case 11: {
                rect.y += rect.height;
                this.drawHighlight(g2, this.mode, rect);
                break;
            }
            case 13: {
                rect.y += rect.height - 3;
                this.drawHighlight(g2, this.mode, rect);
                break;
            }
            case 12: {
                this.drawBox(g2, 1, rect);
                this.drawHighlight(g2, 1, rect);
                break;
            }
            default: {
                g.setColor(new Color(255, 0, 0, 50));
                g.fillRect(rect.x, rect.y, rect.width, rect.height);
            }
        }
        g.drawImage(rend, 0, 0, null);
    }

    private void drawBox(Graphics g, int dock, Rectangle box) {
        BufferedImage image = new BufferedImage(box.width, box.height, 2);
        Graphics2D g2 = (Graphics2D)image.getGraphics();
        int round = 4;
        g2.setStroke(new BasicStroke(1.0f));
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        int x = 0;
        int y = 0;
        int width = box.width - 1;
        int height = box.height - 1;
        switch (dock) {
            case 1: {
                y -= round * 2;
                height += round * 2;
                break;
            }
            case 4: {
                height += round * 2;
                break;
            }
            case 2: {
                x -= round * 2;
                width += round * 2;
                break;
            }
            case 3: {
                width += round * 2;
            }
        }
        g2.setColor(new Color(80, 80, 80, 60));
        g2.fill(new RoundRectangle2D.Float(x, y, width, height, round, round));
        g2.setColor(new Color(160, 160, 160, 80));
        g2.draw(new RoundRectangle2D.Float(x + 1, y + 1, width - 2, height - 2, round, round));
        g2.setColor(new Color(50, 50, 50, 120));
        g2.draw(new RoundRectangle2D.Float(x, y, width, height, round, round));
        g.drawImage(image, box.x, box.y, null);
    }

    private void drawRectHighlight(Graphics g, Rectangle box) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setStroke(new BasicStroke(2.5f));
        g2.setColor(new Color(36, 153, 206, 200));
        g2.draw(new RoundRectangle2D.Float(box.x + 1, box.y + 1, box.width - 3, box.height - 3, 4.0f, 4.0f));
    }

    private void drawHighlight(Graphics g, int dock, Rectangle box) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
        g2.setStroke(new BasicStroke(1.0f));
        int hr = 36;
        int hg = 153;
        int hb = 206;
        int x = box.x;
        int y = box.y;
        int x2 = box.x + box.width - 1;
        int y2 = box.y + box.height - 1;
        boolean horizontal = dock != 2 && dock != 3;
        switch (dock) {
            case 1: {
                x += 2;
                x2 -= 2;
                break;
            }
            case 4: {
                x += 2;
                x2 -= 2;
                y += box.height - 5;
                break;
            }
            case 2: {
                y += 2;
                y2 -= 2;
                break;
            }
            case 3: {
                x += box.width - 5;
                y += 2;
                y2 -= 2;
            }
        }
        g2.setColor(new Color(hr, hg, hb, 200));
        if (horizontal) {
            g2.drawLine(x, y + 2, x2, y + 2);
            g2.setColor(new Color(hr, hg, hb, 160));
            g2.drawLine(x, y + 1, x2, y + 1);
            g2.drawLine(x, y + 3, x2, y + 3);
            g2.setColor(new Color(hr, hg, hb, 100));
            g2.drawLine(x, y, x2, y);
            g2.drawLine(x, y + 4, x2, y + 4);
        } else {
            g2.drawLine(x + 2, y, x + 2, y2);
            g2.setColor(new Color(hr, hg, hb, 160));
            g2.drawLine(x + 1, y, x + 1, y2);
            g2.drawLine(x + 3, y, x + 3, y2);
            g2.setColor(new Color(hr, hg, hb, 100));
            g2.drawLine(x, y, x, y2);
            g2.drawLine(x + 4, y, x + 4, y2);
        }
    }

    public void showDrag(int mode, Rectangle dragRect) {
        if (this.check(mode, dragRect)) {
            this.desktop.repaint();
        }
    }

    public void hideDrag() {
        if (this.check(-1, new Rectangle(0, 0, 0, 0))) {
            this.desktop.repaint();
        }
    }

    private boolean check(int mode, Rectangle dragRect) {
        int oldMode = this.mode;
        Rectangle oldRect = this.dragRect;
        this.mode = mode;
        this.dragRect = dragRect;
        boolean xMatch = oldRect.x == dragRect.x;
        boolean yMatch = oldRect.y == dragRect.y;
        boolean widthMatch = oldRect.width == dragRect.width;
        boolean heightMatch = oldRect.height == dragRect.height;
        boolean rectMatch = xMatch && yMatch && widthMatch && heightMatch;
        boolean result = oldMode != mode || !rectMatch;
        return result;
    }
}

