/*
 * Decompiled with CFR 0.152.
 */
package util.gui;

import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

public abstract class CButtonBox
extends JLayeredPane {
    public static final int CLOSE = 0;
    public static final int MIN_CLOSE = 1;
    public static final int RESTORE_CLOSE = 2;
    public static final int MIN_MAX_CLOSE = 3;
    public static final int MIN_RESTORE_CLOSE = 4;
    public static final int RESTORE_MAX_CLOSE = 5;
    public static final int TYPE_CLOSE = 0;
    public static final int TYPE_MIN = 1;
    public static final int TYPE_MAX = 2;
    public static final int TYPE_RESTORE = 3;
    public static final int STATE_OFF = 0;
    public static final int STATE_OVER = 1;
    public static final int STATE_ON = 2;
    private CButton min;
    private CButton max;
    private CButton close;
    private CButton restore;
    private int width;

    public CButtonBox(int mode) {
        this.setLayout(new FlowLayout(0, 0, 0));
        this.setMode(mode);
    }

    public void setMode(int mode) {
        this.removeAll();
        this.width = 0;
        this.min = new CButton(1);
        this.max = new CButton(2);
        this.close = new CButton(0);
        this.restore = new CButton(3);
        switch (mode) {
            case 0: {
                this.add(this.close);
                break;
            }
            case 1: {
                this.add(this.min);
                this.add(this.close);
                break;
            }
            case 2: {
                this.add(this.restore);
                this.add(this.close);
                break;
            }
            case 3: {
                this.add(this.min);
                this.add(this.max);
                this.add(this.close);
                break;
            }
            case 4: {
                this.add(this.min);
                this.add(this.restore);
                this.add(this.close);
                break;
            }
            case 5: {
                this.add(this.restore);
                this.add(this.max);
                this.add(this.close);
            }
        }
        this.setSize(this.width, this.close.getHeight());
    }

    public Component add(Component comp) {
        this.width += comp.getWidth();
        return super.add(comp);
    }

    public abstract BufferedImage getOffImage();

    public abstract BufferedImage getOverImage();

    public abstract BufferedImage getOnImage();

    public abstract BufferedImage getButtonImage(int var1, int var2);

    public abstract void doAction(int var1);

    private class CButton
    extends JButton {
        public CButton(final int type) {
            this.setSize(CButtonBox.this.getOffImage().getWidth(), CButtonBox.this.getOffImage().getHeight());
            this.setMinimumSize(this.getSize());
            this.setPreferredSize(this.getSize());
            this.setBorder(null);
            this.setContentAreaFilled(false);
            this.setFocusable(false);
            BufferedImage off = CButtonBox.this.getOffImage();
            BufferedImage over = CButtonBox.this.getOverImage();
            BufferedImage on = CButtonBox.this.getOnImage();
            off.getGraphics().drawImage(CButtonBox.this.getButtonImage(type, 0), 0, 0, null);
            over.getGraphics().drawImage(CButtonBox.this.getButtonImage(type, 1), 0, 0, null);
            on.getGraphics().drawImage(CButtonBox.this.getButtonImage(type, 2), 0, 0, null);
            this.setIcon(new ImageIcon(off));
            this.setRolloverIcon(new ImageIcon(over));
            this.setPressedIcon(new ImageIcon(on));
            String toolTip = "Unknown";
            switch (type) {
                case 1: {
                    toolTip = "Minimize";
                    break;
                }
                case 2: {
                    toolTip = "Maximize";
                    break;
                }
                case 0: {
                    toolTip = "Close";
                }
            }
            this.setToolTipText(toolTip);
            this.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent e) {
                    CButtonBox.this.doAction(type);
                }
            });
        }
    }
}

