/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.File;
import java.util.ArrayList;
import javax.swing.filechooser.FileFilter;
import util.Plugin;
import util.struct.DPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TFileFilter
extends FileFilter {
    private String name;
    private ArrayList<Plugin> plugins = new ArrayList();

    public TFileFilter(String name, ArrayList<Plugin> plugins) {
        this.name = name;
        this.plugins = plugins;
    }

    public TFileFilter(Plugin plugin) {
        this.name = plugin.getName();
        this.plugins.add(plugin);
    }

    @Override
    public boolean accept(File file) {
        if (file.isDirectory()) {
            return true;
        }
        DPath path = new DPath(file);
        for (Plugin plugin : this.plugins) {
            if (!path.getPlugin().getId().equals(plugin.getId())) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getDescription() {
        String desc = this.name + " (";
        if (this.plugins.size() > 0) {
            for (Plugin plugin : this.plugins) {
                for (String ext : plugin.getExtensions()) {
                    desc = desc + "*" + ext + ",";
                }
            }
            desc = desc.substring(0, desc.length() - 1);
        } else {
            desc = desc + "*.*";
        }
        return desc + ")";
    }

    public ArrayList<Plugin> getPlugins() {
        return this.plugins;
    }
}

