/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.util.ArrayList;
import util.CIcon;
import util.Common;
import util.Compression;
import util.struct.DPath;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Plugin {
    public static final int NONE = 0;
    public static final int MAGIC = 1;
    private static ArrayList<Plugin> plugins = Plugin.initPlugins();
    private String id;
    private int type;
    private String stamp;
    private String name;
    private String mime;
    private int format;
    private int byteOrder;
    private String[] ext;
    private CIcon icon;

    public Plugin() {
        this.id = "";
        this.type = 0;
        this.icon = CIcon.FILE_BLANK;
        this.name = "Unknown";
        this.stamp = "";
    }

    public Plugin(String stamp) {
        this();
        this.stamp = stamp;
    }

    public Plugin(String id, int type, String stamp, String name, String mime, int format, int byteOrder, String ext, String icon) {
        this.id = id;
        this.type = type;
        this.stamp = stamp;
        this.name = name;
        this.mime = mime;
        this.format = format;
        this.byteOrder = byteOrder;
        this.ext = Common.split(ext, ",");
        this.icon = CIcon.getIconById(icon);
    }

    public String getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public int getType() {
        return this.type;
    }

    public int getFormat() {
        return this.format;
    }

    public String getStamp() {
        return this.stamp;
    }

    public String getStampCode() {
        if (this.stamp.startsWith("0x")) {
            return this.stamp.substring(2);
        }
        return Common.getHex(this.stamp.getBytes());
    }

    public String[] getExtensions() {
        return this.ext;
    }

    public CIcon getIcon() {
        return this.icon;
    }

    public static ArrayList<Plugin> get(int format) {
        ArrayList<Plugin> results = new ArrayList<Plugin>();
        for (Plugin plugin : plugins) {
            if (plugin.getFormat() != format) continue;
            results.add(plugin);
        }
        return results;
    }

    public static ArrayList<Plugin> getPlugins() {
        return plugins;
    }

    public static void scan(DPath path) {
        ArrayList<Match> matches = new ArrayList<Match>();
        byte[] data = path.read(0L, 16L);
        Compression comp = Compression.check(data);
        byte[] decomp = Compression.extract(comp.getType(), data);
        for (Plugin plugin : plugins) {
            switch (plugin.getType()) {
                case 1: {
                    String stamp = plugin.getStampCode();
                    String magic = Common.getHex(data, 0, stamp.length() / 2);
                    String dmagic = Common.getHex(decomp, 0, stamp.length() / 2);
                    boolean isMagic = true;
                    boolean isDMagic = true;
                    for (int i = 0; i < stamp.length() / 2; ++i) {
                        String byteStamp = stamp.substring(i * 2, i * 2 + 2);
                        String byteMagic = magic.substring(i * 2, i * 2 + 2);
                        String byteDMagic = dmagic.substring(i * 2, i * 2 + 2);
                        if (byteStamp.equals("2A")) continue;
                        if (!byteStamp.equals(byteMagic)) {
                            isMagic = false;
                        }
                        if (byteStamp.equals(byteDMagic)) continue;
                        isDMagic = false;
                    }
                    if (isMagic) {
                        matches.add(new Match(plugin, null));
                        break;
                    }
                    if (!isDMagic) break;
                    matches.add(new Match(plugin, comp));
                    break;
                }
                case 0: {
                    for (String ext : plugin.getExtensions()) {
                        if (!ext.equals("." + path.getFile().getExtension())) continue;
                        matches.add(new Match(plugin, comp));
                    }
                    break;
                }
            }
        }
        if (matches.size() > 0) {
            Match match = (Match)matches.get(0);
            path.setPlugin(match.getPlugin());
            comp = match.getCompression();
            if (comp != null && comp.isCompressed()) {
                path.getFile().setFullSize(comp.getSize());
                path.getFile().setCompression(comp.getType());
            }
            if (matches.size() > 1) {
                Common.error("More than one match!!");
            }
        } else if (comp.isCompressed()) {
            path.getFile().setFullSize(comp.getSize());
            path.getFile().setCompression(comp.getType());
            path.setPlugin(new Plugin(Plugin.getMagic(decomp)));
        } else {
            path.setPlugin(new Plugin(Plugin.getMagic(data)));
        }
    }

    private static String getMagic(byte[] data) {
        String magic = "";
        for (int i = 0; i < 4 && i < data.length; ++i) {
            byte value = data[i];
            boolean num = value >= 48 && value <= 57;
            boolean upper = value >= 65 && value <= 90;
            boolean lower = value >= 97 && value <= 122;
            magic = num || upper || lower ? magic + Common.getString(value) : magic + ".";
        }
        if (magic.contains(".")) {
            magic = magic.substring(0, magic.indexOf("."));
        }
        if (magic.length() == 1) {
            magic = "";
        }
        return magic;
    }

    private static void add(String id, int type, String stamp, String name, String mime, int format, int byteOrder, String ext, String icon) {
        plugins.add(new Plugin(id, type, stamp, name, mime, format, byteOrder, ext, icon));
    }

    private static ArrayList<Plugin> initPlugins() {
        plugins = new ArrayList();
        Plugin.add("adobe-photoshop", 1, "8BPS", "Adobe Photoshop Image", "psd", 20, 1, ".psd", "file.image");
        Plugin.add("adobe-clut", 0, "", "Adobe Color Table", "act", 5, 0, ".act,.raw", "file.palette");
        Plugin.add("riff-pal", 1, "RIFF****PAL data", "Microsoft Palette", "riff/pal", 5, 0, ".pal", "file.palette");
        Plugin.add("usenti-pal", 1, "CLRX", "Usenti Palette", "usenti/clrx", 5, 0, ".pal", "file.palette");
        Plugin.add("rom-nds", 0, "", "Nintendo DS Rom", "rom/nds", 3, 0, ".nds", "file.tv");
        Plugin.add("nitro-nclr", 1, "RLCN", "Nitro Color Resource", "nds/nclr", 5, 0, ".nclr", "file.palette");
        Plugin.add("nitro-ncgr", 1, "RGCN", "Nitro Graphic Resource", "nds/ncgr", 6, 0, ".ncgr", "file.image");
        Plugin.add("nitro-ncer", 1, "RECN", "Nitro Cell Resource", "nds/ncer", 7, 0, ".ncer", "file.cell");
        Plugin.add("nitro-nanr", 1, "RNAN", "Nitro Animation Resource", "nds/nanr", 8, 0, ".nanr", "file.image-anim");
        Plugin.add("nitro-nscr", 1, "RCSN", "Nitro Screen Resource", "nds/nscr", 9, 0, ".nscr", "file.map");
        Plugin.add("nitro-narc", 1, "NARC", "Nitro Archive", "nds/narc", 3, 0, ".narc", "file.archive");
        Plugin.add("nitro-nmcr", 1, "RCMN", "Nitro Mapped Cell Resource", "nds/nmcr", 50, 0, ".nmcr", "file.cell");
        Plugin.add("nitro-nmar", 1, "RAMN", "Nitro Mapped Animation Resource", "nds/nmar", 50, 0, ".nmar", "file.image-anim");
        return plugins;
    }

    private static class Match {
        private Plugin plugin;
        private Compression comp;

        public Match(Plugin plugin, Compression comp) {
            this.plugin = plugin;
            this.comp = comp;
        }

        public Plugin getPlugin() {
            return this.plugin;
        }

        public Compression getCompression() {
            return this.comp;
        }
    }
}

