/*
 * Decompiled with CFR 0.152.
 */
package util;

import util.Common;

public class Compression {
    public static final int NONE = 0;
    public static final int LZ77 = 100;
    public static final int HUFFMAN = 101;
    public static final int RLUNCOMP = 102;
    private int type;
    private int size;
    private int reserved;

    public Compression(int type, int size, int reserved) {
        this.type = type;
        this.size = size;
        this.reserved = reserved;
    }

    public int getType() {
        return this.type;
    }

    public int getSize() {
        return this.size;
    }

    public int getReserved() {
        return this.reserved;
    }

    public boolean isCompressed() {
        return this.type != 0;
    }

    public static String getName(int comp) {
        switch (comp) {
            case 0: {
                return "None";
            }
            case 100: {
                return "LZ77";
            }
            case 101: {
                return "Huffman";
            }
            case 102: {
                return "RLUncomp";
            }
        }
        return "Unknown";
    }

    public static Compression check(byte[] data) {
        Compression comp = new Compression(0, 0, 0);
        comp = Common.getString(data, 0, 4).equals("LZ77") ? Compression.ndsHeader(Common.getBytes(data, 4, data.length - 4)) : Compression.ndsHeader(data);
        return comp;
    }

    private static Compression ndsHeader(byte[] data) {
        int type;
        int header = Common.getInt(data, 0, 4);
        int reserved = header & 0xF;
        int id = header >> 4 & 0xF;
        int size = header >> 8 & 0xFFFFFF;
        switch (id) {
            case 1: {
                type = 100;
                break;
            }
            case 2: {
                type = 101;
                break;
            }
            case 3: {
                type = 102;
                break;
            }
            default: {
                type = 0;
            }
        }
        if (size > 0) {
            return new Compression(type, size, reserved);
        }
        return new Compression(0, size, reserved);
    }

    public static byte[] extract(int comp, byte[] data) {
        switch (comp) {
            case 100: {
                return Compression.lz77(data);
            }
            case 102: {
                return Compression.rlu(data);
            }
        }
        return data;
    }

    private static byte[] lz77(byte[] data) {
        int header = Common.getInt(data, 0, 4);
        int reserved = header & 0xF;
        int id = header >> 4 & 0xF;
        int size = header >> 8 & 0xFFFFFF;
        int readOffset = 4;
        if (Common.getString(data, 0, 4).equals("LZ77")) {
            readOffset += 4;
        }
        int saveOffset = 0;
        byte[] decomp = new byte[size];
        int i = 0;
        int flag = 0;
        while (readOffset < data.length) {
            try {
                if (i == 0) {
                    flag = data[readOffset] & 0xFF;
                    ++readOffset;
                }
                if ((flag & 0x80) != 0) {
                    int value = Common.getInt(data, readOffset, 2);
                    int lsb = value >> 8 & 0xFF;
                    int len = value >> 4 & 0xF;
                    int msb = value & 0xF;
                    int disp = lsb | msb << 8;
                    int copy = len + 3;
                    if (reserved == 1) {
                        int indicator = value >> 4 & 0xF;
                        switch (indicator) {
                            case 0: {
                                value = Common.getInt(data, readOffset, 3);
                                ++readOffset;
                                int len2 = value & 0xF;
                                int len1 = value >> 12 & 0xF;
                                len = len2 << 4 | len1;
                                int disp2 = value >> 8 & 0xF;
                                int disp1 = value >> 16 & 0xFF;
                                disp = disp2 << 8 | disp1;
                                copy = len + 17;
                                break;
                            }
                            case 1: {
                                value = Common.getInt(data, readOffset, 4);
                                readOffset += 2;
                                int len3 = value & 0xF;
                                int len2 = value >> 8 & 0xFF;
                                int len1 = value >> 20 & 0xF;
                                len = len3 << 12 | len2 << 4 | len1;
                                int disp2 = value >> 16 & 0xF;
                                int disp1 = value >> 24 & 0xFF;
                                disp = disp2 << 8 | disp1;
                                copy = len + 273;
                                break;
                            }
                            default: {
                                copy = len + 1;
                            }
                        }
                    }
                    int offset = saveOffset - disp - 1;
                    readOffset += 2;
                    for (int j = 0; j < copy; ++j) {
                        decomp[saveOffset + j] = decomp[offset];
                        ++offset;
                    }
                    saveOffset += copy;
                } else {
                    decomp[saveOffset] = data[readOffset];
                    ++readOffset;
                    ++saveOffset;
                }
                flag <<= 1;
                i = (i + 1) % 8;
            }
            catch (Exception e) {
                Common.error("LZ77 Compression: " + e);
                break;
            }
        }
        return decomp;
    }

    private static byte[] rlu(byte[] data) {
        int header = Common.getInt(data, 0, 4);
        int reserved = header & 0xF;
        int id = header >> 4 & 0xF;
        int size = header >> 8 & 0xFFFFFF;
        int readOffset = 4;
        int saveOffset = 0;
        byte[] decomp = new byte[size];
        while (readOffset < data.length) {
            try {
                int i;
                int flag = data[readOffset++] & 0xFF;
                int len = flag & 0x7F;
                if ((flag & 0x80) != 0) {
                    len += 3;
                    for (i = 0; i < len; ++i) {
                        decomp[saveOffset++] = data[readOffset];
                    }
                    ++readOffset;
                    continue;
                }
                ++len;
                for (i = 0; i < len; ++i) {
                    decomp[saveOffset++] = data[readOffset++];
                }
            }
            catch (Exception e) {
                Common.error("RLUncomp Compression: " + e);
                break;
            }
        }
        return decomp;
    }
}

