/*
 * Decompiled with CFR 0.152.
 */
package util;

public class Common {
    public static final String NULL = new String(new byte[]{0});
    public static final String FIXED_V10 = "1.0.9";
    public static final String FIXED_V16 = "1.3.12";
    public static final String FIXED_T16 = "1.11.4";
    public static final String FIXED_F32 = "1.19.12";
    private static final int[] AND = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535, 131071, 262143, 524287, 1048575, 0x1FFFFF, 0x3FFFFF, 0x7FFFFF, 0xFFFFFF};

    public static void msg(Object value) {
        System.out.println(value);
    }

    public static void error(Object value) {
        System.err.println(value);
    }

    public static String trimName(String name) {
        return name.toLowerCase().replace(" ", "");
    }

    public static String padNum(int value, int width) {
        String result = "" + value;
        while (result.length() < width) {
            result = "0" + result;
        }
        return result;
    }

    public static int getInt(String value) {
        if (value.length() == 0) {
            value = "0";
        }
        if (value.startsWith("0x")) {
            return Integer.parseInt(value.substring(2), 16);
        }
        return Integer.parseInt(value);
    }

    public static int getInt(String value, int radix) {
        if (value.length() == 0) {
            value = "0";
        }
        if (value.length() > 6) {
            value = value.substring(value.length() - 7);
        }
        return Integer.parseInt(value, radix);
    }

    public static boolean getBoolean(String value) {
        return value.toLowerCase().contains("true");
    }

    public static void line() {
        System.out.println(Common.repeat("-", 150));
    }

    public static String repeat(String text, int size) {
        String value = "";
        for (int i = 0; i < size; ++i) {
            value = value + text;
        }
        return value;
    }

    public static String[] split(String text, String exp) {
        if (text.contains(exp)) {
            return text.split(exp);
        }
        return new String[]{text};
    }

    public static String calSize(long bytes) {
        String size = bytes + " bytes";
        if (bytes / 1024L > 1L) {
            size = (double)Math.round((double)bytes / 1024.0 * 100.0) / 100.0 + " KB";
        }
        if (bytes / 1024L / 1024L > 1L) {
            size = (double)Math.round((double)bytes / 1024.0 / 1024.0 * 100.0) / 100.0 + " MB";
        }
        if (bytes / 1024L / 1024L / 1024L > 1L) {
            size = (double)Math.round((double)bytes / 1024.0 / 1024.0 / 1024.0 * 100.0) / 100.0 + " GB";
        }
        return size;
    }

    public static String calTime(long milli) {
        String field = " secs.";
        double time = (double)milli / 1000.0;
        if (milli / 1000L / 60L > 1L) {
            field = " mins.";
            time /= 60.0;
        }
        if (milli / 1000L / 60L / 60L > 1L) {
            field = " hrs.";
            time /= 60.0;
        }
        return (double)Math.round(time * 100.0) / 100.0 + field;
    }

    public static String formatBoolean(boolean value) {
        if (value) {
            return "Yes";
        }
        return "No";
    }

    public static String padNum(Object number, int width) {
        String value = "" + number;
        while (value.length() < width) {
            value = "0" + value;
        }
        return value;
    }

    public static String padLeft(Object number, int width) {
        String value = "" + number;
        while (value.length() < width) {
            value = " " + value;
        }
        return value;
    }

    public static String padRight(Object number, int width) {
        String value = "" + number;
        while (value.length() < width) {
            value = value + " ";
        }
        return value;
    }

    public static byte[] getBytes(byte[] data, int offset, int size) {
        byte[] sub = new byte[size];
        for (int i = 0; i < size; ++i) {
            if (offset + i >= data.length) continue;
            sub[i] = data[offset + i];
        }
        return sub;
    }

    public static byte[] getBytes(byte[] data, int offset) {
        return Common.getBytes(data, offset, data.length - offset);
    }

    public static byte[] getBytes(int data, int size) {
        byte[] sub = new byte[size];
        for (int i = 0; i < size; ++i) {
            sub[i] = (byte)(data >> i * 8 & 0xFF);
        }
        return sub;
    }

    public static int getInt(byte[] data, int offset, int size) {
        int value = 0;
        byte[] sub = Common.getBytes(data, offset, size);
        for (int i = 0; i < sub.length; ++i) {
            value |= (sub[i] & 0xFF) << i * 8;
        }
        return value;
    }

    public static int getSign(byte[] data, int offset, int size) {
        return Common.getSign(Common.getInt(data, offset, size), size);
    }

    public static int getSign(int value, int size) {
        int flag = 1 << size * 8 - 1;
        int and = -1 << size * 8;
        if ((value & flag) != 0) {
            value |= and;
        }
        return value;
    }

    public static float getFixed(byte[] data, int offset, String fixedType) {
        String[] vars = fixedType.replace(".", "_").split("_");
        float fixed = 0.0f;
        if (vars.length == 3) {
            int signWidth = Common.getInt(vars[0]);
            int intWidth = Common.getInt(vars[1]);
            int fracWidth = Common.getInt(vars[2]);
            int size = (int)Math.ceil((double)(signWidth + intWidth + fracWidth) / 16.0);
            int value = Common.getInt(data, offset, size);
            float frac = (float)(value & AND[fracWidth]) / (float)fracWidth;
            int integer = value >> fracWidth & AND[intWidth];
            int sign = value >> fracWidth + intWidth & AND[signWidth];
            Common.msg("-> Frac: " + frac + " | Integer: " + integer + " | Sign: " + sign);
        }
        return fixed;
    }

    public static int[] getInts(byte[] data, int bits) {
        int[] ints;
        switch (bits) {
            case 4: {
                ints = new int[data.length * 2];
                for (int i = 0; i < data.length; ++i) {
                    ints[i * 2] = data[i] & 0xF;
                    ints[i * 2 + 1] = data[i] >> 4 & 0xF;
                }
                break;
            }
            default: {
                ints = new int[data.length];
                for (int i = 0; i < data.length; ++i) {
                    ints[i] = data[i] & 0xFF;
                }
            }
        }
        return ints;
    }

    public static String getBin(int number, int width) {
        String value = "";
        for (int i = 0; i < width; ++i) {
            value = Common.padNum(Integer.toBinaryString(number & 0xFF), 8) + value;
            number >>= 8;
        }
        return value;
    }

    public static String getHex(byte data) {
        return Common.getHex(new byte[]{data});
    }

    public static String getHex(byte[] data) {
        return Common.getHex(data, 0, data.length);
    }

    public static String getHex(byte[] data, int offset, int size) {
        String value = "";
        byte[] sub = Common.getBytes(data, offset, size);
        for (int i = 0; i < sub.length; ++i) {
            value = value + Common.padNum(Integer.toHexString(sub[i] & 0xFF), 2);
        }
        return value.toUpperCase();
    }

    public static String getHex(long number, int width) {
        String value = "";
        for (int i = 0; i < width; ++i) {
            value = Common.padNum(Long.toHexString(number & 0xFFL), 2) + value;
            number >>= 8;
        }
        return value.toUpperCase();
    }

    public static String getHex(int number, int width) {
        return Common.getHex((long)number, width);
    }

    public static String getHex(String text) {
        return Common.getHex(text.getBytes());
    }

    public static String getString(byte data) {
        return Common.getString(new byte[]{data});
    }

    public static String getString(byte[] data) {
        return Common.getString(data, 0, data.length);
    }

    public static String getString(byte[] data, int offset, int size) {
        return new String(Common.getBytes(data, offset, size));
    }

    public static String getString(byte[] data, int offset) {
        String string = Common.getString(data, offset, data.length - offset);
        if (string.indexOf(NULL) != -1) {
            string = string.substring(0, string.indexOf(NULL));
        }
        return string;
    }

    public static int[] toIntArray(byte[] data, int bits) {
        int[] ints = new int[data.length];
        switch (bits) {
            case 2: {
                ints = new int[data.length * 4];
                for (int i = 0; i < data.length; ++i) {
                    ints[i * 4] = data[i] & 3;
                    ints[i * 4 + 1] = data[i] >> 2 & 3;
                    ints[i * 4 + 2] = data[i] >> 4 & 3;
                    ints[i * 4 + 3] = data[i] >> 6 & 3;
                }
                break;
            }
            case 4: {
                ints = new int[data.length * 2];
                for (int i = 0; i < data.length; ++i) {
                    ints[i * 2] = data[i] & 0xF;
                    ints[i * 2 + 1] = data[i] >> 4 & 0xF;
                }
                break;
            }
            default: {
                ints = new int[data.length];
                for (int i = 0; i < data.length; ++i) {
                    ints[i] = data[i] & 0xFF;
                }
                if (bits == 8) break;
                Common.msg("Can't convert bytes to ints!! " + bits);
                break;
            }
            case 16: {
                ints = new int[data.length / 2];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = Common.getInt(data, i * 2, 2);
                }
                break;
            }
            case 24: {
                ints = new int[data.length / 3];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = Common.getInt(data, i * 3, 3);
                }
                break;
            }
            case 32: {
                ints = new int[data.length / 4];
                for (int i = 0; i < ints.length; ++i) {
                    ints[i] = Common.getInt(data, i * 4, 4);
                }
            }
        }
        return ints;
    }

    public static Object[] addItem(Object[] list, Object item) {
        Object[] temp = new Object[list.length + 1];
        System.arraycopy(list, 0, temp, 0, list.length);
        temp[list.length] = item;
        return temp;
    }

    public static Object[][] addItem(Object[][] list, Object[] item) {
        Object[][] temp = new Object[list.length + 1][];
        System.arraycopy(list, 0, temp, 0, list.length);
        temp[list.length] = item;
        return temp;
    }

    public static boolean[] addItem(boolean[] list, boolean item) {
        boolean[] temp = new boolean[list.length + 1];
        System.arraycopy(list, 0, temp, 0, list.length);
        temp[list.length] = item;
        return temp;
    }

    public static boolean[][] addItem(boolean[][] list, boolean[] item) {
        boolean[][] temp = new boolean[list.length + 1][];
        System.arraycopy(list, 0, temp, 0, list.length);
        temp[list.length] = item;
        return temp;
    }

    public static Class[] addItem(Class[] list, Class item) {
        Class[] temp = new Class[list.length + 1];
        System.arraycopy(list, 0, temp, 0, list.length);
        temp[list.length] = item;
        return temp;
    }

    public static Class[][] addItem(Class[][] list, Class[] item) {
        Class[][] temp = new Class[list.length + 1][];
        System.arraycopy(list, 0, temp, 0, list.length);
        temp[list.length] = item;
        return temp;
    }
}

