/*
 * Decompiled with CFR 0.152.
 */
package util;

import ctool.CWindow;
import ctool.Main;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import javax.swing.AbstractAction;
import javax.swing.KeyStroke;
import util.CIcon;
import util.CProperty;
import util.Common;
import util.gui.CFileChooser;
import util.gui.frames.CFrame;
import util.gui.frames.CHexFrame;
import util.struct.DFormat;

public class CAction
extends AbstractAction {
    public static final int NONE = 0;
    public static final int EXIT = 1;
    public static final int OPEN = 19;
    public static final int NEW = 20;
    public static final int SAVE = 21;
    public static final int IMPORT = 22;
    public static final int EXPORT = 23;
    public static final int HEX = 24;
    public static final int ADD = 30;
    public static final int REMOVE = 31;
    public static final int HELP = 80;
    public static final int COPY_IMAGE = 50;
    public static final int COLOR_ADD = 102;
    public static final int COLOR_REMOVE = 103;
    public static final int COLOR_FIRST = 104;
    public static final int COLOR_LAST = 105;
    public static final int COLOR_PREV = 106;
    public static final int COLOR_NEXT = 107;
    public static final int PLAYBACK = 200;
    public static final int PLAYBACK_FIRST = 201;
    public static final int PLAYBACK_PREV = 202;
    public static final int PLAYBACK_NEXT = 203;
    public static final int PLAYBACK_LAST = 204;
    public static final int TOGGLE_INFO = 1000;
    public static final int TOGGLE_FRAMES = 1001;
    public static final int TOGGLE_COLOR = 1002;
    public static final int TOGGLE_ALPHA = 2000;
    public static final int CELL_TOGGLE_ORDER = 3000;
    public static final int CELL_TOGGLE_GRID = 3001;
    public static final int CELL_TOGGLE_OUTLINE = 3002;
    public static final int CELL_TOGGLE_RENDER = 3003;
    public static final int OPEN_FILE = 4000;
    public static final int EXTRACT_FILE = 5000;
    public static final String ACTION_ID = "action";
    private static ArrayList<CAction> actions = new ArrayList();

    public CAction(int action) {
        this.putValue(ACTION_ID, action);
        switch (action) {
            case 19: {
                this.set("Open...", "open", CIcon.FILE_FOLDER, KeyStroke.getKeyStroke(79, 128));
                break;
            }
            case 20: {
                this.set("New", "new", CIcon.NEW);
                break;
            }
            case 21: {
                this.set("Save", "save", CIcon.SAVE, KeyStroke.getKeyStroke(83, 128));
                break;
            }
            case 22: {
                this.set("Import", "import", CIcon.IMPORT);
                break;
            }
            case 23: {
                this.set("Export", "export", CIcon.EXPORT);
                break;
            }
            case 80: {
                this.set("Help", "help", CIcon.HELP);
                break;
            }
            case 24: {
                this.set("View Hex", "viewHex", CIcon.HEX);
                break;
            }
            case 1: {
                this.set("Exit", "exit", CIcon.EXIT);
                break;
            }
            case 30: {
                this.set("Add", "add", CIcon.ADD);
                break;
            }
            case 31: {
                this.set("Remove", "remove", CIcon.REMOVE);
                break;
            }
            case 50: {
                this.set("Copy Image", "copyImage", null);
                break;
            }
            case 102: {
                this.set("Add Color", "addColor", CIcon.ADD);
                break;
            }
            case 103: {
                this.set("Remove Color", "removeColor", CIcon.REMOVE);
                break;
            }
            case 104: {
                this.set("Move Color to First", "moveColorFirst", CIcon.CTRL_FIRST);
                break;
            }
            case 106: {
                this.set("Move Color Left", "moveColorLeft", CIcon.CTRL_LEFT);
                break;
            }
            case 107: {
                this.set("Move Color Right", "moveColorRight", CIcon.CTRL_RIGHT);
                break;
            }
            case 105: {
                this.set("Move Color to Last", "moveColorLast", CIcon.CTRL_LAST);
                break;
            }
            case 201: {
                this.set("First Frame", "playbackFirst", CIcon.CTRL_FIRST);
                break;
            }
            case 202: {
                this.set("Previous Frame", "playbackPrevious", CIcon.CTRL_PREV);
                break;
            }
            case 200: {
                this.set("Play", "playbackPlay", CIcon.CTRL_PLAY);
                break;
            }
            case 203: {
                this.set("Next Frame", "playbackNext", CIcon.CTRL_NEXT);
                break;
            }
            case 204: {
                this.set("Last Frame", "playbackLast", CIcon.CTRL_LAST);
                break;
            }
            case 2000: {
                this.set("Transparency", "toggleAlpha", CIcon.IMAGE_ALPHA);
                break;
            }
            case 3000: {
                this.set("Rendering Order", "toggleCellOrder", CIcon.LAYERS);
                break;
            }
            case 3001: {
                this.set("Grid", "toggleCellGrid", CIcon.GRID);
                break;
            }
            case 3002: {
                this.set("Cell Outlines", "toggleCellOutline", CIcon.ZONE);
                break;
            }
            case 3003: {
                this.set("Display Cells", "toggleCellRender", CIcon.EYE);
                break;
            }
            case 4000: {
                this.set("Open File", "openFile", CIcon.OPEN);
                break;
            }
            case 5000: {
                this.set("Extract File", "extractFile", CIcon.ARCHIVE_EXTRACT);
                break;
            }
            default: {
                this.set("Action #" + action, "error", CIcon.ERROR);
            }
        }
    }

    private void set(String name, String command, CIcon icon) {
        this.set(name, command, name, icon, null);
    }

    private void set(String name, String command, CIcon icon, KeyStroke keyStroke) {
        this.set(name, command, name, icon, keyStroke);
    }

    private void set(String name, String command, String desc, CIcon icon) {
        this.set(name, command, desc, icon, null);
    }

    private void set(String name, String command, String desc, CIcon icon, KeyStroke keyStroke) {
        this.putValue("Name", name);
        this.putValue("ActionCommandKey", command);
        if (desc != null) {
            this.putValue("ShortDescription", desc);
        } else {
            this.putValue("ShortDescription", name);
        }
        if (icon != null) {
            this.putValue("SwingLargeIconKey", icon.getIcon());
            this.putValue("SmallIcon", icon.getIcon());
        }
        this.putValue("AcceleratorKey", keyStroke);
    }

    public int getActionId() {
        return (Integer)this.getValue(ACTION_ID);
    }

    public String getActionCommand() {
        return (String)this.getValue("ActionCommandKey");
    }

    public void actionPerformed(ActionEvent e) {
        CAction.doAction(this);
    }

    public static CAction getAction(int actionId) {
        for (CAction action : actions) {
            if (action.getActionId() != actionId) continue;
            return action;
        }
        CAction action = new CAction(actionId);
        actions.add(action);
        return action;
    }

    public static void doAction(int actionId) {
        CAction.doAction(CAction.getAction(actionId));
    }

    public static void doAction(CAction action) {
        CWindow window = CAction.getWindow();
        CFrame selectFrame = window.getDesktop().getFrameBox().getSelected();
        boolean check = true;
        DFormat selectFormat = null;
        if (selectFrame != null) {
            check = !selectFrame.doAction(action.getActionId());
            selectFormat = selectFrame.getFormat();
        }
        if (check) {
            boolean done = true;
            switch (action.getActionId()) {
                case 19: {
                    new CFileChooser(0, selectFormat).showChooser();
                    break;
                }
                case 24: {
                    DFormat format = selectFrame.getFormat();
                    boolean accept = true;
                    for (CFrame frame : window.getDesktop().getFrameBox().getFrames()) {
                        if (frame.getFormat() != format || !(frame instanceof CHexFrame)) continue;
                        accept = false;
                        window.getDesktop().getFrameBox().setSelected(frame);
                    }
                    if (!accept) break;
                    window.getDesktop().addFrame(new CHexFrame(format), true);
                    break;
                }
                case 1: {
                    System.exit(0);
                    break;
                }
                case 2000: {
                    CProperty.ALPHA.setValue((Boolean)CProperty.ALPHA.getValue() == false);
                    break;
                }
                case 3000: {
                    CProperty.CELL_ORDER.setValue((Boolean)CProperty.CELL_ORDER.getValue() == false);
                    break;
                }
                case 3001: {
                    CProperty.CELL_GRID.setValue((Boolean)CProperty.CELL_GRID.getValue() == false);
                    break;
                }
                case 3002: {
                    CProperty.CELL_OUTLINE.setValue((Boolean)CProperty.CELL_OUTLINE.getValue() == false);
                    break;
                }
                case 3003: {
                    CProperty.CELL_RENDER.setValue((Boolean)CProperty.CELL_RENDER.getValue() == false);
                    break;
                }
                case 201: {
                    CProperty.SELECTED_FRAME.setValue(0);
                    break;
                }
                case 202: {
                    CProperty.SELECTED_FRAME.setValue((Integer)CProperty.SELECTED_FRAME.getValue() - 1);
                    break;
                }
                case 203: {
                    CProperty.SELECTED_FRAME.setValue((Integer)CProperty.SELECTED_FRAME.getValue() + 1);
                    break;
                }
                case 204: {
                    CProperty.SELECTED_FRAME.setValue((Integer)CProperty.TOTAL_FRAMES.getValue() - 1);
                    break;
                }
                case 200: {
                    boolean playback = (Boolean)CProperty.PLAYBACK.getValue();
                    if (playback) {
                        action.set("Play", action.getActionCommand(), CIcon.CTRL_PLAY);
                    } else {
                        action.set("Pause", action.getActionCommand(), CIcon.CTRL_PAUSE);
                    }
                    CProperty.PLAYBACK.setValue(!playback);
                    break;
                }
                default: {
                    done = false;
                }
            }
            if (!done) {
                Common.msg("Action #" + action.getActionId() + ": " + action.getActionCommand());
            }
        }
    }

    private static CWindow getWindow() {
        return Main.getWindow();
    }
}

