/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

// NES_6502 interface class
// created to cut down on extra work required for retro-fitting of
// new releases of Matt Conte's nes6502

#ifndef _NES_6502_H_
#define _NES_6502_H_

#include "../../types.h"

#include "nes6502.h"

#define CPUINLINE __inline

//class NES;  // prototype of NES class

#define CPUINT_Context nes6502_context

  void CPUINT_FakeConstructor(void);

  // Functions that govern the 6502's execution
  static CPUINLINE void CPUINT_Init()                           { /*nes6502_init();*/ }
  static CPUINLINE void CPUINT_Reset()                          { nes6502_reset(); }
  static CPUINLINE int  CPUINT_Execute(int total_cycles)        { return nes6502_execute(total_cycles); }
  static CPUINLINE void CPUINT_DoNMI(void)                      { nes6502_nmi(); }
  static CPUINLINE void CPUINT_DoIRQ(void)                      { nes6502_irq(); }
  static CPUINLINE void CPUINT_SetDMA(int cycles)               { nes6502_burn(cycles); }
  static CPUINLINE uint8  CPUINT_GetByte(uint32 address)        { return nes6502_getbyte(address); }
  static CPUINLINE uint32 CPUINT_GetCycles(boolean reset_flag)  { return nes6502_getcycles(reset_flag); }

  // Context get/set
  void CPUINT_SetContext(CPUINT_Context *cpu);
  void CPUINT_GetContext(CPUINT_Context *cpu);


#endif
