//remaining from gba nester port
#ifndef _GAME_MAIN_H
#define _GAME_MAIN_H
#ifndef _WIN32
#include <NDS.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#define consolePrintf printf

#define NESTER_STATIC_VAR_EXPL static
#define NESTER_STATIC_VAR_EXPL_Q
#define NESTER_STATIC_FN_EXPL static
#define NESTER_STATIC_FN_EXPL_Q
#define NESTER_VAR_CONST const
#ifdef _WIN32
#define NESTER_DTCM
#define EWRAM_DATA
#else
#define EWRAM_DATA __attribute__((section(".ewram")))
#define NESTER_DTCM DTCM_DATA //EWRAM_DATA
#endif

//checking for fake heap issues
/*
#ifndef ARM7
#define _STATIC_MALLOC
#endif
*/

#ifndef _STATIC_MALLOC
#define nestermalloc malloc
#define nesterfree free
#else
void *nestermalloc(size_t size);
void nesterfree(void *ptr);

__inline void *operator new( size_t s )
{
	return nestermalloc( s );
}
__inline void operator delete( void *p )
{
	nesterfree( p );
}
__inline void *operator new[]( size_t s )
{
	return nestermalloc( s );
}
__inline void operator delete[]( void *p )
{
	nesterfree( p );
}
#endif

#define GBAOPTION_SHOW_ALL_SCANLINES			0
//NESTER_settings.nes.graphics.show_all_scanlines

#define GBAOPTION_SHOW_MORE_THAN_8_SPRITES		0
//NESTER_settings.nes.graphics.show_more_than_8_sprites

#define GBAOPTION_CALCULATE_PALETTE				0
//NESTER_settings.nes.graphics.calculate_palette

#define	GBAOPTION_TINT							0x86
//NESTER_settings.nes.graphics.tint

#define GBAOPTION_HUE							0x9d
//NESTER_settings.nes.graphics.hue

#define GBAOPTION_BLACK_AND_WHITE				0
//NESTER_settings.nes.graphics.black_and_white

#define GBAOPTION_SND_RECT1_ENABLED				1
//NESTER_settings.nes.sound.rectangle1_enabled

#define GBAOPTION_SND_RECT2_ENABLED				1
//NESTER_settings.nes.sound.rectangle2_enabled

#define GBAOPTION_SND_TRIANGLE_ENABLED			1
//NESTER_settings.nes.sound.triangle_enabled

#define GBAOPTION_SND_NOISE_ENABLED				1
//NESTER_settings.nes.sound.noise_enabled

#define GBAOPTION_SND_DPCM_ENABLED				1
//NESTER_settings.nes.sound.dpcm_enabled

#define GBAOPTION_SND_EXTERNAL_ENABLED			1
//NESTER_settings.nes.sound.external_enabled

#define FILTER_NONE					0
#define FILTER_LOWPASS				1
#define FILTER_LOWPASS_WEIGHTED		2
//enum filter_type_t { FILTER_NONE, FILTER_LOWPASS, FILTER_LOWPASS_WEIGHTED };

#define GBAOPTION_SND_FILTERTYPE				FILTER_LOWPASS_WEIGHTED
//NESTER_settings.nes.sound.filter_type


#ifndef _MAX_PATH
#define _MAX_PATH	128
#endif

#define BYTE unsigned char
#define DWORD unsigned int
#define WORD unsigned short

/*
#define REG_INTERUPT   *(DWORD*)0x3007FFC		//Interrupt Register
#define REG_DISPCNT    *(DWORD*)0x4000000		//Display Control (Mode)
#define REG_DISPCNT_L  *(WORD*)0x4000000		//???
#define REG_DISPCNT_H  *(WORD*)0x4000002		//???
#define REG_DISPSTAT   *(WORD*)0x4000004		//???
#define REG_VCOUNT     *(WORD*)0x4000006		//Vertical Control (Sync)
#define REG_BG0CNT     *(WORD*)0x4000008		//Background 0
#define REG_BG1CNT     *(WORD*)0x400000A		//Background 1
#define REG_BG2CNT     *(WORD*)0x400000C		//Background 2
#define REG_BG3CNT     *(WORD*)0x400000E		//Background 3
#define REG_BG0HOFS    *(WORD*)0x4000010		//Background 0 Horizontal Offset
#define REG_BG0VOFS    *(WORD*)0x4000012		//Background 0 Vertical Offset
#define REG_BG1HOFS    *(WORD*)0x4000014		//Background 1 Horizontal Offset
#define REG_BG1VOFS    *(WORD*)0x4000016		//Background 1 Vertical Offset
#define REG_BG2HOFS    *(WORD*)0x4000018		//Background 2 Horizontal Offset
#define REG_BG2VOFS    *(WORD*)0x400001A		//Background 2 Vertical Offset
#define REG_BG3HOFS    *(WORD*)0x400001C		//Background 3 Horizontal Offset
#define REG_BG3VOFS    *(WORD*)0x400001E		//Background 3 Vertical Offset
#define REG_BG2PA      *(WORD*)0x4000020		//Background 2 PA Rotation (pa = x_scale * cos(angle);)
#define REG_BG2PB      *(WORD*)0x4000022		//Background 2 PB Rotation (pb = y_scale * sin(angle);)
#define REG_BG2PC      *(WORD*)0x4000024		//Background 2 PC Rotation (pc = x_scale * -sin(angle);)
#define REG_BG2PD      *(WORD*)0x4000026		//Background 2 PD Rotation (pd = y_scale * cos(angle);)
#define REG_BG2X       *(DWORD*)0x4000028		//Background 2 X Location
#define REG_BG2X_L     *(WORD*)0x4000028		//???
#define REG_BG2X_H     *(WORD*)0x400002A		//???
#define REG_BG2Y       *(DWORD*)0x400002C		//Background 2 Y Location
#define REG_BG2Y_L     *(WORD*)0x400002C		//???
#define REG_BG2Y_H     *(WORD*)0x400002E		//???
#define REG_BG3PA      *(WORD*)0x4000030		//Background 3 PA Rotation (pa = x_scale * cos(angle);)
#define REG_BG3PB      *(WORD*)0x4000032		//Background 3 PB Rotation (pb = y_scale * sin(angle);)
#define REG_BG3PC      *(WORD*)0x4000034		//Background 3 PC Rotation (pc = x_scale * -sin(angle);)
#define REG_BG3PD      *(WORD*)0x4000036		//Background 3 PD Rotation (pd = y_scale * cos(angle);)
#define REG_BG3X       *(DWORD*)0x4000038		//Background 3 X Location
#define REG_BG3X_L     *(WORD*)0x4000038		//???
#define REG_BG3X_H     *(WORD*)0x400003A		//???
#define REG_BG3Y       *(DWORD*)0x400003C		//Background 3 Y Location
#define REG_BG3Y_L     *(WORD*)0x400003C		//???
#define REG_BG3Y_H     *(WORD*)0x400003E		//???
#define REG_WIN0H      *(WORD*)0x4000040		//Window 0 X coords (bits 0-7 right, bits 8-16 left)
#define REG_WIN1H      *(WORD*)0x4000042		//Window 1 X coords (bits 0-7 right, bits 8-16 left)
#define REG_WIN0V      *(WORD*)0x4000044		//Window 0 Y coords (bits 0-7 bottom, bits 8-16 top)
#define REG_WIN1V      *(WORD*)0x4000046		//Window 1 Y coords (bits 0-7 bottom, bits 8-16 top)
#define REG_WININ      *(WORD*)0x4000048		//Inside Window Settings
#define REG_WINOUT     *(WORD*)0x400004A		//Outside Window Settings
#define REG_MOSAIC     *(DWORD*)0x400004C		//Mosaic Mode
#define REG_MOSAIC_L   *(DWORD*)0x400004C		//??? //NOTE: uh, I imagine L is low and H is high and they should both be WORD..?
#define REG_MOSAIC_H   *(DWORD*)0x400004E		//???
#define REG_BLDMOD     *(WORD*)0x4000050		//Blend Mode
#define REG_COLEV      *(WORD*)0x4000052		//???
#define REG_COLEY      *(WORD*)0x4000054		//???
#define REG_SG10       *(DWORD*)0x4000060		//???
#define REG_SG10_L     *(WORD*)0x4000060		//???
#define REG_SG10_H     *(WORD*)0x4000062		//???
#define REG_SG11       *(WORD*)0x4000064		//???
#define REG_SG20       *(WORD*)0x4000068		//???
#define REG_SG21       *(WORD*)0x400006C		//???
#define REG_SG30       *(DWORD*)0x4000070		//???
#define REG_SG30_L     *(WORD*)0x4000070		//???
#define REG_SG30_H     *(WORD*)0x4000072		//???
#define REG_SG31       *(WORD*)0x4000074		//???
#define REG_SG40       *(WORD*)0x4000078		//???
#define REG_SG40_H     *(WORD*)0x400007A		//???
#define REG_SG41       *(WORD*)0x400007C		//???
#define REG_SGCNT0     *(DWORD*)0x4000080		//???
#define REG_SGCNT0_L   *(WORD*)0x4000080		//???
#define REG_SGCNT0_H   *(WORD*)0x4000082		//???
#define REG_SGCNT1     *(WORD*)0x4000084		//???
#define REG_SGCNT1_H   *(WORD*)0x4000086		//???
#define REG_SGBIAS     *(WORD*)0x4000088		//???
#define REG_SGWR0      *(DWORD*)0x4000090		//???
#define REG_SGWR0_L    *(WORD*)0x4000090		//???
#define REG_SGWR0_H    *(WORD*)0x4000092		//???
#define REG_SGWR1      *(DWORD*)0x4000094		//???
#define REG_SGWR1_L    *(WORD*)0x4000094		//???
#define REG_SGWR1_H    *(WORD*)0x4000096		//???
#define REG_SGWR2      *(DWORD*)0x4000098		//???
#define REG_SGWR2_L    *(WORD*)0x4000098		//???
#define REG_SGWR2_H    *(WORD*)0x400009A		//???
#define REG_SGWR3      *(DWORD*)0x400009C		//???
#define REG_SGWR3_L    *(WORD*)0x400009C		//???
#define REG_SGWR3_H    *(WORD*)0x400009E		//???
#define REG_SGFIF0A    *(DWORD*)0x40000A0		//???
#define REG_SGFIFOA_L  *(WORD*)0x40000A0		//???
#define REG_SGFIFOA_H  *(WORD*)0x40000A2		//???
#define REG_SGFIFOB    *(DWORD*)0x40000A4		//???
#define REG_SGFIFOB_L  *(WORD*)0x40000A4		//???
#define REG_SGFIFOB_H  *(WORD*)0x40000A6		//???
#define REG_DMA0SAD     *(DWORD*)0x40000B0	//DMA0 Source Address
#define REG_DMA0SAD_L   *(WORD*)0x40000B0	//DMA0 Source Address Low Value
#define REG_DMA0SAD_H   *(WORD*)0x40000B2	//DMA0 Source Address High Value
#define REG_DMA0DAD     *(DWORD*)0x40000B4	//DMA0 Destination Address
#define REG_DMA0DAD_L   *(WORD*)0x40000B4	//DMA0 Destination Address Low Value
#define REG_DMA0DAD_H   *(WORD*)0x40000B6	//DMA0 Destination Address High Value
#define REG_DMA0CNT     *(DWORD*)0x40000B8	//DMA0 Control (Amount)
#define REG_DMA0CNT_L   *(WORD*)0x40000B8	//DMA0 Control Low Value
#define REG_DMA0CNT_H   *(WORD*)0x40000BA	//DMA0 Control High Value
#define REG_DMA1SAD     *(DWORD*)0x40000BC	//DMA1 Source Address
#define REG_DMA1SAD_L   *(WORD*)0x40000BC	//DMA1 Source Address Low Value
#define REG_DMA1SAD_H   *(WORD*)0x40000BE	//DMA1 Source Address High Value
#define REG_DMA1DAD     *(DWORD*)0x40000C0	//DMA1 Desination Address
#define REG_DMA1DAD_L   *(WORD*)0x40000C0	//DMA1 Destination Address Low Value
#define REG_DMA1DAD_H   *(WORD*)0x40000C2	//DMA1 Destination Address High Value
#define REG_DMA1CNT     *(DWORD*)0x40000C4	//DMA1 Control (Amount)
#define REG_DMA1CNT_L   *(WORD*)0x40000C4	//DMA1 Control Low Value
#define REG_DMA1CNT_H   *(WORD*)0x40000C6	//DMA1 Control High Value
#define REG_DMA2SAD     *(DWORD*)0x40000C8	//DMA2 Source Address
#define REG_DMA2SAD_L   *(WORD*)0x40000C8	//DMA2 Source Address Low Value
#define REG_DMA2SAD_H   *(WORD*)0x40000CA	//DMA2 Source Address High Value
#define REG_DMA2DAD     *(DWORD*)0x40000CC	//DMA2 Destination Address
#define REG_DMA2DAD_L   *(WORD*)0x40000CC	//DMA2 Destination Address Low Value
#define REG_DMA2DAD_H   *(WORD*)0x40000CE	//DMA2 Destination Address High Value
#define REG_DMA2CNT     *(DWORD*)0x40000D0	//DMA2 Control (Amount)
#define REG_DMA2CNT_L   *(WORD*)0x40000D0	//DMA2 Control Low Value
#define REG_DMA2CNT_H   *(WORD*)0x40000D2	//DMA2 Control High Value
#define REG_DMA3SAD     *(DWORD*)0x40000D4	//DMA3 Source Address
#define REG_DMA3SAD_L   *(WORD*)0x40000D4	//DMA3 Source Address Low Value
#define REG_DMA3SAD_H   *(WORD*)0x40000D6	//DMA3 Source Address High Value
#define REG_DMA3DAD     *(DWORD*)0x40000D8	//DMA3 Destination Address
#define REG_DMA3DAD_L   *(WORD*)0x40000D8	//DMA3 Destination Address Low Value
#define REG_DMA3DAD_H   *(WORD*)0x40000DA	//DMA3 Destination Address High Value
#define REG_DMA3CNT     *(DWORD*)0x40000DC	//DMA3 Control (Amount)
#define REG_DMA3CNT_L   *(WORD*)0x40000DC	//DMA3 Control Low Value
#define REG_DMA3CNT_H   *(WORD*)0x40000DE	//DMA3 Control High Value
#define REG_TM0D       *(WORD*)0x4000100		//Timer 1?
#define REG_TM0CNT     *(WORD*)0x4000102		//Timer 1 Control
#define REG_TM0CNT_L   *(WORD*)0x4000102		//Timer 1 Control
#define REG_TM0CNT_H   *(WORD*)0x4000104		//Timer 1 Control
#define REG_TM1D       *(WORD*)0x4000104		//Timer 2?
#define REG_TM1CNT     *(WORD*)0x4000106		//Timer 2 Control
#define REG_TM2D       *(WORD*)0x4000108		//Timer 3?
#define REG_TM2CNT     *(WORD*)0x400010A		//Timer 3 Control
#define REG_TM3D       *(WORD*)0x400010C		//Timer 4?
#define REG_TM3CNT     *(WORD*)0x400010E		//Timer 4 Control
#define REG_SCD0       *(WORD*)0x4000120		//32-bit Normal Serial Communication Data 0 / Multi-play
#define REG_SCD1       *(WORD*)0x4000122		//32-bit Normal Serial Communication Data 1 /Multi-play
#define REG_SCD2       *(WORD*)0x4000124		//Multi-play Communication Data 2
#define REG_SCD3       *(WORD*)0x4000126		//Multi-play Communication Data 3
#define REG_SCCNT      *(DWORD*)0x4000128		//???
#define REG_SCCNT_L    *(WORD*)0x4000128		//???
#define REG_SCCNT_H    *(WORD*)0x400012A		//???
#define REG_P1         *(WORD*)0x4000130		//Player 1 Input
#define REG_P1CNT      *(WORD*)0x4000132		//Player 1 Input Interrupt Status
#define REG_R          *(WORD*)0x4000134		//???
#define REG_HS_CTRL    *(WORD*)0x4000140		//???
#define REG_JOYRE      *(DWORD*)0x4000150		//???
#define REG_JOYRE_L    *(WORD*)0x4000150		//???
#define REG_JOYRE_H    *(WORD*)0x4000152		//???
#define REG_JOYTR      *(DWORD*)0x4000154		//???
#define REG_JOYTR_L    *(WORD*)0x4000154		//???
#define REG_JOYTR_H    *(WORD*)0x4000156		//???
#define REG_JSTAT      *(DWORD*)0x4000158		//???
#define REG_JSTAT_L    *(WORD*)0x4000158		//???
#define REG_JSTAT_H    *(WORD*)0x400015A		//???
#define REG_IE         *(WORD*)0x4000200		//Master Interrupt Enable
#define REG_IF         *(WORD*)0x4000202		//Interrupt Flags
#define REG_WSCNT      *(WORD*)0x4000204		//???
#define REG_IME        *(WORD*)0x4000208		//Interrupt Master Enable
#define REG_PAUSE      *(WORD*)0x4000300		//Pause

#define MODE_0 0x0
#define MODE_1 0x1
#define MODE_2 0x2
#define MODE_3 0x3
#define MODE_4 0x4
#define MODE_5 0x5
#define MODE_6 0x6
#define MODE_7 0x7
#define MODE_8 0x8
#define MODE_9 0x9
#define MODE_10 0x10

#define BACKBUFFER 0x10
#define H_BLANK_OAM 0x20 

#define OBJ_MAP_2D 0x0
#define OBJ_MAP_1D 0x40

#define FORCE_BLANK 0x80

#define BG0_ENABLE 0x100
#define BG1_ENABLE 0x200 
#define BG2_ENABLE 0x400
#define BG3_ENABLE 0x800
#define OBJ_ENABLE 0x1000 

#define WIN1_ENABLE 0x2000 
#define WIN2_ENABLE 0x4000
#define WINOBJ_ENABLE 0x8000

#define BUTTON_A 			(1<<0)
#define BUTTON_B 			(1<<1)
#define BUTTON_SELECT		(1<<2)
#define BUTTON_START 		(1<<3)
#define BUTTON_RIGHT 		(1<<4)
#define BUTTON_LEFT 		(1<<5)
#define BUTTON_UP 			(1<<6)
#define BUTTON_DOWN 		(1<<7)
#define BUTTON_R			(1<<8)
#define BUTTON_L 			(1<<9)


//sound stuff
//SGCNT0_L
#define RIGHT_VOLUME(n)					n
#define LEFT_VOLUME(n)					n<<4
#define SOUND_1_RIGHT_CHANNEL			(1<<8)
#define SOUND_2_RIGHT_CHANNEL			(1<<9)
#define SOUND_3_RIGHT_CHANNEL			(1<<10)
#define SOUND_4_RIGHT_CHANNEL			(1<<11)
#define SOUND_1_LEFT_CHANNEL			(1<<12)
#define SOUND_2_LEFT_CHANNEL			(1<<13)
#define SOUND_3_LEFT_CHANNEL			(1<<14)
#define SOUND_4_LEFT_CHANNEL			(1<<15)

//SGCNT0_H
#define SOUND_OUTPUT_1_4				0
#define SOUND_OUTPUT_1_2				(1<<0)
#define SOUND_OUTPUT_FULL				(1<<1)
#define DSOUND_A_OUTPUT_HALF			0
#define DSOUND_A_OUTPUT_FULL			(1<<2)
#define DSOUND_B_OUTPUT_HALF			0
#define DSOUND_B_OUTPUT_FULL			(1<<3)
#define DSOUND_A_RIGHT_CHANNEL			(1<<8)
#define DSOUND_A_LEFT_CHANNEL			(1<<9)
#define DSOUND_A_TIMER_0				0
#define DSOUND_A_TIMER_1				(1<<10)
#define DSOUND_A_FIFO_RESET				(1<<11)
#define DSOUND_B_RIGHT_CHANNEL			(1<<12)
#define DSOUND_B_LEFT_CHANNEL			(1<<13)
#define DSOUND_B_TIMER_0				0
#define DSOUND_B_TIMER_1				(1<<14)
#define DSOUND_B_FIFO_RESET				(1<<15)

//SGCNT1
#define SOUND_1_ENABLE					(1<<0)
#define SOUND_2_ENABLE					(1<<1)
#define SOUND_3_ENABLE					(1<<2)
#define SOUND_4_ENABLE					(1<<3)
#define SOUND_MASTER_ENABLE				(1<<7)

//SG10_L
#define S10L_NUM_SWEEP_SHIFTS(n)		n
#define S10L_SWEEP_INCREASE				0
#define S10L_SWEEP_DECREASE				(1<<3)
#define S10L_SWEEP_CHANGE_FREQ(n)		n<<4

//SG10_H
#define S10H_SGSOUND_LENGTH(n)			n
#define S10H_WAVEFORM_CYCLE_12			0
#define S10H_WAVEFORM_CYCLE_25			(1<<6)
#define S10H_WAVEFORM_CYCLE_50			(1<<7)
#define S10H_WAVEFROM_CYCLE_75			(1<<6) | (1<<7)
#define S10H_ENVELOPE_STEPS(n)			n<<8
#define S10H_ENVELOPE_INCREASE			0
#define S10H_ENVELOPE_DECREASE			(1<<11)
#define S10H_ENVELOPE_START_VALUE(n)	n<<12

//SG20
#define S20_SOUND_LENGTH(n)				n
#define S20_WAVEFORM_CYCLE_12			0
#define S20_WAVEFORM_CYCLE_25			(1<<6)
#define S20_WAVEFORM_CYCLE_50			(1<<7)
#define S20_WAVEFROM_CYCLE_75			(1<<6) | (1<<7)
#define S20_ENVELOPE_STEPS(n)			n<<8
#define S20_ENVELOPE_INCREASE			0
#define S20_ENVELOPE_DECREASE			(1<<11)
#define S20_ENVELOPE_START_VALUE(n)		n<<12

//SG21
#define S21_FREQUENCY(n)				n
#define S21_CONTINOUS					0
#define S21_COUNTER						(1<<14)
#define S21_RESTART						(1<<15)

//SG30_L
#define S30L_32_STEP_WAVEFORM			0
#define S30L_64_STEP_WAVEFORM			(1<<5)
#define S30L_RAM_BANK_0					0
#define S30L_RAM_BANK_1					(1<<6)
#define S30L_ENABLE						(1<<7)

//SG30_H
#define S30H_SOUND_LENGTH(n)			n
#define S30H_OUTPUT_MUTE				0
#define S30H_OUTPUT_FULL				(1<<13)
#define S30H_OUTPUT_1_2					(1<<14)
#define S30H_OUTPUT_1_4					(1<<13) | (1<<14)
#define S30H_OUTPUT_3_4					(1<<15)

//SG31
#define S31_FREQUENCY(n)				n
#define S31_CONTINOUS					0
#define S31_COUNTER						(1<<14)
#define S31_RESTART						(1<<15)

//SG40
#define S40_SOUND_LENGTH(n)				n
#define S40_ENVELOPE_STEPS(n)			n<<8
#define S40_ENVELOPE_INCREASE			0
#define S40_ENVELOPE_DECREASE			(1<<11)
#define S40_ENVELOPE_START_VALUE(n)		n<<12

//SG41
#define S41_DIVIDE_FREQ_2				0
#define S41_DIVIDE_FREQ_1				(1<<0)
#define S41_DIVIDE_FREQ_1_2				(1<<1)
#define S41_DIVIDE_FREQ_1_3				(1<<0) | (1<<1)
#define S41_DIVIDE_FREQ_1_4				(1<<2)
#define S41_DIVIDE_FREQ_1_5				(1<<0) | (1<<2)
#define S41_DIVIDE_FREQ_1_6				(1<<1) | (1<<2)
#define S41_DIVIDE_FREQ_1_7				(1<<0) | (1<<1) | (1<<2)
#define S41_POLY_STEPS_15				0
#define S41_POLY_STEPS_7				(1<<3)
#define S41_POLY_SHIFT_FREQ(n)			n<<4
#define S41_CONTINOUS					0
#define S41_COUNTER						(1<<14)
#define S41_RESTART						(1<<15)


//dma stuff
#define DMA_ENABLE					(1<<15)
#define DMA_INTERUPT_ENABLE			(1<<14)
#define DMA_TIMING_IMMEDIATE		0
#define DMA_TIMING_VBLANK			(1<<12)
#define DMA_TIMING_HBLANK			(1<<13)
#define DMA_TIMING_SYNC_TO_DISPLAY	(1<<12) | (1<<13)
#define DMA_16						0
#define DMA_32						(1<<10)
#define DMA_REPEAT					(1<<9)
#define DMA_SOURCE_INCREMENT		0
#define DMA_SOURCE_DECREMENT		(1<<7)
#define DMA_SOURCE_FIXED			(1<<8)
#define DMA_DEST_INCREMENT			0
#define DMA_DEST_DECREMENT			(1<<5)
#define DMA_DEST_FIXED				(1<<6)
#define DMA_DEST_RELOAD				(1<<5) | (1<<6)

//timer stuff
#define TIMER_CASCADE				(1<<2)
#define TIMER_IRQ					(1<<6)
#define TIMER_ENABLE				(1<<7)

//irq stuff
#define IRQ_VBLANK			(1<<0)
#define IRQ_HBLANK			(1<<1)
#define IRQ_Y_TRIGGER		(1<<2)
#define IRQ_TM0				(1<<3)
#define IRQ_TM1				(1<<4)
#define IRQ_TM2				(1<<5)
#define IRQ_TM3				(1<<6)
#define IRQ_COMMS			(1<<7)
#define IRQ_DMA0			(1<<8)
#define IRQ_DMA1			(1<<9)
#define IRQ_DMA2			(1<<10)
#define IRQ_DMA3			(1<<11)
#define IRQ_KEY				(1<<12)
#define IRQ_CART			(1<<13)

#define IRQ_ENABLE			(1<<0)
*/

#if defined(__GNUC__)

#ifdef __cplusplus
extern "C" {
#endif
	extern void memmove_gba(void *to, const void *from, int size);
	extern void memset_gba(void *addr, int val, int size);
	extern void memcpy_gba(void *to, const void *from, int size);
	extern void memset_dword(DWORD *b, DWORD value, int size);
#ifdef __cplusplus
}
#endif

#endif //(__GNUC__)

#if !defined(__GNUC__)
#define memset_gba memset
#define memmove_gba memmove
#define memcpy_gba memcpy
#endif

#endif //_GAME_MAIN_H
