#include "ds2io.h"
#include "keyorwhatever.h"

_Pad Pad;
 _Stylus Stylus;

#define UPDATEPAD(pad, var) do{\
	Pad.pad.A = (var & KEY_A);\
	Pad.pad.B = (var & KEY_B)>>1;\
	Pad.pad.X = (var & KEY_X)>>10; \
	Pad.pad.Y = (var & KEY_Y)>>11;\
	Pad.pad.Up = (var & KEY_UP)>>6;\
	Pad.pad.Down = (var & KEY_DOWN)>>7;\
	Pad.pad.Left = (var & KEY_LEFT)>>5;\
	Pad.pad.Right = (var & KEY_RIGHT)>>4;\
	Pad.pad.Start = (var & KEY_START)>>3;\
	Pad.pad.Select = (var & KEY_SELECT)>>2;\
	Pad.pad.L = (var & KEY_L)>>9;\
	Pad.pad.R = (var & KEY_R)>>8;\
}while(0)

#define UPDATESTYLUS(type, var) do{\
	type = (var & KEY_TOUCH)>>12;\
}while(0)


unsigned short CompletePad, ExPad, TempPad;

void UpdatePad(void) 
{
	ExPad = CompletePad;
	
	struct key_buf rawin;

	ds2_getrawInput(&rawin);
	CompletePad = rawin.key;
	
	
	UPDATEPAD(Held, CompletePad);
	UPDATEPAD(Released, (ExPad & (~CompletePad)));
	UPDATEPAD(Newpress, (CompletePad & (~ExPad)));
	
	UPDATESTYLUS(Stylus.Held, CompletePad);
	UPDATESTYLUS(Stylus.Released, (ExPad & (~CompletePad)));
	UPDATESTYLUS(Stylus.Newpress, (CompletePad & (~ExPad)));	
	Stylus.X = rawin.x;
	Stylus.Y = rawin.y;
	
}