int topBuffer[256*192];
int bottomBuffer[256*192];
int bgwidth, bgheight;

u8 font[24576];
u8 font1[24576];
int fontColor = RGB15(31,31,31);
int shaddowColor = RGB15(0,0,0);

void loadFont(void)
{
	FILE* imgFile=fopen("/_imenu/font.raw","r");	
	if(imgFile)
	{			
		fread(&font[0], 24576, 1, imgFile);
		fclose(imgFile);
	}
}void loadFont1(void)
{
	FILE* imgFile=fopen("/_imenu/font1.raw","r");	
	if(imgFile)
	{			
		fread(&font1[0], 24576, 1, imgFile);
		fclose(imgFile);
	}
}

// font stuff
char fontWidth[96]={
2,3,5,6,5,7,6,3,4,2,
3,5,3,4,3,6,5,//0
6,5,5,
6,5,5,6,5,5,3,4,6,5,
4,5,8,7,//A
5,6,6,5,5,6,
6,2,4,6,5,8,6,6,5,6,
5,5,6,6,7,11,7,6,6,3,
3,4,5,7,3,
5,//a
5,5,5,5,
5,6,5,3,4,5,2,8,5,5,
5,5,4,4,4,5,6,9,5,6,
5,4,2,4,6,4};

char font1Width[96]={
2,4,6,10,8,13,0,4,6,6,8,
10,5,6,5,6,8,7,8,8,8,8,8,
8,8,8,5,5,9,9,10,7,12,9,
8,9,9,8,8,9,9,6,6,9,8,10,
9,10,8,10,9,8,10,9,9,13,9,
10,8,6,6,6,10,9,6,7,8,8,8,
8,6,8,8,4,4,8,4,12,8,8,8,
8,6,7,7,8,8,11,8,8,6,7,
5,7,10,5};

void drawText(bool screen, bool bg, int x, int y, int mx, int my, char* string, int color, int fNum, bool center)
{
	int x1=0, y1=0, temp = 0;
	int line_width = 0;
	int karakta = 0, pixel = 0;
	int newLine = x;
	
	for(temp=0; temp<strlen(string); temp++){
		karakta = string[temp]-32;
		if(fNum==0) line_width += fontWidth[karakta];
		if(fNum==1) line_width += font1Width[karakta];
		if(line_width > mx-x){
			string[temp]=0;
			if(fNum==0) line_width -= fontWidth[karakta];
			if(fNum==1) line_width -= font1Width[karakta];
	   }
	}
	if(center)x = ((mx+x)>>1) -(line_width>>1);
	line_width=0;
	int alpha=0;
	int wide;
	
	for(temp=0; temp<strlen(string); temp++){
	   karakta = string[temp]-32;
	   if(karakta+32 == 10){y+=16; x=newLine;}
	   
		if(fNum==0)wide = fontWidth[karakta];
		if(fNum==1)wide = font1Width[karakta];
		if(karakta >= 0 && karakta<=95){
			for(y1=0; y1<16; y1++){
				for(x1=0; x1<16; x1++){
					if(fNum==0)alpha = font[(karakta*16*16) + x1 + 16 * y1];
					if(fNum==1)alpha = font1[(karakta*16*16) + x1 + 16 * y1];
					if(alpha>>3 <31){ // skip plotting if no alpha
						if(screen){
							pixel = ((unsigned short*)down_screen_addr)[(x1+line_width+x) + 256*(y1+y)]; // or bottomBuffer
						}else{
							pixel = ((unsigned short*)up_screen_addr)[(x1+line_width+x) + 256*(y1+y)]; //topBuffer[(x1+line_width+x) + 256*(y1+y)];
						}
						int b2 = (pixel>>10)&31;
						int g2 = (pixel>>5)&31;
						int r2 = pixel &31;
						pixel = color;//fontColor;
						int b1 = (pixel>>10)&31;
						int g1 = (pixel>>5)&31;
						int r1 = pixel &31;
						pixel = RGB15(mix(r2,r1,alpha),mix(g2,g1,alpha),mix(b2,b1,alpha));
						if(x1+line_width+x >=0 && x1+line_width+x <256 && x1+line_width+x <mx){
							if(screen){
							//	if(bg){
									((unsigned short*)down_screen_addr)[(x1+line_width+x) + 256*(y1+y)]=pixel;
							//	}else{
							//		bottomBuffer[(x1+line_width+x) + 256*(y1+y)]=pixel;
							//	}
							}else{
							//	if(bg){
									((unsigned short*)up_screen_addr)[(x1+line_width+x) + 256*(y1+y)]=pixel;
							//	}else{
							//		topBuffer[(x1+line_width+x) + 256*(y1+y)]=pixel;
							//	}
							}
						}   
					}// alpha			
				}   
			}
			if(fNum==0)line_width += fontWidth[karakta];
			if(fNum==1)line_width += font1Width[karakta]-1;
		}//valid karakta
	}      
}   

struct BMPHeader
{
    char bfType[2];       /* "BM" */
    int bfSize;           /* Size of file in bytes */
    int bfReserved;       /* set to 0 */
    int bfOffBits;        /* Byte offset to actual bitmap data (= 54) */
    int biSize;           /* Size of BITMAPINFOHEADER, in bytes (= 40) */
    int biWidth;          /* Width of image, in pixels */
    int biHeight;         /* Height of images, in pixels */
    short biPlanes;       /* Number of planes in target device (set to 1) */
    short biBitCount;     /* Bits per pixel*/
    int biCompression;    /* Type of compression (0 if no compression) */
    int biSizeImage;      /* Image size, in bytes (0 if no compression) */
    int biXPelsPerMeter;  /* Resolution in pixels/meter of display device */
    int biYPelsPerMeter;  /* Resolution in pixels/meter of display device */
    int biClrUsed;        /* Number of colors in the color table (if 0, use 
                             maximum allowed by biBitCount) */
    int biClrImportant;   /* Number of important colors.  If 0, all colors 
                             are important */
};

char Screen_Cap(char Screen, char *Directory)
{
	//get date for file name
	struct rtc Date;
	ds2_getTime(&Date);
	
	char ScreenCapName[256];
//	sprintf(ScreenCapName, "%s/%d-%d-%d-%d-%d-%d.bmp",Directory,Date.year,Date.month,Date.day,Date.hours,Date.minutes,Date.seconds); 
	sprintf(ScreenCapName, "%s",Directory); 

	FILE* file=fopen(ScreenCapName, "wb");
	if(file == NULL)
		return -1; //error
	
   
    int width=SCREEN_WIDTH;
	int height= (Screen != DUAL_SCREEN) ? SCREEN_HEIGHT : SCREEN_HEIGHT<<1;
	
	int Bits = 24;
    int bytesPerLine = (((width* Bits) +31)/32)*4;;
    unsigned char *line;

	struct BMPHeader bmph;
	
	//fill the header
	strcpy(bmph.bfType, "BM");
	bmph.bfOffBits = 54;
    bmph.bfSize = bmph.bfOffBits + bytesPerLine * height;
    bmph.bfReserved = 0;
    bmph.biSize = 40;
    bmph.biWidth = width;
    bmph.biHeight = height;
    bmph.biPlanes = 1;
    bmph.biBitCount = Bits;
    bmph.biCompression = 0;
    bmph.biSizeImage = bytesPerLine * height;
    bmph.biXPelsPerMeter = 0;
    bmph.biYPelsPerMeter = 0;
    bmph.biClrUsed = 0;       
    bmph.biClrImportant = 0; 

	//write header
	fwrite(&bmph.bfType, 2, 1, file);
    fwrite(&bmph.bfSize, 4, 1, file);
    fwrite(&bmph.bfReserved, 4, 1, file);
    fwrite(&bmph.bfOffBits, 4, 1, file);
    fwrite(&bmph.biSize, 4, 1, file);
    fwrite(&bmph.biWidth, 4, 1, file);
    fwrite(&bmph.biHeight, 4, 1, file);
    fwrite(&bmph.biPlanes, 2, 1, file);
    fwrite(&bmph.biBitCount, 2, 1, file);
    fwrite(&bmph.biCompression, 4, 1, file);
    fwrite(&bmph.biSizeImage, 4, 1, file);
    fwrite(&bmph.biXPelsPerMeter, 4, 1, file);
    fwrite(&bmph.biYPelsPerMeter, 4, 1, file);
    fwrite(&bmph.biClrUsed, 4, 1, file);
    fwrite(&bmph.biClrImportant, 4, 1, file);

	//now to write the data
	line = malloc(bytesPerLine);
    if (line == NULL)
	   return -2;
	
	int x, y;
	short red,green,blue;
	unsigned short color =0;
	
	unsigned short* Top_Screen = up_screen_addr;
	unsigned short* Bottom_Screen = down_screen_addr;
	
	for (y = height - 1; y >= 0; y--)
	{
		for (x = 0; x < width+1; x++)
		{
			switch(Screen)
			{
				case UP_SCREEN:
					color = (unsigned short)Top_Screen[ x +( y << 8)];
				break;
				case DOWN_SCREEN:
					color =  (unsigned short)Bottom_Screen[x +( y << 8)];
				break;
				case DUAL_SCREEN:
					color = (y<SCREEN_HEIGHT) ? (unsigned short)Top_Screen[x +( y << 8)] :  (unsigned short)Bottom_Screen[  x +( y << 8)];
				break;
			}
					
			blue=(color&31)<<3;
			green=((color>>5)&31)<<3;
			red=((color>>10)&31)<<3;
			line[3*x] = red;
			line[3*x+1] = green;
			line[3*x+2] = blue;
		}
		fwrite(line, 1, bytesPerLine, file);
	}
	free(line);
	line = NULL;
	fclose(file);
	
	return 1;
} 

u16 loading_Pal[33]={
64543, 32768, 45452, 65535, 57079, 46509, 34882, 33825, 39110, 44395, 62364, 43338, 63421, 36996, 64478, 58136, 47566, 53908, 41224, 40167, 42281, 56022, 49680, 60250, 54965, 35939, 38053, 59193, 51794, 61307, 50737, 52851, 48623};

u8 loading_Texture[4096]={
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 4, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 5, 3, 3, 6, 1, 1, 7, 8, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 9, 10, 11, 
1, 1, 1, 1, 1, 1, 1, 5, 12, 3, 12, 1, 1, 13, 10, 14, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 15, 4, 6, 
1, 1, 1, 1, 1, 1, 11, 12, 16, 3, 17, 1, 13, 10, 3, 3, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 18, 1, 
1, 1, 1, 1, 1, 19, 12, 19, 17, 3, 20, 6, 10, 21, 3, 15, 
1, 1, 1, 1, 22, 12, 23, 1, 1, 1, 1, 1, 1, 1, 1, 7, 
17, 24, 1, 25, 8, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 26, 12, 21, 1, 
1, 1, 1, 1, 26, 12, 20, 1, 12, 14, 6, 27, 4, 28, 3, 9, 
1, 1, 7, 15, 3, 29, 3, 1, 25, 27, 17, 6, 15, 15, 1, 22, 
3, 21, 6, 10, 21, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 17, 3, 19, 1, 
1, 1, 1, 6, 10, 2, 1, 8, 3, 17, 21, 12, 13, 12, 14, 1, 
1, 1, 4, 3, 30, 19, 24, 1, 28, 3, 16, 17, 3, 10, 1, 10, 
3, 20, 17, 3, 24, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 6, 14, 27, 1, 1, 
1, 1, 7, 27, 30, 1, 1, 16, 3, 29, 3, 18, 11, 3, 31, 1, 
1, 2, 3, 29, 7, 27, 26, 1, 12, 10, 21, 9, 3, 24, 19, 3, 
29, 19, 3, 3, 16, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 16, 3, 22, 1, 1, 
1, 1, 24, 4, 1, 1, 1, 24, 3, 3, 32, 1, 24, 3, 2, 13, 
1, 21, 3, 15, 21, 20, 1, 18, 3, 3, 20, 17, 3, 2, 32, 3, 
17, 27, 24, 3, 20, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 4, 3, 27, 27, 13, 
1, 22, 10, 6, 1, 1, 1, 29, 3, 30, 1, 1, 12, 3, 29, 4, 
1, 21, 3, 14, 8, 25, 8, 30, 3, 28, 1, 29, 3, 11, 21, 3, 
3, 11, 31, 3, 11, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 30, 12, 30, 13, 1, 
20, 3, 20, 1, 1, 1, 1, 16, 5, 1, 1, 1, 27, 14, 24, 6, 
1, 13, 22, 27, 3, 15, 18, 17, 24, 1, 1, 4, 4, 26, 32, 29, 
18, 1, 22, 15, 6, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 25, 
12, 31, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 4, 
12, 6, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 26, 10, 
2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3, 3, 2, 1, 
1, 1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 3, 2, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 2, 3, 2, 1, 1, 1, 1, 2, 3, 1, 
1, 2, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 2, 3, 3, 3, 3, 3, 3, 
3, 3, 3, 3, 3, 3, 3, 2, 1, 1, 1, 1, 1, 1, 3, 3, 
3, 3, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 8, 17, 21, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 9, 3, 15, 18, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 31, 22, 1, 1, 1, 27, 27, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 6, 3, 19, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 10, 19, 1, 1, 1, 27, 27, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 9, 12, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 13, 12, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 17, 31, 1, 1, 1, 1, 1, 1, 1, 1, 
9, 27, 3, 23, 19, 1, 1, 1, 11, 10, 12, 28, 17, 1, 1, 1, 
20, 23, 14, 21, 17, 1, 1, 8, 24, 17, 13, 30, 23, 1, 18, 23, 
12, 25, 1, 7, 31, 14, 12, 30, 32, 13, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 12, 20, 1, 1, 1, 1, 1, 1, 1, 17, 
23, 8, 1, 20, 23, 1, 1, 2, 23, 26, 25, 14, 2, 1, 1, 5, 
27, 13, 6, 12, 9, 1, 1, 1, 21, 5, 1, 16, 24, 18, 32, 7, 
3, 25, 1, 31, 24, 7, 8, 14, 9, 7, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 19, 14, 1, 1, 1, 1, 1, 1, 1, 9, 29, 
7, 1, 1, 1, 3, 1, 13, 10, 6, 1, 1, 12, 25, 1, 26, 29, 
6, 1, 1, 10, 7, 1, 1, 1, 14, 13, 1, 21, 30, 16, 1, 19, 
29, 1, 1, 14, 6, 1, 25, 14, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 22, 24, 1, 1, 1, 1, 1, 1, 1, 27, 20, 
1, 1, 1, 20, 23, 1, 31, 2, 1, 1, 19, 23, 1, 1, 24, 9, 
1, 1, 11, 15, 1, 1, 1, 18, 29, 1, 1, 14, 17, 1, 1, 22, 
30, 1, 1, 12, 8, 7, 24, 17, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 23, 2, 1, 1, 1, 1, 5, 1, 1, 3, 1, 
1, 1, 7, 29, 5, 1, 12, 7, 1, 7, 27, 22, 1, 1, 14, 7, 
1, 13, 23, 32, 1, 1, 1, 30, 28, 1, 18, 14, 25, 1, 1, 23, 
18, 1, 1, 11, 14, 14, 17, 7, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 13, 3, 26, 1, 1, 13, 30, 22, 1, 1, 23, 11, 
1, 8, 27, 24, 1, 1, 3, 26, 13, 30, 29, 11, 20, 1, 14, 26, 
8, 32, 29, 20, 20, 1, 1, 23, 9, 2, 28, 28, 1, 1, 25, 14, 
19, 13, 1, 5, 20, 1, 1, 1, 1, 1, 1, 27, 27, 1, 1, 1, 
1, 1, 1, 8, 21, 3, 3, 3, 3, 3, 3, 13, 1, 1, 8, 23, 
3, 23, 5, 1, 1, 1, 28, 3, 31, 7, 14, 24, 7, 1, 22, 3, 
28, 1, 12, 31, 1, 1, 1, 12, 21, 7, 29, 18, 1, 1, 8, 14, 
2, 1, 1, 29, 3, 10, 21, 16, 6, 1, 1, 27, 27, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 32, 19, 25, 18, 2, 17, 10, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 14, 11, 7, 1, 6, 2, 27, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 9, 27, 14, 3, 29, 28, 6, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 
1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1
};
 
 