/*---------------------------------------------------------------------------------
---------------------------------------------------------------------------------*/
#include "nds.h"
#include <nds/arm9/console.h> //basic print funcionality
#include <stdio.h>
#include "malloc.h"
#include "norops.h"
#include <fat.h>

u8* buffer;

// from the EZ3 SDK
void SetRompage(u16 page)
{
    *(u16 *)0x9fe0000 = 0xd200;
    *(u16 *)0x8000000 = 0x1500;
    *(u16 *)0x8020000 = 0xd200;
    *(u16 *)0x8040000 = 0x1500;
    *(u16 *)0x9880000 = page;
    *(u16 *)0x9fc0000 = 0x1500;
}

void OpenWrite()
{
    *(u16 *)0x9fe0000 = 0xd200;
    *(u16 *)0x8000000 = 0x1500;
    *(u16 *)0x8020000 = 0xd200;
    *(u16 *)0x8040000 = 0x1500;
    *(u16 *)0x9C40000 = 0x1500;
    *(u16 *)0x9fc0000 = 0x1500;
}
 
void CloseWrite()
{
    *(u16 *)0x9fe0000 = 0xd200;
    *(u16 *)0x8000000 = 0x1500;
    *(u16 *)0x8020000 = 0xd200;
    *(u16 *)0x8040000 = 0x1500;
    *(u16 *)0x9C40000 = 0xd200;
    *(u16 *)0x9fc0000 = 0x1500;
}

#define ROMBASE 0x08000000
#define BLKSZ 0x10000

void restore(void)
{
    FILE* in;
	int i, read;
	iprintf("setting OS mode\n");
    SetRompage(0x8000);
    iprintf("OpenWrite\n");
    OpenWrite();
    iprintf("Erasing 4M OS chip\n");
    EZ4_NOR_Erase_All();
	iprintf("Erase complete, opening file\n");
	in = fopen("/ez4.bin", "rb");
    iprintf("Writing ez4.bin\n");
	for(i=0; i<40; i++)
	{
		read = fread(buffer, 1, BLKSZ, in);
		EZ4_NOR_Write((uint16*)(ROMBASE+(BLKSZ*i)), (uint16*)buffer, BLKSZ);
		iprintf(".");
	}
    CloseWrite();
	fclose(in);
    return;
}

bool fileExist (const char* filename)
{
    bool ret = false;
    FILE* fp;
    fp = fopen(filename, "rb");
    if (fp == NULL)
        ret = false;
    else
        ret = true;
    fclose(fp);
    return ret;
}

//---------------------------------------------------------------------------------
int main(void) {
//---------------------------------------------------------------------------------
    powerON(POWER_ALL_2D);

    videoSetMode(MODE_FB1);//not using the main screen
    videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);	//sub bg 0 will be used to print text
    vramSetBankC(VRAM_C_SUB_BG);

    SUB_BG0_CR = BG_MAP_BASE(31);

    BG_PALETTE_SUB[255] = RGB15(31,31,31);	//by default font will be rendered with color 255

    //consoleInit() is a lot more flexible but this gets you up and running quick
    consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

    //  give ARM9 access to the GBA cart to write the register to switch to OS mode
    REG_EXEMEMCNT &= ~0x0880;
    buffer = (u8*)malloc(0x10000); // allocate 64K for data

    if ((!fatInitDefault()) && (buffer != NULL))
    {
		if(buffer == NULL)
			iprintf("unable to alloc memory!");
		else
			iprintf("FAT start failed!");
	}
    else
    {
		if(fileExist("/ez4.bin"))
		{
		    iprintf("EZ4 restore tool (dlx/mini)\n");
		    iprintf("---------------------------\n");
			iprintf("file found, FAT started OK\n");
		    iprintf("-insert your EZ4\n"
		            "-press A to begin\n\n"
		            "*Do NOT proceed if\n"
		            "you use EZ4 compact*\n\n");

		    int press = 1;
		    while (press==1)
		    {
		        scanKeys();
		        u16 keys = keysHeld();

		        if(keys & KEY_A)
		        {
		            press = 0;
		            restore();
		        }
		    }

		    iprintf("Writing completed.\nPower off now.");
		}
		else
			iprintf("file ez4.bin not found in root");
	}

    while(1) // put it into a loop for the heck of it
    { 
    }
    return 0;
}
