@
@ Reversed from EZ4 DLX bootstrap
@ This is my first crack at actually re-assembling this stuff
@ So the comments may be wrong and the prototypes might not be quite right.
@
@ Jan 14, 2007
@
@ cory1492
@
    .ALIGN
    .CODE 32
    .ARM

.global  EZ4_NOR_Erase_All, EZ4_NOR_Write

@void EZ4_NOR_Erase_All(void);
@Erases from 0x040000 to 0x400000 on EZ4 OS NOR
@This is the space the GBA/NDS kernels are stored in
@Must set OpenWrite and OS mode before use
EZ4_NOR_Erase_All:
    stmfd sp!, {r3-r6}  @ store registers
    ldr r2, =0x8000000  @ start address
    ldr r1, =0x8400000  @ end address
eloop1:
    mov  r3,#0xFF  @ flash read
    strh r3,[r2]
    mov  r3,#0x20  @ flash erase
    strh r3,[r2]
    mov  r3,#0xD0  @ flash ack
    strh r3,[r2]
eloop2:
    ldrh r3,[r2]
    cmp r3,#0x80   @ check flash for return ack
    bne eloop2
    add  r2,r2,#0x10000 @ increment count
    cmp r2,r1
    bne eloop1

    ldmfd sp!, {r3-r6}  @ restore registers
    bx lr  @ return

@void EZ4_NOR_WRITE(uint16* address, uint16*data, uint16 length);
@length must be a multiple of 0x100?
EZ4_NOR_Write:
    stmdb  sp!,{r4,r5,r6,r14}
    movs r6,r2,lsr #0x1 @ length into R6
    mov  r4,r0 @ address into R4
    mov  r0,r1 @ data into r0
    mov  r5,#0x0 @ 0 into r5
wloop1:
    mov  r3,r5,lsl #0x1 @ r3 = r5<<1
    mov  r2,#0xFF  @ flash read
    strh r2,[r3, +r4] @ send flash read ack to addt r3+r4
    add  r1,r3,r4 @ r1 = r3+r4
    mov  r2,#0x41  @ flash page program
    strh r2,[r3, +r4]
    mov  r14,r1
    mov  r2,r0
    mov  r12,#0x0
wloop2:
    add  r12,r12,#0x1
    ldrh r3,[r2],#+0x2
    cmp r12,#0x80
    strh r3,[r14],#+0x2
    bne wloop2
    mov  r3,#0xE
    mov  r2,#0xD0  @ flash ack
    strh r3,[r1]
    strh r2,[r1]
wloop3:
    ldrh r3,[r1]
    cmp r3,#0x80
    bne wloop3
    add  r5,r5,#0x80
    mov  r3,#0xFF
    cmp r6,r5
    strh r3,[r1]
    add  r0,r0,#0x100
    bhi wloop1
    ldr r2, =0x8040000  @ start address??
    mov  r3,#0xFF
    strh r3,[r2]
    ldmia  sp!,{r4,r5,r6,r14}
    bx r14

    .END
