/*---------------------------------------------------------------------------------
---------------------------------------------------------------------------------*/
#include "nds.h"
#include <nds/arm9/console.h> //basic print funcionality
#include <stdio.h>
#include <fat.h>
#include "malloc.h"

#define ROMBASE 0x08000000

// from the EZ3 SDK
void SetRompage(u16 page)
{
    *(u16 *)0x9fe0000 = 0xd200;
    *(u16 *)0x8000000 = 0x1500;
    *(u16 *)0x8020000 = 0xd200;
    *(u16 *)0x8040000 = 0x1500;
    *(u16 *)0x9880000 = page;
    *(u16 *)0x9fc0000 = 0x1500;
}

void OpenWrite()
{
    *(u16 *)0x9fe0000 = 0xd200;
    *(u16 *)0x8000000 = 0x1500;
    *(u16 *)0x8020000 = 0xd200;
    *(u16 *)0x8040000 = 0x1500;
    *(u16 *)0x9C40000 = 0x1500;
    *(u16 *)0x9fc0000 = 0x1500;
}
 
void CloseWrite()
{
    *(u16 *)0x9fe0000 = 0xd200;
    *(u16 *)0x8000000 = 0x1500;
    *(u16 *)0x8020000 = 0xd200;
    *(u16 *)0x8040000 = 0x1500;
    *(u16 *)0x9C40000 = 0xd200;
    *(u16 *)0x9fc0000 = 0x1500;
}

void readGBA(uint32 address, u8* dest, uint32 length)
{
    uint32 i ;
    u16* pData = (u16*)dest;
    for(i=0;i<length;i+=2)
    {
        pData[i>>1]=*(u16*)(address+i);
    }
}

int main(void)
{
    powerON(POWER_ALL_2D);

    videoSetMode(MODE_FB1);
	videoSetModeSub(MODE_0_2D | DISPLAY_BG0_ACTIVE);	//sub bg 0 will be used to print text
	vramSetBankC(VRAM_C_SUB_BG);

	SUB_BG0_CR = BG_MAP_BASE(31);

	BG_PALETTE_SUB[255] = RGB15(31,31,31);	//by default font will be rendered with color 255

	//consoleInit() is a lot more flexible but this gets you up and running quick
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

//  give ARM9 access to the GBA cart to write the register to switch to OS mode
//	sysSetBusOwners(ARM9_OWNS_SRAM, ARM9_OWNS_CARD, ARM9_OWNS_ROM);
    REG_EXEMEMCNT &= ~0x0880;
    FILE* out;
    u8* buffer;
    buffer = (u8*)malloc(262144); // allocate 256K for the loader data
	u8 i;

	iprintf("start FAT\n");
    if (!fatInitDefault())
    {
		iprintf("FAT start failed!");
	}
    else
    {
    //  switch EZ to OS mode
        iprintf("setting OS mode\n");
        SetRompage(0x8000);
        iprintf("dumping 4MiB NOR\n");
		iprintf("Opening file 'dump.bin'\n");
        out = fopen("/dump.bin","w");
		for(i=0; i<16; i++)
		{
			readGBA (ROMBASE+(i*262144), buffer, 262144);
			fwrite (buffer, 262144, 1, out);
			iprintf(".");
		}
        fclose(out);

        iprintf("done.");
    }

    while(1) // put it into a loop for the heck of it
    { 
    }
	return 0;
}
