/*
** nester - NES emulator
** Copyright (C) 2000  Darren Ranalli
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as published by
** the Free Software Foundation; either version 2 of the License, or
** (at your option) any later version.
**
** This program is distributed in the hope that it will be useful, 
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU 
** Library General Public License for more details.  To obtain a 
** copy of the GNU Library General Public License, write to the Free 
** Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
**
** Any permitted reproduction of these routines, in whole or in part,
** must bear this legend.
*/

#ifndef NESPPU_H_
#define NESPPU_H_

#include <stdio.h>
#include "../../pixmap.h"
#include "../../types.h"
#include "../../settings.h"
#include "../../GBA_main.h"

#include "../libsnss/libsnss.h"

#define PPUINLINE __inline

//class NES;  // class prototype

int getTopMargin();
int getViewableHeight();

typedef enum
{
	MIRROR_HORIZ,
	MIRROR_VERT,
	MIRROR_FOUR_SCREEN
} mirroring_type;

enum { 
	NES_SCREEN_WIDTH  = 256,
	NES_SCREEN_HEIGHT = 240,

	SIDE_MARGIN = 8,

	NES_SCREEN_WIDTH_VIEWABLE  = NES_SCREEN_WIDTH,

	NES_BACKBUF_WIDTH = NES_SCREEN_WIDTH + (2*SIDE_MARGIN)
};

enum { BG_WRITTEN_FLAG = 0x01, SPR_WRITTEN_FLAG = 0x02 };

/*
extern uint8 LowRegs[0x08];
extern uint8 HighReg0x4014;

extern uint8* PPU_VRAM_banks[12];
*/
typedef struct ppuGlobals_s
{
	uint8 LowRegs[0x08];						//0
	uint8 HighReg0x4014;						//8

	uint8 pad1, pad2, pad3;						//remain 4 byte aligned

	uint32  in_vblank;							//12

	uint16  bg_pattern_table_addr;				//16
	uint16  spr_pattern_table_addr;				//18

	uint16  ppu_addr_inc;						//20

	// loopy's internal PPU variables
	uint16  loopy_v;							//22 // vram address -- used for reading/writing through $2007
					// see loopy-2005.txt
	uint16  loopy_t;							//24 // temp vram address
	uint8   loopy_x;							//26 // 3-bit subtile x-offset

	uint8   toggle_2005_2006;					//27

	uint8 spr_ram_rw_ptr;						//28 // sprite ram read/write pointer

	uint8 read_2007_buffer;						//29

	uint8 pad4, pad5;							//remain 4 byte aligned

	// rendering stuff
	uint32 current_frame_line;					//32
	uint8* PPU_VRAM_banks[12];					//36
	uint32 solid_buf[NES_BACKBUF_WIDTH];		//84 // bit flags for pixels of current line
	uint8  dummy_buffer[NES_BACKBUF_WIDTH];		//1172 // used to do sprite 0 hit detection when we aren't supposed to draw

	uint8 bg_pal[0x10];							//1444 (1408 from PPU_VRAM_banks offset)
	uint8 spr_pal[0x10];						//1460

	// sprite ram
	uint8 spr_ram[0x100];						//1476

	// 4 internal name tables (2 of these really are in the NES)
	uint8 PPU_nametables[4*0x400];				//1732
} ppuGlobals_t;
extern ppuGlobals_t ppuGlobals;
#define PPU_VRAM_banks ppuGlobals.PPU_VRAM_banks
#define PPU_nametables ppuGlobals.PPU_nametables
#define bg_pal ppuGlobals.bg_pal
#define spr_pal ppuGlobals.spr_pal
#define spr_ram ppuGlobals.spr_ram
#define LowRegs ppuGlobals.LowRegs
#define HighReg0x4014 ppuGlobals.HighReg0x4014
#define in_vblank ppuGlobals.in_vblank
#define bg_pattern_table_addr ppuGlobals.bg_pattern_table_addr
#define spr_pattern_table_addr ppuGlobals.spr_pattern_table_addr
#define ppu_addr_inc ppuGlobals.ppu_addr_inc
#define loopy_v ppuGlobals.loopy_v
#define loopy_t ppuGlobals.loopy_t
#define loopy_x ppuGlobals.loopy_x
#define toggle_2005_2006 ppuGlobals.toggle_2005_2006
#define spr_ram_rw_ptr ppuGlobals.spr_ram_rw_ptr
#define read_2007_buffer ppuGlobals.read_2007_buffer
#define current_frame_line ppuGlobals.current_frame_line
#define solid_buf ppuGlobals.solid_buf
#define dummy_buffer ppuGlobals.dummy_buffer

// 0x2000
static PPUINLINE uint32 PPU_NMI_enabled()  { return LowRegs[0] & 0x80; }
static PPUINLINE uint32 PPU_sprites_8x16() { return LowRegs[0] & 0x20; }

// 0x2001
static PPUINLINE uint32 PPU_spr_enabled()    { return LowRegs[1] & 0x10; }
static PPUINLINE uint32 PPU_bg_enabled()     { return LowRegs[1] & 0x08; }
static PPUINLINE uint32 PPU_spr_clip_left8() { return !(LowRegs[1] & 0x04); }
static PPUINLINE uint32 PPU_bg_clip_left8()  { return !(LowRegs[1] & 0x02); }

// 0x2002
static PPUINLINE uint32 PPU_sprite0_hit()                     { return LowRegs[2] & 0x40; }
static PPUINLINE uint32 PPU_more_than_8_sprites_on_cur_line() { return LowRegs[2] & 0x20; }
static PPUINLINE uint32 PPU_VRAM_accessible()                 { return LowRegs[2] & 0x10; }

#ifdef _WIN32
	#define PPUCODESECTION
#else
	#define PPUCODESECTION	ITCM_CODE
#endif

  void PPU_FakeConstructor();

  void PPU_reset();

  void PPU_set_mirroring(uint32 nt0, uint32 nt1, uint32 nt2, uint32 nt3);
  void PPU_set_mirroringB(mirroring_type m);

  uint32 PPU_vblank_NMI_enabled();

  uint8 PPU_ReadLowRegs(uint32 addr);
  void  PPU_WriteLowRegs(uint32 addr, uint8 data);

  uint8 PPU_Read0x4014();
  void  PPU_Write0x4014(uint8 data);

  // these are the rendering functions
  // screen is drawn a line at a time
  void PPU_start_frame();
  void PPU_do_scanline_and_draw(uint8* buf);
  void PPU_do_scanline_and_dont_draw();
  void PPU_end_frame();

  void PPU_start_vblank();
  void PPU_end_vblank();

  uint8 PPU_getBGColor();

  // these functions read from/write to VRAM using loopy_v
  uint8 PPU_read_2007();
  void PPU_write_2007(uint8 data);

  void PPU_render_bg(uint8* buf);

  void PPU_render_spr(uint8* buf);


#endif
