<?php
//Directory of BSNES-style CHT files.
$directory = @opendir("./in");

//Loop to run through files...
while ($file = readdir($directory)) {

	//If the file isn't a directory structure...
	if ($file != "." && $file != "..") {
	
		//List of codes taken from the file.
		//This makes it into an array (of lines).
		$codes_list = file("./in/$file");

		//Set up a blank array to hold the converted codes.
		$output_list = array();
		
		//Set up a counter so we can see if the CHT actually
		//contained any usable codes, and forgo writing it
		//if there wouldn't be any codes in it.
		$codes_made = 0;

		//For each line...
		foreach ($codes_list as $line) {
			
			//Remove the useless info.
			$line = str_replace('"','',$line);
			$line = str_replace('disabled,','',$line);
			
			//If it's a Game Genie code or a blank line, skip it.
			if ($line[4] != "-" && $line[4] != NULL) {
				
				//Confirm that at least one code was made.
				$codes_made++;
				
				//Set up a variable for later.
				$descript_move = 9;
				
				//Take the PAR code.
				$code = substr($line,0,8);
				//Chop off the 7E, as it's not needed.
				$code = str_replace('7E','',$code);
				//Separate the address and value by a comma.
				$addr = substr($code,0,4);
				$value = substr($code,4,2);
				$code = "On=".$addr.",".$value;
				
				//If it's a multi-line PAR code...
				$codes_number = substr_count($line,"+");
				
				if ($codes_number > 0) {
					//Extra segment 1.
					//Repeat the code portion again.
					$code2 = substr($line,11,8);
					$code2 = str_replace('7E','',$code2);
					$addr = substr($code2,0,4);
					$value = substr($code2,4,2);
					$code = $code.";".$addr.",".$value;
					$descript_move+=9;
					$line2 = substr($line,8,100);
				}
				
				if ($codes_number > 1) {
					//Extra segment 1.
					//Repeat the code portion again.
					$code2 = substr($line2,11,8);
					$code2 = str_replace('7E','',$code2);
					$addr = substr($code2,0,4);
					$value = substr($code2,4,2);
					$code = $code.";".$addr.",".$value;
					$descript_move+=9;
					$line2 = substr($line,8,100);
				}
				
				if ($codes_number > 2) {
					//Extra segment 1.
					//Repeat the code portion again.
					$code2 = substr($line2,11,8);
					$code2 = str_replace('7E','',$code2);
					$addr = substr($code2,0,4);
					$value = substr($code2,4,2);
					$code = $code.";".$addr.",".$value;
					$descript_move+=9;
					$line2 = substr($line,8,100);
				}
				
				//Take the description, remove a stray newline.
				$description = substr($line,$descript_move,100);
				$description = str_replace("\r\n",'',$description);

				//Put the info into the new format.
				$code = "[$description]\r\n$code\r\n\r\n";
				
				//Stick it in the output array.
				$output_list["$line"] = $code;
			}
		}
		
		//Add the game info.
		$game_name = str_replace(".cht","",$file);
		$game_info = "[GameInfo]\r\nName=$game_name\r\nSystem=SFC\r\nText=Automatically converted from the BSNES Cheat Code Pack.";
		
		//Compile the codes and info together.
		$output = "";
		foreach ($output_list as $line) { $output = $output.$line; } $output = $output.$game_info;
		
		//Write the file into the out folder (as long as it has codes).
		if ($codes_made != 0) {
			$output_file = "./out/$file";
			$handle = fopen($output_file, 'w');
			fwrite($handle, $output);
			fclose($handle);
			//Add in some damn confirmation...
			echo "$file<br />";
		}
	}
}

?>