/*
 * NDS SAVES to SLOT-2 v1.0 - by Marc R. (2011)
 *
 * fat.cpp: Functions used to manage FAT functions: mount file system,
 *			read and save files...

 * This program is free software; you can redistribute it and/or modify 
 * it under the terms of the GNU General Public License as published by 
 * the Free Software Foundation; either version 2 of the License, or 
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but 
 * WITHOUT ANY WARRANTY; without even the implied warranty of MERCHANTABILITY 
 * or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License 
 * for more details.
 * 
 * You should have received a copy of the GNU General Public License along 
 * with this program; if not, write to the Free Software Foundation, Inc., 
 * 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#include <nds.h>
#include <fat.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/stat.h> //for mkdir

int FAT_InitSLOT2(){
	return fatInitDefault();
}

int FAT_Save_File(const char *filepath, u8 *outbuf, u32 outlen){
	int ret;
	FILE *fd;
	fd = fopen(filepath, "wb");
	if(fd){
		ret=fwrite(outbuf, 1, outlen, fd);
		fclose(fd);
	}else{
		ret=-1;
	}

	return ret;
}



int FAT_Read_File(const char *filepath, void **outbuf){
	FILE *fp     = NULL;
	void *buffer = NULL;

	u32         filelen;

	s32 ret;

	/* Open file */
	fp = fopen(filepath, "rb");
	if (!fp)
		goto err;

	/* Get filesize */
	fseek(fp, 0, SEEK_END);
	filelen = ftell(fp);
	fseek(fp, 0, SEEK_SET);

	/* Allocate memory */
	buffer = malloc(filelen);
	if (!buffer)
		goto err;

	/* Read file */
	ret = fread(buffer, 1, filelen, fp);
	if (ret != filelen)
		goto err;

	/* Set pointer */
	*outbuf = buffer;

	goto out;

err:
	/* Free memory */
	if (buffer)
		free(buffer);

	/* Error code */
	ret = -1;

out:
	/* Close file */
	if (fp)
		fclose(fp);

	return ret;
}



int FAT_MakeDir(const char *dirname){
	int ret;
	DIR *dir;

	dir=opendir(dirname);
	if(dir){
		ret=1;
		closedir(dir);
	}else{
		mkdir(dirname, S_IREAD | S_IWRITE);
		ret=0;
	}

	return ret;
}

int FAT_ReadDir(const char *dirname, char** fileNames){
	DIR *dir;
	struct dirent *ent;
	struct stat statbuf;
	int nFiles=0;
	char filePath[256];

	dir=opendir(dirname);
	if (dir){
		while ((ent=readdir(dir))!=NULL) {
			sprintf(filePath, "%s/%s", dirname, ent->d_name);
    		stat(filePath, &statbuf);

			if(strcmp(".", ent->d_name) == 0 || strcmp("..", ent->d_name) == 0)
				continue;

			if(!(S_ISDIR(statbuf.st_mode))){ //if it's not a directory
				fileNames[nFiles]=(char *)malloc(256);
				sprintf(fileNames[nFiles], "%s", ent->d_name);

				//iprintf("%s %ld\n", ent->d_name, statbuf.st_size);
				nFiles++;
			}
		}
		closedir(dir);
	} else {
		nFiles=-1;
	}

	return nFiles;
}