#include "../GBA_main.h"

#include <stdarg.h>

#include "../addmoon/_const.h"
#include "../addmoon/_console.h"
#include "../addmoon/setarm9_reg_waitcr.h"

#include "../addmoon/gba_nds_fat/gba_nds_fat.h"
/*
#include <stdio.h>
#include <fat.h>
*/

//#define _EXLUDE_NES_MODULES

//512 is correct, but 256 will make it look right with current version of iDeaS
#define DS_BG_WIDTH 512

#ifndef _EXLUDE_NES_MODULES
#include "../nes/NES.h"
#include "../nes/NES_screen_mgr.h"
#include "../nes/NES_ROM.h"
#include "../nes/ppu/NES_PPU.h"
#include "../pixmap.h"
#include "../nes/SNSS.h"
#endif

#include <nds/arm9/console.h>

#include "../GBA_globals.h"
#include "../arm7_shared.h"

#define PRIMARY_VRAM_BUFFER VRAM_A

#ifdef _STATIC_MALLOC
#define STATIC_MALLOC_SIZE 262144
uint8 g_staticMallocBuffer[STATIC_MALLOC_SIZE] EWRAM_DATA;
uint32 g_staticMallocInc = 0;
void *nestermalloc(size_t size)
{
	if (g_staticMallocInc+size >= STATIC_MALLOC_SIZE)
	{
		consolePrintf("\n==================\nMALLOC OVERFLOW!!!\n==================\n");
	}

	void *p = &g_staticMallocBuffer[g_staticMallocInc];
	g_staticMallocInc += size;
	return p;
}
void nesterfree(void *ptr)
{
}
#endif

int GetRawTime(void)
{
	return (TIMER1_DATA*(1<<16))+TIMER0_DATA;
}

#define TIMER_MS_DIV	32
int GetTimeMS(void)
{
	return GetRawTime()/TIMER_MS_DIV;
}

void AdjustDSScale(void)
{
	if (globals->hwScale)
	{
		BG3_XDY = 0;
		BG3_YDX = 0;
		BG3_XDX = 256;
		BG3_YDY = 256+44;
	}
	else
	{
		BG3_XDY = 0;
		BG3_YDX = 0;
		BG3_XDX = 256;
		BG3_YDY = 256;
	}
}

#if 0
int g_debugTimerStart = 0;
int g_debugTime = 0;
INLINE void DBGTIMER_START(void)
{
	g_debugTimerStart = GetRawTime();
}
INLINE void DBGTIMER_END(void)
{
	g_debugTime = GetRawTime()-g_debugTimerStart;
}
INLINE void DBGTIMER_DRAW(void)
{
	DrawNumberToFramebuffer(PRIMARY_VRAM_BUFFER, g_debugTime, 0, 0);
}
#else
#define DBGTIMER_START(x)
#define DBGTIMER_END(x)
#define DBGTIMER_DRAW(x)
#endif

gbaGlobals_t *globals NESTER_DTCM;

#if 0
//FIXME - use gbfs, read nesrom from cart rom
static const unsigned char g_nesRom[1000000] = { "INSERTROMHERE:unknowntitle\0" };
//gbaGlobals_t staticGlobals;
#endif

#define PBUFFER_W (256+16)
#define PBUFFER_H (224+8)

boolean SCRMGR_lock(pixmap *p)
{
	p->width  = PBUFFER_W;
	p->height = PBUFFER_H;
#ifdef _BUFFER_DIRECT_MODE
	p->pitch  = 512;
#elif defined _DTCM_VID_BUFFER
	p->pitch  = 512;
#else
	p->pitch  = PBUFFER_W;
#endif
	p->data   = (PIXEL *)globals->pixelBuffer;
	return TRUE;
}

boolean SCRMGR_unlock()
{
	globals->newBuffer = true;
	globals->bufferLines = globals->altLineFrame;
	return TRUE;
}

void SCRMGR_blt()
{
}

void SCRMGR_flip()
{
}

void SCRMGR_clear(PIXEL color)
{
}

boolean SCRMGR_set_palette(const uint8 pal[256][3])
{
	return TRUE;
}

boolean SCRMGR_get_palette(uint8 pal[256][3])
{
	return TRUE;
}

int CapRGB(int x)
{
	if (x < 0)
	{
		return 0;
	}
	if (x > 31)
	{
		return 31;
	}

	return x;
}
boolean SCRMGR_set_palette_section(uint8 start, uint8 len)
{
	float scale = 8.0f;
	int i = start;
	int j = 0;
	int total;

	total = i+len;
	while (i < total)
	{
		int irgb[3];
		irgb[0] = CapRGB((int)(NES_RGB_pal[j][0]/scale));
		irgb[1] = CapRGB((int)(NES_RGB_pal[j][1]/scale));
		irgb[2] = CapRGB((int)(NES_RGB_pal[j][2]/scale));

		BG_PALETTE[i] = ((irgb[0])|(irgb[1]<<5)|(irgb[2]<<10)|(1<<15));

		j++;
		i++;
	}

	return TRUE;
}

boolean SCRMGR_get_palette_section(uint8 start, uint8 len, uint8 pal[][3])
{
	return TRUE;
}

boolean SCRMGR_set_NES_palette()
{
	NES_calculate_palette();
	return SCRMGR_set_palette_section(NES_COLOR_BASE, NES_NUM_COLORS);
}

void SCRMGR_assert_palette()
{
	SCRMGR_set_NES_palette();
}


//assign some global var values
void AssignGBAGlobals(const char *pfn,u32 size,unsigned char *pnesrombuf)
{
	globals = (gbaGlobals_t *)nestermalloc(sizeof(gbaGlobals_t));
	memset_gba(globals, 0, sizeof(gbaGlobals_t));

//	globals->nesRom = (nesRom_t *)g_nesRom;

	globals->nesRom = (nesRom_t *)nestermalloc(sizeof(nesRom_t));
	memset_gba(globals->nesRom, 0, sizeof(nesRom_t));
	
	globals->nesRom->romName=pfn;
	globals->nesRom->romLen=size;
	globals->nesRom->romData=pnesrombuf;
	
	//now in dtcm
	//globals->nesPal = (uint16 *)nestermalloc(256*sizeof(uint16));

	globals->altLineRendering = 0;
	globals->altLineFrame = 0;
	globals->heightOffset = 16;
	globals->frameSkip = -1;//3;
	globals->hwScale = 1;
	globals->speedHack = 0;

	globals->g_lastTime = 0;
	globals->g_Time = 0;

	globals->emuDrawEnabled = 1;
	globals->frames = 0;
	globals->logOps = 0;
}

uint8 pad_inp_state = 0;

#ifdef _DTCM_VID_BUFFER
PIXEL dtcmBuffer[512] NESTER_DTCM;
#endif

//emulator globals
#ifndef _EXLUDE_NES_MODULES
int NESEmuGlobals(void)
{
	/*
	globals->c_emu = new NES;
	if (!globals->c_emu)
	{
		return 0;
	}
	*/
	/*
	globals->c_cpu = new NES_6502;
	if (!globals->c_cpu)
	{
		return 0;
	}
	*/

	//arm7
	/*
	globals->c_apu = new NES_APU;
	if (!globals->c_apu)
	{
		return 0;
	}
	*/

	/*
	globals->scrn_mgr = new gbaScreenManager;
	if (!globals->scrn_mgr)
	{
		return 0;
	}
	*/

	/*
	globals->nesPad = new NES_pad;
	if (!globals->nesPad)
	{
		return 0;
	}
	*/

#ifdef _BUFFER_DIRECT_MODE
	globals->pixelBuffer = (PIXEL *)nestermalloc(sizeof(PIXEL)*(512*PBUFFER_H));
#elif defined _DTCM_VID_BUFFER
	globals->pixelBuffer = dtcmBuffer;
#else
	globals->pixelBuffer = (PIXEL *)nestermalloc(sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
#endif
	if (!globals->pixelBuffer)
	{
		return 0;
	}
	else
	{
#ifdef _BUFFER_DIRECT_MODE
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*(512*PBUFFER_H));
#elif defined _DTCM_VID_BUFFER
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*512);
#else
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
#endif
	}
	return 1;
}
#else
int NESEmuGlobals(void)
{
	return 1;
}
#endif

//debug log function
void GBA_Log(const char *msg)
{ return;
//  _consolePrint(msg); _consolePrint("\n");
	/*
	if (!globals->emuDrawEnabled)
	{
		int waitTime = strlen(msg)*20;

		PrintText("", -1);

		PrintText(msg, 0);

		while (waitTime > 0)
		{
			GBA_VSyncWait();
			waitTime--;
		}
	}
	*/
}

void *GBA_RomAlloc(int size)
{
	return nestermalloc(size);
}

void UpdateFrameBuffer(void)
{
#if 0 //old framebuffer method
	PIXEL *buf = globals->pixelBuffer;
	int w = 0;
	int h = 0;
	uint16 *frameBuffer = BG_BMP_RAM(0);
	buf += 8+(PBUFFER_W*globals->heightOffset);
	int scanDraw = -1;
	bool alr = (globals->altLineRendering == 2);

	if (globals->altLineRendering)
	{
		scanDraw = globals->bufferLines;
	}

	while (h < SCREEN_HEIGHT)
	{
		w = 0;
		if (scanDraw != -1)
		{
			if (!scanDraw)
			{
				if (alr)
				{
					memset_gba(frameBuffer, 0, sizeof(uint16)*SCREEN_WIDTH);
				}
				w = SCREEN_WIDTH;
				buf += SCREEN_WIDTH;
			}
			scanDraw = !scanDraw;
		}
		while (w < SCREEN_WIDTH)
		{
			frameBuffer[w] = BG_PALETTE[*buf];
			buf++;
			w++;
		}
		frameBuffer += SCREEN_WIDTH;
		buf += (PBUFFER_W-SCREEN_WIDTH);

		h++;
	}

	/*
	if (globals->clearNextRender)
	{
		memset_gba(PRIMARY_VRAM_BUFFER, 0, sizeof(uint16)*(SCREEN_WIDTH*SCREEN_HEIGHT));
		globals->clearNextRender = false;
	}
	*/
#elif defined _BUFFER_DIRECT_MODE //direct async copy
	uint8 channel = 0;
	PIXEL *buf = globals->pixelBuffer+(8*512);
	uint8 *out = (uint8 *)BG_BMP_RAM(0);

	while (dmaBusy(channel));
	dmaCopyWordsAsynch(channel, buf, out, 512*PBUFFER_H);
#else
#define PBUFFER_OFF_W	0
#define PBUFFER_OFF_H	8
	PIXEL *buf = globals->pixelBuffer+PBUFFER_OFF_W+(PBUFFER_OFF_H*PBUFFER_W)+8;
	uint8 *out = (uint8 *)BG_BMP_RAM(0);
	int h = 0;
	uint8 channel = 0;

	if (!globals->hwScale)
	{
		buf += (PBUFFER_W*globals->heightOffset);
		h += globals->heightOffset;
	}

	/*
	if (globals->clearNextRender)
	{
		memset_gba(globals->pixelBuffer, 0, sizeof(PIXEL)*((PBUFFER_W+16)*PBUFFER_H));
		globals->clearNextRender = false;
	}
	*/

	while (h < PBUFFER_H-PBUFFER_OFF_H)
	{
		while (dmaBusy(channel));
		dmaCopyWordsAsynch(channel, buf, out, PBUFFER_W-PBUFFER_OFF_W);

		buf += PBUFFER_W;
		out += DS_BG_WIDTH;
		h++;
	}

#endif
}

void on_irq() 
{	
  if(REG_IF & IRQ_VBLANK) {
	//draw frame
#ifndef _DTCM_VID_BUFFER
	if (globals->newBuffer)
	{
		globals->newBuffer = false;
		UpdateFrameBuffer();
	}
#endif

    // Tell the DS we handled the VBLANK interrupt
    VBLANK_INTR_WAIT_FLAGS |= IRQ_VBLANK;
    REG_IF |= IRQ_VBLANK;
  }
  else {
    // Ignore all other interrupts
    REG_IF = REG_IF;
  }
}

//stolen from a tutorial because i'm lazy.
static int key_prev = 0;
static int key_curr = 0;
#define key_poll() { key_prev=key_curr; key_curr = keys_cur; }
#define key_transit(key) ((key_curr^key_prev) & key)
#define key_held(key) (~(key_curr|key_prev) & key)
#define key_hit(key) ((~key_curr&key_prev) & key)
#define key_released(key) ((key_curr&~key_prev) & key)

const char *TextForOption(int option)
{
	if (option)
	{
		return " (ON)";
	}
	else
	{
		return " (OFF)";
	}
}

const char *TextForFrameskip(int skip)
{
	if (skip == -1)
	{
		return " - AUTO";
	}

	static char str[128];
	sprintf(str, " - %i", skip);
	return str;
}

void PrintConsoleText(void)
{
//	consoleClear();

	consolePrintf("\nNesterDS (v0.3)");
	consolePrintf("\nNester written by");
	consolePrintf("\nDarren Ranalli");
	consolePrintf("\nDS port by Rich Whitehouse");
	consolePrintf("\nwww.telefragged.com/thefatal/");
	consolePrintf("\n\nL/R adjusts height offset.\nHold X for functions:");
//	consolePrintf("\n X+A - toggle line mode");
//	consolePrintf(TextForOption(globals->altLineRendering));
	consolePrintf("\n X+B - swap screens");
	consolePrintf("\n X+Y - toggle hw scale");
	consolePrintf(TextForOption(globals->hwScale));
	consolePrintf("\n X+UP - toggle sound");
	consolePrintf(TextForOption(g_sharedPData->soundEnabled));
	consolePrintf("\n X+L/R - frameskip");
	consolePrintf(TextForFrameskip(globals->frameSkip));
	consolePrintf("\n X+SEL - toggle speedhack");
	consolePrintf(TextForOption(globals->speedHack));
	consolePrintf("\n X+START - reset");

  consolePrintf("\n\n");
  consolePrintf("L+R+START: Return to MoonShell2.");
  consolePrintf("           (not impliment)");

#if 0
	extern uint32 __dtcm_used, __dtcm_start;
	char str[128];
	int a = (int)&__dtcm_used - (int)&__dtcm_start;
	const int targetMem = 15000;
	if (a > targetMem)
	{
		sprintf(str, "\n\nWARNING! dtcm using %i bytes, over target of %i.", a, targetMem);
		consolePrintf(str);
	}

	uint32 endIPCAddr = (uint32)(g_sharedPData+1);
	sprintf(str, "\n%i bytes remaining for active IPC.\n", 0x2800000-endIPCAddr);
	consolePrintf(str);
#endif
}

void SetNESInput(void)
{
	scanKeys();
	int keys_cur = keysHeld();

	key_poll();

	if (keys_cur & (KEY_X))
	{ //x acts as a "function" key
		PAD_set_button_state(NES_UP,     false);
		PAD_set_button_state(NES_DOWN,   false);
		PAD_set_button_state(NES_LEFT,   false);
		PAD_set_button_state(NES_RIGHT,  false);
		PAD_set_button_state(NES_SELECT, false);
		PAD_set_button_state(NES_START,  false);
		PAD_set_button_state(NES_B,      false);
		PAD_set_button_state(NES_A,      false);

		bool changed = false;
		/*
		if (key_hit(KEY_A))
		{ //toggle rendering mode
			globals->altLineRendering = !globals->altLineRendering;
			globals->clearNextRender = true;
			changed = true;
		}
		*/
		if (key_hit(KEY_B))
		{ //swap screens
			lcdSwap();
		}
		if (key_hit(KEY_UP))
		{ //toggle sound
			g_sharedPData->soundEnabled = !g_sharedPData->soundEnabled;
			changed = true;
		}
		if (key_hit(KEY_R))
		{
			globals->frameSkip++;
			if (globals->frameSkip > 10)
			{
				globals->frameSkip = 10;
			}
			changed = true;
		}
		if (key_hit(KEY_L))
		{
			globals->frameSkip--;
			if (globals->frameSkip < -1)
			{
				globals->frameSkip = -1;
			}
			changed = true;
		}
		if (key_hit(KEY_Y))
		{
			globals->hwScale = !globals->hwScale;
			AdjustDSScale();
			changed = true;
		}
		if (key_hit(KEY_SELECT))
		{
			globals->speedHack = !globals->speedHack;
			changed = true;
		}
		if (key_hit(KEY_START))
		{
			CPUINT_Reset();
		}

		if (changed)
		{
			consoleClear();
			PrintConsoleText();
		}
		return;
	}

	if (key_held(KEY_R))
	{
		globals->heightOffset += 2;
		if (globals->heightOffset > PBUFFER_H-SCREEN_HEIGHT+2)
		{
			globals->heightOffset = PBUFFER_H-SCREEN_HEIGHT+2;
		}
	}
	if (key_held(KEY_L))
	{
		globals->heightOffset -= 2;
		if (globals->heightOffset < 0)
		{
			globals->heightOffset = 0;
		}
	}

	PAD_set_button_state(NES_UP,     (keys_cur & (KEY_UP)));
	PAD_set_button_state(NES_DOWN,   (keys_cur & (KEY_DOWN)));
	PAD_set_button_state(NES_LEFT,   (keys_cur & (KEY_LEFT)));
	PAD_set_button_state(NES_RIGHT,  (keys_cur & (KEY_RIGHT)));
	PAD_set_button_state(NES_SELECT, (keys_cur & (KEY_SELECT)));
	PAD_set_button_state(NES_START,  (keys_cur & (KEY_START)));
	PAD_set_button_state(NES_B,      (keys_cur & (KEY_B)));
	PAD_set_button_state(NES_A,      (keys_cur & (KEY_A)));
}

int NES_Init(void)
{
	if (!NESEmuGlobals())
	{
		return 0;
	}
#ifndef _EXLUDE_NES_MODULES
	if (!NES_FakeConstructor())
	{
		return 0;
	}
//	globals->c_emu->set_pad1(globals->nesPad);
#endif

	return 1;
}

//get general arm state info and print it
extern int GetTCMInfo(void);
extern int GetCRInfo(void);
extern void SetCRInfo(int cr);
void DS_DebugInfo(void)
{
	char str[128];

	int cr = GetCRInfo();
	int tcm = GetTCMInfo();

	int itcmSize = 512<<((tcm>>6)&15);
	int dtcmSize = 512<<((tcm>>18)&15);

	if (cr & (1<<0))
	{
		consolePrintf("Protection unit enabled.\n");
	}
	if (cr & (1<<2))
	{
		consolePrintf("Data cache enabled.\n");
	}
	if (cr & (1<<7))
	{
		consolePrintf("Big endian mode.\n");
	}
	else
	{
		consolePrintf("Little endian mode.\n");
	}
	if (cr & (1<<12))
	{
		consolePrintf("Instruction cache enabled.\n");
	}
	if (cr & (1<<13))
	{
		consolePrintf("Alternate vector select enabled.\n");
	}
	if (cr & (1<<14))
	{
		consolePrintf("Round-robin replacement enabled.\n");
	}
	if (cr & (1<<15))
	{
		consolePrintf("No TBIT.\n");
	}
	if (cr & (1<<16))
	{
		consolePrintf("DTCM enabled.\n");
	}
	if (cr & (1<<17))
	{
		consolePrintf("DTCM Load Mode: 1\n");
	}
	else
	{
		consolePrintf("DTCM Load Mode: 0\n");
	}
	if (cr & (1<<18))
	{
		consolePrintf("ITCM enabled.\n");
	}
	if (cr & (1<<19))
	{
		consolePrintf("ITCM Load Mode: 1\n");
	}
	else
	{
		consolePrintf("ITCM Load Mode: 0\n");
	}

	if ((tcm & (1<<2)))
	{
		itcmSize = 0;
	}
	if ((tcm & (1<<14)))
	{
		dtcmSize = 0;
	}
	sprintf(str, "\nITCM size: %i\nDTCM size: %i\n", itcmSize, dtcmSize);
	consolePrintf(str);

	//dtcm data should have been copied by the runtime, to verify go through the region and check for non-0 words
	/*
	{
		extern uint32 __dtcm_start, __dtcm_end;
		uint32 *dtcm = &__dtcm_start;
		uint32 *dtcmEnd = dtcm+(&__dtcm_end-&__dtcm_start);
		//int dtcmLen = (int)(&__dtcm_end-&__dtcm_start);

		while (dtcm < dtcmEnd) {
			if (*dtcm != 0) {
				consolePrintf("dtcm non-0.\n");
				break;
			}
			dtcm++;
		}

		sprintf(str, "dtcm scan finished (%0x, %0x)\n", (int)&__dtcm_start, (int)dtcmEnd);
		consolePrintf(str);
	}

	//itcm data should have been copied by the runtime, to verify go through the region and check for non-0 words
	{
		extern uint32 __itcm_start, __itcm_end;
		uint32 *itcm = &__itcm_start;
		uint32 *itcmEnd = itcm+(&__itcm_end-&__itcm_start);
		//int itcmLen = (int)(&__itcm_end-&__itcm_start);

		while (itcm < itcmEnd) {
			if (*itcm != 0) {
				consolePrintf("itcm non-0.\n");
				break;
			}
			itcm++;
		}

		sprintf(str, "itcm scan finished (%0x, %0x)\n", (int)&__itcm_start, (int)itcmEnd);
		consolePrintf(str);
	}
	*/

	//screwing around
	//cr &= ~(1<<12);
	//cr |= (1<<19);
	//SetCRInfo(cr);
}

#include "../addmoon/GBA_main_AssignGBAGlobals_From_MoonShell2_ExtLink.h"

//pass this to the arm7
//uint8 g_apuBuffer[16384] EWRAM_DATA;

#define NTSC_FRAMERATE (60000.0/1001.0)
#define FRAME_PERIOD   (1000.0/NTSC_FRAMERATE)

#define THROTTLE_SPEED  (NESTER_settings.nes.preferences.speed_throttling && 1)
#define SKIP_FRAMES     (NESTER_settings.nes.preferences.auto_frameskip && THROTTLE_SPEED)
void NES_InitialArmShare(void);
int main(int argc, char *argv[])
{
	int success;
	int last_frame_time_i;
	double last_frame_time;

	//this also only became necessary upon upgrading ndslib.
	//weird, i guess the new libs pushed memory around to cause it?
	//but i've never had the issue before regardless of drastic changes in code size.
	memset((void *)g_sharedPData, 0, sizeof(customSharedData_t));

	powerON(POWER_ALL);

	//what the hell? the new ndslib reverses screens?
	lcdSwap();

	// IRQ basic setup
	IRQ_HANDLER = on_irq;
	REG_IE |= IRQ_VBLANK;

	//setup the main display
	videoSetMode(MODE_5_2D|DISPLAY_BG3_ACTIVE);
	vramSetBankA(VRAM_A_MAIN_BG);
	BG3_CR = BG_BMP8_512x512|BG_BMP_BASE(0);

	//setup the sub display
	videoSetModeSub(MODE_0_2D|DISPLAY_BG0_ACTIVE);
	vramSetBankC(VRAM_C_SUB_BG);
	SUB_BG0_CR = BG_MAP_BASE(31);
	BG_PALETTE_SUB[255] = RGB15(31,31,31);

	//give the arm7 some scratch mem (only when buffer is not in arm7 mem)
	//g_sharedPData->audioBuffer = (uint32)(&g_apuBuffer[0]);

	//todo: draw some kewl stuff in here, maybe an nes pad for the touch screen, and also
	//put options here instead of using x as a function key.
	consoleInitDefault((u16*)SCREEN_BASE_BLOCK_SUB(31), (u16*)CHAR_BASE_BLOCK_SUB(0), 16);

	//enable timers for keeping track of a normal time value every frame.
	TIMER0_CR = TIMER_ENABLE|TIMER_DIV_1024;
	TIMER1_CR = TIMER_ENABLE|TIMER_CASCADE;

	g_sharedPData->nesRomRunning = 0;
	g_sharedPData->nesBurn = 0;

	AdjustDSScale();

	consoleClear();
	
	AssignGBAGlobals_From_MoonShell2_ExtLink();

	PrintConsoleText();

	//DS_DebugInfo();

	success = NES_Init();
	if (!success)
	{
		consolePrintf("\n\nNo NES ROM found, or unsupported mapper.");
		while (1)
		{
			swiWaitForVBlank();
		}
	}

	NES_InitialArmShare();

	//enable sound by default
	g_sharedPData->soundEnabled = 1;

	globals->randomPixels = 0;

	last_frame_time_i = GetTimeMS();
	last_frame_time = (double)last_frame_time_i;

	while (1)
	{
		// get the current time
		int cur_time_i = GetTimeMS();
		double cur_time = (double)cur_time_i;//SYS_TimeInMilliseconds();

		SetNESInput();

#if 0
		char str[128];
		sprintf(str, "%i\n", g_sharedPData->debugValue);
		consolePrintf(str);
#endif

		if (success)
		{
			// make up for missed frames
			if (1)//SKIP_FRAMES)
			{
				uint32 frames_since_last;
				if (cur_time < last_frame_time)
				{ //rollover, just don't frameskip.
					frames_since_last = 0;
				}
				else
				{
					frames_since_last = (uint32)((cur_time - last_frame_time) / FRAME_PERIOD);
				}

				if (globals->frameSkip != -1)
				{
					frames_since_last = globals->frameSkip;
				}
				// are there extra frames?
				if(frames_since_last > 1)
				{
					uint32 i;
					for(i = 1; i < frames_since_last; i++)
					{
						if(i == 10) break;
						SetNESInput();

						last_frame_time += FRAME_PERIOD;
						NES_emulate_frame(FALSE);
					}
				}
			}

			last_frame_time_i = cur_time_i;
			last_frame_time = cur_time;
			NES_emulate_frame(TRUE);
			globals->frames++;
			/*
			if (globals->randomPixels)
			{
				for (i = 0; i < (SCREEN_WIDTH*SCREEN_HEIGHT); i++) 
				{
					frameBuffer[i] = RGB15(rand()%31,rand()%31,rand()%31);
				}
			}
			*/
		}
		else
		{
			/*
			globals->randomPixels = 1;
			if (globals->randomPixels)
			{
				for (uint32 i = 0; i < (SCREEN_WIDTH*SCREEN_HEIGHT); i++) 
				{
					frameBuffer[i] = RGB15(rand()%31,0,0);
				}
			}
			*/
		}

		//DrawNumberToFramebuffer(frameBuffer, cur_time_i, 0, 0);
		//swiWaitForVBlank();
	}
	
	return 0;
}
