unit _inifile;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, ComCtrls, StdCtrls, ExtCtrls, Buttons, INIFiles, _m_Tools;

procedure LoadINI;
procedure SaveINI;

implementation

uses MainWin;

const CRLF:string=char($0d)+char($0a);

function GetINIFilename:string;
begin
  Result:=ChangeFileExt(Application.ExeName,'.ini');
end;

procedure LoadINI;
var
  fini:TINIFile;
  Section:string;
  chk:boolean;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='ConvertSettings';

  Main.LargeThumbChk.Checked:=fini.ReadBool(Section,'LargeThumb',Main.LargeThumbChk.Checked);

  fini.Free;
end;

procedure SaveINI;
var
  fini:TINIFile;
  Section:string;
begin
  fini:=TINIFile.Create(GetINIFilename);

  Section:='ConvertSettings';

  fini.WriteBool(Section,'LargeThumb',Main.LargeThumbChk.Checked);

  fini.Free;
end;

end.
