package org.util;

import java.io.OutputStream;
import java.io.PrintStream;

/**
 * 
 * @author uidd0536
 * Logger for LMT
 */
public final class Log {
	
	/**
	 * Log Level: info
	 */
	public static final int INFO = 0;
	/**
	 * Log Level: warning
	 */
	public static final int WARNING = 1;
	/**
	 * Log Level: error
	 */
	public static final int ERROR = 2;

	/**
	 * DEBUG ON/OFF
	 */
	public static boolean debug = false;
	/**
	 * Log Level
	 */
	public static int severity = 0;
	
	/**
	 * The stream to log
	 */
	public static PrintStream out;
	
	private Log() {
		
	}
	
	/**
	 * set the outputstream
	 * @param _out the new outpustream
	 */
	public static void setOutputStream(OutputStream _out) {
		out = new PrintStream(_out);
	}
	
	/**
	 * set the outputstream
	 * @param _out the new outpustream
	 */
	public static void setOutputStream(PrintStream _out) {
		out = _out;
	}

	/**
	 * log an info trace
	 * @param trace the info trace
	 */
	public static void info(String trace) {
		if (severity <= INFO) {
			out.println(trace);
		}
	}

	/**
	 * log a warning trace
	 * @param trace the warning trace
	 */
	public static void warning(String trace) {
		if (severity <= WARNING) {
			out.println(trace);
		}
	}

	/**
	 * log an error trace
	 * @param trace the error trace
	 */
	public static void error(String trace) {
		if (severity <= ERROR) {
			out.println(trace);
		}
	}

	/**
	 * log an debug trace
	 * @param trace the debug trace
	 */
	public static void debug(String trace) {
		if (debug) {
			out.println(trace);
		}
	}
	
	/**
	 * log an exception (debug)
	 * @param thr the exception
	 */
	public static void debug(Throwable thr) {
		if (debug) {
			thr.printStackTrace(out);
		}
	}

	/**
	 * force a trace on the console (bypass log outpustream)
	 * @param trace the trace
	 */
	public static void sysout(String trace) {
		System.out.println(trace);
	}
	
}
