package org.pictods.ui;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.swt.widgets.Text;
import org.pictods.NDSSettings;

public class NDSSettingsUI extends Dialog {

	private Shell dialogShell;
	public NDSSettings settings;
	private static final int WIDTH = 350;

	private Text iWidth, iHeight, iSize;
	private Text oWidth, oHeight, oSize;
	private Text thWidth, thHeight, thSize;
	private Text name, author, provider;
	private Combo iQuality, oQuality, thQuality;
	public String title = "";
//	RightHanded_Landscape_View
//	KEY_Right  = Action_ScrollRight;
//	KEY_Down   = Action_ScrollDown;
//	KEY_Up     = Action_ScrollUp;
//	KEY_Left   = Action_ScrollLeft;
//	KEY_A      = Action_ChangeViewMode;
//	KEY_B      = Action_SetModeThmbs;
//	KEY_X      = Action_RightPage;
//	KEY_Y      = Action_LeftPage;
//	KEY_R      = Action_Rotate;
//	KEY_L      = Action_ChangeMode;
//	KEY_Select = Action_ChangeLight;
	private Button manga; 
	

	public NDSSettingsUI(Shell parent) {
		super(parent);
	}

	public void defaultPressed() {
		applySettingsToUI(new NDSSettings());
		applyUIToSettings();
	}
	
	protected void okPressed() {
		applyUIToSettings();
		//String str = name.getText();
		// check file could be created
//		try {
//			File testfile = File.createTempFile(str,"");
//			testfile.delete();
//		}
//		catch(Throwable th) {
//			MessageDialog.openError(
//					getShell(),
//					"Pictods error",
//					"Invalid name: '" + str + "'. Check for invalid character / \\ | * ? : < > \"");
//			return;
//		}
		super.okPressed();
	}
	
	protected void buttonPressed(int buttonId) {
		if (buttonId == IDialogConstants.BACK_ID) {
			defaultPressed();
		}
		else {
			super.buttonPressed(buttonId);
		}
	}
	
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		createButton(parent, IDialogConstants.BACK_ID,
				"Default", false);
	}
	
	public void applyUIToSettings() {
		try {
			settings.iWidth = Integer.parseInt(iWidth.getText());
			settings.iHeight = Integer.parseInt(iHeight.getText());
			settings.iSize = Integer.parseInt(iSize.getText());
			settings.iQuality = Integer.parseInt(thQuality.getItem(iQuality
					.getSelectionIndex()));

			settings.oWidth = Integer.parseInt(oWidth.getText());
			settings.oHeight = Integer.parseInt(oHeight.getText());
			settings.oSize = Integer.parseInt(oSize.getText());
			settings.oQuality = Integer.parseInt(thQuality.getItem(oQuality
					.getSelectionIndex()));

			settings.thWidth = Integer.parseInt(thWidth.getText());
			settings.thHeight = Integer.parseInt(thHeight.getText());
			settings.thSize = Integer.parseInt(thSize.getText());
			settings.thQuality = Integer.parseInt(thQuality.getItem(thQuality
					.getSelectionIndex()));
			
			settings.manga = manga.getSelection()? 1:0;
			
			if (name.isEnabled())
				settings.name = name.getText();
			if (author.isEnabled())
				settings.author = author.getText();
			if (provider.isEnabled())
				settings.provider = provider.getText();
			
		} catch (NumberFormatException e) {
			MessageDialog.openError(
					dialogShell, "Pictods error", "Bad value. Please, check fields.");
		}
	}

	public void applySettingsToUI(NDSSettings set) {
		iWidth.setText("" + set.iWidth);
		iHeight.setText("" + set.iHeight);
		iSize.setText("" + set.iSize);
		iQuality.select((set.iQuality / 10) - 1);

		oWidth.setText("" + set.oWidth);
		oHeight.setText("" + set.oHeight);
		oSize.setText("" + set.oSize);
		oQuality.select((set.oQuality / 10) - 1);

		thWidth.setText("" + set.thWidth);
		thHeight.setText("" + set.thHeight);
		thSize.setText("" + set.thSize);
		thQuality.select((set.thQuality / 10) - 1);
		
		manga.setSelection(set.manga == 0?false:true);

		if (set.name == null) {
			name.setEnabled(false);
		}
		else {
			name.setText(set.name);
		}
		author.setText(set.author);
		provider.setText(set.provider);
	}

	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		dialogShell = newShell;
		dialogShell.setText("NDS Settings");
		dialogShell.setImage(new Image(Display.getCurrent(),
				"../resources/pictods.ico"));
		dialogShell.setLayout(new GridLayout(1, false));
		dialogShell.setMinimumSize(WIDTH, -1);
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		((GridLayout) composite.getLayout()).numColumns = 1;
		
		Label titleLabel = new Label(composite, SWT.NONE);
		titleLabel.setText(title);

		Group panel = new Group(composite, SWT.NONE);
		panel.setLayout(new GridLayout(1, false));
		panel.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));

		TabFolder ndsFolder = new TabFolder(panel, SWT.NONE);
		ndsFolder.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));

		Group imageGroup = new Group(ndsFolder, SWT.NONE);
		imageGroup.setLayout(new GridLayout(2, false));
		imageGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));
		TabItem imageItem = new TabItem(ndsFolder, SWT.NONE);
		imageItem.setText("Image");
		imageItem.setControl(imageGroup);
		Label widthLabel = new Label(imageGroup, SWT.NONE);
		widthLabel.setText("Width:");
		iWidth = new Text(imageGroup, SWT.BORDER);
		iWidth.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));
		Label heightLabel = new Label(imageGroup, SWT.NONE);
		heightLabel.setText("Height:");
		iHeight = new Text(imageGroup, SWT.BORDER);
		iHeight.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));
		Label maxLabel = new Label(imageGroup, SWT.NONE);
		maxLabel.setText("Max Size:");
		iSize = new Text(imageGroup, SWT.BORDER);
		iSize.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));
		Label qualityLabel = new Label(imageGroup, SWT.NONE);
		qualityLabel.setText("Quality:");
		iQuality = new Combo(imageGroup, SWT.BORDER);
		iQuality.setItems(new String[] { "10", "20", "30", "40", "50", "60",
				"70", "80", "90" });

		Group overviewGroup = new Group(ndsFolder, SWT.NONE);
		overviewGroup.setLayout(new GridLayout(2, false));
		overviewGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));
		TabItem overviewItem = new TabItem(ndsFolder, SWT.NONE);
		overviewItem.setText("Overview");
		overviewItem.setControl(overviewGroup);
		Label owidthLabel = new Label(overviewGroup, SWT.NONE);
		owidthLabel.setText("Width:");
		oWidth = new Text(overviewGroup, SWT.BORDER);
		oWidth.setEnabled(false);
		Label oheightLabel = new Label(overviewGroup, SWT.NONE);
		oheightLabel.setText("Height:");
		oHeight = new Text(overviewGroup, SWT.BORDER);
		oHeight.setEnabled(false);
		Label omaxLabel = new Label(overviewGroup, SWT.NONE);
		omaxLabel.setText("Max Size:");
		oSize = new Text(overviewGroup, SWT.BORDER);
		oSize.setEnabled(false);
		Label oqualityLabel = new Label(overviewGroup, SWT.NONE);
		oqualityLabel.setText("Quality:");
		oQuality = new Combo(overviewGroup, SWT.BORDER);
		oQuality.setItems(new String[] { "10", "20", "30", "40", "50", "60",
				"70", "80", "90" });

		Group thumnailGroup = new Group(ndsFolder, SWT.NONE);
		thumnailGroup.setLayout(new GridLayout(2, false));
		thumnailGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));
		TabItem thumbnailItem = new TabItem(ndsFolder, SWT.NONE);
		thumbnailItem.setText("Thumbnail");
		thumbnailItem.setControl(thumnailGroup);
		Label thwidthLabel = new Label(thumnailGroup, SWT.NONE);
		thwidthLabel.setText("Width:");
		thWidth = new Text(thumnailGroup, SWT.BORDER);
		thWidth.setEnabled(false);
		Label thheightLabel = new Label(thumnailGroup, SWT.NONE);
		thheightLabel.setText("Height:");
		thHeight = new Text(thumnailGroup, SWT.BORDER);
		thHeight.setEnabled(false);
		Label thmaxLabel = new Label(thumnailGroup, SWT.NONE);
		thmaxLabel.setText("Max Size:");
		thSize = new Text(thumnailGroup, SWT.BORDER);
		thSize.setEnabled(false);
		Label thqualityLabel = new Label(thumnailGroup, SWT.NONE);
		thqualityLabel.setText("Quality:");
		thQuality = new Combo(thumnailGroup, SWT.BORDER);
		thQuality.setItems(new String[] { "10", "20", "30", "40", "50", "60",
				"70", "80", "90" });
		
		Group outputGroup = new Group(ndsFolder, SWT.NONE);
		outputGroup.setLayout(new GridLayout(1, false));
		outputGroup.setLayoutData(new GridData(GridData.FILL, GridData.FILL,
				true, true));
		TabItem outputItem = new TabItem(ndsFolder, SWT.NONE);
		outputItem.setText("Output");
		outputItem.setControl(outputGroup);

		Label nameLabel = new Label(outputGroup, SWT.NONE);
		nameLabel.setText("Name:");
		name = new Text(outputGroup, SWT.BORDER);
		name.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));

		Label authorLabel = new Label(outputGroup, SWT.NONE);
		authorLabel.setText("Author:");
		author = new Text(outputGroup, SWT.BORDER);
		author.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));

		Label providerLabel = new Label(outputGroup, SWT.NONE);
		providerLabel.setText("Provider:");
		provider = new Text(outputGroup, SWT.BORDER);
		provider.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_CENTER, true, false));

		Label modeLabel = new Label(outputGroup, SWT.NONE);
		modeLabel.setText("Mode:");
		manga = new Button(outputGroup, SWT.CHECK);
		manga.setText("manga");
		manga.setToolTipText("right to left mode, left to right otherwise");
		
		applySettingsToUI(settings);
		return composite;
	}

}
