package org.pictods.ui;

import java.io.File;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pictods.PictodsSettings;

public class PictoDSSettingsUI extends Dialog {

	private Shell dialogShell;
	public PictodsSettings settings;
	private static final int WIDTH = 450;
	private Text input, output, unrar, explorer, pdf2jpg;

	public PictoDSSettingsUI(Shell parent) {
		super(parent);
	}
	
	public void defaultPressed() {
		applySettingsToUI(new PictodsSettings());
		applyUIToSettings();
	}
	
	protected void okPressed() {
		applyUIToSettings();
		super.okPressed();
	}
	
	protected void buttonPressed(int buttonId) {
		if (buttonId == IDialogConstants.BACK_ID) {
			defaultPressed();
		}
		else {
			super.buttonPressed(buttonId);
		}
	}

	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				true);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
		createButton(parent, IDialogConstants.BACK_ID,
				"Default", false);
	}
	
	public void applyUIToSettings() {
		File file;
		file = new File(input.getText());
		if (file.exists() && file.isDirectory())
			settings.inputPath = file.getAbsolutePath();
		file = new File(output.getText());
		if (file.exists() && file.isDirectory())
			settings.outputPath = file.getAbsolutePath();
		settings.unrarPath = unrar.getText();
		settings.explorerPath = explorer.getText();
		settings.pdf2jpgPath = pdf2jpg.getText();
	}

	public void applySettingsToUI(PictodsSettings set) {
		input.setText(set.inputPath);
		output.setText(set.outputPath);
		unrar.setText(set.unrarPath);
		explorer.setText(set.explorerPath);
		pdf2jpg.setText(set.pdf2jpgPath);
	}
	
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		dialogShell = newShell;
		dialogShell.setText("Path Settings");
		dialogShell.setImage(new Image(Display.getCurrent(),
				"../resources/pictods.ico"));
		dialogShell.setLayout(new GridLayout(1, false));
		dialogShell.setMinimumSize(WIDTH, -1);
//		Rectangle displaySize = Display.getCurrent().getBounds();
//		dialogShell.setLocation(new Point(displaySize.width / 2 - WIDTH / 2,
//				displaySize.height / 2 - HEIGHT / 2));
	}

	protected Control createDialogArea(Composite parent) {
		Composite composite = (Composite) super.createDialogArea(parent);
		((GridLayout) composite.getLayout()).numColumns = 1;
		
		Group dirpath = new Group(composite, SWT.NONE);
		dirpath.setLayout(new GridLayout(3, false));
		dirpath.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));
		dirpath.setText("Directories path");

		Label intputLabel = new Label(dirpath, SWT.NONE);
		intputLabel.setText("Input:");
		intputLabel.setToolTipText("The default directory where .cbz, and so on, are stored");
		input = new Text(dirpath, SWT.BORDER);
		input.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_END, true, false));
		Button inputButton = new Button(dirpath, SWT.PUSH);
		inputButton.setText("Browse");
		inputButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				String path = new DirectoryDialog(dialogShell, SWT.SINGLE | SWT.OPEN).open();
				if (path != null)
					input.setText(path);
			}
		});

		Label outputLabel = new Label(dirpath, SWT.NONE);
		outputLabel.setText("Output:");
		outputLabel.setToolTipText("The default directory where .nds files will be generated");
		output = new Text(dirpath, SWT.BORDER);
		output.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_END, true, false));
		Button outputButton = new Button(dirpath, SWT.PUSH);
		outputButton.setText("Browse");
		outputButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				String path = new DirectoryDialog(dialogShell, SWT.SINGLE | SWT.OPEN).open();
				if (path != null)
					output.setText(path);
			}
		});
		
		Group thirdpartiespath = new Group(composite, SWT.NONE);
		thirdpartiespath.setLayout(new GridLayout(3, false));
		thirdpartiespath.setLayoutData(new GridData(GridData.FILL, GridData.FILL, true, true));
		thirdpartiespath.setText("Third parties path");
		
		Label unrarLabel = new Label(thirdpartiespath, SWT.NONE);
		unrarLabel.setText("Unrar:");
		unrarLabel.setToolTipText("The unrar executable file (used for .rar and .cbr files)");
		unrar = new Text(thirdpartiespath, SWT.BORDER);
		unrar.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_END, true, false));
		Button unrarButton = new Button(thirdpartiespath, SWT.PUSH);
		unrarButton.setText("Browse");
		unrarButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				String path = new FileDialog(dialogShell, SWT.SINGLE | SWT.OPEN).open();
				if (path != null)
					unrar.setText(path);
			}
		});
		
		Label explorerLabel = new Label(thirdpartiespath, SWT.NONE);
		explorerLabel.setText("Explorer:");
		explorerLabel.setToolTipText("The explorer executable file (used to open the output directory in File menu)");
		explorer = new Text(thirdpartiespath, SWT.BORDER);
		explorer.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_END, true, false));
		Button explorerButton = new Button(thirdpartiespath, SWT.PUSH);
		explorerButton.setText("Browse");
		explorerButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				String path = new FileDialog(dialogShell, SWT.SINGLE | SWT.OPEN).open();
				if (path != null)
					explorer.setText(path);
			}
		});

		Label pdf2jpgLabel = new Label(thirdpartiespath, SWT.NONE);
		pdf2jpgLabel.setText("PDF to JPG:");
		pdf2jpgLabel.setToolTipText("The command line to export your pdf to jpg files");
		pdf2jpg = new Text(thirdpartiespath, SWT.BORDER);
		pdf2jpg.setLayoutData(new GridData(GridData.FILL, GridData.VERTICAL_ALIGN_END, true, false));
		Button pdf2jpgButton = new Button(thirdpartiespath, SWT.PUSH);
		pdf2jpgButton.setText("Browse");
		pdf2jpgButton.addSelectionListener(new SelectionListener() {
			public void widgetDefaultSelected(SelectionEvent arg0) {
			}
			public void widgetSelected(SelectionEvent arg0) {
				String path = new FileDialog(dialogShell, SWT.SINGLE | SWT.OPEN).open();
				if (path != null)
					pdf2jpg.setText(path);
			}
		});

		applySettingsToUI(settings);
		return composite;
	}
	
}
