/*
 * Decompiled with CFR 0.152.
 */
package org.pictods.ui;

import java.io.File;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pictods.PictodsSettings;

public class PictoDSSettingsUI
extends Dialog {
    private Shell dialogShell;
    public PictodsSettings settings;
    private static final int WIDTH = 450;
    private Text input;
    private Text output;
    private Text unrar;
    private Text explorer;
    private Text pdf2jpg;

    public PictoDSSettingsUI(Shell parent) {
        super(parent);
    }

    public void defaultPressed() {
        this.applySettingsToUI(new PictodsSettings());
        this.applyUIToSettings();
    }

    protected void okPressed() {
        this.applyUIToSettings();
        super.okPressed();
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 14) {
            this.defaultPressed();
        } else {
            super.buttonPressed(buttonId);
        }
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.createButton(parent, 1, IDialogConstants.CANCEL_LABEL, false);
        this.createButton(parent, 14, "Default", false);
    }

    public void applyUIToSettings() {
        File file = new File(this.input.getText());
        if (file.exists() && file.isDirectory()) {
            this.settings.inputPath = file.getAbsolutePath();
        }
        if ((file = new File(this.output.getText())).exists() && file.isDirectory()) {
            this.settings.outputPath = file.getAbsolutePath();
        }
        this.settings.unrarPath = this.unrar.getText();
        this.settings.explorerPath = this.explorer.getText();
        this.settings.pdf2jpgPath = this.pdf2jpg.getText();
    }

    public void applySettingsToUI(PictodsSettings set) {
        this.input.setText(set.inputPath);
        this.output.setText(set.outputPath);
        this.unrar.setText(set.unrarPath);
        this.explorer.setText(set.explorerPath);
        this.pdf2jpg.setText(set.pdf2jpgPath);
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        this.dialogShell = newShell;
        this.dialogShell.setText("Path Settings");
        this.dialogShell.setImage(new Image((Device)Display.getCurrent(), "../resources/pictods.ico"));
        this.dialogShell.setLayout((Layout)new GridLayout(1, false));
        this.dialogShell.setMinimumSize(450, -1);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 1;
        Group dirpath = new Group(composite, 0);
        dirpath.setLayout((Layout)new GridLayout(3, false));
        dirpath.setLayoutData((Object)new GridData(4, 4, true, true));
        dirpath.setText("Directories path");
        Label intputLabel = new Label((Composite)dirpath, 0);
        intputLabel.setText("Input:");
        intputLabel.setToolTipText("The default directory where .cbz, and so on, are stored");
        this.input = new Text((Composite)dirpath, 2048);
        this.input.setLayoutData((Object)new GridData(4, 8, true, false));
        Button inputButton = new Button((Composite)dirpath, 8);
        inputButton.setText("Browse");
        inputButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String path = new DirectoryDialog(PictoDSSettingsUI.this.dialogShell, 4100).open();
                if (path != null) {
                    PictoDSSettingsUI.this.input.setText(path);
                }
            }
        });
        Label outputLabel = new Label((Composite)dirpath, 0);
        outputLabel.setText("Output:");
        outputLabel.setToolTipText("The default directory where .nds files will be generated");
        this.output = new Text((Composite)dirpath, 2048);
        this.output.setLayoutData((Object)new GridData(4, 8, true, false));
        Button outputButton = new Button((Composite)dirpath, 8);
        outputButton.setText("Browse");
        outputButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String path = new DirectoryDialog(PictoDSSettingsUI.this.dialogShell, 4100).open();
                if (path != null) {
                    PictoDSSettingsUI.this.output.setText(path);
                }
            }
        });
        Group thirdpartiespath = new Group(composite, 0);
        thirdpartiespath.setLayout((Layout)new GridLayout(3, false));
        thirdpartiespath.setLayoutData((Object)new GridData(4, 4, true, true));
        thirdpartiespath.setText("Third parties path");
        Label unrarLabel = new Label((Composite)thirdpartiespath, 0);
        unrarLabel.setText("Unrar:");
        unrarLabel.setToolTipText("The unrar executable file (used for .rar and .cbr files)");
        this.unrar = new Text((Composite)thirdpartiespath, 2048);
        this.unrar.setLayoutData((Object)new GridData(4, 8, true, false));
        Button unrarButton = new Button((Composite)thirdpartiespath, 8);
        unrarButton.setText("Browse");
        unrarButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String path = new FileDialog(PictoDSSettingsUI.this.dialogShell, 4100).open();
                if (path != null) {
                    PictoDSSettingsUI.this.unrar.setText(path);
                }
            }
        });
        Label explorerLabel = new Label((Composite)thirdpartiespath, 0);
        explorerLabel.setText("Explorer:");
        explorerLabel.setToolTipText("The explorer executable file (used to open the output directory in File menu)");
        this.explorer = new Text((Composite)thirdpartiespath, 2048);
        this.explorer.setLayoutData((Object)new GridData(4, 8, true, false));
        Button explorerButton = new Button((Composite)thirdpartiespath, 8);
        explorerButton.setText("Browse");
        explorerButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String path = new FileDialog(PictoDSSettingsUI.this.dialogShell, 4100).open();
                if (path != null) {
                    PictoDSSettingsUI.this.explorer.setText(path);
                }
            }
        });
        Label pdf2jpgLabel = new Label((Composite)thirdpartiespath, 0);
        pdf2jpgLabel.setText("PDF to JPG:");
        pdf2jpgLabel.setToolTipText("The command line to export your pdf to jpg files");
        this.pdf2jpg = new Text((Composite)thirdpartiespath, 2048);
        this.pdf2jpg.setLayoutData((Object)new GridData(4, 8, true, false));
        Button pdf2jpgButton = new Button((Composite)thirdpartiespath, 8);
        pdf2jpgButton.setText("Browse");
        pdf2jpgButton.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent arg0) {
            }

            public void widgetSelected(SelectionEvent arg0) {
                String path = new FileDialog(PictoDSSettingsUI.this.dialogShell, 4100).open();
                if (path != null) {
                    PictoDSSettingsUI.this.pdf2jpg.setText(path);
                }
            }
        });
        this.applySettingsToUI(this.settings);
        return composite;
    }
}

