typedef unsigned char byte;
typedef unsigned short u16;
typedef unsigned int u32;
typedef unsigned long u64;

#define FBIN	O_RDONLY | O_BINARY

typedef struct
{
	char		identification[4];		/* should be IWAD */
	int			numlumps;
	int			infotableofs;
} wadinfo_t;

wadinfo_t wad;

typedef struct
{
	int			filepos;					/* also texture_t * for comp lumps */
	int			size;
	char		name[8];
} lumpinfo_t;

lumpinfo_t* lump;

char lmpFiles[256];

long LongSwap (long dat)
{
	unsigned    a,b,c,d;
	
	a = (dat>>24)&0xff;
	b = (dat>>16)&0xff;
	c = (dat>>8)&0xff;
	d = dat&0xff;
	return (d<<24)+(c<<16)+(b<<8)+a;
}

#define	LITTLELONG(x) LongSwap(x)