#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>

void *M_MakeAlloc(size_t size)
{
	void* buf = malloc(size);
	if(buf == NULL)
	{
		printf("MakeAlloc: Failed allocation\n");
		exit(1);
	}
	return buf;
}

void *M_Clear(void* data, size_t blocks, bool freeMe)
{
	if(blocks <= 0)
	{
		printf("M_Clear: Invaild blocksize\n");
		exit(1);
	}
	if(data == NULL)
	{
		printf("M_Clear: No memory left\n");
		exit(1);
	}
		memset(data, 0, blocks);
	if(freeMe)
		free(data);
	return data;
}
