#include <stdio.h>
#include <io.h>
#include <string.h>
#include <stdlib.h>
#include <fcntl.h>

typedef unsigned char byte;
typedef struct
{
	char		identification[4];		/* should be IWAD */
	int			numlumps;
	int			infotableofs;
} wadinfo_t;

typedef struct
{
	int			filepos;					/* also texture_t * for comp lumps */
	int			size;
	char		name[8];
} lumpinfo_t;

#define	MAXLUMPS	4096
int			numlumps;

lumpinfo_t	*lumpinfo;

void KillFileName(char *name)
{
	char *search;

	search = name+strlen(name)-1;
	while(search != name)
	{
		if(*search == 92 || *search == 47)
		{
			search++;
			*search = '\0';
			return;
		}
		search--;
	}
}

int main(int argc, char**argv)
{
	wadinfo_t wad;
	int handle;
	char* base = argv[0];
	KillFileName(base);
	
	if(!argv[1])
	{
		printf("LMPDMP.exe usage: -wad input [option]\n");
		printf("Options: -dumpgbasprites :Dumps all of the sprites in the gbadoom iwad\n");
		printf("-dumpmaplumps :Dumps all map data lumps (THINGS, LINEDEFS etc");
		return 0;
	}
	handle = open(argv[1], O_RDONLY | O_BINARY);
	lseek(handle, 0, SEEK_SET);
	read(handle, &wad, sizeof(wadinfo_t));
	if(strncmp(wad.identification, "IWAD", sizeof(wad.identification))
		&& strncmp(wad.identification, "PWAD", sizeof(wad.identification)))
	{
		printf("Invalid Iwad..\n");
		exit(1);
	}

	lseek(handle, wad.infotableofs, SEEK_SET);

	lumpinfo = (lumpinfo_t*)malloc(sizeof(lumpinfo_t)*wad.numlumps);
	read(handle, lumpinfo, sizeof(lumpinfo_t)*wad.numlumps);

	if(argv[2] && !strcmp(argv[2], "-dumpgbasprites"))
	{
		int i = 0;
		byte* buffer;
		byte* buffer2;
		char path[256];
		char name[9];
		char dataName[256];
		FILE*fp;

		while(strncmp(lumpinfo[i].name, "T_START", sizeof(lumpinfo->name)))
		{
			buffer = (byte*)malloc(lumpinfo[i].size);
			lseek(handle, lumpinfo[i].filepos, SEEK_SET);
			read(handle, buffer, lumpinfo[i].size);
			strncpy(name, lumpinfo[i].name, 8);
			name[8] = '\0';
			sprintf(path, "%s/Sprites/%s.lmp", base, name);
			fp = fopen(path, "wb");
			if(!fp)
			{
				printf("Can't open %s\n", path);
				exit(1);
			}
			fwrite(buffer, lumpinfo[i].size, 1, fp);
			fclose(fp);
			free(buffer);

			buffer2 = (byte*)malloc(lumpinfo[i+1].size);
			lseek(handle, lumpinfo[i+1].filepos, SEEK_SET);
			read(handle, buffer2, lumpinfo[i+1].size);
			sprintf(dataName, "%s_data.lmp", name);
			sprintf(path, "%s/Sprites/%s", base, dataName);
			fp = fopen(path, "wb");
			if(!fp)
			{
				printf("Can't open %s\n", path);
				exit(1);
			}
			fwrite(buffer2, lumpinfo[i+1].size, 1, fp);
			fclose(fp);
			free(buffer2);

			printf("Dumping %s\n", name);
			i+=2;
		}
	}
	else if(argv[2] && !strcmp(argv[2], "-dumpmaplumps"))
	{
		char map[8];
		char path[256];
		byte* buffer;
		char name[9];
		FILE* fp;
		int i, j;

		if(!argv[3])
		{
			printf("Specify a map number!\n");
			exit(1);
		}
		sprintf(map, "MAP%02d", atoi(argv[3]));
		map[8] = '\0';
		printf("Reading %s\n", map);
		for(i = 0; i < wad.numlumps; i++)
		{
			if(!strncmp(lumpinfo[i].name, map, 8))
				break;
		}
		for(j = i; j < i+12; j++)
		{
			if(j == (i+11) && strncmp(lumpinfo[j].name, "LEAFS", 8))
			{
				break;
			}
			strncpy(name, lumpinfo[j].name, 8);
			name[8] = '\0';
			printf("Getting %s\n", name);
			sprintf(path, "%s/Maps/%s/%s.lmp", base, map, name);
			fp = fopen(path, "wb");
			if(!fp)
			{
				printf("Can't open %s\n", path);
				exit(1);
			}
			buffer = (byte*)malloc(lumpinfo[j].size);
			lseek(handle, lumpinfo[j].filepos, SEEK_SET);
			read(handle, buffer, lumpinfo[j].size);
			fwrite(buffer, lumpinfo[j].size, 1, fp);
			free(buffer);
			fclose(fp);

		}
	}

	free(lumpinfo);
	close(handle);
	return 1;
}