// 
// import names to be used with XexTool generated idc files
// 

#include <idc.idc>


// work out which name generating function to use
// 
// args:	name of the library to get name from
//			version of the library to get name from
//			id that represents the function/data in the library
// returns:	generated name
static DoNameGen(libName, version, id)
{
	auto funcName, i;
	
	// remove the extension from the library name
	for(i=0; i<strlen(libName); i=i+1)
	{
		if( substr(libName, i, i+1) == "." )
		{
			libName = substr(libName, 0, i);
			break;
		}
	}
	
	if(		"connectx" == libName)               funcName = connectxNameGen(libName, version, id);
	else if("createprofile" == libName)          funcName = createprofileNameGen(libName, version, id);
	else if("vk" == libName)                     funcName = vkNameGen(libName, version, id);
	else if("xam" == libName)                    funcName = xamNameGen(libName, version, id);
	else if("xapi" == libName)                   funcName = xapiNameGen(libName, version, id);
	else if("xbdm" == libName)                   funcName = xbdmNameGen(libName, version, id);
	else if("xboxkrnl" == libName)               funcName = xboxkrnlNameGen(libName, version, id);
	else if("syscall" == libName)                funcName = syscallNameGen(libName, version, id);
	else                                         funcName = unknownNameGen(libName, version, id);
	
	return funcName;
}

static connectxNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "CxGetVersion";
	else if(id == 0x00000002)	funcName = "NbtNetbios";
	else if(id == 0x00000003)	funcName = "SmbCloseHandle";
	else if(id == 0x00000004)	funcName = "SmbCreateDirectoryW";
	else if(id == 0x00000005)	funcName = "SmbCreateFileW";
	else if(id == 0x00000006)	funcName = "SmbDeleteFileW";
	else if(id == 0x00000007)	funcName = "SmbFindClose";
	else if(id == 0x00000008)	funcName = "SmbFindFirstFileW";
	else if(id == 0x00000009)	funcName = "SmbFindNextFile";
	else if(id == 0x0000000A)	funcName = "SmbFlushFileBuffers";
	else if(id == 0x0000000B)	funcName = "SmbGetDiskFreeSpaceW";
	else if(id == 0x0000000C)	funcName = "SmbGetFileAttributesW";
	else if(id == 0x0000000D)	funcName = "SmbGetFileInformationByHandle";
	else if(id == 0x0000000E)	funcName = "SmbGetFileSize";
	else if(id == 0x0000000F)	funcName = "SmbGetFileTime";
	else if(id == 0x00000010)	funcName = "SmbMoveFileW";
	else if(id == 0x00000011)	funcName = "SmbReadFile";
	else if(id == 0x00000012)	funcName = "SmbRemoveDirectoryW";
	else if(id == 0x00000013)	funcName = "SmbSetEndOfFile";
	else if(id == 0x00000014)	funcName = "SmbSetFileAttributesW";
	else if(id == 0x00000015)	funcName = "SmbSetFilePointer";
	else if(id == 0x00000016)	funcName = "SmbSetFileTime";
	else if(id == 0x00000017)	funcName = "SmbStartup";
	else if(id == 0x00000018)	funcName = "SmbWriteFile";
	
	return funcName;
}


static createprofileNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "CreateProfile_Register";
	else if(id == 0x00000002)	funcName = "CreateProfile_Unregister";
	
	return funcName;
}


static vkNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "RegisterXuiClasses";
	else if(id == 0x00000002)	funcName = "VK_UnInit";
	else if(id == 0x00000003)	funcName = "VK_CreateScene";
	else if(id == 0x00000004)	funcName = "VK_GetUserCancelled";
	
	return funcName;
}


static xamNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "NetDll_WSAStartup";
	else if(id == 0x00000002)	funcName = "NetDll_WSACleanup";
	else if(id == 0x00000003)	funcName = "NetDll_socket";
	else if(id == 0x00000004)	funcName = "NetDll_closesocket";
	else if(id == 0x00000005)	funcName = "NetDll_shutdown";
	else if(id == 0x00000006)	funcName = "NetDll_ioctlsocket";
	else if(id == 0x00000007)	funcName = "NetDll_setsockopt";
	else if(id == 0x00000008)	funcName = "NetDll_getsockopt";
	else if(id == 0x00000009)	funcName = "NetDll_getsockname";
	else if(id == 0x0000000A)	funcName = "NetDll_getpeername";
	else if(id == 0x0000000B)	funcName = "NetDll_bind";
	else if(id == 0x0000000C)	funcName = "NetDll_connect";
	else if(id == 0x0000000D)	funcName = "NetDll_listen";
	else if(id == 0x0000000E)	funcName = "NetDll_accept";
	else if(id == 0x0000000F)	funcName = "NetDll_select";
	else if(id == 0x00000010)	funcName = "NetDll_WSAGetOverlappedResult";
	else if(id == 0x00000011)	funcName = "NetDll_WSACancelOverlappedIO";
	else if(id == 0x00000012)	funcName = "NetDll_recv";
	else if(id == 0x00000013)	funcName = "NetDll_WSARecv";
	else if(id == 0x00000014)	funcName = "NetDll_recvfrom";
	else if(id == 0x00000015)	funcName = "NetDll_WSARecvFrom";
	else if(id == 0x00000016)	funcName = "NetDll_send";
	else if(id == 0x00000017)	funcName = "NetDll_WSASend";
	else if(id == 0x00000018)	funcName = "NetDll_sendto";
	else if(id == 0x00000019)	funcName = "NetDll_WSASendTo";
	else if(id == 0x0000001A)	funcName = "NetDll_inet_addr";
	else if(id == 0x0000001B)	funcName = "NetDll_WSAGetLastError";
	else if(id == 0x0000001C)	funcName = "NetDll_WSASetLastError";
	else if(id == 0x0000001D)	funcName = "NetDll_WSACreateEvent";
	else if(id == 0x0000001E)	funcName = "NetDll_WSACloseEvent";
	else if(id == 0x0000001F)	funcName = "NetDll_WSASetEvent";
	else if(id == 0x00000020)	funcName = "NetDll_WSAResetEvent";
	else if(id == 0x00000021)	funcName = "NetDll_WSAWaitForMultipleEvents";
	else if(id == 0x00000022)	funcName = "NetDll___WSAFDIsSet";
	else if(id == 0x00000023)	funcName = "NetDll_WSAEventSelect";
	else if(id == 0x00000024)	funcName = "NetDll_WSAStartupEx";
	else if(id == 0x00000033)	funcName = "NetDll_XNetStartup";
	else if(id == 0x00000034)	funcName = "NetDll_XNetCleanup";
	else if(id == 0x00000035)	funcName = "NetDll_XNetRandom";
	else if(id == 0x00000036)	funcName = "NetDll_XNetCreateKey";
	else if(id == 0x00000037)	funcName = "NetDll_XNetRegisterKey";
	else if(id == 0x00000038)	funcName = "NetDll_XNetUnregisterKey";
	else if(id == 0x00000039)	funcName = "NetDll_XNetXnAddrToInAddr";
	else if(id == 0x0000003A)	funcName = "NetDll_XNetServerToInAddr";
	else if(id == 0x0000003B)	funcName = "NetDll_XNetTsAddrToInAddr";
	else if(id == 0x0000003C)	funcName = "NetDll_XNetInAddrToXnAddr";
	else if(id == 0x0000003D)	funcName = "NetDll_XNetInAddrToServer";
	else if(id == 0x0000003E)	funcName = "NetDll_XNetInAddrToString";
	else if(id == 0x0000003F)	funcName = "NetDll_XNetUnregisterInAddr";
	else if(id == 0x00000040)	funcName = "NetDll_XNetXnAddrToMachineId";
	else if(id == 0x00000041)	funcName = "NetDll_XNetConnect";
	else if(id == 0x00000042)	funcName = "NetDll_XNetGetConnectStatus";
	else if(id == 0x00000043)	funcName = "NetDll_XNetDnsLookup";
	else if(id == 0x00000044)	funcName = "NetDll_XNetDnsRelease";
	else if(id == 0x00000045)	funcName = "NetDll_XNetQosListen";
	else if(id == 0x00000046)	funcName = "NetDll_XNetQosLookup";
	else if(id == 0x00000047)	funcName = "NetDll_XNetQosServiceLookup";
	else if(id == 0x00000048)	funcName = "NetDll_XNetQosRelease";
	else if(id == 0x00000049)	funcName = "NetDll_XNetGetTitleXnAddr";
	else if(id == 0x0000004A)	funcName = "NetDll_XNetGetDebugXnAddr";
	else if(id == 0x0000004B)	funcName = "NetDll_XNetGetEthernetLinkStatus";
	else if(id == 0x0000004C)	funcName = "NetDll_XNetGetBroadcastVersionStatus";
	else if(id == 0x0000004D)	funcName = "NetDll_XNetQosGetListenStats";
	else if(id == 0x0000004E)	funcName = "NetDll_XNetGetOpt";
	else if(id == 0x0000004F)	funcName = "NetDll_XNetSetOpt";
	else if(id == 0x00000050)	funcName = "NetDll_XNetStartupEx";
	else if(id == 0x00000051)	funcName = "NetDll_XNetReplaceKey";
	else if(id == 0x00000052)	funcName = "NetDll_XNetGetXnAddrPlatform";
	else if(id == 0x00000053)	funcName = "NetDll_XNetGetSystemLinkPort";
	else if(id == 0x00000054)	funcName = "NetDll_XNetSetSystemLinkPort";
	else if(id == 0x00000065)	funcName = "NetDll_XnpLoadConfigParams";
	else if(id == 0x00000066)	funcName = "NetDll_XnpSaveConfigParams";
	else if(id == 0x00000067)	funcName = "NetDll_XnpConfigUPnP";
	else if(id == 0x00000068)	funcName = "NetDll_XnpConfig";
	else if(id == 0x00000069)	funcName = "NetDll_XnpGetConfigStatus";
	else if(id == 0x0000006A)	funcName = "NetDll_XnpLoadMachineAccount";
	else if(id == 0x0000006B)	funcName = "NetDll_XnpSaveMachineAccount";
	else if(id == 0x0000006C)	funcName = "NetDll_XnpCapture";
	else if(id == 0x0000006D)	funcName = "NetDll_XnpEthernetInterceptSetCallbacks";
	else if(id == 0x0000006E)	funcName = "NetDll_XnpEthernetInterceptXmit";
	else if(id == 0x0000006F)	funcName = "NetDll_XnpEthernetInterceptRecv";
	else if(id == 0x00000070)	funcName = "NetDll_XnpLogonGetStatus";
	else if(id == 0x00000071)	funcName = "NetDll_XnpLogonGetQFlags";
	else if(id == 0x00000072)	funcName = "NetDll_XnpLogonSetQFlags";
	else if(id == 0x00000073)	funcName = "NetDll_XnpLogonSetQEvent";
	else if(id == 0x00000074)	funcName = "NetDll_XnpLogonClearQEvent";
	else if(id == 0x00000075)	funcName = "NetDll_XnpLogonGetQVals";
	else if(id == 0x00000076)	funcName = "NetDll_XnpLogonSetQVals";
	else if(id == 0x00000077)	funcName = "NetDll_XnpLogonSetPState";
	else if(id == 0x00000078)	funcName = "NetDll_XnpGetVlanXboxName";
	else if(id == 0x00000079)	funcName = "NetDll_XnpSetVlanXboxName";
	else if(id == 0x0000007A)	funcName = "NetDll_XnpGetActiveSocketList";
	else if(id == 0x0000007B)	funcName = "NetDll_XnpNoteSystemTime";
	else if(id == 0x0000007C)	funcName = "NetDll_XnpRegisterKeyForCallerType";
	else if(id == 0x0000007D)	funcName = "NetDll_XnpUnregisterKeyForCallerType";
	else if(id == 0x0000007E)	funcName = "NetDll_XnpLogonGetChallenge";
	else if(id == 0x0000007F)	funcName = "NetDll_XnpLogonClearChallenge";
	else if(id == 0x00000080)	funcName = "NetDll_XnpLogonSetChallengeResponse";
	else if(id == 0x00000081)	funcName = "NetDll_XnpGetSecAssocList";
	else if(id == 0x00000082)	funcName = "NetDll_XnpGetKeyList";
	else if(id == 0x00000083)	funcName = "NetDll_XnpGetQosLookupList";
	else if(id == 0x00000084)	funcName = "NetDll_XnpPersistTitleState";
	else if(id == 0x00000085)	funcName = "NetDll_XnpReplaceKeyForCallerType";
	else if(id == 0x00000086)	funcName = "NetDll_XnpEthernetInterceptSetExtendedReceiveCallback";
	else if(id == 0x00000087)	funcName = "NetDll_XnpQosHistoryLoad";
	else if(id == 0x00000088)	funcName = "NetDll_XnpQosHistorySaveMeasurements";
	else if(id == 0x00000089)	funcName = "NetDll_XnpQosHistoryGetEntries";
	else if(id == 0x0000008A)	funcName = "NetDll_XnpQosHistoryGetAggregateMeasurement";
	else if(id == 0x0000008B)	funcName = "NetDll_XnpToolSetCallbacks";
	else if(id == 0x0000008C)	funcName = "NetDll_XnpToolIpProxyInject";
	else if(id == 0x0000008D)	funcName = "NetDll_XnpUpdateConfigParams";
	else if(id == 0x0000008E)	funcName = "NetDll_XnpEthernetInterceptXmitAsIp";
	else if(id == 0x00000097)	funcName = "NetDll_XmlDownloadStart";
	else if(id == 0x00000098)	funcName = "NetDll_XmlDownloadContinue";
	else if(id == 0x00000099)	funcName = "NetDll_XmlDownloadStop";
	else if(id == 0x0000009A)	funcName = "NetDll_XmlDownloadGetParseTime";
	else if(id == 0x0000009B)	funcName = "NetDll_XmlDownloadGetReceivedDataSize";
	else if(id == 0x000000C6)	funcName = "XnpGetXwppMemoryLogSnapshot";
	else if(id == 0x000000C7)	funcName = "XnpGetXwppRuntimeFilter";
	else if(id == 0x000000C9)	funcName = "NetDll_XHttpStartup";
	else if(id == 0x000000CA)	funcName = "NetDll_XHttpShutdown";
	else if(id == 0x000000CB)	funcName = "NetDll_XHttpOpen";
	else if(id == 0x000000CC)	funcName = "NetDll_XHttpCloseHandle";
	else if(id == 0x000000CD)	funcName = "NetDll_XHttpConnect";
	else if(id == 0x000000CE)	funcName = "NetDll_XHttpSetStatusCallback";
	else if(id == 0x000000CF)	funcName = "NetDll_XHttpOpenRequest";
	else if(id == 0x000000D0)	funcName = "NetDll_XHttpOpenRequestUsingMemory";
	else if(id == 0x000000D1)	funcName = "NetDll_XHttpSendRequest";
	else if(id == 0x000000D2)	funcName = "NetDll_XHttpReceiveResponse";
	else if(id == 0x000000D3)	funcName = "NetDll_XHttpQueryHeaders";
	else if(id == 0x000000D4)	funcName = "NetDll_XHttpReadData";
	else if(id == 0x000000D5)	funcName = "NetDll_XHttpWriteData";
	else if(id == 0x000000D6)	funcName = "NetDll_XHttpQueryOption";
	else if(id == 0x000000D7)	funcName = "NetDll_XHttpSetOption";
	else if(id == 0x000000D8)	funcName = "NetDll_XHttpDoWork";
	else if(id == 0x000000D9)	funcName = "NetDll_XHttpSetCredentials";
	else if(id == 0x000000DA)	funcName = "NetDll_XHttpQueryAuthSchemes";
	else if(id == 0x000000DB)	funcName = "NetDll_XHttpCrackUrl";
	else if(id == 0x000000FB)	funcName = "NetDll_UpnpStartup";
	else if(id == 0x000000FC)	funcName = "NetDll_UpnpCleanup";
	else if(id == 0x000000FD)	funcName = "NetDll_UpnpSearchCreate";
	else if(id == 0x000000FE)	funcName = "NetDll_UpnpSearchGetDevices";
	else if(id == 0x000000FF)	funcName = "NetDll_UpnpDescribeCreate";
	else if(id == 0x00000100)	funcName = "NetDll_UpnpDescribeGetResults";
	else if(id == 0x00000101)	funcName = "NetDll_UpnpActionCalculateWorkBufferSize";
	else if(id == 0x00000102)	funcName = "NetDll_UpnpActionCreate";
	else if(id == 0x00000103)	funcName = "NetDll_UpnpActionGetResults";
	else if(id == 0x00000104)	funcName = "NetDll_UpnpEventCreate";
	else if(id == 0x00000105)	funcName = "NetDll_UpnpEventGetCurrentState";
	else if(id == 0x00000106)	funcName = "NetDll_UpnpEventUnsubscribe";
	else if(id == 0x00000107)	funcName = "NetDll_UpnpDoWork";
	else if(id == 0x00000108)	funcName = "NetDll_UpnpCloseHandle";
	else if(id == 0x0000012D)	funcName = "XNetLogonGetLoggedOnUsers";
	else if(id == 0x0000012E)	funcName = "XNetLogonGetNatType";
	else if(id == 0x0000012F)	funcName = "XNetLogonTaskStart";
	else if(id == 0x00000130)	funcName = "XNetLogonTaskClose";
	else if(id == 0x00000131)	funcName = "XNetLogonTaskContinue";
	else if(id == 0x00000132)	funcName = "XNetLogonGetServiceInfo";
	else if(id == 0x00000133)	funcName = "XNetLogonGetUserPrivileges";
	else if(id == 0x00000134)	funcName = "XNetLogonSetConsoleCertificate";
	else if(id == 0x00000135)	funcName = "XNetLogonGetMachineID";
	else if(id == 0x00000136)	funcName = "XNetLogonGetTitleID";
	else if(id == 0x00000137)	funcName = "XNetLogonGetTitleVersion";
	else if(id == 0x00000138)	funcName = "XNetLogonGetServiceNetworkID";
	else if(id == 0x00000139)	funcName = "XNetLogonGetDnsString";
	else if(id == 0x0000013A)	funcName = "XNetLogonSetTitleID";
	else if(id == 0x0000013B)	funcName = "XNetLogonGetExtendedStatus";
	else if(id == 0x0000013C)	funcName = "XNetLogonClearTicketCaches";
	else if(id == 0x0000013D)	funcName = "XNetLogonInitOverrideInfo";
	else if(id == 0x0000013E)	funcName = "XNetLogonGetLastUPnPStatus";
	else if(id == 0x0000013F)	funcName = "XNetLogonGetFlowToken";
	else if(id == 0x00000140)	funcName = "XNetLogonGetTicketOpt";
	else if(id == 0x00000141)	funcName = "XNetLogonSetTicketOpt";
	else if(id == 0x00000190)	funcName = "XamInputGetCapabilities";
	else if(id == 0x00000191)	funcName = "XamInputGetState";
	else if(id == 0x00000192)	funcName = "XamInputSetState";
	else if(id == 0x00000193)	funcName = "XamInputGetKeystroke";
	else if(id == 0x00000194)	funcName = "XamInputEnableAutobind";
	else if(id == 0x00000195)	funcName = "XamInputRawState";
	else if(id == 0x00000196)	funcName = "XamEnableSystemAppInput";
	else if(id == 0x00000197)	funcName = "XamInputGetDeviceStats";
	else if(id == 0x00000198)	funcName = "XamInputGetKeystrokeEx";
	else if(id == 0x00000199)	funcName = "XamInputGetKeystrokeHud";
	else if(id == 0x0000019A)	funcName = "XamInputSetLayoutKeyboard";
	else if(id == 0x0000019B)	funcName = "XamInputToggleKeyLocks";
	else if(id == 0x0000019C)	funcName = "XamInputResetLayoutKeyboard";
	else if(id == 0x0000019D)	funcName = "XamInputGetKeystrokeHudEx";
	else if(id == 0x0000019E)	funcName = "XamInputSetKeyboardTranslationHud";
	else if(id == 0x0000019F)	funcName = "XamSetInactivityTime";
	else if(id == 0x000001A0)	funcName = "XamEnableInactivityProcessing";
	else if(id == 0x000001A1)	funcName = "XamResetInactivity";
	else if(id == 0x000001A2)	funcName = "XamSetInactivityTimeFromConfig";
	else if(id == 0x000001A3)	funcName = "XamLoaderGetMediaInfo";
	else if(id == 0x000001A4)	funcName = "XamLoaderLaunchTitle";
	else if(id == 0x000001A5)	funcName = "XamLoaderLaunchTitleEx";
	else if(id == 0x000001A6)	funcName = "XamLoaderSetLaunchData";
	else if(id == 0x000001A7)	funcName = "XamLoaderGetLaunchDataSize";
	else if(id == 0x000001A8)	funcName = "XamLoaderGetLaunchData";
	else if(id == 0x000001A9)	funcName = "XamLoaderTerminateTitle";
	else if(id == 0x000001AA)	funcName = "XamLoaderGetDvdTrayState";
	else if(id == 0x000001AB)	funcName = "XamLoaderGetGameInfo";
	else if(id == 0x000001AC)	funcName = "XamLoaderLaunchTitleOnDvd";
	else if(id == 0x000001AD)	funcName = "XamLoaderSetSpindleSpeed";
	else if(id == 0x000001AE)	funcName = "XamTaskCreateQueue";
	else if(id == 0x000001AF)	funcName = "XamTaskSchedule";
	else if(id == 0x000001B0)	funcName = "XamTaskReschedule";
	else if(id == 0x000001B1)	funcName = "XamTaskCloseHandle";
	else if(id == 0x000001B2)	funcName = "XamTaskCancel";
	else if(id == 0x000001B3)	funcName = "XamTaskShouldExit";
	else if(id == 0x000001B4)	funcName = "XamTaskWaitOnCompletion";
	else if(id == 0x000001B5)	funcName = "XamTaskModify";
	else if(id == 0x000001B6)	funcName = "XamTaskGetCurrentTask";
	else if(id == 0x000001B7)	funcName = "XamTaskGetAttributes";
	else if(id == 0x000001B8)	funcName = "XamExecutingOnBehalfOfTitle";
	else if(id == 0x000001B9)	funcName = "XamInputSendStayAliveRequest";
	else if(id == 0x000001BA)	funcName = "XamInputGetUserVibrationLevel";
	else if(id == 0x000001BB)	funcName = "XamIsSystemTitleId";
	else if(id == 0x000001BC)	funcName = "XamLoaderIsTitleTerminatePending";
	else if(id == 0x000001BD)	funcName = "XamInputSetTextMessengerIndicator";
	else if(id == 0x000001BE)	funcName = "XamLoaderGetPriorTitleId";
	else if(id == 0x000001BF)	funcName = "XamIsXbox1TitleId";
	else if(id == 0x000001C0)	funcName = "XamInputSetKeyLocks";
	else if(id == 0x000001C1)	funcName = "XamInputGetKeyLocks";
	else if(id == 0x000001C2)	funcName = "XamTaskGetStatus";
	else if(id == 0x000001C3)	funcName = "XamGetRootObj";
	else if(id == 0x000001C4)	funcName = "XamDevAuthSetFault";
	else if(id == 0x000001C5)	funcName = "XamGetDefaultSystemImage";
	else if(id == 0x000001C6)	funcName = "XamGetWCNConfigFile";
	else if(id == 0x000001C7)	funcName = "XamSetPowerMode";
	else if(id == 0x000001C8)	funcName = "XamExecuteChallenge";
	else if(id == 0x000001C9)	funcName = "XamGetDefaultImage";
	else if(id == 0x000001CA)	funcName = "XamMuteSound";
	else if(id == 0x000001CB)	funcName = "XamGetOnlineSchema";
	else if(id == 0x000001CC)	funcName = "XamSetDashContext";
	else if(id == 0x000001CD)	funcName = "XamGetDashContext";
	else if(id == 0x000001CE)	funcName = "XamIsCurrentTitleDash";
	else if(id == 0x000001CF)	funcName = "XamGetCurrentTitleId";
	else if(id == 0x000001D0)	funcName = "XamSetCurrentTitleDash";
	else if(id == 0x000001D1)	funcName = "XamAllocHeapFreeSpace";
	else if(id == 0x000001D2)	funcName = "XamSetDashContextEx";
	else if(id == 0x000001D3)	funcName = "XamGetDashContextEx";
	else if(id == 0x000001D4)	funcName = "XamSetHudContext";
	else if(id == 0x000001D5)	funcName = "XamGetHudContext";
	else if(id == 0x000001D6)	funcName = "XCustomGetBannerImage";
	else if(id == 0x000001D7)	funcName = "Refresh";
	else if(id == 0x000001D8)	funcName = "XCustomSetAction";
	else if(id == 0x000001D9)	funcName = "XCustomGetLastActionPress";
	else if(id == 0x000001DA)	funcName = "XCustomSetDynamicActions";
	else if(id == 0x000001DB)	funcName = "XCustomBroadcastActionEvent";
	else if(id == 0x000001DC)	funcName = "XCustomGetLastActionPressEx";
	else if(id == 0x000001DD)	funcName = "XCustomRegisterDynamicActions";
	else if(id == 0x000001DE)	funcName = "XCustomUnregisterDynamicActions";
	else if(id == 0x000001DF)	funcName = "XCustomGetCurrentGamercard";
	else if(id == 0x000001E0)	funcName = "XamDbgPrint";
	else if(id == 0x000001E1)	funcName = "XamDbgSetOutputLevel";
	else if(id == 0x000001E2)	funcName = "XamDbgSetBreakLevel";
	else if(id == 0x000001E3)	funcName = "XamLoaderGetMediaInfoEx";
	else if(id == 0x000001E4)	funcName = "XamLoaderSetGameInfo";
	else if(id == 0x000001E5)	funcName = "XamFormatMessage";
	else if(id == 0x000001E6)	funcName = "XamUniSortCmpString";
	else if(id == 0x000001E7)	funcName = "XamFormatTimeString";
	else if(id == 0x000001E8)	funcName = "XamFormatDateString";
	else if(id == 0x000001E9)	funcName = "XamGetLocaleDateFormat";
	else if(id == 0x000001EA)	funcName = "XamAlloc";
	else if(id == 0x000001EB)	funcName = "XamAllocEx";
	else if(id == 0x000001EC)	funcName = "XamFree";
	else if(id == 0x000001ED)	funcName = "XamAllocSize";
	else if(id == 0x000001EE)	funcName = "XamAllocMountIPTVHeap";
	else if(id == 0x000001EF)	funcName = "XamAllocUnmountIPTVHeap";
	else if(id == 0x000001F0)	funcName = "XamAllocFreeIPTVHeap";
	else if(id == 0x000001F1)	funcName = "XamDeviceRemap";
	else if(id == 0x000001F2)	funcName = "XamLoaderGetClearCache";
	else if(id == 0x000001F3)	funcName = "XamLoaderSetClearCache";
	else if(id == 0x000001F4)	funcName = "XMsgInProcessCall";
	else if(id == 0x000001F5)	funcName = "XMsgCompleteIORequest";
	else if(id == 0x000001F6)	funcName = "XMsgSystemProcessCall";
	else if(id == 0x000001F7)	funcName = "XMsgStartIORequest";
	else if(id == 0x000001F8)	funcName = "XMsgCancelIORequest";
	else if(id == 0x000001F9)	funcName = "XMsgAcquireAsyncMessageFromOverlapped";
	else if(id == 0x000001FA)	funcName = "XMsgReleaseAsyncMessageToOverlapped";
	else if(id == 0x000001FB)	funcName = "XamGetOverlappedResult";
	else if(id == 0x000001FC)	funcName = "XMsgStartIORequestEx";
	else if(id == 0x000001FD)	funcName = "XamAppAllocateInterappWorkspace";
	else if(id == 0x000001FE)	funcName = "XamAppGetInterappWorkspace";
	else if(id == 0x000001FF)	funcName = "XamAppFreeInterappWorkspace";
	else if(id == 0x00000200)	funcName = "XamFeatureEnabled";
	else if(id == 0x00000201)	funcName = "XamFeatureEnforceImageBudget";
	else if(id == 0x00000202)	funcName = "XamFeatureSetMask";
	else if(id == 0x00000203)	funcName = "XamFeatureEnableDisable";
	else if(id == 0x00000204)	funcName = "XuiControlSetItemAssociation";
	else if(id == 0x00000205)	funcName = "XamGetTitleGlobalStorageValue";
	else if(id == 0x00000206)	funcName = "XamSetTitleGlobalStorageValue";
	else if(id == 0x00000207)	funcName = "XamUserValidateAvatarManifest";
	else if(id == 0x00000208)	funcName = "XamUserGetDeviceContext";
	else if(id == 0x00000209)	funcName = "XamUserLookupDevice";
	else if(id == 0x0000020A)	funcName = "XamUserGetXUID";
	else if(id == 0x0000020B)	funcName = "XamUserLogon";
	else if(id == 0x0000020C)	funcName = "XamUserGetGamerTag";
	else if(id == 0x0000020D)	funcName = "XamUserGetUserIndexMask";
	else if(id == 0x0000020E)	funcName = "XamUserGetName";
	else if(id == 0x0000020F)	funcName = "XamLookupCommonStringByIndex";
	else if(id == 0x00000210)	funcName = "XamUserGetSigninState";
	else if(id == 0x00000211)	funcName = "XamUserGetIndexFromXUID";
	else if(id == 0x00000212)	funcName = "XamUserCheckPrivilege";
	else if(id == 0x00000213)	funcName = "XamUserAreUsersFriends";
	else if(id == 0x00000214)	funcName = "XamSetUserPresetPresenceState";
	else if(id == 0x00000215)	funcName = "XamGetUserPresetPresenceState";
	else if(id == 0x00000216)	funcName = "XamUserGetUserFlagsFromXUID";
	else if(id == 0x00000217)	funcName = "XamUserGetMembershipTierFromXUID";
	else if(id == 0x00000218)	funcName = "XamUserGetOnlineCountryFromXUID";
	else if(id == 0x00000219)	funcName = "XamUserReadProfileSettings";
	else if(id == 0x0000021A)	funcName = "XamUserWriteProfileSettings";
	else if(id == 0x0000021B)	funcName = "XamUserGetMembershipTier";
	else if(id == 0x0000021C)	funcName = "XamUserGetUserFlags";
	else if(id == 0x0000021D)	funcName = "XamUserGetRequestedUserIndexMask";
	else if(id == 0x0000021E)	funcName = "XamUserIsGuest";
	else if(id == 0x0000021F)	funcName = "XamUserProfileSync";
	else if(id == 0x00000220)	funcName = "XamUserFlushLogonQueue";
	else if(id == 0x00000221)	funcName = "XamUserIsOnlineEnabled";
	else if(id == 0x00000222)	funcName = "XamUserGetCachedUserFlags";
	else if(id == 0x00000223)	funcName = "XamAreMixedAccountsSignedIn";
	else if(id == 0x00000224)	funcName = "XamUserLogonEx";
	else if(id == 0x00000225)	funcName = "XamSetUserShowMessengerFriends";
	else if(id == 0x00000226)	funcName = "XamGetUserShowMessengerFriends";
	else if(id == 0x00000227)	funcName = "XamUserGetSigninInfo";
	else if(id == 0x00000228)	funcName = "XamUserIsPartial";
	else if(id == 0x00000229)	funcName = "XamUserGetOnlineLanguageFromXUID";
	else if(id == 0x0000022A)	funcName = "XamUserReadProfileSettingsEx";
	else if(id == 0x0000022B)	funcName = "XamSystemUpdaterLogon";
	else if(id == 0x0000022C)	funcName = "XamUserGetUsersMissingAvatars";
	else if(id == 0x0000022D)	funcName = "XamIsChildAccountSignedIn";
	else if(id == 0x0000022E)	funcName = "XamUserPrefetchProfileSettings";
	else if(id == 0x0000022F)	funcName = "XamUserInvalidateProfileSetting";
	else if(id == 0x00000230)	funcName = "XamProfileCreate";
	else if(id == 0x00000231)	funcName = "XamProfileCreateEnumerator";
	else if(id == 0x00000232)	funcName = "XamProfileEnumerate";
	else if(id == 0x00000233)	funcName = "XamProfileDelete";
	else if(id == 0x00000234)	funcName = "XamProfileGetCreationStatus";
	else if(id == 0x00000235)	funcName = "XamProfileFindAccount";
	else if(id == 0x00000236)	funcName = "XamProfileRenameAccount";
	else if(id == 0x00000237)	funcName = "XamProfileOpen";
	else if(id == 0x00000238)	funcName = "XamProfileClose";
	else if(id == 0x00000239)	funcName = "XamProfileSaveAccountInfo";
	else if(id == 0x0000023A)	funcName = "XamProfileLoadAccountInfo";
	else if(id == 0x0000023B)	funcName = "XamProfileRecoverTitle";
	else if(id == 0x0000023C)	funcName = "XamProfileSaveWindowsLiveCredentials";
	else if(id == 0x0000023D)	funcName = "XamProfileLoadWindowsLiveCredentials";
	else if(id == 0x0000023E)	funcName = "XamProfileIsSaveWindowsLiveCredsEnabled";
	else if(id == 0x0000023F)	funcName = "XamProfileSetSaveWindowsLiveCredsEnabled";
	else if(id == 0x00000240)	funcName = "XamSetProfileReadTestHook";
	else if(id == 0x00000241)	funcName = "XamProfileGetLastSync";
	else if(id == 0x00000242)	funcName = "XamAccountRecoveryRecoverTitle";
	else if(id == 0x00000243)	funcName = "XamProfileControlPec";
	else if(id == 0x00000244)	funcName = "XamAppLoad";
	else if(id == 0x00000245)	funcName = "XamAppUnloadSelf";
	else if(id == 0x00000246)	funcName = "XamAppUnloadStack";
	else if(id == 0x00000247)	funcName = "XamSendMessageToLoadedApps";
	else if(id == 0x00000248)	funcName = "XamAppRequestLoad";
	else if(id == 0x00000249)	funcName = "XamAppUnrequestLoad";
	else if(id == 0x0000024A)	funcName = "XamNavigate";
	else if(id == 0x0000024B)	funcName = "XamRegisterSysApp";
	else if(id == 0x0000024C)	funcName = "XamUnregisterSysApp";
	else if(id == 0x0000024D)	funcName = "XamAppReinitialize";
	else if(id == 0x0000024E)	funcName = "XamCreateEnumeratorHandle";
	else if(id == 0x0000024F)	funcName = "XamGetPrivateEnumStructureFromHandle";
	else if(id == 0x00000250)	funcName = "XamEnumerate";
	else if(id == 0x00000251)	funcName = "XamLoadSysApp";
	else if(id == 0x00000252)	funcName = "XamUnloadSysApp";
	else if(id == 0x00000253)	funcName = "XamReloadSysApp";
	else if(id == 0x00000254)	funcName = "XamAppLoadPass2SysApps";
	else if(id == 0x00000255)	funcName = "XamProfileGetLiveLegalLocale";
	else if(id == 0x00000256)	funcName = "XamUserIsParentalControlled";
	else if(id == 0x00000257)	funcName = "XamContentLaunchImageFromFileInternal";
	else if(id == 0x00000258)	funcName = "XamContentCreate";
	else if(id == 0x00000259)	funcName = "XamContentCreateEx";
	else if(id == 0x0000025A)	funcName = "XamContentClose";
	else if(id == 0x0000025B)	funcName = "XamContentDelete";
	else if(id == 0x0000025C)	funcName = "XamContentCreateEnumerator";
	else if(id == 0x0000025D)	funcName = "XamContentCreateDeviceEnumerator";
	else if(id == 0x0000025E)	funcName = "XamContentGetDeviceData";
	else if(id == 0x0000025F)	funcName = "XamContentGetDeviceName";
	else if(id == 0x00000260)	funcName = "XamContentSetThumbnail";
	else if(id == 0x00000261)	funcName = "XamContentGetThumbnail";
	else if(id == 0x00000262)	funcName = "XamContentGetCreator";
	else if(id == 0x00000263)	funcName = "XamContentLaunchImage";
	else if(id == 0x00000264)	funcName = "XamContentGetAttributes";
	else if(id == 0x00000265)	funcName = "XamContentGetDeviceState";
	else if(id == 0x00000266)	funcName = "XamContentGetLicenseMask";
	else if(id == 0x00000267)	funcName = "XamContentFlush";
	else if(id == 0x00000268)	funcName = "XamContentResolve";
	else if(id == 0x00000269)	funcName = "XamContentOpenFile";
	else if(id == 0x0000026A)	funcName = "XamContentInstall";
	else if(id == 0x0000026B)	funcName = "XamContentLockUnlockPackageHeaders";
	else if(id == 0x0000026C)	funcName = "XamContentCopyInternal";
	else if(id == 0x0000026D)	funcName = "XamContentMoveInternal";
	else if(id == 0x0000026E)	funcName = "XamContentGetMetaDataInternal";
	else if(id == 0x0000026F)	funcName = "XamContentCreateEnumeratorInternal";
	else if(id == 0x00000270)	funcName = "XamContentDeleteInternal";
	else if(id == 0x00000271)	funcName = "XamContentCreateInternal";
	else if(id == 0x00000272)	funcName = "XamContentSetThumbnailInternal";
	else if(id == 0x00000273)	funcName = "XamContentLaunchImageInternal";
	else if(id == 0x00000274)	funcName = "XamContentWritePackageHeader";
	else if(id == 0x00000275)	funcName = "XamContentDismountAndClosePackage";
	else if(id == 0x00000276)	funcName = "XamContentResolveInternal";
	else if(id == 0x00000277)	funcName = "XamContentGetAttributesInternal";
	else if(id == 0x00000278)	funcName = "XamContentOpenFileInternal";
	else if(id == 0x00000279)	funcName = "XamContentAggregateCreateEnumerator";
	else if(id == 0x0000027A)	funcName = "XamContentCreateAndMountPackage";
	else if(id == 0x0000027B)	funcName = "XamContentOpenPackageFile";
	else if(id == 0x0000027C)	funcName = "XamContentMountPackage";
	else if(id == 0x0000027D)	funcName = "XamContentFlushPackage";
	else if(id == 0x0000027E)	funcName = "XamContentClosePackageFile";
	else if(id == 0x0000027F)	funcName = "XamContentDuplicateFileHandle";
	else if(id == 0x00000280)	funcName = "XamGetExecutionId";
	else if(id == 0x00000281)	funcName = "XamGetGameRatings";
	else if(id == 0x00000282)	funcName = "XamGetSystemVersion";
	else if(id == 0x00000283)	funcName = "XamContentGetLocalizedString";
	else if(id == 0x00000284)	funcName = "XamContentGetDefaultDevice";
	else if(id == 0x00000285)	funcName = "XamContentInstallInternal";
	else if(id == 0x00000286)	funcName = "XamContentSetMediaMetaDataInternal";
	else if(id == 0x00000287)	funcName = "XamContentGetDeviceSerialNumber";
	else if(id == 0x00000288)	funcName = "XamContentGetMountedPackageByRootName";
	else if(id == 0x00000289)	funcName = "XamContentRegisterChangeCallback";
	else if(id == 0x0000028A)	funcName = "XamNotifyCreateListener";
	else if(id == 0x0000028B)	funcName = "XNotifyGetNext";
	else if(id == 0x0000028C)	funcName = "XNotifyPositionUI";
	else if(id == 0x0000028D)	funcName = "XNotifyDelayUI";
	else if(id == 0x0000028E)	funcName = "XNotifyBroadcast";
	else if(id == 0x0000028F)	funcName = "XNotifyRegisterArea";
	else if(id == 0x00000290)	funcName = "XNotifyQueueUI";
	else if(id == 0x00000291)	funcName = "XamNotifyCreateListenerInternal";
	else if(id == 0x00000292)	funcName = "XNotifyUISetOptions";
	else if(id == 0x00000293)	funcName = "XNotifyUIGetOptions";
	else if(id == 0x00000294)	funcName = "XamContentLaunchImageInternalEx";
	else if(id == 0x00000295)	funcName = "XamShutdown";
	else if(id == 0x00000296)	funcName = "XamAllocDevkitHeapAvailable";
	else if(id == 0x00000297)	funcName = "XamNotifyCreateListenerRangeInternal";
	else if(id == 0x00000298)	funcName = "XNotifyQueueUIEx";
	else if(id == 0x00000299)	funcName = "XamAppRequestLoadEx";
	else if(id == 0x0000029A)	funcName = "XuiPNGTextureLoader";
	else if(id == 0x0000029B)	funcName = "XuiRenderGetXuiDevice";
	else if(id == 0x0000029C)	funcName = "XuiDefault_False";
	else if(id == 0x0000029D)	funcName = "XamUserGetReportingInfo";
	else if(id == 0x0000029E)	funcName = "XamUpdateStart";
	else if(id == 0x0000029F)	funcName = "XamUpdateGetProgress";
	else if(id == 0x000002A0)	funcName = "XamUpdateGetExtenderInstance";
	else if(id == 0x000002A1)	funcName = "XamUpdateFinish";
	else if(id == 0x000002A2)	funcName = "XamUpdateAttachExtenderInstance";
	else if(id == 0x000002A3)	funcName = "XamUpdateAllocateExtenderBuffer";
	else if(id == 0x000002A4)	funcName = "XamRestartTitleLoadAfterUpdate";
	else if(id == 0x000002A5)	funcName = "XamUIThreadDisableFontPatching";
	else if(id == 0x000002A6)	funcName = "XamUpdateGetBaseSystemVersion";
	else if(id == 0x000002A7)	funcName = "XamUpdateGetCurrentSystemVersion";
	else if(id == 0x000002A8)	funcName = "XamUIThreadEnableFontPatching";
	else if(id == 0x000002A9)	funcName = "XamTerminateTitleForUpdate";
	else if(id == 0x000002AA)	funcName = "XamSystemUpdateInstallLocal";
	else if(id == 0x000002AB)	funcName = "XamUpdateChainPass3FromPass2";
	else if(id == 0x000002AD)	funcName = "XamInputGetCapabilitiesEx";
	else if(id == 0x000002AE)	funcName = "XamUserIsUnsafeProgrammingAllowed";
	else if(id == 0x000002AF)	funcName = "XamDevAuthSetFaultEx";
	else if(id == 0x000002B0)	funcName = "XamUpdateGetData";
	else if(id == 0x000002B1)	funcName = "XamCacheIntegrityCheck";
	else if(id == 0x000002B2)	funcName = "XamCacheStoreFile";
	else if(id == 0x000002B3)	funcName = "XamCacheFetchFile";
	else if(id == 0x000002B4)	funcName = "XamCacheOpenFile";
	else if(id == 0x000002B5)	funcName = "XamCacheCloseFile";
	else if(id == 0x000002B6)	funcName = "XamGetCachedTitleName";
	else if(id == 0x000002B7)	funcName = "XamCacheReset";
	else if(id == 0x000002B8)	funcName = "XamGetCachedGamerTag";
	else if(id == 0x000002B9)	funcName = "XamGetCachedGamerTagW";
	else if(id == 0x000002BA)	funcName = "XamCacheDeleteFile";
	else if(id == 0x000002BB)	funcName = "XamCacheRenameFile";
	else if(id == 0x000002BC)	funcName = "XamShowSigninUI";
	else if(id == 0x000002BD)	funcName = "XamShowSigninUIEx";
	else if(id == 0x000002BE)	funcName = "XamShowSigninUIp";
	else if(id == 0x000002BF)	funcName = "XamShowFriendsUI";
	else if(id == 0x000002C0)	funcName = "XamShowMessagesUI";
	else if(id == 0x000002C1)	funcName = "XamShowKeyboardUI";
	else if(id == 0x000002C2)	funcName = "XamShowQuickChatUI";
	else if(id == 0x000002C3)	funcName = "XamShowVoiceMailUI";
	else if(id == 0x000002C4)	funcName = "XamShowGamerCardUI";
	else if(id == 0x000002C5)	funcName = "XamShowAchievementsUI";
	else if(id == 0x000002C6)	funcName = "XamShowPlayerReviewUI";
	else if(id == 0x000002C7)	funcName = "XamShowMarketplaceUI";
	else if(id == 0x000002C8)	funcName = "XamShowPlayersUI";
	else if(id == 0x000002C9)	funcName = "XamShowUpdaterUI";
	else if(id == 0x000002CA)	funcName = "XamShowMessageBoxUI";
	else if(id == 0x000002CB)	funcName = "XamShowDeviceSelectorUI";
	else if(id == 0x000002CC)	funcName = "XamShowMessageComposeUI";
	else if(id == 0x000002CD)	funcName = "XamShowGameInviteUI";
	else if(id == 0x000002CE)	funcName = "XamShowFriendRequestUI";
	else if(id == 0x000002CF)	funcName = "XamShowCreateProfileUI";
	else if(id == 0x000002D0)	funcName = "XamShowGamesUI";
	else if(id == 0x000002D1)	funcName = "XamShowLiveSignupUI";
	else if(id == 0x000002D2)	funcName = "XamShowFriendsUIp";
	else if(id == 0x000002D3)	funcName = "XamShowComplaintUI";
	else if(id == 0x000002D4)	funcName = "XamShowReputationUI";
	else if(id == 0x000002D5)	funcName = "XamShowGamerCardUIForXUID";
	else if(id == 0x000002D6)	funcName = "XamShowForcedNameChangeUI";
	else if(id == 0x000002D7)	funcName = "XamShowLiveUpsellUI";
	else if(id == 0x000002D8)	funcName = "XamShowPasscodeVerifyUI";
	else if(id == 0x000002D9)	funcName = "XamShowDirtyDiscErrorUI";
	else if(id == 0x000002DA)	funcName = "XamShowSignupCreditCardUI";
	else if(id == 0x000002DB)	funcName = "XamShowPrivateChatInviteUI";
	else if(id == 0x000002DC)	funcName = "XamShowMessageBoxUIEx";
	else if(id == 0x000002DD)	funcName = "XamShowRecentMessageUI";
	else if(id == 0x000002DE)	funcName = "XamShowRecentMessageUIEx";
	else if(id == 0x000002DF)	funcName = "XamShowMessagesUIEx";
	else if(id == 0x000002E0)	funcName = "XamShowAchievementDetailsUI";
	else if(id == 0x000002E1)	funcName = "XamShowPersonalizationUI";
	else if(id == 0x000002E2)	funcName = "XamShowChangeGamerTileUI";
	else if(id == 0x000002E3)	funcName = "XamShowVoiceSettingsUI";
	else if(id == 0x000002E4)	funcName = "XamShowVideoChatInviteUI";
	else if(id == 0x000002E5)	funcName = "XamShowCustomMessageComposeUI";
	else if(id == 0x000002E6)	funcName = "XamShowCustomPlayerListUI";
	else if(id == 0x000002E7)	funcName = "XamShowMarketplaceDownloadItemsUI";
	else if(id == 0x000002E8)	funcName = "XamShowMarketplaceUIEx";
	else if(id == 0x000002E9)	funcName = "XamShowMessageBox";
	else if(id == 0x000002EA)	funcName = "XamIsSysUiInvokedByXenonButton";
	else if(id == 0x000002EB)	funcName = "XamIsSysUiInvokedByTitle";
	else if(id == 0x000002EC)	funcName = "XamIsUIActive";
	else if(id == 0x000002ED)	funcName = "XamSysUiDisableAutoClose";
	else if(id == 0x000002EE)	funcName = "XamUserCreateAchievementEnumerator";
	else if(id == 0x000002EF)	funcName = "XamReadTile";
	else if(id == 0x000002F0)	funcName = "XamWriteGamerTile";
	else if(id == 0x000002F1)	funcName = "XamWriteTile";
	else if(id == 0x000002F2)	funcName = "XamReadImage";
	else if(id == 0x000002F3)	funcName = "XamUserCreateTitlesPlayedEnumerator";
	else if(id == 0x000002F4)	funcName = "XamDecompressPNGToTexture";
	else if(id == 0x000002F5)	funcName = "XamReadTileToTexture";
	else if(id == 0x000002F6)	funcName = "XamReadString";
	else if(id == 0x000002F7)	funcName = "XamUserCreateStatsEnumerator";
	else if(id == 0x000002F8)	funcName = "XamPrepareGamerTiles";
	else if(id == 0x000002F9)	funcName = "XamClearTitle";
	else if(id == 0x000002FA)	funcName = "XamReadStrings";
	else if(id == 0x000002FB)	funcName = "XamWriteGamerTileEx";
	else if(id == 0x000002FC)	funcName = "XamReadTileEx";
	else if(id == 0x000002FD)	funcName = "XamReadTileToTextureEx";
	else if(id == 0x000002FE)	funcName = "XamShowMessengerUI";
	else if(id == 0x000002FF)	funcName = "XamShowKeyboardUIMessenger";
	else if(id == 0x00000300)	funcName = "XamShowLiveUpsellUIEx";
	else if(id == 0x00000301)	funcName = "XamShowJoinSessionInProgressUI";
	else if(id == 0x00000302)	funcName = "XamShowGraduateUserUI";
	else if(id == 0x00000303)	funcName = "XamShowGamerCardUIForXUIDp";
	else if(id == 0x00000304)	funcName = "XamShowGuideUI";
	else if(id == 0x00000305)	funcName = "XamShowPartyUI";
	else if(id == 0x00000306)	funcName = "XamShowPartyInviteUI";
	else if(id == 0x00000307)	funcName = "XamUserAddRecentPlayer";
	else if(id == 0x00000308)	funcName = "XamUserUpdateRecentPlayer";
	else if(id == 0x00000309)	funcName = "XamUserCreatePlayerEnumerator";
	else if(id == 0x0000030A)	funcName = "XamParseGamerTileKey";
	else if(id == 0x0000030B)	funcName = "XamShowCommunitySessionsUI";
	else if(id == 0x0000030C)	funcName = "XamVoiceCreate";
	else if(id == 0x0000030D)	funcName = "XamVoiceHeadsetPresent";
	else if(id == 0x0000030E)	funcName = "XamVoiceSubmitPacket";
	else if(id == 0x0000030F)	funcName = "XamVoiceClose";
	else if(id == 0x00000310)	funcName = "XamVoiceGetBatteryStatus";
	else if(id == 0x00000311)	funcName = "Refresh";
	else if(id == 0x00000312)	funcName = "Refresh";
	else if(id == 0x00000313)	funcName = "XamShowJoinSessionByIdInProgressUI";
	else if(id == 0x00000314)	funcName = "XamShowPartyJoinInProgressUI";
	else if(id == 0x00000315)	funcName = "XamBuildSharedSystemResourceLocator";
	else if(id == 0x00000316)	funcName = "XamSessionCreateHandle";
	else if(id == 0x00000317)	funcName = "XamSessionRefObjByHandle";
	else if(id == 0x00000318)	funcName = "XamVoiceGetMicArrayStatus";
	else if(id == 0x00000319)	funcName = "XamVoiceSetAudioCaptureRoutine";
	else if(id == 0x0000031A)	funcName = "XamVoiceGetDirectionalData";
	else if(id == 0x0000031B)	funcName = "XamBuildResourceLocator";
	else if(id == 0x0000031C)	funcName = "XamBuildSharedSystemResourceLocator";
	else if(id == 0x0000031D)	funcName = "XamBuildGamercardResourceLocator";
	else if(id == 0x0000031E)	funcName = "XamBuildDynamicResourceLocator";
	else if(id == 0x0000031F)	funcName = "XamBuildXamResourceLocator";
	else if(id == 0x00000320)	funcName = "XuiAnimRun";
	else if(id == 0x00000321)	funcName = "XuiApplyLocale";
	else if(id == 0x00000322)	funcName = "XuiBubbleMessage";
	else if(id == 0x00000323)	funcName = "XuiControlIsBackButton";
	else if(id == 0x00000324)	funcName = "XuiControlIsNavButton";
	else if(id == 0x00000325)	funcName = "XuiCreateObject";
	else if(id == 0x00000326)	funcName = "XuiDestroyObject";
	else if(id == 0x00000327)	funcName = "XuiDynamicCast";
	else if(id == 0x00000328)	funcName = "XuiElementAddChild";
	else if(id == 0x00000329)	funcName = "XuiElementFindNamedFrame";
	else if(id == 0x0000032A)	funcName = "XuiElementGetChildById";
	else if(id == 0x0000032B)	funcName = "XuiElementGetFirstChild";
	else if(id == 0x0000032C)	funcName = "XuiElementGetFocus";
	else if(id == 0x0000032D)	funcName = "XuiElementGetFocusUser";
	else if(id == 0x0000032E)	funcName = "XuiElementGetId";
	else if(id == 0x0000032F)	funcName = "XuiElementGetLastChild";
	else if(id == 0x00000330)	funcName = "XuiElementGetNext";
	else if(id == 0x00000331)	funcName = "XuiElementGetParent";
	else if(id == 0x00000332)	funcName = "XuiElementGetUserFocus";
	else if(id == 0x00000333)	funcName = "XuiElementInitFocus";
	else if(id == 0x00000334)	funcName = "XuiElementInitUserFocus";
	else if(id == 0x00000335)	funcName = "XuiElementPlayTimeline";
	else if(id == 0x00000336)	funcName = "XuiElementSetBounds";
	else if(id == 0x00000337)	funcName = "XuiElementSetFocus";
	else if(id == 0x00000338)	funcName = "XuiElementSetUserFocus";
	else if(id == 0x00000339)	funcName = "XuiElementTreeGetFocus";
	else if(id == 0x0000033A)	funcName = "XuiFindClass";
	else if(id == 0x0000033B)	funcName = "XuiFreeStringTable";
	else if(id == 0x0000033C)	funcName = "XuiGetBaseObject";
	else if(id == 0x0000033D)	funcName = "XuiGetClass";
	else if(id == 0x0000033E)	funcName = "XuiGetObjectClass";
	else if(id == 0x0000033F)	funcName = "XuiGetOuter";
	else if(id == 0x00000340)	funcName = "XuiInit";
	else if(id == 0x00000341)	funcName = "XuiLoadFromBinary";
	else if(id == 0x00000342)	funcName = "XuiLoadStringTableFromFile";
	else if(id == 0x00000343)	funcName = "XuiVisualGetBasePath";
	else if(id == 0x00000344)	funcName = "XuiLookupStringTable";
	else if(id == 0x00000345)	funcName = "XuiNavButtonGetPressPath";
	else if(id == 0x00000346)	funcName = "XuiObjectFromHandle";
	else if(id == 0x00000347)	funcName = "XuiObjectGetProperty";
	else if(id == 0x00000348)	funcName = "XuiObjectGetPropertyId";
	else if(id == 0x00000349)	funcName = "XuiProcessInput";
	else if(id == 0x0000034A)	funcName = "XuiRegisterClass";
	else if(id == 0x0000034B)	funcName = "XuiRenderBegin";
	else if(id == 0x0000034C)	funcName = "XuiRenderCreateDC";
	else if(id == 0x0000034D)	funcName = "XuiRenderDCDeviceChanged";
	else if(id == 0x0000034E)	funcName = "XuiRenderDestroyDC";
	else if(id == 0x0000034F)	funcName = "XuiRenderEnd";
	else if(id == 0x00000350)	funcName = "XuiRenderGetBackBufferSize";
	else if(id == 0x00000351)	funcName = "XuiRenderInit";
	else if(id == 0x00000352)	funcName = "XuiRenderInitShared";
	else if(id == 0x00000353)	funcName = "XuiRenderPresent";
	else if(id == 0x00000354)	funcName = "XuiRenderSetViewTransform";
	else if(id == 0x00000355)	funcName = "XuiRenderUninit";
	else if(id == 0x00000356)	funcName = "XamShowNuiGuideUI";
	else if(id == 0x00000357)	funcName = "XuiSceneCreate";
	else if(id == 0x00000358)	funcName = "XuiSceneNavigateBack";
	else if(id == 0x00000359)	funcName = "XuiSceneNavigateFirst";
	else if(id == 0x0000035A)	funcName = "XuiSceneNavigateForward";
	else if(id == 0x0000035B)	funcName = "XuiScenePlayBackFromTransition";
	else if(id == 0x0000035C)	funcName = "XuiScenePlayBackToTransition";
	else if(id == 0x0000035D)	funcName = "XuiScenePlayFromTransition";
	else if(id == 0x0000035E)	funcName = "XuiScenePlayToTransition";
	else if(id == 0x0000035F)	funcName = "XuiSendMessage";
	else if(id == 0x00000360)	funcName = "XuiSetLocale";
	else if(id == 0x00000361)	funcName = "XuiUninit";
	else if(id == 0x00000362)	funcName = "XuiUnregisterClass";
	else if(id == 0x00000363)	funcName = "XuiTextElementSetText";
	else if(id == 0x00000364)	funcName = "XuiSetTimer";
	else if(id == 0x00000365)	funcName = "XuiTimersRun";
	else if(id == 0x00000366)	funcName = "XuiTextElementGetText";
	else if(id == 0x00000367)	funcName = "XuiVisualSetBasePath";
	else if(id == 0x00000368)	funcName = "XuiHandleIsValid";
	else if(id == 0x00000369)	funcName = "XuiAlloc";
	else if(id == 0x0000036A)	funcName = "XuiFree";
	else if(id == 0x0000036B)	funcName = "XuiDefault_True";
	else if(id == 0x0000036C)	funcName = "XuiDefault_EmptyString";
	else if(id == 0x0000036D)	funcName = "XuiDefault_IntegerZero";
	else if(id == 0x0000036E)	funcName = "XuiCopyString";
	else if(id == 0x0000036F)	funcName = "XuiRealloc";
	else if(id == 0x00000370)	funcName = "XuiControlPlayOptionalVisual";
	else if(id == 0x00000371)	funcName = "XuiKillTimer";
	else if(id == 0x00000372)	funcName = "XuiElementEnableInput";
	else if(id == 0x00000373)	funcName = "XuiElementInputEnabled";
	else if(id == 0x00000374)	funcName = "XuiIsInstanceOf";
	else if(id == 0x00000375)	funcName = "XuiResourceComposeLocator";
	else if(id == 0x00000376)	funcName = "XuiResourceLocatorIsAbsolute";
	else if(id == 0x00000377)	funcName = "XuiBroadcastMessage";
	else if(id == 0x00000378)	funcName = "XuiElementDisallowRecursiveTimelineControl";
	else if(id == 0x00000379)	funcName = "XUIElementPropVal_Construct";
	else if(id == 0x0000037A)	funcName = "XUIElementPropVal_Destruct";
	else if(id == 0x0000037B)	funcName = "XUIElementPropVal_SetString";
	else if(id == 0x0000037C)	funcName = "XuiObjectSetProperty";
	else if(id == 0x0000037D)	funcName = "XuiElementGetOpacity";
	else if(id == 0x0000037E)	funcName = "XuiElementSetOpacity";
	else if(id == 0x0000037F)	funcName = "XuiEditSetTextLimit";
	else if(id == 0x00000380)	funcName = "XuiEditGetTextLimit";
	else if(id == 0x00000381)	funcName = "XuiSliderSetValue";
	else if(id == 0x00000382)	funcName = "XuiSliderGetValue";
	else if(id == 0x00000383)	funcName = "XuiSliderSetRange";
	else if(id == 0x00000384)	funcName = "XuiElementUnlink";
	else if(id == 0x00000385)	funcName = "XuiElementInsertChild";
	else if(id == 0x00000386)	funcName = "XuiSceneNavigateBackToFirst";
	else if(id == 0x00000387)	funcName = "XuiProgressBarSetRange";
	else if(id == 0x00000388)	funcName = "XuiProgressBarSetValue";
	else if(id == 0x00000389)	funcName = "XuiProgressBarGetValue";
	else if(id == 0x0000038A)	funcName = "XuiControlAttachVisual";
	else if(id == 0x0000038B)	funcName = "XuiCreateTextureBrush";
	else if(id == 0x0000038C)	funcName = "XuiDestroyBrush";
	else if(id == 0x0000038D)	funcName = "XUIElementPropVal_SetColorFromUint";
	else if(id == 0x0000038E)	funcName = "XuiFigureSetFill";
	else if(id == 0x0000038F)	funcName = "XuiSliderGetRange";
	else if(id == 0x00000390)	funcName = "XuiFigureSetTexture";
	else if(id == 0x00000391)	funcName = "XuiControlGetItemAssociation";
	else if(id == 0x00000392)	funcName = "XuiResourceLoadAll";
	else if(id == 0x00000393)	funcName = "XuiImageElementSetImagePath";
	else if(id == 0x00000394)	funcName = "XuiImageElementGetImagePath";
	else if(id == 0x00000395)	funcName = "XuiControlGetVisual";
	else if(id == 0x00000396)	funcName = "XuiControlGetNavigation";
	else if(id == 0x00000397)	funcName = "XuiLookupStringTableByIndex";
	else if(id == 0x00000398)	funcName = "XUIElementPropVal_SetBool";
	else if(id == 0x00000399)	funcName = "XuiElementHasFocus";
	else if(id == 0x0000039A)	funcName = "XUIElementPropVal_SetUint";
	else if(id == 0x0000039B)	funcName = "XUIElementPropVal_Clear";
	else if(id == 0x0000039C)	funcName = "XuiEditSetTextFormatInfo";
	else if(id == 0x0000039D)	funcName = "XuiCreateSolidBrush";
	else if(id == 0x0000039E)	funcName = "XuiSceneInterruptTransitions";
	else if(id == 0x0000039F)	funcName = "XuiResourceOpen";
	else if(id == 0x000003A0)	funcName = "XuiResourceRead";
	else if(id == 0x000003A1)	funcName = "XuiResourceClose";
	else if(id == 0x000003A2)	funcName = "XuiVisualCreateInstance";
	else if(id == 0x000003A3)	funcName = "XuiElementGetTimeline";
	else if(id == 0x000003A4)	funcName = "GetCodecVersion";
	else if(id == 0x000003A5)	funcName = "XuiElementIsDescendant";
	else if(id == 0x000003A6)	funcName = "XuiSetMessageFilter";
	else if(id == 0x000003A7)	funcName = "XuiAttachTextureBrush";
	else if(id == 0x000003A8)	funcName = "XuiElementBeginRender";
	else if(id == 0x000003A9)	funcName = "XuiElementEndRender";
	else if(id == 0x000003AA)	funcName = "XuiDrawShape";
	else if(id == 0x000003AB)	funcName = "XuiSelectBrushEx";
	else if(id == 0x000003AC)	funcName = "XuiFigureGetShape";
	else if(id == 0x000003AD)	funcName = "XuiFillRect";
	else if(id == 0x000003AE)	funcName = "XuiVec2TransformCoord";
	else if(id == 0x000003AF)	funcName = "XuiMatrixMultiply";
	else if(id == 0x000003B0)	funcName = "XuiElementGetXForm";
	else if(id == 0x000003B1)	funcName = "XuiElementSetPosition";
	else if(id == 0x000003B2)	funcName = "XuiSelectBrush";
	else if(id == 0x000003B3)	funcName = "XuiElementRenderChildren";
	else if(id == 0x000003B4)	funcName = "XuiFreeUnusedTextures";
	else if(id == 0x000003B5)	funcName = "XuiListEnableItemOverride";
	else if(id == 0x000003B6)	funcName = "XuiListGetDefaultItemSize";
	else if(id == 0x000003B7)	funcName = "XuiResourceSeek";
	else if(id == 0x000003B8)	funcName = "XuiElementDiscardResources";
	else if(id == 0x000003B9)	funcName = "XuiTabSceneGoto";
	else if(id == 0x000003BA)	funcName = "XuiTabSceneGetCurrentTab";
	else if(id == 0x000003BB)	funcName = "XamShowWhatsOnUI";
	else if(id == 0x000003BC)	funcName = "XamShowEditProfileUI";
	else if(id == 0x000003BD)	funcName = "XamShowStorePickerUI";
	else if(id == 0x000003BE)	funcName = "XamShowTermsOfUseUI";
	else if(id == 0x000003BF)	funcName = "XamShowJoinPartyUI";
	else if(id == 0x000003C0)	funcName = "XamShowWordRegisterUI";
	else if(id == 0x000003C1)	funcName = "XamOverrideHudOpenType";
	else if(id == 0x000003C2)	funcName = "XamShowAchievementsUIEx";
	else if(id == 0x000003C3)	funcName = "XamUserGetUserTenure";
	else if(id == 0x000003C4)	funcName = "XamUserGetSubscriptionType";
	else if(id == 0x000003C5)	funcName = "XamShowGameVoiceChannelUI";
	else if(id == 0x000003C6)	funcName = "XamShowAvatarAwardsUI";
	else if(id == 0x000003C7)	funcName = "XamShowAvatarAwardGamesUI";
	else if(id == 0x000003C8)	funcName = "XamShowVideoRichPresenceUI";
	else if(id == 0x000003C9)	funcName = "XamHudGetUserIndex";
	else if(id == 0x000003CA)	funcName = "XGetAudioFlags";
	else if(id == 0x000003CB)	funcName = "XGetAVPack";
	else if(id == 0x000003CC)	funcName = "XGetGameRegion";
	else if(id == 0x000003CD)	funcName = "XGetLanguage";
	else if(id == 0x000003CE)	funcName = "XapipGetLocale";
	else if(id == 0x000003CF)	funcName = "XGetVideoFlags";
	else if(id == 0x000003D0)	funcName = "XGetVideoStandard";
	else if(id == 0x000003D1)	funcName = "XGetVideoMode";
	else if(id == 0x000003D2)	funcName = "XamGetLanguage";
	else if(id == 0x000003D3)	funcName = "XUITimeline_Run";
	else if(id == 0x000003D4)	funcName = "XamSetAutomation";
	else if(id == 0x000003D5)	funcName = "XAutomationpBindController";
	else if(id == 0x000003D6)	funcName = "XAutomationpUnbindController";
	else if(id == 0x000003D7)	funcName = "XAutomationpInputXenonButton";
	else if(id == 0x000003D8)	funcName = "XAutomationpInputPress";
	else if(id == 0x000003D9)	funcName = "XAutomationpInputSetState";
	else if(id == 0x000003DA)	funcName = "XamEnableOverdraw";
	else if(id == 0x000003DB)	funcName = "g_XuiAutomation";
	else if(id == 0x000003DC)	funcName = "XamVoiceGetMicArrayAudio";
	else if(id == 0x000003DD)	funcName = "XampSystemInput";
	else if(id == 0x000003DE)	funcName = "XamInputControl";
	else if(id == 0x000003DF)	funcName = "XuiElementGetPosition";
	else if(id == 0x000003E0)	funcName = "XamIsMessageBoxActive";
	else if(id == 0x000003E1)	funcName = "XamIsBackgroundSceneInTransition";
	else if(id == 0x000003E2)	funcName = "XuiElementTreeHasFocus";
	else if(id == 0x000003E3)	funcName = "XuiFigureClose";
	else if(id == 0x000003E4)	funcName = "GamerCardStartup";
	else if(id == 0x000003E5)	funcName = "GamerCardCleanup";
	else if(id == 0x000003E6)	funcName = "GamerCardRegisterControls";
	else if(id == 0x000003E7)	funcName = "GamerCardUnregisterControls";
	else if(id == 0x000003E8)	funcName = "RtlFindFirstFile";
	else if(id == 0x000003E9)	funcName = "RtlFindNextFile";
	else if(id == 0x000003EA)	funcName = "RtlGetModuleFileName";
	else if(id == 0x000003EB)	funcName = "RtlOutputDebugString";
	else if(id == 0x000003EC)	funcName = "RtlRemoveDirectory";
	else if(id == 0x000003ED)	funcName = "RtlSleep";
	else if(id == 0x000003EE)	funcName = "RtlGetLastError";
	else if(id == 0x000003EF)	funcName = "RtlSetLastError";
	else if(id == 0x000003F0)	funcName = "RtlSetLastNTError";
	else if(id == 0x000003F1)	funcName = "RtlDebugPrint";
	else if(id == 0x000003F2)	funcName = "RtlDebugError";
	else if(id == 0x000003F3)	funcName = "XDebugWarning";
	else if(id == 0x000003F4)	funcName = "RtlDebugTrace";
	else if(id == 0x000003F5)	funcName = "RtlDebugEntry";
	else if(id == 0x000003F6)	funcName = "RtlDebugExit";
	else if(id == 0x000003F7)	funcName = "RtlGetAttributesOnHeapAlloc";
	else if(id == 0x000003F8)	funcName = "RtlSetAttributesOnHeapAlloc";
	else if(id == 0x000003F9)	funcName = "XuiFigureSetShape";
	else if(id == 0x000003FA)	funcName = "RtlCreateHeap";
	else if(id == 0x000003FB)	funcName = "RtlDestroyHeap";
	else if(id == 0x000003FC)	funcName = "RtlAllocateHeap";
	else if(id == 0x000003FD)	funcName = "RtlAllocateHeapSlowly";
	else if(id == 0x000003FE)	funcName = "RtlReAllocateHeap";
	else if(id == 0x000003FF)	funcName = "RtlFreeHeap";
	else if(id == 0x00000400)	funcName = "RtlFreeHeapSlowly";
	else if(id == 0x00000401)	funcName = "RtlSizeHeap";
	else if(id == 0x00000402)	funcName = "RtlZeroHeap";
	else if(id == 0x00000403)	funcName = "RtlDebugWalkHeap";
	else if(id == 0x00000404)	funcName = "RtlWalkHeap";
	else if(id == 0x00000405)	funcName = "RtlLockHeap";
	else if(id == 0x00000406)	funcName = "RtlUnlockHeap";
	else if(id == 0x00000407)	funcName = "RtlValidateHeap";
	else if(id == 0x00000408)	funcName = "RtlDebugCompactHeap";
	else if(id == 0x00000409)	funcName = "RtlCompactHeap";
	else if(id == 0x0000040A)	funcName = "XamAppSetTestOption";
	else if(id == 0x0000040B)	funcName = "XamAppReportError";
	else if(id == 0x0000040C)	funcName = "XamIsNuiUIActive";
	else if(id == 0x0000040D)	funcName = "XamVerifyPasscode";
	else if(id == 0x0000040E)	funcName = "OutputDebugStringA";
	else if(id == 0x0000040F)	funcName = "DebugBreak";
	else if(id == 0x00000410)	funcName = "GetCurrentThreadId";
	else if(id == 0x00000411)	funcName = "XDebugError";
	else if(id == 0x00000412)	funcName = "XDebugWarning";
	else if(id == 0x00000413)	funcName = "RtlDebugSetLevel";
	else if(id == 0x00000414)	funcName = "CloseHandle";
	else if(id == 0x00000415)	funcName = "GetTickCount";
	else if(id == 0x00000416)	funcName = "GetLastError";
	else if(id == 0x00000417)	funcName = "SetFilePointer";
	else if(id == 0x00000418)	funcName = "SetFilePointerEx";
	else if(id == 0x00000419)	funcName = "SetLastError";
	else if(id == 0x0000041A)	funcName = "MultiByteToWideChar";
	else if(id == 0x0000041B)	funcName = "WideCharToMultiByte";
	else if(id == 0x0000041C)	funcName = "ReadFile";
	else if(id == 0x0000041D)	funcName = "FlushFileBuffers";
	else if(id == 0x0000041E)	funcName = "WriteFile";
	else if(id == 0x0000041F)	funcName = "OutputDebugStringW";
	else if(id == 0x00000420)	funcName = "SetEvent";
	else if(id == 0x00000421)	funcName = "XapiFormatTimeOut";
	else if(id == 0x00000422)	funcName = "CreateMutexA";
	else if(id == 0x00000423)	funcName = "OpenMutexA";
	else if(id == 0x00000424)	funcName = "ReleaseMutex";
	else if(id == 0x00000425)	funcName = "WaitForSingleObject";
	else if(id == 0x00000426)	funcName = "WaitForSingleObjectEx";
	else if(id == 0x00000427)	funcName = "GetFileSize";
	else if(id == 0x00000428)	funcName = "GetFileSizeEx";
	else if(id == 0x00000429)	funcName = "XapiDirectoryInformationToFindData";
	else if(id == 0x0000042A)	funcName = "XapiFormatObjectAttributes";
	else if(id == 0x0000042B)	funcName = "ResetEvent";
	else if(id == 0x0000042C)	funcName = "wsprintfA";
	else if(id == 0x0000042D)	funcName = "wsprintfW";
	else if(id == 0x0000042E)	funcName = "GetOverlappedResult";
	else if(id == 0x0000042F)	funcName = "QueryPerformanceCounter";
	else if(id == 0x00000430)	funcName = "QueryPerformanceFrequency";
	else if(id == 0x00000431)	funcName = "LocalAlloc";
	else if(id == 0x00000432)	funcName = "LocalFree";
	else if(id == 0x00000433)	funcName = "RaiseException";
	else if(id == 0x00000434)	funcName = "RtlUniform";
	else if(id == 0x00000435)	funcName = "RtlRandom";
	else if(id == 0x00000436)	funcName = "Sleep";
	else if(id == 0x00000437)	funcName = "SleepEx";
	else if(id == 0x00000438)	funcName = "XMemSet";
	else if(id == 0x00000439)	funcName = "XRegisterThreadNotifyRoutine";
	else if(id == 0x0000043A)	funcName = "XGetOverlappedExtendedError";
	else if(id == 0x0000043B)	funcName = "XGetOverlappedResult";
	else if(id == 0x0000043C)	funcName = "CreateThread";
	else if(id == 0x0000043D)	funcName = "ResumeThread";
	else if(id == 0x0000043E)	funcName = "ExitThread";
	else if(id == 0x0000043F)	funcName = "GetTimeZoneInformation";
	else if(id == 0x00000440)	funcName = "GetSystemTimeAsFileTime";
	else if(id == 0x00000441)	funcName = "SystemTimeToFileTime";
	else if(id == 0x00000442)	funcName = "FileTimeToSystemTime";
	else if(id == 0x00000443)	funcName = "GetSystemTime";
	else if(id == 0x00000444)	funcName = "GetLocalTime";
	else if(id == 0x00000445)	funcName = "CreateDirectoryA";
	else if(id == 0x00000446)	funcName = "CreateEventA";
	else if(id == 0x00000447)	funcName = "CreateFileA";
	else if(id == 0x00000448)	funcName = "DeleteFileA";
	else if(id == 0x00000449)	funcName = "FindFirstFileA";
	else if(id == 0x0000044A)	funcName = "FindNextFileA";
	else if(id == 0x0000044B)	funcName = "GetFileAttributesA";
	else if(id == 0x0000044C)	funcName = "XamLoaderGetCurrentTitleD3DVersion";
	else if(id == 0x0000044D)	funcName = "GetFileAttributesExA";
	else if(id == 0x0000044E)	funcName = "GetModuleHandleA";
	else if(id == 0x0000044F)	funcName = "GetDiskFreeSpaceExA";
	else if(id == 0x00000450)	funcName = "CopyFileA";
	else if(id == 0x00000451)	funcName = "SetEndOfFile";
	else if(id == 0x00000452)	funcName = "XamFamilyAddParentalExemptionToList";
	else if(id == 0x00000453)	funcName = "XamFamilyIsParentalValidationRequired";
	else if(id == 0x00000454)	funcName = "PIXBeginCapture";
	else if(id == 0x00000455)	funcName = "PIXEndCapture";
	else if(id == 0x00000456)	funcName = "PIXAddCounter";
	else if(id == 0x00000457)	funcName = "PIXGetGPUSlot";
	else if(id == 0x00000458)	funcName = "SetWaitableTimer";
	else if(id == 0x00000459)	funcName = "CancelWaitableTimer";
	else if(id == 0x0000045A)	funcName = "CreateWaitableTimerA";
	else if(id == 0x0000045B)	funcName = "DuplicateHandle";
	else if(id == 0x0000045C)	funcName = "XapipCreateThread";
	else if(id == 0x0000045D)	funcName = "lstrcpyA";
	else if(id == 0x0000045E)	funcName = "lstrcpyW";
	else if(id == 0x0000045F)	funcName = "lstrcpynA";
	else if(id == 0x00000460)	funcName = "lstrcpynW";
	else if(id == 0x00000461)	funcName = "lstrcatA";
	else if(id == 0x00000462)	funcName = "lstrcatW";
	else if(id == 0x00000463)	funcName = "lstrlenA";
	else if(id == 0x00000464)	funcName = "lstrlenW";
	else if(id == 0x00000465)	funcName = "IsBadReadPtr";
	else if(id == 0x00000466)	funcName = "IsBadWritePtr";
	else if(id == 0x00000467)	funcName = "FileTimeToLocalFileTime";
	else if(id == 0x00000468)	funcName = "XMemCpy";
	else if(id == 0x00000469)	funcName = "XMemCpyStreaming";
	else if(id == 0x0000046A)	funcName = "XamHudSetUserIndex";
	else if(id == 0x0000046B)	funcName = "XamShowNuiTroubleshooterUI";
	else if(id == 0x0000046C)	funcName = "XamTestShowNuiTroubleshooterUI";
	else if(id == 0x0000046D)	funcName = "XamShowPasscodeVerifyUIEx";
	else if(id == 0x0000046E)	funcName = "XamShowNuiAchievementsUI";
	else if(id == 0x0000046F)	funcName = "XamShowNuiCommunitySessionsUI";
	else if(id == 0x00000470)	funcName = "XamShowNuiDeviceSelectorUI";
	else if(id == 0x00000471)	funcName = "XamShowNuiDirtyDiscErrorUI";
	else if(id == 0x00000472)	funcName = "XamShowNuiFriendsUI";
	else if(id == 0x00000473)	funcName = "XamShowNuiGameInviteUI";
	else if(id == 0x00000474)	funcName = "XamShowNuiGamerCardUIForXUID";
	else if(id == 0x00000475)	funcName = "XamShowNuiMarketplaceDownloadItemsUI";
	else if(id == 0x00000476)	funcName = "XamShowNuiMarketplaceUI";
	else if(id == 0x00000477)	funcName = "XamShowNuiMessageBoxUI";
	else if(id == 0x00000478)	funcName = "XamShowNuiPartyUI";
	else if(id == 0x00000479)	funcName = "XamShowNuiFriendRequestUI";
	else if(id == 0x0000047A)	funcName = "XamShowNuiSigninUI";
	else if(id == 0x0000047B)	funcName = "XamShowNuiControllerRequiredUI";
	else if(id == 0x0000047C)	funcName = "XamShowNuiGamesUI";
	else if(id == 0x0000047D)	funcName = "XamShowNuiHardwareRequiredUI";
	else if(id == 0x0000047E)	funcName = "XamCacheStoreFileByString";
	else if(id == 0x0000047F)	funcName = "XamCacheFetchFileByString";
	else if(id == 0x00000480)	funcName = "XamCacheDeleteFileByString";
	else if(id == 0x00000481)	funcName = "XamGetCachedTitleNameEx";
	else if(id == 0x00000482)	funcName = "XamXlfsInitializeUploadQueue";
	else if(id == 0x00000483)	funcName = "XamXlfsUninitializeUploadQueue";
	else if(id == 0x00000484)	funcName = "XamXlfsMountUploadQueueInstance";
	else if(id == 0x00000485)	funcName = "XamXlfsUnmountUploadQueueInstance";
	else if(id == 0x00000486)	funcName = "XamVoiceRecordUserPrivileges";
	else if(id == 0x00000487)	funcName = "XamXlfsInitializeUploadQueueWithTestHooks";
	else if(id == 0x00000488)	funcName = "XamXlfsNotifyContentDeletion";
	else if(id == 0x00000489)	funcName = "XMemAlloc";
	else if(id == 0x0000048A)	funcName = "XMemFree";
	else if(id == 0x0000048B)	funcName = "XMemSize";
	else if(id == 0x0000048C)	funcName = "XamVoiceSetMicArrayIdleUsers";
	else if(id == 0x0000048D)	funcName = "XamVoiceMuteMicArray";
	else if(id == 0x0000048E)	funcName = "XamVoiceGetMicArrayUnderrunStatus";
	else if(id == 0x0000048F)	funcName = "XuiSceneEnableTransitionDependency";
	else if(id == 0x00000490)	funcName = "XamVoiceGetMicArrayAudioEx";
	else if(id == 0x00000491)	funcName = "XamVoiceDisableMicArray";
	else if(id == 0x00000497)	funcName = "XamVoiceIsActiveProcess";
	else if(id == 0x000004B0)	funcName = "XMPRegisterCodec";
	else if(id == 0x00000514)	funcName = "XamIsCurrentTitleIptv";
	else if(id == 0x00000515)	funcName = "XamIsIptvEnabled";
	else if(id == 0x00000516)	funcName = "XamIsDvrRecording";
	else if(id == 0x00000517)	funcName = "XamIptvUninstall";
	else if(id == 0x00000518)	funcName = "XamGetDvrStorage";
	else if(id == 0x00000519)	funcName = "XamSetDvrStorage";
	else if(id == 0x0000051A)	funcName = "XamIptvGetServiceName";
	else if(id == 0x0000051B)	funcName = "XamNuiHudGetEngagedEnrollmentIndex";
	else if(id == 0x00000578)	funcName = "XamReminderGetItems";
	else if(id == 0x00000579)	funcName = "XamReminderClearItems";
	else if(id == 0x0000057A)	funcName = "XamReminderItemAdd";
	else if(id == 0x0000057B)	funcName = "XamReminderItemRemove";
	else if(id == 0x0000057C)	funcName = "XamReminderGetNextItem";
	else if(id == 0x0000057D)	funcName = "XamReminderGetModifiedTime";
	else if(id == 0x0000057E)	funcName = "XamReminderClearCache";
	else if(id == 0x000005DC)	funcName = "XamAvatarInitialize";
	else if(id == 0x000005DD)	funcName = "XamAvatarShutdown";
	else if(id == 0x000005DE)	funcName = "XamAvatarGetManifestLocalUser";
	else if(id == 0x000005DF)	funcName = "XamAvatarGetManifestsByXuid";
	else if(id == 0x000005E0)	funcName = "XamAvatarGetAssetsResultSize";
	else if(id == 0x000005E1)	funcName = "XamAvatarGetAssets";
	else if(id == 0x000005E2)	funcName = "XamAvatarGenerateMipMaps";
	else if(id == 0x000005E3)	funcName = "XamAvatarSetCustomAsset";
	else if(id == 0x000005E4)	funcName = "XamAvatarSetManifest";
	else if(id == 0x000005E5)	funcName = "EnumerateMediaObjects";
	else if(id == 0x000005E6)	funcName = "EnumerateMediaObjects";
	else if(id == 0x000005E7)	funcName = "XamAvatarLoadAnimation";
	else if(id == 0x000005E8)	funcName = "XamAvatarBeginEnumAssets";
	else if(id == 0x000005E9)	funcName = "XamAvatarEndEnumAssets";
	else if(id == 0x000005EA)	funcName = "XamAvatarEnumAssets";
	else if(id == 0x000005EB)	funcName = "XamAvatarGetMetadataRandom";
	else if(id == 0x000005EC)	funcName = "EnumerateMediaObjects";
	else if(id == 0x000005ED)	funcName = "EnumerateMediaObjects";
	else if(id == 0x000005EE)	funcName = "XamAvatarGetMetadataSignedOutProfileCount";
	else if(id == 0x000005EF)	funcName = "XamAvatarGetMetadataSignedOutProfile";
	else if(id == 0x000005F0)	funcName = "EnumerateMediaObjects";
	else if(id == 0x000005F1)	funcName = "XamAvatarManifestGetBodyType";
	else if(id == 0x000005F2)	funcName = "XamAvatarGetInstrumentation";
	else if(id == 0x000005F3)	funcName = "XamAvatarGetAssetIcon";
	else if(id == 0x000005F4)	funcName = "XamAvatarWearNow";
	else if(id == 0x000005F5)	funcName = "XamAvatarGetAssetBinary";
	else if(id == 0x000005F6)	funcName = "XamAvatarReinstallAwardedAsset";
	else if(id == 0x000005F7)	funcName = "XamAvatarGetInstalledAssetPackageDescription";
	else if(id == 0x000005F8)	funcName = "XamAvatarSetMocks";
	else if(id == 0x0000060E)	funcName = "XamContentMountInstalledGame";
	else if(id == 0x0000060F)	funcName = "XamContentIsGameInstalledToHDD";
	else if(id == 0x00000610)	funcName = "XamContentQueryLicenseInternal";
	else if(id == 0x00000611)	funcName = "XamContentGetDeviceVolumePath";
	else if(id == 0x00000612)	funcName = "XamContentDeviceCheckUpdates";
	else if(id == 0x00000613)	funcName = "XamContentGetHeaderInternal";
	else if(id == 0x00000640)	funcName = "XamPackageManagerFindPackageContainingIndexedXEX";
	else if(id == 0x00000641)	funcName = "XamPackageManagerReinitialize";
	else if(id == 0x00000642)	funcName = "XamPackageManagerGetAuthoritativeManifestVersion";
	else if(id == 0x00000643)	funcName = "XamGetCurrentSystemOnlineManifestRevision";
	else if(id == 0x00000644)	funcName = "XamPackageManagerDeleteExtendedPartition";
	else if(id == 0x00000645)	funcName = "XamPackageManagerHasExtendedPartition";
	else if(id == 0x00000646)	funcName = "XamPackageManagerGetExperienceMode";
	else if(id == 0x00000647)	funcName = "XamPackageManagerGetFeatureRequiresUpdateStrings";
	else if(id == 0x00000648)	funcName = "XamPackageManagerGetFileSize";
	else if(id == 0x00000649)	funcName = "XampDemandUpdateGetAttributes";
	else if(id == 0x0000064A)	funcName = "XampDemandUpdateGetExtendedAttributes";
	else if(id == 0x0000064B)	funcName = "XampDemandUpdateGetInstance";
	else if(id == 0x0000064C)	funcName = "XampDemandUpdateSetRefreshTestFlags";
	else if(id == 0x0000064D)	funcName = "XampDemandUpdateIsRefreshTestFlagSet";
	else if(id == 0x0000064E)	funcName = "XampDemandUpdateGetManifestLocalPath";
	else if(id == 0x0000064F)	funcName = "XampDemandUpdateRefreshManifest";
	else if(id == 0x00000650)	funcName = "XdfInitialize";
	else if(id == 0x00000651)	funcName = "XdfShutdown";
	else if(id == 0x00000652)	funcName = "XdfGetExpectedDownloadSize";
	else if(id == 0x00000653)	funcName = "XdfGetItem";
	else if(id == 0x00000654)	funcName = "XdfCacheItem";
	else if(id == 0x00000655)	funcName = "XdfLoadXexFromCache";
	else if(id == 0x00000656)	funcName = "XdfLoadXex";
	else if(id == 0x00000657)	funcName = "XdfCancelRequest";
	else if(id == 0x00000658)	funcName = "XdfResumeDelayedItem";
	else if(id == 0x00000659)	funcName = "XdfLaunchNewImageFromCache";
	else if(id == 0x0000065A)	funcName = "XampDemandUpdateRefreshManifestDuringLogon";
	else if(id == 0x0000065B)	funcName = "XampDemandUpdateCheckOnlineManifestChanged";
	else if(id == 0x0000065C)	funcName = "XampDemandUpdateRunCacheCleaner";
	else if(id == 0x00000686)	funcName = "XamXStudioRequest";
	else if(id == 0x000006A4)	funcName = "XamShowAvatarMiniCreatorUI";
	else if(id == 0x000006A5)	funcName = "XamShowGoldUpgradeUI";
	else if(id == 0x000006A6)	funcName = "XamResumeUpdaterUI";
	else if(id == 0x000006A7)	funcName = "XamShowDirectAcquireUI";
	else if(id == 0x000006A8)	funcName = "XamShowPaymentOptionsUI";
	else if(id == 0x00000708)	funcName = "XamGetLiveHiveValueA";
	else if(id == 0x00000709)	funcName = "XamGetLiveHiveValueW";
	else if(id == 0x0000070A)	funcName = "XamGetLiveHiveValueDuringLogonAttemptA";
	else if(id == 0x0000076C)	funcName = "XamDownloadMarketplaceStoresList";
	else if(id == 0x0000076D)	funcName = "XamGetStoreFront";
	else if(id == 0x0000076E)	funcName = "XamSetStagingMode";
	else if(id == 0x0000076F)	funcName = "XamGetStagingMode";
	else if(id == 0x00000770)	funcName = "XamAppGetSessionId";
	else if(id == 0x000007D0)	funcName = "XamDoesOmniNeedConfiguration";
	else if(id == 0x000007D1)	funcName = "XamFirstRunExperienceShouldRun";
	else if(id == 0x000007D2)	funcName = "GetProcessHeap";
	else if(id == 0x000007D3)	funcName = "UnhandledExceptionFilter";
	else if(id == 0x000007D4)	funcName = "SetUnhandledExceptionFilter";
	else if(id == 0x000007D5)	funcName = "XamIsOptionalMediaUpdateInstalled";
	else if(id == 0x000007D6)	funcName = "XamShowOptionalMediaUpdateRequiredUI";
	else if(id == 0x000007D7)	funcName = "XamShowOptionalMediaUpdateRequiredUIEx";
	else if(id == 0x000007D8)	funcName = "XamShowFirstRunWelcomeUI";
	else if(id == 0x000007D9)	funcName = "XamTaskCreateQueueEx";
	else if(id == 0x000007DA)	funcName = "XamSetDashBackstackData";
	else if(id == 0x000007DB)	funcName = "XamLaunchAvatarEditor";
	else if(id == 0x000007DC)	funcName = "XamGetDashBackstackData";
	else if(id == 0x000007DD)	funcName = "XamGetDashBackstackNodesCount";
	else if(id == 0x000007DE)	funcName = "XamSetLastActiveUserData";
	else if(id == 0x000007DF)	funcName = "XamGetLastActiveUserData";
	else if(id == 0x000007E0)	funcName = "XamSetActiveDashAppInfo";
	else if(id == 0x000007E1)	funcName = "XamGetActiveDashAppInfo";
	else if(id == 0x00000802)	funcName = "XamUserCreateAvatarAssetEnumerator";
	else if(id == 0x00000803)	funcName = "XamInitializeGameTileCache";
	else if(id == 0x00000804)	funcName = "XamDestroyGameTileCache";
	else if(id == 0x00000805)	funcName = "XamReadGameTileImage";
	else if(id == 0x00000806)	funcName = "XamShouldThrottleAccountInfoCall";
	else if(id == 0x00000807)	funcName = "XuiClassDerivesFrom";
	else if(id == 0x00000808)	funcName = "XuiFreeVisuals";
	else if(id == 0x00000809)	funcName = "XuiGetBaseClass";
	else if(id == 0x0000080A)	funcName = "XuiLoadVisualFromBinary";
	else if(id == 0x0000080B)	funcName = "XuiResourceGetBuffer";
	else if(id == 0x0000080C)	funcName = "XuiResourceGetTotalSize";
	else if(id == 0x0000080D)	funcName = "XuiElementGetUserData";
	else if(id == 0x0000080E)	funcName = "XuiElementSetUserData";
	else if(id == 0x0000080F)	funcName = "XuiTabSceneGetCount";
	else if(id == 0x00000810)	funcName = "XuiSliderGetStep";
	else if(id == 0x00000811)	funcName = "XuiSliderSetStep";
	else if(id == 0x00000812)	funcName = "XuiProgressBarGetRange";
	else if(id == 0x00000813)	funcName = "XuiElementSetHittable";
	else if(id == 0x00000814)	funcName = "XuiElementPlayNamedFrames";
	else if(id == 0x00000815)	funcName = "XuiElementGetPivot";
	else if(id == 0x00000816)	funcName = "XuiElementGetPrev";
	else if(id == 0x00000817)	funcName = "XuiElementGetScale";
	else if(id == 0x00000818)	funcName = "XuiElementSetPivot";
	else if(id == 0x00000819)	funcName = "XuiElementSetRotation";
	else if(id == 0x0000081A)	funcName = "XuiElementSetScale";
	else if(id == 0x0000081B)	funcName = "XuiControlWantsUnfocusedInput";
	else if(id == 0x0000081C)	funcName = "XuiResourceOpenNoLoc";
	else if(id == 0x0000081D)	funcName = "XuiResourceReleasePackage";
	else if(id == 0x0000081E)	funcName = "XuiResourceGetPackageEntryInfo";
	else if(id == 0x0000081F)	funcName = "XuiResourceGetPackageEntryCount";
	else if(id == 0x00000820)	funcName = "XuiResourceOpenPackage";
	else if(id == 0x00000821)	funcName = "XamCodeCoverageFileOpen";
	else if(id == 0x00000822)	funcName = "XamCodeCoverageFileClose";
	else if(id == 0x00000823)	funcName = "XamCodeCoverageFileLseek";
	else if(id == 0x00000824)	funcName = "XamCodeCoverageFileRead";
	else if(id == 0x00000825)	funcName = "XamCodeCoverageFileWrite";
	else if(id == 0x00000826)	funcName = "Refresh";
	else if(id == 0x00000827)	funcName = "XampHeapGetInfo";
	else if(id == 0x00000828)	funcName = "XampHeapGetCount";
	else if(id == 0x00000829)	funcName = "XamShowPamUI";
	else if(id == 0x0000082A)	funcName = "XuiElementLayoutTree";
	else if(id == 0x0000082B)	funcName = "XamRegisterScreenSaverCallback";
	else if(id == 0x0000082C)	funcName = "XUIElementPropVal_SetInt";
	else if(id == 0x0000082D)	funcName = "XUIElementPropVal_SetFloat";
	else if(id == 0x0000082E)	funcName = "XuiObjectGetPropertyDef";
	else if(id == 0x0000082F)	funcName = "XuiRenderGetDevice";
	else if(id == 0x00000830)	funcName = "XuiRenderRestoreState";
	else if(id == 0x00000831)	funcName = "XuiElementGetFullXForm";
	else if(id == 0x00000832)	funcName = "XuiRenderGetViewTransform";
	else if(id == 0x00000833)	funcName = "XuiRenderGetColorSpace";
	else if(id == 0x00000834)	funcName = "XamPngEncode";
	else if(id == 0x00000835)	funcName = "XamPngDecode";
	else if(id == 0x00000836)	funcName = "XamPngEncodeEx";
	else if(id == 0x00000837)	funcName = "XuiTextElementMeasureText";
	else if(id == 0x00000838)	funcName = "XamLoaderShouldConfirmReboot";
	else if(id == 0x00000839)	funcName = "XamLoaderRebootToDash";
	else if(id == 0x0000083A)	funcName = "XamNuiHudGetEngagedTrackingID";
	else if(id == 0x0000083B)	funcName = "XamLoaderLaunchTitleForReason";
	else if(id == 0x0000083C)	funcName = "XamNuiHudSetEngagedTrackingID";
	else if(id == 0x0000083E)	funcName = "XamSetupTexture";
	else if(id == 0x00000841)	funcName = "XamSetupCameraPreviewStuff";
	else if(id == 0x00000842)	funcName = "XamReleaseCameraPreviewStuff";
	else if(id == 0x00000843)	funcName = "XamRenderCameraPreviewStuff";
	else if(id == 0x00000848)	funcName = "XamAccountRecoveryGetSetTitleSyncTime";
	else if(id == 0x00000849)	funcName = "XamReadBiometricData";
	else if(id == 0x0000084A)	funcName = "XamWriteBiometricData";
	else if(id == 0x0000084B)	funcName = "XamD3DResourceDescriptorCreate";
	else if(id == 0x0000084C)	funcName = "XamD3DResourceDescriptorAddRef";
	else if(id == 0x0000084D)	funcName = "XamD3DResourceDescriptorRelease";
	else if(id == 0x0000084E)	funcName = "XamD3DResourceAddRef";
	else if(id == 0x0000084F)	funcName = "XamD3DResourceSet";
	else if(id == 0x00000850)	funcName = "XamD3DResourceIsBusy";
	else if(id == 0x00000851)	funcName = "XamD3DResourceRelease";
	else if(id == 0x0000085E)	funcName = "XamNuiEnableChatMic";
	else if(id == 0x0000085F)	funcName = "XamNuiIsChatMicEnabled";
	else if(id == 0x00000860)	funcName = "XamNuiGetDepthCalibration";
	else if(id == 0x00000861)	funcName = "XamNuiStoreDepthCalibration";
	else if(id == 0x00000862)	funcName = "XamUserNuiIsBiometricEnabled";
	else if(id == 0x00000863)	funcName = "XamUserNuiEnableBiometric";
	else if(id == 0x00000864)	funcName = "XamNuiCameraSetFlags";
	else if(id == 0x00000865)	funcName = "XamNuiCameraRememberFloor";
	else if(id == 0x00000866)	funcName = "XamUserNuiGetUserIndexForBind";
	else if(id == 0x00000867)	funcName = "XamUserNuiGetUserIndexForSignin";
	else if(id == 0x00000868)	funcName = "XamUserNuiBind";
	else if(id == 0x00000869)	funcName = "XamUserNuiGetUserIndex";
	else if(id == 0x0000086A)	funcName = "XamUserNuiGetEnrollmentIndex";
	else if(id == 0x0000086B)	funcName = "XamUserNuiUnbind";
	else if(id == 0x0000086C)	funcName = "XamNuiIdentityGetQualityFlagsMessage";
	else if(id == 0x0000086D)	funcName = "XamNuiCameraTiltSetCallback";
	else if(id == 0x0000086E)	funcName = "XamNuiHudIsEnabled";
	else if(id == 0x0000086F)	funcName = "XamNuiCameraGetTiltControllerType";
	else if(id == 0x00000870)	funcName = "XamNuiCameraTiltGetStatus";
	else if(id == 0x00000871)	funcName = "XamNuiIdentityGetQualityFlags";
	else if(id == 0x00000872)	funcName = "XamNuiIdentityEnrollForSignIn";
	else if(id == 0x00000873)	funcName = "XamNuiIdentityGetSessionId";
	else if(id == 0x00000874)	funcName = "XamNuiIdentityIdentifyWithBiometric";
	else if(id == 0x00000875)	funcName = "ControlPackGetHandleManager";
	else if(id == 0x00000876)	funcName = "XamEnableNuiAutomation";
	else if(id == 0x00000877)	funcName = "XamNuiGetSystemGestureControl";
	else if(id == 0x00000878)	funcName = "XamGetPasscodeKeyFromVirtualKey";
	else if(id == 0x00000879)	funcName = "XamEnableNatalPlayback";
	else if(id == 0x0000087A)	funcName = "XamIsNuiAutomationEnabled";
	else if(id == 0x0000087B)	funcName = "XamIsNatalPlaybackEnabled";
	else if(id == 0x0000087C)	funcName = "XamNuiHudInterpretFrame";
	else if(id == 0x0000087D)	funcName = "XamNuiHudEnableInputFilter";
	else if(id == 0x0000087E)	funcName = "ControlpackNuiCursorSetTrackingId";
	else if(id == 0x0000087F)	funcName = "XamNuiHudGetInitializeFlags";
	else if(id == 0x00000880)	funcName = "XamNuiCameraElevationSetAngle";
	else if(id == 0x00000881)	funcName = "XamNuiCameraElevationGetAngle";
	else if(id == 0x00000882)	funcName = "XamNuiCameraElevationAutoTilt";
	else if(id == 0x00000883)	funcName = "XamNuiCameraElevationStopMovement";
	else if(id == 0x00000884)	funcName = "XamNuiCameraElevationSetCallback";
	else if(id == 0x00000885)	funcName = "XamNuiGetDeviceStatus";
	else if(id == 0x00000886)	funcName = "XamNuiNatalCameraUpdateStarting";
	else if(id == 0x00000887)	funcName = "XamNuiNatalCameraUpdateComplete";
	else if(id == 0x00000888)	funcName = "XamNuiHudGetVersions";
	else if(id == 0x00000889)	funcName = "XamGetHUDElementByPath";
	else if(id == 0x0000088A)	funcName = "XamGetHUDElementByAutoId";
	else if(id == 0x0000088B)	funcName = "XuiElementGetScreenPositionCenter";
	else if(id == 0x0000088C)	funcName = "XamNuiCameraElevationReverseAutoTilt";
	else if(id == 0x0000088D)	funcName = "ControlPackSimpleCursorGetRayFromScreenPosition";
	else if(id == 0x0000088E)	funcName = "ControlPackSideNavControlGetNuiHandle";
	else if(id == 0x0000088F)	funcName = "XamFindHUDElementByXuiId";
	else if(id == 0x00000890)	funcName = "XamNuiIsDeviceReady";
	else if(id == 0x00000891)	funcName = "XamNuiSetForceDeviceOff";
	else if(id == 0x00000892)	funcName = "XamNuiPlayerEngagementUpdate";
	else if(id == 0x00000893)	funcName = "XamNuiSkeletonGetBestSkeletonIndex";
	else if(id == 0x00000894)	funcName = "XamNuiSkeletonScoreUpdate";
	else if(id == 0x00000895)	funcName = "XamNuiCameraTiltReportStatus";
	else if(id == 0x00000896)	funcName = "XamNuiCameraAdjustTilt";
	else if(id == 0x00000898)	funcName = "D3DDevice_CreateVertexShader";
	else if(id == 0x00000899)	funcName = "D3DDevice_CreatePixelShader";
	else if(id == 0x0000089A)	funcName = "D3DDevice_CreateTexture";
	else if(id == 0x0000089B)	funcName = "D3DDevice_CreateVertexBuffer";
	else if(id == 0x0000089C)	funcName = "D3DDevice_CreateIndexBuffer";
	else if(id == 0x0000089D)	funcName = "D3DDevice_CreateVertexDeclaration";
	else if(id == 0x0000089E)	funcName = "D3DVertexBuffer_Unlock";
	else if(id == 0x0000089F)	funcName = "D3DVertexBuffer_Lock";
	else if(id == 0x000008A0)	funcName = "D3DIndexBuffer_Unlock";
	else if(id == 0x000008A1)	funcName = "D3DIndexBuffer_Lock";
	else if(id == 0x000008A2)	funcName = "D3DTexture_UnlockRect";
	else if(id == 0x000008A3)	funcName = "D3DTexture_LockRect";
	else if(id == 0x000008A4)	funcName = "D3DDevice_Clear";
	else if(id == 0x000008A5)	funcName = "D3DDevice_SetViewport";
	else if(id == 0x000008A6)	funcName = "D3DDevice_GetViewport";
	else if(id == 0x000008A7)	funcName = "D3DVertexShader_Release";
	else if(id == 0x000008A8)	funcName = "D3DPixelShader_Release";
	else if(id == 0x000008A9)	funcName = "D3DVertexDeclaration_Release";
	else if(id == 0x000008AA)	funcName = "D3DResource_Release";
	else if(id == 0x000008AB)	funcName = "D3DDevice_Release";
	else if(id == 0x000008AC)	funcName = "D3DDevice_SetVertexShader";
	else if(id == 0x000008AD)	funcName = "D3DDevice_SetPixelShader";
	else if(id == 0x000008AE)	funcName = "D3DDevice_SetTexture";
	else if(id == 0x000008AF)	funcName = "D3DDevice_SetVertexDeclaration";
	else if(id == 0x000008B0)	funcName = "D3DDevice_SetIndices";
	else if(id == 0x000008B1)	funcName = "D3DDevice_SetStreamSource";
	else if(id == 0x000008B2)	funcName = "D3DDevice_DrawVertices";
	else if(id == 0x000008B3)	funcName = "D3DDevice_DrawVerticesUP";
	else if(id == 0x000008B4)	funcName = "D3DDevice_DrawIndexedVertices";
	else if(id == 0x000008B5)	funcName = "D3DDevice_DrawIndexedVerticesUP";
	else if(id == 0x000008B6)	funcName = "D3DDevice_SetVertexShaderConstantF_ParameterCheck";
	else if(id == 0x000008B7)	funcName = "D3DDevice_SetPixelShaderConstantF_ParameterCheck";
	else if(id == 0x000008B8)	funcName = "D3DDevice_SetSamplerState_ParameterCheck";
	else if(id == 0x000008B9)	funcName = "D3DDevice_SetRenderState_ParameterCheck";
	else if(id == 0x000008BA)	funcName = "D3DDevice_GetRenderState_ParameterCheck";
	else if(id == 0x000008BB)	funcName = "D3DDevice_SetVertexShaderConstantFN";
	else if(id == 0x000008BC)	funcName = "D3DDevice_SetPixelShaderConstantFN";
	else if(id == 0x000008BD)	funcName = "D3DDevice_GetRenderState_ZEnable";
	else if(id == 0x000008BE)	funcName = "D3DDevice_GetRenderState_CullMode";
	else if(id == 0x000008BF)	funcName = "D3DDevice_GetRenderState_AlphaBlendEnable";
	else if(id == 0x000008C0)	funcName = "D3DDevice_GetRenderState_SrcBlendAlpha";
	else if(id == 0x000008C1)	funcName = "D3DDevice_GetRenderState_DestBlendAlpha";
	else if(id == 0x000008C2)	funcName = "D3DDevice_GetRenderState_BlendOp";
	else if(id == 0x000008C3)	funcName = "D3DDevice_GetRenderState_ViewportEnable";
	else if(id == 0x000008C4)	funcName = "D3DDevice_SetRenderState_ZEnable";
	else if(id == 0x000008C5)	funcName = "D3DDevice_SetRenderState_CullMode";
	else if(id == 0x000008C6)	funcName = "D3DDevice_SetRenderState_AlphaBlendEnable";
	else if(id == 0x000008C7)	funcName = "D3DDevice_SetRenderState_SrcBlendAlpha";
	else if(id == 0x000008C8)	funcName = "D3DDevice_SetRenderState_DestBlendAlpha";
	else if(id == 0x000008C9)	funcName = "D3DDevice_SetRenderState_BlendOp";
	else if(id == 0x000008CA)	funcName = "D3DDevice_SetRenderState_ViewportEnable";
	else if(id == 0x000008CB)	funcName = "D3DDevice_SetSamplerState_MagFilter";
	else if(id == 0x000008CC)	funcName = "D3DDevice_SetSamplerState_MinFilter";
	else if(id == 0x000008CD)	funcName = "D3DDevice_SetSamplerState_AddressU";
	else if(id == 0x000008CE)	funcName = "D3DDevice_SetSamplerState_AddressV";
	else if(id == 0x000008CF)	funcName = "XGSetTextureHeader";
	else if(id == 0x000008D0)	funcName = "XGGetTextureDesc";
	else if(id == 0x000008D1)	funcName = "XGOffsetResourceAddress";
	else if(id == 0x000008D2)	funcName = "D3DResource_AddRef";
	else if(id == 0x000008D3)	funcName = "D3DVertexShader_AddRef";
	else if(id == 0x000008D4)	funcName = "D3DPixelShader_AddRef";
	else if(id == 0x000008D5)	funcName = "D3DVertexDeclaration_AddRef";
	else if(id == 0x000008D6)	funcName = "XGSetTextureHeaderEx";
	else if(id == 0x000008D7)	funcName = "D3DDevice_GetRenderTarget";
	else if(id == 0x000008D8)	funcName = "D3DDevice_SetRenderTarget";
	else if(id == 0x000008D9)	funcName = "D3DDevice_GetDepthStencilSurface";
	else if(id == 0x000008DA)	funcName = "D3DDevice_SetDepthStencilSurface";
	else if(id == 0x000008DB)	funcName = "D3DDevice_Resolve";
	else if(id == 0x000008DC)	funcName = "D3DDevice_SetPixelShaderConstantB";
	else if(id == 0x000008DD)	funcName = "XamNuiGetDeviceSerialNumber";
	else if(id == 0x000008FC)	funcName = "XamXtwManagerGetVariableCount";
	else if(id == 0x000008FD)	funcName = "XamXtwManagerGetId";
	else if(id == 0x000008FE)	funcName = "XamXtwManagerGetValue";
	else if(id == 0x000008FF)	funcName = "XamXtwManagerSetValue";
	else if(id == 0x00000900)	funcName = "XamXtwManagerIncrement";
	else if(id == 0x00000901)	funcName = "XamXtwManagerDecrement";
	else if(id == 0x00000902)	funcName = "XamXtwManagerResetValue";
	else if(id == 0x00000903)	funcName = "XamXtwManagerResetAll";
	else if(id == 0x00000904)	funcName = "XamXtwManagerGetDataFilePath";
	else if(id == 0x00000905)	funcName = "XamXtwManagerDeleteDataFile";
	else if(id == 0x00000906)	funcName = "XamXtwManagerSave";
	else if(id == 0x00000907)	funcName = "XamXtwManagerLoad";
	else if(id == 0x00000908)	funcName = "XamGetXTweakManager";
	else if(id == 0x000009C4)	funcName = "XamBackgroundDownloadSetMode";
	else if(id == 0x000009C5)	funcName = "XamBackgroundDownloadIsEnabled";
	else if(id == 0x000009C6)	funcName = "XamBackgroundDownloadGetActiveItem";
	else if(id == 0x000009C7)	funcName = "XamBackgroundDownloadGetItems";
	else if(id == 0x000009C8)	funcName = "XamBackgroundDownloadClearItems";
	else if(id == 0x000009C9)	funcName = "XamBackgroundDownloadItemAdd";
	else if(id == 0x000009CA)	funcName = "XamBackgroundDownloadItemRemove";
	else if(id == 0x000009CB)	funcName = "XamBackgroundDownloadItemMakeFirst";
	else if(id == 0x000009CC)	funcName = "XamBackgroundDownloadSetForegroundPriority";
	else if(id == 0x000009CD)	funcName = "XamBackgroundDownloadGetForegroundPriority";
	else if(id == 0x000009CE)	funcName = "XamBackgroundDownloadItemToContentData";
	else if(id == 0x000009CF)	funcName = "XamBackgroundDownloadItemGetStatus";
	else if(id == 0x000009D0)	funcName = "XamBackgroundDownloadHistoryGetItem";
	else if(id == 0x000009D1)	funcName = "XamBackgroundDownloadItemGetHistoryStatus";
	else if(id == 0x000009D2)	funcName = "XamBackgroundDownloadItemSetHistoryStatus";
	else if(id == 0x000009D3)	funcName = "XamBackgroundDownloadItemGetStatusAsync";
	else if(id == 0x000009D4)	funcName = "XamBackgroundDownloadItemGetStatusEx";
	else if(id == 0x000009D5)	funcName = "XamBackgroundDownloadItemGetHistoryStatusEx";
	else if(id == 0x000009D6)	funcName = "XamBackgroundDownloadBindItems";
	else if(id == 0x000009D7)	funcName = "XamBackgroundDownloadSetPollingActive";
	else if(id == 0x000009D8)	funcName = "XamBackgroundDownloadGetPollingActive";
	else if(id == 0x000009D9)	funcName = "XamBackgroundDownloadGetMode";
	else if(id == 0x000009DA)	funcName = "XamBackgroundDownloadGetUnexpectedChangeCount";
	else if(id == 0x000009DB)	funcName = "XamBackgroundDownloadIsItemForThisConsole";
	else if(id == 0x000009DC)	funcName = "XamBackgroundDownloadSelectDevice";
	else if(id == 0x000009DD)	funcName = "XamBackgroundDownloadItemModify";
	else if(id == 0x000009DE)	funcName = "XamBackgroundDownloadCacheLegacyMappingInfo";
	else if(id == 0x000009DF)	funcName = "XamBackgroundDownloadGetLegacyMappingInfo";
	else if(id == 0x000009E0)	funcName = "XamBackgroundDownloadGetLegacyId";
	else if(id == 0x000009E1)	funcName = "XamBackgroundDownloadDoFail";
	else if(id == 0x00000A28)	funcName = "XamSwapDisc";
	else if(id == 0x00000A29)	funcName = "XamSwapDiscPatchAddress";
	else if(id == 0x00000A2A)	funcName = "XamSwapCancel";
	else if(id == 0x00000A32)	funcName = "XamRamDriveCreate";
	else if(id == 0x00000A33)	funcName = "XamRamDriveDestroy";
	else if(id == 0x00000A5A)	funcName = "XamPlayTimerGetData";
	else if(id == 0x00000A5B)	funcName = "XamPlayTimerSetData";
	else if(id == 0x00000A5C)	funcName = "XamPlayTimerResume";
	else if(id == 0x00000A5D)	funcName = "XamPlayTimerSuspend";
	else if(id == 0x00000A5E)	funcName = "XamPlayTimerIsRunning";
	else if(id == 0x00000A5F)	funcName = "XamPlayTimerIsEnabled";
	else if(id == 0x00000A60)	funcName = "XamPlayTimerGetNextResetDate";
	else if(id == 0x00000A61)	funcName = "XamPlayTimerFormatDurationString";
	else if(id == 0x00000A62)	funcName = "XamPlayTimerGetTimeRemaining";
	else if(id == 0x00000A63)	funcName = "XamPlayTimerUpdateTimeRemaining";
	else if(id == 0x00000A64)	funcName = "XamPlayTimerForceNotification";
	else if(id == 0x00000A65)	funcName = "XamPlayTimerRefreshResetDate";
	else if(id == 0x00000A6E)	funcName = "UpnpAVServerSearchInitialize";
	else if(id == 0x00000A6F)	funcName = "UpnpAVServerSearchDestroy";
	else if(id == 0x00000A70)	funcName = "UpnpAVServerSearchStart";
	else if(id == 0x00000A71)	funcName = "Destroy";
	else if(id == 0x00000A72)	funcName = "UpnpAVServerSearchDoWork";
	else if(id == 0x00000A73)	funcName = "UpnpAVServerSearchGetNextServer";
	else if(id == 0x00000A8C)	funcName = "XCustomBroadcastGamercardEvent";
	else if(id == 0x00000A8D)	funcName = "XamCustomGetCurrentActions";
	else if(id == 0x00000AA0)	funcName = "XamInstrumentationLogEvent";
	else if(id == 0x00000AA1)	funcName = "XamRegisterSMCNotification";
	else if(id == 0x00000AAA)	funcName = "XamInstrumentationLogEventEx";
	else if(id == 0x00000AAB)	funcName = "XamInstrumentationGetSourceConfig";
	else if(id == 0x00000AAC)	funcName = "XamInstrumentationDebugConfig";
	else if(id == 0x00000ADC)	funcName = "CurlCreateCacheEntry";
	else if(id == 0x00000ADD)	funcName = "CurlOpenCacheEntry";
	else if(id == 0x00000ADE)	funcName = "CurlSetCacheEntryExpireTime";
	else if(id == 0x00000ADF)	funcName = "CurlReadCacheEntryHeaders";
	else if(id == 0x00000AE0)	funcName = "CurlReadCacheEntryContent";
	else if(id == 0x00000AE1)	funcName = "CurlWriteCacheEntryContent";
	else if(id == 0x00000AE2)	funcName = "CurlCloseCacheEntry";
	else if(id == 0x00000AE3)	funcName = "CurlEnumerateCacheEntry";
	else if(id == 0x00000AE5)	funcName = "CurlWipeBackingFiles";
	else if(id == 0x00000AE7)	funcName = "CurlOpenTitleBackingFile";
	else if(id == 0x00000AF0)	funcName = "XamSetSecurityViolationDetected";
	else if(id == 0x00000AF1)	funcName = "XamIsSecurityViolationDetected";
	else if(id == 0x00000AF2)	funcName = "XamIsAnySecurityViolationDetected";
	else if(id == 0x00000AF3)	funcName = "XamGetSecurityViolationsDetected";
	else if(id == 0x00000AF4)	funcName = "XamActivateCounterMeasure";
	else if(id == 0x00000AF5)	funcName = "XamDeactivateCounterMeasure";
	else if(id == 0x00000AF6)	funcName = "XamIsCounterMeasureActivated";
	else if(id == 0x00000AF7)	funcName = "XamGetActiveCounterMeasures";
	else if(id == 0x00000AFC)	funcName = "XamPartyCreate";
	else if(id == 0x00000AFD)	funcName = "XamPartyLeave";
	else if(id == 0x00000AFE)	funcName = "XamPartySendInviteDeprecated";
	else if(id == 0x00000AFF)	funcName = "XamPartyGetUserList";
	else if(id == 0x00000B00)	funcName = "XamPartySendGameInvites";
	else if(id == 0x00000B01)	funcName = "XamPartyJoin";
	else if(id == 0x00000B02)	funcName = "XamPartyKickUser";
	else if(id == 0x00000B03)	funcName = "XamPartyAddLocalUsers";
	else if(id == 0x00000B04)	funcName = "XamConvertEmoticons";
	else if(id == 0x00000B05)	funcName = "XamGetLocaleTimeFormat";
	else if(id == 0x00000B06)	funcName = "XamPartyRemoveLocalUsers";
	else if(id == 0x00000B07)	funcName = "XamPartyGetUserListInternal";
	else if(id == 0x00000B08)	funcName = "XamPartySetJoinable";
	else if(id == 0x00000B09)	funcName = "XamPartyGetJoinable";
	else if(id == 0x00000B0A)	funcName = "XamPartyGetInfo";
	else if(id == 0x00000B0B)	funcName = "XamPartySetCustomData";
	else if(id == 0x00000B0C)	funcName = "XamPartySetConnectivityGraph";
	else if(id == 0x00000B0D)	funcName = "XamPartyGetRoutingTable";
	else if(id == 0x00000B0E)	funcName = "XamPartyAutomationInprocCall";
	else if(id == 0x00000B0F)	funcName = "XamPartyGetState";
	else if(id == 0x00000B10)	funcName = "XamPartyGetBandwidth";
	else if(id == 0x00000B11)	funcName = "XamPartyGetNetworkCounters";
	else if(id == 0x00000B12)	funcName = "XamShowQuickLaunchUI";
	else if(id == 0x00000B13)	funcName = "XamPartyIsCoordinator";
	else if(id == 0x00000B14)	funcName = "XamPartyGetFormation";
	else if(id == 0x00000B15)	funcName = "XamPartySendInvite";
	else if(id == 0x00000B16)	funcName = "XamPartySetTestDelay";
	else if(id == 0x00000B17)	funcName = "XamPartyOverrideNatType";
	else if(id == 0x00000B18)	funcName = "XamPartyGetAccessLevel";
	else if(id == 0x00000B19)	funcName = "XamPartySetTestFlags";
	else if(id == 0x00000B1A)	funcName = "XamIsSystemExperienceTitleId";
	else if(id == 0x00000B22)	funcName = "XamTaskSetCancelSubTasks";
	else if(id == 0x00000B23)	funcName = "XamTaskGetCompletionStatus";
	else if(id == 0x00000B24)	funcName = "XamTaskCancelWaitAndCloseWaitTask";
	else if(id == 0x00000B2C)	funcName = "XamWebInstrumentationCreateReport";
	else if(id == 0x00000B2D)	funcName = "XamWebInstrumentationSetUserVar";
	else if(id == 0x00000B2E)	funcName = "XamWebInstrumentationSetUserVarNoEscape";
	else if(id == 0x00000B2F)	funcName = "XamWebInstrumentationGetURL";
	else if(id == 0x00000B30)	funcName = "XamWebInstrumentationSendReport";
	else if(id == 0x00000B31)	funcName = "XamWebInstrumentationDestroyReport";
	else if(id == 0x00000B32)	funcName = "XamWebInstrumentationCreateSampledReport";
	else if(id == 0x00000B33)	funcName = "XampSetSamplingRandomValue";
	else if(id == 0x00000B34)	funcName = "XampWebInstrumentationSetProfileCounts";
	else if(id == 0x00000B35)	funcName = "XamWebInstrumentationGetURLEx";
	else if(id == 0x00000B36)	funcName = "XampSetOmnitureCallbackFunction";
	else if(id == 0x00000B37)	funcName = "XamShowQuickChatUIp";
	else if(id == 0x00000B4A)	funcName = "XamVerifyXSignerSignature";
	
	return funcName;
}


static xapiNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "XapiProcessHeap";
	else if(id == 0x00000002)	funcName = "_locktable";
	else if(id == 0x00000003)	funcName = "__tlsindexXapi";
	else if(id == 0x00000004)	funcName = "XapiTermHeapNoop";
	else if(id == 0x00000005)	funcName = "XapiDebugHeap";
	
	return funcName;
}


static xbdmNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "DmAllocatePool";
	else if(id == 0x00000002)	funcName = "DmAllocatePoolWithTag";
	else if(id == 0x00000003)	funcName = "DmCloseCounters";
	else if(id == 0x00000004)	funcName = "DmCloseModuleSections";
	else if(id == 0x00000005)	funcName = "DmCloseModuleSections";
	else if(id == 0x00000006)	funcName = "DmCloseNotificationSession";
	else if(id == 0x00000007)	funcName = "DmClosePerformanceCounter";
	else if(id == 0x00000008)	funcName = "DmContinueThread";
	else if(id == 0x00000009)	funcName = "DmFreePool";
	else if(id == 0x0000000A)	funcName = "DmGetMemory";
	else if(id == 0x0000000B)	funcName = "DmGetModuleLongName";
	else if(id == 0x0000000C)	funcName = "DmGetProcAddress";
	else if(id == 0x0000000D)	funcName = "DmGetThreadContext";
	else if(id == 0x0000000F)	funcName = "DmGetThreadList";
	else if(id == 0x00000010)	funcName = "DmGetXbeInfo";
	else if(id == 0x00000011)	funcName = "DmGetXboxName";
	else if(id == 0x00000013)	funcName = "DmGo";
	else if(id == 0x00000014)	funcName = "DmHaltThread";
	else if(id == 0x00000015)	funcName = "DmIsDebuggerPresent";
	else if(id == 0x00000016)	funcName = "DmIsThreadStopped";
	else if(id == 0x00000017)	funcName = "DmLoadExtension";
	else if(id == 0x00000018)	funcName = "DmNotify";
	else if(id == 0x00000019)	funcName = "DmOpenNotificationSession";
	else if(id == 0x0000001A)	funcName = "DmOpenPerformanceCounter";
	else if(id == 0x0000001B)	funcName = "DmQueryPerformanceCounterHandle";
	else if(id == 0x0000001C)	funcName = "DmReboot";
	else if(id == 0x0000001E)	funcName = "DmRegisterCommandProcessor";
	else if(id == 0x00000020)	funcName = "DmRegisterNotificationProcessor";
	else if(id == 0x00000021)	funcName = "DmRegisterPerformanceCounter";
	else if(id == 0x00000022)	funcName = "DmRemoveBreakpoint";
	else if(id == 0x00000023)	funcName = "DmResumeThread";
	else if(id == 0x00000024)	funcName = "DmSendNotificationString";
	else if(id == 0x00000025)	funcName = "DmSetBreakpoint";
	else if(id == 0x00000026)	funcName = "DmSetDataBreakpoint";
	else if(id == 0x00000027)	funcName = "DmSetInitialBreakpoint";
	else if(id == 0x00000028)	funcName = "DmSetMemory";
	else if(id == 0x00000029)	funcName = "DmSetThreadContext";
	else if(id == 0x0000002A)	funcName = "DmSetTitle";
	else if(id == 0x0000002B)	funcName = "DmSetXboxName";
	else if(id == 0x0000002D)	funcName = "DmStop";
	else if(id == 0x0000002E)	funcName = "DmStopOn";
	else if(id == 0x00000030)	funcName = "DmSuspendThread";
	else if(id == 0x00000031)	funcName = "DmThreadUserData";
	else if(id == 0x00000032)	funcName = "DmUnloadExtension";
	else if(id == 0x00000033)	funcName = "DmWalkLoadedModules";
	else if(id == 0x00000034)	funcName = "DmWalkModuleSections";
	else if(id == 0x00000035)	funcName = "DmWalkPerformanceCounters";
	else if(id == 0x00000037)	funcName = "DmCloseCounters";
	else if(id == 0x00000038)	funcName = "DmIsBreakpoint";
	else if(id == 0x00000039)	funcName = "DmCloseCounters";
	else if(id == 0x0000003A)	funcName = "DmSetUserAccess";
	else if(id == 0x0000003B)	funcName = "DmGetUserAccess";
	else if(id == 0x0000003C)	funcName = "DmWalkUserList";
	else if(id == 0x0000003D)	funcName = "DmAddUser";
	else if(id == 0x0000003E)	funcName = "DmEnableSecurity";
	else if(id == 0x0000003F)	funcName = "DmIsSecurityEnabled";
	else if(id == 0x00000040)	funcName = "DmRemoveUser";
	else if(id == 0x00000041)	funcName = "__CAP_Start_Profiling";
	else if(id == 0x00000042)	funcName = "__CAP_End_Profiling";
	else if(id == 0x00000046)	funcName = "__CAP_Enter_Function";
	else if(id == 0x00000047)	funcName = "__CAP_Exit_Function";
	else if(id == 0x00000048)	funcName = "DmRegisterCommandProcessorEx";
	else if(id == 0x00000049)	funcName = "DmStartProfiling";
	else if(id == 0x0000004A)	funcName = "DmStopProfiling";
	else if(id == 0x0000004B)	funcName = "DmQueryMemoryStatistics";
	else if(id == 0x0000004C)	funcName = "DmEnableStackTrace";
	else if(id == 0x0000004D)	funcName = "DmQueryAllocationTypeName";
	else if(id == 0x0000004E)	funcName = "DmRegisterAllocationType";
	else if(id == 0x0000004F)	funcName = "DmInsertAllocationEntry";
	else if(id == 0x00000050)	funcName = "DmRemoveAllocationEntry";
	else if(id == 0x00000051)	funcName = "DmSetTitleEx";
	else if(id == 0x00000052)	funcName = "DmCaptureStackBackTrace";
	else if(id == 0x00000053)	funcName = "DmCrashDump";
	else if(id == 0x00000054)	funcName = "DmIsFastCAPEnabled";
	else if(id == 0x00000055)	funcName = "DmGetFileAccessCount";
	else if(id == 0x00000058)	funcName = "DmGetUtilityDriveInfo";
	else if(id == 0x00000059)	funcName = "DmGetThreadInfoEx";
	else if(id == 0x0000005A)	funcName = "DmSetProfilingOptions";
	else if(id == 0x0000005B)	funcName = "DmQuerySystemSettings";
	else if(id == 0x0000005C)	funcName = "DmSaveSystemSettings";
	else if(id == 0x0000006A)	funcName = "DmpGetPgoModuleHandleForBaseAddress";
	else if(id == 0x0000006B)	funcName = "DmpOnPgoModuleLoad";
	else if(id == 0x0000006C)	funcName = "DmPgoStartDataCollection";
	else if(id == 0x0000006D)	funcName = "DmPgoStopDataCollection";
	else if(id == 0x0000006E)	funcName = "DmPgoSaveSnapshot";
	else if(id == 0x0000006F)	funcName = "IrtClientAbort";
	else if(id == 0x00000070)	funcName = "IrtPogoInit";
	else if(id == 0x00000071)	funcName = "IrtSetStaticInfo";
	else if(id == 0x00000072)	funcName = "IrtAutoSweepW";
	else if(id == 0x00000073)	funcName = "IrtAutoSweepA";
	else if(id == 0x00000075)	funcName = "DmGetDumpMode";
	else if(id == 0x00000076)	funcName = "DmSetDumpMode";
	else if(id == 0x00000077)	funcName = "DmGetDumpSettings";
	else if(id == 0x00000078)	funcName = "DmSetDumpSettings";
	else if(id == 0x00000079)	funcName = "DmGetEventDeferFlags";
	else if(id == 0x0000007A)	funcName = "DmSetEventDeferFlags";
	else if(id == 0x0000007B)	funcName = "DmWalkCommittedMemory";
	else if(id == 0x0000007C)	funcName = "DmCloseCounters";
	else if(id == 0x0000007D)	funcName = "DmRebootEx";
	else if(id == 0x00000082)	funcName = "DmMountFdfxVolume";
	else if(id == 0x00000083)	funcName = "DmCapGetFileHeader";
	else if(id == 0x00000084)	funcName = "DmCapFreeFileHeader";
	else if(id == 0x00000085)	funcName = "DmTraceStartRecording";
	else if(id == 0x00000086)	funcName = "DmTraceStartRecordingFunction";
	else if(id == 0x00000087)	funcName = "DmTraceSetBufferSize";
	else if(id == 0x00000088)	funcName = "DmTraceStopRecording";
	else if(id == 0x00000089)	funcName = "DmTraceSaveBuffer";
	else if(id == 0x0000008C)	funcName = "DmGetConsoleType";
	else if(id == 0x0000008D)	funcName = "DmMapDevkitDrive";
	else if(id == 0x0000008E)	funcName = "DmWalkLoadedModulesEx";
	else if(id == 0x0000008F)	funcName = "DmGetXexHeaderField";
	else if(id == 0x00000090)	funcName = "DmGetMouseChanges";
	else if(id == 0x00000091)	funcName = "DmFindPdbSignature";
	else if(id == 0x00000092)	funcName = "DmGetProfilingStatus";
	else if(id == 0x00000093)	funcName = "DmOpticalDiscLogStart";
	else if(id == 0x00000094)	funcName = "DmOpticalDiscLogStop";
	else if(id == 0x00000095)	funcName = "DmStartSamplingProfiler";
	else if(id == 0x00000096)	funcName = "DmStopSamplingProfiler";
	else if(id == 0x00000097)	funcName = "DmGetSamplingProfilerInfo";
	else if(id == 0x00000098)	funcName = "DmStartFileEventCapture";
	else if(id == 0x00000099)	funcName = "DmStopFileEventCapture";
	else if(id == 0x0000009A)	funcName = "DmSetFileEventMarker";
	else if(id == 0x0000009B)	funcName = "DmMarkPseudoCreateBegin";
	else if(id == 0x0000009C)	funcName = "DmMarkPseudoCreateEnd";
	else if(id == 0x0000009D)	funcName = "DmMarkPseudoEventBegin";
	else if(id == 0x0000009E)	funcName = "DmMarkPseudoEventEnd";
	else if(id == 0x0000009F)	funcName = "DmMarkFileEventWorkerThreadBegin";
	else if(id == 0x000000A0)	funcName = "DmMarkFileEventWorkerThreadEnd";
	else if(id == 0x000000A1)	funcName = "DmGetSystemInfo";
	else if(id == 0x000000A2)	funcName = "DmAbortProfiling";
	else if(id == 0x000000A3)	funcName = "DmNetCaptureStart";
	else if(id == 0x000000A4)	funcName = "DmNetCaptureStop";
	else if(id == 0x000000A5)	funcName = "DmQueryTitleMemoryStatistics";
	else if(id == 0x000000A6)	funcName = "DmAutomationGetInputProcess";
	else if(id == 0x000000A7)	funcName = "DmAutomationBindController";
	else if(id == 0x000000A8)	funcName = "DmAutomationUnbindController";
	else if(id == 0x000000A9)	funcName = "DmAutomationConnectController";
	else if(id == 0x000000AA)	funcName = "DmAutomationDisconnectController";
	else if(id == 0x000000AB)	funcName = "DmAutomationSetGamepadState";
	else if(id == 0x000000AC)	funcName = "DmAutomationQueueGamepadState";
	else if(id == 0x000000AD)	funcName = "DmAutomationClearGamepadQueue";
	else if(id == 0x000000AE)	funcName = "DmAutomationQueryGamepadQueue";
	else if(id == 0x000000AF)	funcName = "DmAutomationGetUserDefaultProfile";
	else if(id == 0x000000B0)	funcName = "DmAutomationSetUserDefaultProfile";
	else if(id == 0x000000B1)	funcName = "DmTraceIsRecording";
	else if(id == 0x000000B2)	funcName = "DmLoadDebuggerExtension";
	else if(id == 0x000000B3)	funcName = "DmUnloadDebuggerExtension";
	else if(id == 0x000000B4)	funcName = "DmCreateSystemThread";
	else if(id == 0x000000B5)	funcName = "PEPLELookup";
	else if(id == 0x000000B6)	funcName = "PEPLELookupCompact";
	else if(id == 0x000000B7)	funcName = "PVPLELookup";
	else if(id == 0x000000B8)	funcName = "PVPLELookupCompact";
	else if(id == 0x000000B9)	funcName = "PVPLELookupCompactMDS";
	else if(id == 0x000000BA)	funcName = "PVPLEFilteredLookup";
	else if(id == 0x000000BB)	funcName = "PVPLEFilteredLookupCompact";
	else if(id == 0x000000BC)	funcName = "PVPLEFilteredLookupCompactMDS";
	else if(id == 0x000000BD)	funcName = "PVPLETemplatedLookup";
	else if(id == 0x000000BE)	funcName = "PVPLETemplatedLookupCompact";
	else if(id == 0x000000BF)	funcName = "PVPLETemplatedLookupCompactMDS";
	else if(id == 0x000000C0)	funcName = "DmpPgoCounterOverflow";
	else if(id == 0x000000C1)	funcName = "UpdateMDSProbeState";
	else if(id == 0x000000C2)	funcName = "DmGetHttpRegistration";
	else if(id == 0x000000C3)	funcName = "DmTraceSetIOThread";
	else if(id == 0x000000C4)	funcName = "DmPMCInstallAndStart";
	else if(id == 0x000000C5)	funcName = "DmPMCStopAndReport";
	else if(id == 0x000000C6)	funcName = "DmPMCInstallSetup";
	else if(id == 0x000000C7)	funcName = "DmPMCUnInstallSetup";
	else if(id == 0x000000C8)	funcName = "DmPMCResetCounters";
	else if(id == 0x000000C9)	funcName = "DmPMCSetTriggerProcessor";
	else if(id == 0x000000CA)	funcName = "DmPMCStart";
	else if(id == 0x000000CB)	funcName = "DmPMCStop";
	else if(id == 0x000000CC)	funcName = "DmPMCGetCounter";
	else if(id == 0x000000CD)	funcName = "DmPMCGetCounters";
	else if(id == 0x000000CE)	funcName = "DmPMCGetCounterName";
	else if(id == 0x000000CF)	funcName = "DmPMCDumpCounters";
	else if(id == 0x000000D0)	funcName = "DmPMCDumpCountersVerbose";
	else if(id == 0x000000D1)	funcName = "DmPMCGetCounterCostEstimate";
	else if(id == 0x000000D2)	funcName = "DmPMCGetCounterSource";
	else if(id == 0x000000D3)	funcName = "DmPMCComputeFrequency";
	else if(id == 0x000000D4)	funcName = "DmGetAdditionalTitleMemorySetting";
	else if(id == 0x000000D5)	funcName = "DmGetDebugMemorySize";
	else if(id == 0x000000D6)	funcName = "DmGetConsoleDebugMemoryStatus";
	else if(id == 0x000000D7)	funcName = "DmNetSimSetLinkStatusHidden";
	else if(id == 0x000000D8)	funcName = "DmNetSimInsertQueue";
	else if(id == 0x000000D9)	funcName = "DmNetSimRemoveQueue";
	else if(id == 0x000000DA)	funcName = "DmNetSimRemoveAllQueues";
	else if(id == 0x000000DB)	funcName = "DmNetSimModifyQueueSettings";
	else if(id == 0x000000DC)	funcName = "DmGetConsoleFeatures";
	else if(id == 0x000000DD)	funcName = "DmNetSimGetQueueStats";
	else if(id == 0x000000DE)	funcName = "DmNetSimGetQueueSettings";
	else if(id == 0x000000DF)	funcName = "DmNetSimGetNumQueues";
	else if(id == 0x000000E0)	funcName = "DmNetSimInsertIpv4Redirect";
	else if(id == 0x000000E1)	funcName = "DmNetSimRemoveIpv4Redirect";
	else if(id == 0x000000E2)	funcName = "DmNetSimGetNumIpv4Redirects";
	else if(id == 0x0000012C)	funcName = "XLFAllocate";
	else if(id == 0x0000012D)	funcName = "XLFFree";
	else if(id == 0x0000012E)	funcName = "XLFQueueAdd";
	else if(id == 0x0000012F)	funcName = "XLFQueueAllocated";
	else if(id == 0x00000130)	funcName = "XLFQueueCreate";
	else if(id == 0x00000131)	funcName = "XLFQueueDestroy";
	else if(id == 0x00000132)	funcName = "XLFQueueGetEntryCount";
	else if(id == 0x00000133)	funcName = "XLFQueueIsEmpty";
	else if(id == 0x00000134)	funcName = "XLFQueueRemove";
	else if(id == 0x00000135)	funcName = "XLFQueueUnsafeDump";
	else if(id == 0x00000136)	funcName = "XLFStackAllocated";
	else if(id == 0x00000137)	funcName = "XLFStackCreate";
	else if(id == 0x00000138)	funcName = "XLFStackDestroy";
	else if(id == 0x00000139)	funcName = "XLFStackGetEntryCount";
	else if(id == 0x0000013A)	funcName = "XLFStackIsEmpty";
	else if(id == 0x0000013B)	funcName = "XLFStackPop";
	else if(id == 0x0000013C)	funcName = "XLFStackPush";
	else if(id == 0x0000013D)	funcName = "XLFStackUnsafeDump";
	else if(id == 0x00000140)	funcName = "XLFPriorityQueueAdd";
	else if(id == 0x00000141)	funcName = "XLFPriorityQueueAllocated";
	else if(id == 0x00000142)	funcName = "XLFPriorityQueueCreate";
	else if(id == 0x00000143)	funcName = "XLFPriorityQueueDestroy";
	else if(id == 0x00000144)	funcName = "XLFPriorityQueueGetEntryCount";
	else if(id == 0x00000145)	funcName = "XLFPriorityQueueIsEmpty";
	else if(id == 0x00000146)	funcName = "XLFPriorityQueueRemoveFirst";
	else if(id == 0x00000147)	funcName = "XLFPriorityQueueRemove";
	else if(id == 0x00000148)	funcName = "XLFPriorityQueueUnsafeDump";
	else if(id == 0x0000014A)	funcName = "XLFHashTableAdd";
	else if(id == 0x0000014B)	funcName = "XLFHashTableAllocated";
	else if(id == 0x0000014C)	funcName = "XLFHashTableCreate";
	else if(id == 0x0000014D)	funcName = "XLFHashTableDestroy";
	else if(id == 0x0000014E)	funcName = "XLFHashTableGetEntryCount";
	else if(id == 0x0000014F)	funcName = "XLFHashTableIsEmpty";
	else if(id == 0x00000150)	funcName = "XLFHashTableRemoveFirst";
	else if(id == 0x00000151)	funcName = "XLFHashTableRemove";
	else if(id == 0x00000152)	funcName = "XLFHashTableUnsafeDump";
	else if(id == 0x00000154)	funcName = "XLFPoolAcquireLock";
	else if(id == 0x00000155)	funcName = "XLFPoolAllocated";
	else if(id == 0x00000156)	funcName = "XLFPoolCreate";
	else if(id == 0x00000157)	funcName = "XLFPoolCreateLock";
	else if(id == 0x00000158)	funcName = "XLFPoolDestroy";
	else if(id == 0x00000159)	funcName = "XLFPoolDestroyLock";
	else if(id == 0x0000015A)	funcName = "XLFPoolIncreaseEvents";
	else if(id == 0x0000015B)	funcName = "XLFPoolIncreaseLocks";
	else if(id == 0x0000015C)	funcName = "XLFPoolInitializeLock";
	else if(id == 0x0000015D)	funcName = "XLFPoolNumberOfEvents";
	else if(id == 0x0000015E)	funcName = "XLFPoolNumberOfLocks";
	else if(id == 0x0000015F)	funcName = "XLFPoolReleaseLock";
	else if(id == 0x00000163)	funcName = "XLFStartLog";
	else if(id == 0x00000164)	funcName = "XLFStartUserLog";
	else if(id == 0x00000165)	funcName = "XLFInitializeLog";
	else if(id == 0x00000166)	funcName = "XLFInitializeUserLog";
	else if(id == 0x00000168)	funcName = "XLFEndLog";
	else if(id == 0x00000169)	funcName = "XLFLogPrint";
	else if(id == 0x0000016A)	funcName = "XLFLogPrintV";
	else if(id == 0x0000016B)	funcName = "XLFLogBuffer";
	else if(id == 0x0000016C)	funcName = "XLFLogMessageStats";
	else if(id == 0x00000172)	funcName = "XLockFreeGetErrorHandler";
	else if(id == 0x00000173)	funcName = "XLockFreeSetErrorHandler";
	
	return funcName;
}


static xboxkrnlNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000001)	funcName = "DbgBreakPoint";
	else if(id == 0x00000002)	funcName = "DbgBreakPointWithStatus";
	else if(id == 0x00000003)	funcName = "DbgPrint";
	else if(id == 0x00000004)	funcName = "DbgPrompt";
	else if(id == 0x00000005)	funcName = "DumpGetRawDumpInfo";
	else if(id == 0x00000006)	funcName = "DumpWriteDump";
	else if(id == 0x00000007)	funcName = "ExAcquireReadWriteLockExclusive";
	else if(id == 0x00000008)	funcName = "ExAcquireReadWriteLockShared";
	else if(id == 0x00000009)	funcName = "ExAllocatePool";
	else if(id == 0x0000000A)	funcName = "ExAllocatePoolWithTag";
	else if(id == 0x0000000B)	funcName = "ExAllocatePoolTypeWithTag";
	else if(id == 0x0000000C)	funcName = "ExConsoleGameRegion";
	else if(id == 0x0000000D)	funcName = "ExCreateThread";
	else if(id == 0x0000000E)	funcName = "ExEventObjectType";
	else if(id == 0x0000000F)	funcName = "ExFreePool";
	else if(id == 0x00000010)	funcName = "ExGetXConfigSetting";
	else if(id == 0x00000011)	funcName = "ExInitializeReadWriteLock";
	else if(id == 0x00000012)	funcName = "ExMutantObjectType";
	else if(id == 0x00000013)	funcName = "ExQueryPoolBlockSize";
	else if(id == 0x00000014)	funcName = "ExRegisterThreadNotification";
	else if(id == 0x00000015)	funcName = "ExRegisterTitleTerminateNotification";
	else if(id == 0x00000016)	funcName = "ExReleaseReadWriteLock";
	else if(id == 0x00000017)	funcName = "ExSemaphoreObjectType";
	else if(id == 0x00000018)	funcName = "ExSetXConfigSetting";
	else if(id == 0x00000019)	funcName = "ExTerminateThread";
	else if(id == 0x0000001A)	funcName = "ExTerminateTitleProcess";
	else if(id == 0x0000001B)	funcName = "ExThreadObjectType";
	else if(id == 0x0000001C)	funcName = "ExTimerObjectType";
	else if(id == 0x0000001D)	funcName = "MmDoubleMapMemory";
	else if(id == 0x0000001E)	funcName = "MmUnmapMemory";
	else if(id == 0x0000001F)	funcName = "XeKeysGetConsoleCertificate";
	else if(id == 0x00000020)	funcName = "FscGetCacheElementCount";
	else if(id == 0x00000021)	funcName = "FscSetCacheElementCount";
	else if(id == 0x00000022)	funcName = "HalGetCurrentAVPack";
	else if(id == 0x00000023)	funcName = "HalGpioControl";
	else if(id == 0x00000024)	funcName = "HalOpenCloseODDTray";
	else if(id == 0x00000025)	funcName = "HalReadWritePCISpace";
	else if(id == 0x00000026)	funcName = "HalRegisterPowerDownNotification";
	else if(id == 0x00000027)	funcName = "HalRegisterSMCNotification";
	else if(id == 0x00000028)	funcName = "HalReturnToFirmware";
	else if(id == 0x00000029)	funcName = "HalSendSMCMessage";
	else if(id == 0x0000002A)	funcName = "HalSetAudioEnable";
	else if(id == 0x0000002B)	funcName = "InterlockedFlushSList";
	else if(id == 0x0000002C)	funcName = "InterlockedPopEntrySList";
	else if(id == 0x0000002D)	funcName = "InterlockedPushEntrySList";
	else if(id == 0x0000002E)	funcName = "IoAcquireDeviceObjectLock";
	else if(id == 0x0000002F)	funcName = "IoAllocateIrp";
	else if(id == 0x00000030)	funcName = "IoBuildAsynchronousFsdRequest";
	else if(id == 0x00000031)	funcName = "IoBuildDeviceIoControlRequest";
	else if(id == 0x00000032)	funcName = "IoBuildSynchronousFsdRequest";
	else if(id == 0x00000033)	funcName = "IoCallDriver";
	else if(id == 0x00000034)	funcName = "IoCheckShareAccess";
	else if(id == 0x00000035)	funcName = "IoCompleteRequest";
	else if(id == 0x00000036)	funcName = "IoCompletionObjectType";
	else if(id == 0x00000037)	funcName = "IoCreateDevice";
	else if(id == 0x00000038)	funcName = "IoCreateFile";
	else if(id == 0x00000039)	funcName = "IoDeleteDevice";
	else if(id == 0x0000003A)	funcName = "IoDeviceObjectType";
	else if(id == 0x0000003B)	funcName = "IoDismountVolume";
	else if(id == 0x0000003C)	funcName = "IoDismountVolumeByFileHandle";
	else if(id == 0x0000003D)	funcName = "IoDismountVolumeByName";
	else if(id == 0x0000003E)	funcName = "IoFileObjectType";
	else if(id == 0x0000003F)	funcName = "IoFreeIrp";
	else if(id == 0x00000040)	funcName = "IoInitializeIrp";
	else if(id == 0x00000041)	funcName = "IoInvalidDeviceRequest";
	else if(id == 0x00000042)	funcName = "ExSetBetaFeaturesEnabled";
	else if(id == 0x00000043)	funcName = "IoQueueThreadIrp";
	else if(id == 0x00000044)	funcName = "IoReleaseDeviceObjectLock";
	else if(id == 0x00000045)	funcName = "IoRemoveShareAccess";
	else if(id == 0x00000046)	funcName = "IoSetIoCompletion";
	else if(id == 0x00000047)	funcName = "IoSetShareAccess";
	else if(id == 0x00000048)	funcName = "IoStartNextPacket";
	else if(id == 0x00000049)	funcName = "IoStartNextPacketByKey";
	else if(id == 0x0000004A)	funcName = "IoStartPacket";
	else if(id == 0x0000004B)	funcName = "IoSynchronousDeviceIoControlRequest";
	else if(id == 0x0000004C)	funcName = "IoSynchronousFsdRequest";
	else if(id == 0x0000004D)	funcName = "KeAcquireSpinLockAtRaisedIrql";
	else if(id == 0x0000004E)	funcName = "KeAlertResumeThread";
	else if(id == 0x0000004F)	funcName = "KeAlertThread";
	else if(id == 0x00000050)	funcName = "KeBlowFuses";
	else if(id == 0x00000051)	funcName = "KeBoostPriorityThread";
	else if(id == 0x00000052)	funcName = "KeBugCheck";
	else if(id == 0x00000053)	funcName = "KeBugCheckEx";
	else if(id == 0x00000054)	funcName = "KeCancelTimer";
	else if(id == 0x00000055)	funcName = "KeConnectInterrupt";
	else if(id == 0x00000056)	funcName = "KeContextFromKframes";
	else if(id == 0x00000057)	funcName = "KeContextToKframes";
	else if(id == 0x00000058)	funcName = "KeCreateUserMode";
	else if(id == 0x00000059)	funcName = "KeDebugMonitorData";
	else if(id == 0x0000005A)	funcName = "KeDelayExecutionThread";
	else if(id == 0x0000005B)	funcName = "KeDeleteUserMode";
	else if(id == 0x0000005C)	funcName = "KeDisconnectInterrupt";
	else if(id == 0x0000005D)	funcName = "KeEnableFpuExceptions";
	else if(id == 0x0000005E)	funcName = "KeEnablePPUPerformanceMonitor";
	else if(id == 0x0000005F)	funcName = "KeEnterCriticalRegion";
	else if(id == 0x00000060)	funcName = "KeEnterUserMode";
	else if(id == 0x00000061)	funcName = "KeFlushCacheRange";
	else if(id == 0x00000062)	funcName = "KeFlushCurrentEntireTb";
	else if(id == 0x00000063)	funcName = "KeFlushEntireTb";
	else if(id == 0x00000064)	funcName = "KeFlushUserModeCurrentTb";
	else if(id == 0x00000065)	funcName = "KeFlushUserModeTb";
	else if(id == 0x00000066)	funcName = "KeGetCurrentProcessType";
	else if(id == 0x00000067)	funcName = "KeGetPMWRegister";
	else if(id == 0x00000068)	funcName = "KeGetPRVRegister";
	else if(id == 0x00000069)	funcName = "KeGetSocRegister";
	else if(id == 0x0000006A)	funcName = "KeGetSpecialPurposeRegister";
	else if(id == 0x0000006B)	funcName = "KeLockL2";
	else if(id == 0x0000006C)	funcName = "KeUnlockL2";
	else if(id == 0x0000006D)	funcName = "KeInitializeApc";
	else if(id == 0x0000006E)	funcName = "KeInitializeDeviceQueue";
	else if(id == 0x0000006F)	funcName = "KeInitializeDpc";
	else if(id == 0x00000070)	funcName = "KeInitializeEvent";
	else if(id == 0x00000071)	funcName = "KeInitializeInterrupt";
	else if(id == 0x00000072)	funcName = "KeInitializeMutant";
	else if(id == 0x00000073)	funcName = "KeInitializeQueue";
	else if(id == 0x00000074)	funcName = "KeInitializeSemaphore";
	else if(id == 0x00000075)	funcName = "KeInitializeTimerEx";
	else if(id == 0x00000076)	funcName = "KeInsertByKeyDeviceQueue";
	else if(id == 0x00000077)	funcName = "KeInsertDeviceQueue";
	else if(id == 0x00000078)	funcName = "KeInsertHeadQueue";
	else if(id == 0x00000079)	funcName = "KeInsertQueue";
	else if(id == 0x0000007A)	funcName = "KeInsertQueueApc";
	else if(id == 0x0000007B)	funcName = "KeInsertQueueDpc";
	else if(id == 0x0000007C)	funcName = "KeIpiGenericCall";
	else if(id == 0x0000007D)	funcName = "KeLeaveCriticalRegion";
	else if(id == 0x0000007E)	funcName = "KeLeaveUserMode";
	else if(id == 0x0000007F)	funcName = "KePulseEvent";
	else if(id == 0x00000080)	funcName = "KeQueryBackgroundProcessors";
	else if(id == 0x00000081)	funcName = "KeQueryBasePriorityThread";
	else if(id == 0x00000082)	funcName = "KeQueryInterruptTime";
	else if(id == 0x00000083)	funcName = "KeQueryPerformanceFrequency";
	else if(id == 0x00000084)	funcName = "KeQuerySystemTime";
	else if(id == 0x00000085)	funcName = "KeRaiseIrqlToDpcLevel";
	else if(id == 0x00000086)	funcName = "KeRegisterDriverNotification";
	else if(id == 0x00000087)	funcName = "KeReleaseMutant";
	else if(id == 0x00000088)	funcName = "KeReleaseSemaphore";
	else if(id == 0x00000089)	funcName = "KeReleaseSpinLockFromRaisedIrql";
	else if(id == 0x0000008A)	funcName = "KeRemoveByKeyDeviceQueue";
	else if(id == 0x0000008B)	funcName = "KeRemoveDeviceQueue";
	else if(id == 0x0000008C)	funcName = "KeRemoveEntryDeviceQueue";
	else if(id == 0x0000008D)	funcName = "KeRemoveQueue";
	else if(id == 0x0000008E)	funcName = "KeRemoveQueueDpc";
	else if(id == 0x0000008F)	funcName = "KeResetEvent";
	else if(id == 0x00000090)	funcName = "KeRestoreFloatingPointState";
	else if(id == 0x00000091)	funcName = "KeRestoreVectorUnitState";
	else if(id == 0x00000092)	funcName = "KeResumeThread";
	else if(id == 0x00000093)	funcName = "KeRetireDpcList";
	else if(id == 0x00000094)	funcName = "KeRundownQueue";
	else if(id == 0x00000095)	funcName = "KeSaveFloatingPointState";
	else if(id == 0x00000096)	funcName = "KeSaveVectorUnitState";
	else if(id == 0x00000097)	funcName = "KeSetAffinityThread";
	else if(id == 0x00000098)	funcName = "KeSetBackgroundProcessors";
	else if(id == 0x00000099)	funcName = "KeSetBasePriorityThread";
	else if(id == 0x0000009A)	funcName = "KeSetCurrentProcessType";
	else if(id == 0x0000009B)	funcName = "KeSetCurrentStackPointers";
	else if(id == 0x0000009C)	funcName = "KeSetDisableBoostThread";
	else if(id == 0x0000009D)	funcName = "KeSetEvent";
	else if(id == 0x0000009E)	funcName = "KeSetEventBoostPriority";
	else if(id == 0x0000009F)	funcName = "KeSetPMWRegister";
	else if(id == 0x000000A0)	funcName = "KeSetPowerMode";
	else if(id == 0x000000A1)	funcName = "KeSetPRVRegister";
	else if(id == 0x000000A2)	funcName = "KeSetPriorityClassThread";
	else if(id == 0x000000A3)	funcName = "KeSetPriorityThread";
	else if(id == 0x000000A4)	funcName = "KeSetSocRegister";
	else if(id == 0x000000A5)	funcName = "KeSetSpecialPurposeRegister";
	else if(id == 0x000000A6)	funcName = "KeSetTimer";
	else if(id == 0x000000A7)	funcName = "KeSetTimerEx";
	else if(id == 0x000000A8)	funcName = "KeStallExecutionProcessor";
	else if(id == 0x000000A9)	funcName = "KeSuspendThread";
	else if(id == 0x000000AA)	funcName = "KeSweepDcacheRange";
	else if(id == 0x000000AB)	funcName = "KeSweepIcacheRange";
	else if(id == 0x000000AC)	funcName = "KeTestAlertThread";
	else if(id == 0x000000AD)	funcName = "KeTimeStampBundle";
	else if(id == 0x000000AE)	funcName = "KeTryToAcquireSpinLockAtRaisedIrql";
	else if(id == 0x000000AF)	funcName = "KeWaitForMultipleObjects";
	else if(id == 0x000000B0)	funcName = "KeWaitForSingleObject";
	else if(id == 0x000000B1)	funcName = "KfAcquireSpinLock";
	else if(id == 0x000000B2)	funcName = "KfRaiseIrql";
	else if(id == 0x000000B3)	funcName = "KfLowerIrql";
	else if(id == 0x000000B4)	funcName = "KfReleaseSpinLock";
	else if(id == 0x000000B5)	funcName = "KiBugCheckData";
	else if(id == 0x000000B6)	funcName = "LDICreateDecompression";
	else if(id == 0x000000B7)	funcName = "LDIDecompress";
	else if(id == 0x000000B8)	funcName = "LDIDestroyDecompression";
	else if(id == 0x000000B9)	funcName = "MmAllocatePhysicalMemory";
	else if(id == 0x000000BA)	funcName = "MmAllocatePhysicalMemoryEx";
	else if(id == 0x000000BB)	funcName = "MmCreateKernelStack";
	else if(id == 0x000000BC)	funcName = "MmDeleteKernelStack";
	else if(id == 0x000000BD)	funcName = "MmFreePhysicalMemory";
	else if(id == 0x000000BE)	funcName = "MmGetPhysicalAddress";
	else if(id == 0x000000BF)	funcName = "MmIsAddressValid";
	else if(id == 0x000000C0)	funcName = "MmLockAndMapSegmentArray";
	else if(id == 0x000000C1)	funcName = "MmLockUnlockBufferPages";
	else if(id == 0x000000C2)	funcName = "MmMapIoSpace";
	else if(id == 0x000000C3)	funcName = "MmPersistPhysicalMemoryAllocation";
	else if(id == 0x000000C4)	funcName = "MmQueryAddressProtect";
	else if(id == 0x000000C5)	funcName = "MmQueryAllocationSize";
	else if(id == 0x000000C6)	funcName = "MmQueryStatistics";
	else if(id == 0x000000C7)	funcName = "MmSetAddressProtect";
	else if(id == 0x000000C8)	funcName = "MmSplitPhysicalMemoryAllocation";
	else if(id == 0x000000C9)	funcName = "MmUnlockAndUnmapSegmentArray";
	else if(id == 0x000000CA)	funcName = "MmUnmapIoSpace";
	else if(id == 0x000000CB)	funcName = "Nls844UnicodeCaseTable";
	else if(id == 0x000000CC)	funcName = "NtAllocateVirtualMemory";
	else if(id == 0x000000CD)	funcName = "NtCancelTimer";
	else if(id == 0x000000CE)	funcName = "NtClearEvent";
	else if(id == 0x000000CF)	funcName = "NtClose";
	else if(id == 0x000000D0)	funcName = "NtCreateDirectoryObject";
	else if(id == 0x000000D1)	funcName = "NtCreateEvent";
	else if(id == 0x000000D2)	funcName = "NtCreateFile";
	else if(id == 0x000000D3)	funcName = "NtCreateIoCompletion";
	else if(id == 0x000000D4)	funcName = "NtCreateMutant";
	else if(id == 0x000000D5)	funcName = "NtCreateSemaphore";
	else if(id == 0x000000D6)	funcName = "NtCreateSymbolicLinkObject";
	else if(id == 0x000000D7)	funcName = "NtCreateTimer";
	else if(id == 0x000000D8)	funcName = "NtDeleteFile";
	else if(id == 0x000000D9)	funcName = "NtDeviceIoControlFile";
	else if(id == 0x000000DA)	funcName = "NtDuplicateObject";
	else if(id == 0x000000DB)	funcName = "NtFlushBuffersFile";
	else if(id == 0x000000DC)	funcName = "NtFreeVirtualMemory";
	else if(id == 0x000000DD)	funcName = "NtMakeTemporaryObject";
	else if(id == 0x000000DE)	funcName = "NtOpenDirectoryObject";
	else if(id == 0x000000DF)	funcName = "NtOpenFile";
	else if(id == 0x000000E0)	funcName = "NtOpenSymbolicLinkObject";
	else if(id == 0x000000E1)	funcName = "NtProtectVirtualMemory";
	else if(id == 0x000000E2)	funcName = "NtPulseEvent";
	else if(id == 0x000000E3)	funcName = "NtQueueApcThread";
	else if(id == 0x000000E4)	funcName = "NtQueryDirectoryFile";
	else if(id == 0x000000E5)	funcName = "NtQueryDirectoryObject";
	else if(id == 0x000000E6)	funcName = "NtQueryEvent";
	else if(id == 0x000000E7)	funcName = "NtQueryFullAttributesFile";
	else if(id == 0x000000E8)	funcName = "NtQueryInformationFile";
	else if(id == 0x000000E9)	funcName = "NtQueryIoCompletion";
	else if(id == 0x000000EA)	funcName = "NtQueryMutant";
	else if(id == 0x000000EB)	funcName = "NtQuerySemaphore";
	else if(id == 0x000000EC)	funcName = "NtQuerySymbolicLinkObject";
	else if(id == 0x000000ED)	funcName = "NtQueryTimer";
	else if(id == 0x000000EE)	funcName = "NtQueryVirtualMemory";
	else if(id == 0x000000EF)	funcName = "NtQueryVolumeInformationFile";
	else if(id == 0x000000F0)	funcName = "NtReadFile";
	else if(id == 0x000000F1)	funcName = "NtReadFileScatter";
	else if(id == 0x000000F2)	funcName = "NtReleaseMutant";
	else if(id == 0x000000F3)	funcName = "NtReleaseSemaphore";
	else if(id == 0x000000F4)	funcName = "NtRemoveIoCompletion";
	else if(id == 0x000000F5)	funcName = "NtResumeThread";
	else if(id == 0x000000F6)	funcName = "NtSetEvent";
	else if(id == 0x000000F7)	funcName = "NtSetInformationFile";
	else if(id == 0x000000F8)	funcName = "NtSetIoCompletion";
	else if(id == 0x000000F9)	funcName = "NtSetSystemTime";
	else if(id == 0x000000FA)	funcName = "NtSetTimerEx";
	else if(id == 0x000000FB)	funcName = "NtSignalAndWaitForSingleObjectEx";
	else if(id == 0x000000FC)	funcName = "NtSuspendThread";
	else if(id == 0x000000FD)	funcName = "NtWaitForSingleObjectEx";
	else if(id == 0x000000FE)	funcName = "NtWaitForMultipleObjectsEx";
	else if(id == 0x000000FF)	funcName = "NtWriteFile";
	else if(id == 0x00000100)	funcName = "NtWriteFileGather";
	else if(id == 0x00000101)	funcName = "NtYieldExecution";
	else if(id == 0x00000102)	funcName = "ObCreateObject";
	else if(id == 0x00000103)	funcName = "ObCreateSymbolicLink";
	else if(id == 0x00000104)	funcName = "ObDeleteSymbolicLink";
	else if(id == 0x00000105)	funcName = "ObDereferenceObject";
	else if(id == 0x00000106)	funcName = "ObDirectoryObjectType";
	else if(id == 0x00000107)	funcName = "ObGetWaitableObject";
	else if(id == 0x00000108)	funcName = "ObInsertObject";
	else if(id == 0x00000109)	funcName = "ObIsTitleObject";
	else if(id == 0x0000010A)	funcName = "ObLookupAnyThreadByThreadId";
	else if(id == 0x0000010B)	funcName = "ObLookupThreadByThreadId";
	else if(id == 0x0000010C)	funcName = "ObMakeTemporaryObject";
	else if(id == 0x0000010D)	funcName = "ObOpenObjectByName";
	else if(id == 0x0000010E)	funcName = "ObOpenObjectByPointer";
	else if(id == 0x0000010F)	funcName = "ObReferenceObject";
	else if(id == 0x00000110)	funcName = "ObReferenceObjectByHandle";
	else if(id == 0x00000111)	funcName = "ObReferenceObjectByName";
	else if(id == 0x00000112)	funcName = "ObSymbolicLinkObjectType";
	else if(id == 0x00000113)	funcName = "ObTranslateSymbolicLink";
	else if(id == 0x00000114)	funcName = "RtlAnsiStringToUnicodeString";
	else if(id == 0x00000115)	funcName = "RtlAppendStringToString";
	else if(id == 0x00000116)	funcName = "RtlAppendUnicodeStringToString";
	else if(id == 0x00000117)	funcName = "RtlAppendUnicodeToString";
	else if(id == 0x00000118)	funcName = "RtlAssert";
	else if(id == 0x00000119)	funcName = "RtlCaptureContext";
	else if(id == 0x0000011A)	funcName = "RtlCompareMemory";
	else if(id == 0x0000011B)	funcName = "RtlCompareMemoryUlong";
	else if(id == 0x0000011C)	funcName = "RtlCompareString";
	else if(id == 0x0000011D)	funcName = "RtlCompareStringN";
	else if(id == 0x0000011E)	funcName = "RtlCompareUnicodeString";
	else if(id == 0x0000011F)	funcName = "RtlCompareUnicodeStringN";
	else if(id == 0x00000120)	funcName = "RtlCompareUtf8ToUnicode";
	else if(id == 0x00000121)	funcName = "RtlCopyString";
	else if(id == 0x00000122)	funcName = "RtlCopyUnicodeString";
	else if(id == 0x00000123)	funcName = "RtlCreateUnicodeString";
	else if(id == 0x00000124)	funcName = "RtlDowncaseUnicodeChar";
	else if(id == 0x00000125)	funcName = "RtlEnterCriticalSection";
	else if(id == 0x00000126)	funcName = "RtlFillMemoryUlong";
	else if(id == 0x00000127)	funcName = "RtlFreeAnsiString";
	else if(id == 0x00000128)	funcName = "RtlFreeAnsiString";
	else if(id == 0x00000129)	funcName = "RtlGetCallersAddress";
	else if(id == 0x0000012A)	funcName = "RtlGetStackLimits";
	else if(id == 0x0000012B)	funcName = "RtlImageXexHeaderField";
	else if(id == 0x0000012C)	funcName = "RtlInitAnsiString";
	else if(id == 0x0000012D)	funcName = "RtlInitUnicodeString";
	else if(id == 0x0000012E)	funcName = "RtlInitializeCriticalSection";
	else if(id == 0x0000012F)	funcName = "RtlInitializeCriticalSectionAndSpinCount";
	else if(id == 0x00000130)	funcName = "RtlLeaveCriticalSection";
	else if(id == 0x00000131)	funcName = "RtlLookupFunctionEntry";
	else if(id == 0x00000132)	funcName = "RtlLowerChar";
	else if(id == 0x00000133)	funcName = "RtlMultiByteToUnicodeN";
	else if(id == 0x00000134)	funcName = "RtlMultiByteToUnicodeSize";
	else if(id == 0x00000135)	funcName = "RtlNtStatusToDosError";
	else if(id == 0x00000136)	funcName = "RtlRaiseException";
	else if(id == 0x00000137)	funcName = "RtlRaiseStatus";
	else if(id == 0x00000138)	funcName = "RtlRip";
	else if(id == 0x00000139)	funcName = "_scprintf";
	else if(id == 0x0000013A)	funcName = "_snprintf";
	else if(id == 0x0000013B)	funcName = "sprintf";
	else if(id == 0x0000013C)	funcName = "_scwprintf";
	else if(id == 0x0000013D)	funcName = "_snwprintf";
	else if(id == 0x0000013E)	funcName = "_swprintf";
	else if(id == 0x0000013F)	funcName = "RtlTimeFieldsToTime";
	else if(id == 0x00000140)	funcName = "RtlTimeToTimeFields";
	else if(id == 0x00000141)	funcName = "RtlTryEnterCriticalSection";
	else if(id == 0x00000142)	funcName = "RtlUnicodeStringToAnsiString";
	else if(id == 0x00000143)	funcName = "RtlUnicodeToMultiByteN";
	else if(id == 0x00000144)	funcName = "RtlUnicodeToMultiByteSize";
	else if(id == 0x00000145)	funcName = "RtlUnicodeToUtf8";
	else if(id == 0x00000146)	funcName = "RtlUnicodeToUtf8Size";
	else if(id == 0x00000147)	funcName = "RtlUnwind";
	else if(id == 0x00000148)	funcName = "RtlUnwind2";
	else if(id == 0x00000149)	funcName = "RtlUpcaseUnicodeChar";
	else if(id == 0x0000014A)	funcName = "RtlUpperChar";
	else if(id == 0x0000014B)	funcName = "RtlVirtualUnwind";
	else if(id == 0x0000014C)	funcName = "_vscprintf";
	else if(id == 0x0000014D)	funcName = "_vsnprintf";
	else if(id == 0x0000014E)	funcName = "vsprintf";
	else if(id == 0x0000014F)	funcName = "_vscwprintf";
	else if(id == 0x00000150)	funcName = "_vsnwprintf";
	else if(id == 0x00000151)	funcName = "_vswprintf";
	else if(id == 0x00000152)	funcName = "KeTlsAlloc";
	else if(id == 0x00000153)	funcName = "KeTlsFree";
	else if(id == 0x00000154)	funcName = "KeTlsGetValue";
	else if(id == 0x00000155)	funcName = "KeTlsSetValue";
	else if(id == 0x00000156)	funcName = "XboxHardwareInfo";
	else if(id == 0x00000157)	funcName = "XboxKrnlBaseVersion";
	else if(id == 0x00000158)	funcName = "XboxKrnlVersion";
	else if(id == 0x00000159)	funcName = "XeCryptAesKey";
	else if(id == 0x0000015A)	funcName = "XeCryptAesEcb";
	else if(id == 0x0000015B)	funcName = "XeCryptAesCbc";
	else if(id == 0x0000015C)	funcName = "XeCryptBnDwLeDhEqualBase";
	else if(id == 0x0000015D)	funcName = "XeCryptBnDwLeDhInvalBase";
	else if(id == 0x0000015E)	funcName = "XeCryptBnDwLeDhModExp";
	else if(id == 0x0000015F)	funcName = "XeCryptBnDw_Copy";
	else if(id == 0x00000160)	funcName = "XeCryptBnDw_SwapLeBe";
	else if(id == 0x00000161)	funcName = "XeCryptBnDw_Zero";
	else if(id == 0x00000162)	funcName = "XeCryptBnDwLePkcs1Format";
	else if(id == 0x00000163)	funcName = "XeCryptBnDwLePkcs1Verify";
	else if(id == 0x00000164)	funcName = "XeCryptBnQwBeSigCreate";
	else if(id == 0x00000165)	funcName = "XeCryptBnQwBeSigFormat";
	else if(id == 0x00000166)	funcName = "XeCryptBnQwBeSigVerify";
	else if(id == 0x00000167)	funcName = "XeCryptBnQwNeModExp";
	else if(id == 0x00000168)	funcName = "XeCryptBnQwNeModExpRoot";
	else if(id == 0x00000169)	funcName = "XeCryptBnQwNeModInv";
	else if(id == 0x0000016A)	funcName = "XeCryptBnQwNeModMul";
	else if(id == 0x0000016B)	funcName = "XeCryptBnQwNeRsaKeyGen";
	else if(id == 0x0000016C)	funcName = "XeCryptBnQwNeRsaPrvCrypt";
	else if(id == 0x0000016D)	funcName = "XeCryptBnQwNeRsaPubCrypt";
	else if(id == 0x0000016E)	funcName = "XeCryptBnQw_Copy";
	else if(id == 0x0000016F)	funcName = "XeCryptBnQw_SwapDwQw";
	else if(id == 0x00000170)	funcName = "XeCryptBnQw_SwapDwQwLeBe";
	else if(id == 0x00000171)	funcName = "XeCryptBnQw_SwapLeBe";
	else if(id == 0x00000172)	funcName = "XeCryptBnQw_Zero";
	else if(id == 0x00000173)	funcName = "XeCryptChainAndSumMac";
	else if(id == 0x00000174)	funcName = "XeCryptDesParity";
	else if(id == 0x00000175)	funcName = "XeCryptDesKey";
	else if(id == 0x00000176)	funcName = "XeCryptDesEcb";
	else if(id == 0x00000177)	funcName = "XeCryptDesCbc";
	else if(id == 0x00000178)	funcName = "XeCryptDes3Key";
	else if(id == 0x00000179)	funcName = "XeCryptDes3Ecb";
	else if(id == 0x0000017A)	funcName = "XeCryptDes3Cbc";
	else if(id == 0x0000017B)	funcName = "XeCryptHmacMd5Init";
	else if(id == 0x0000017C)	funcName = "XeCryptHmacMd5Update";
	else if(id == 0x0000017D)	funcName = "XeCryptHmacMd5Final";
	else if(id == 0x0000017E)	funcName = "XeCryptHmacMd5";
	else if(id == 0x0000017F)	funcName = "XeCryptHmacShaInit";
	else if(id == 0x00000180)	funcName = "XeCryptHmacShaUpdate";
	else if(id == 0x00000181)	funcName = "XeCryptHmacShaFinal";
	else if(id == 0x00000182)	funcName = "XeCryptHmacSha";
	else if(id == 0x00000183)	funcName = "XeCryptHmacShaVerify";
	else if(id == 0x00000184)	funcName = "XeCryptMd5Init";
	else if(id == 0x00000185)	funcName = "XeCryptMd5Update";
	else if(id == 0x00000186)	funcName = "XeCryptMd5Final";
	else if(id == 0x00000187)	funcName = "XeCryptMd5";
	else if(id == 0x00000188)	funcName = "XeCryptParveEcb";
	else if(id == 0x00000189)	funcName = "XeCryptParveCbcMac";
	else if(id == 0x0000018A)	funcName = "XeCryptRandom";
	else if(id == 0x0000018B)	funcName = "XeCryptRc4Key";
	else if(id == 0x0000018C)	funcName = "XeCryptRc4Ecb";
	else if(id == 0x0000018D)	funcName = "XeCryptRc4";
	else if(id == 0x0000018E)	funcName = "XeCryptRotSumSha";
	else if(id == 0x0000018F)	funcName = "XeCryptShaInit";
	else if(id == 0x00000190)	funcName = "XeCryptShaUpdate";
	else if(id == 0x00000191)	funcName = "XeCryptShaFinal";
	else if(id == 0x00000192)	funcName = "XeCryptSha";
	else if(id == 0x00000193)	funcName = "XexExecutableModuleHandle";
	else if(id == 0x00000194)	funcName = "XexCheckExecutablePrivilege";
	else if(id == 0x00000195)	funcName = "XexGetModuleHandle";
	else if(id == 0x00000196)	funcName = "XexGetModuleSection";
	else if(id == 0x00000197)	funcName = "XexGetProcedureAddress";
	else if(id == 0x00000198)	funcName = "XexLoadExecutable";
	else if(id == 0x00000199)	funcName = "XexLoadImage";
	else if(id == 0x0000019A)	funcName = "XexLoadImageFromMemory";
	else if(id == 0x0000019B)	funcName = "XexLoadImageHeaders";
	else if(id == 0x0000019C)	funcName = "XexPcToFileHeader";
	else if(id == 0x0000019D)	funcName = "KiApcNormalRoutineNop";
	else if(id == 0x0000019E)	funcName = "XexRegisterPatchDescriptor";
	else if(id == 0x0000019F)	funcName = "XexSendDeferredNotifications";
	else if(id == 0x000001A0)	funcName = "XexStartExecutable";
	else if(id == 0x000001A1)	funcName = "XexUnloadImage";
	else if(id == 0x000001A2)	funcName = "XexUnloadImageAndExitThread";
	else if(id == 0x000001A3)	funcName = "XexUnloadTitleModules";
	else if(id == 0x000001A4)	funcName = "XexVerifyImageHeaders";
	else if(id == 0x000001A5)	funcName = "__C_specific_handler";
	else if(id == 0x000001A6)	funcName = "DbgLoadImageSymbols";
	else if(id == 0x000001A7)	funcName = "DbgUnLoadImageSymbols";
	else if(id == 0x000001A8)	funcName = "RtlImageDirectoryEntryToData";
	else if(id == 0x000001A9)	funcName = "RtlImageNtHeader";
	else if(id == 0x000001AA)	funcName = "ExDebugMonitorService";
	else if(id == 0x000001AB)	funcName = "MmDbgReadCheck";
	else if(id == 0x000001AC)	funcName = "MmDbgReleaseAddress";
	else if(id == 0x000001AD)	funcName = "MmDbgWriteCheck";
	else if(id == 0x000001AE)	funcName = "ExLoadedCommandLine";
	else if(id == 0x000001AF)	funcName = "ExLoadedImageName";
	else if(id == 0x000001B0)	funcName = "VdBlockUntilGUIIdle";
	else if(id == 0x000001B1)	funcName = "VdCallGraphicsNotificationRoutines";
	else if(id == 0x000001B2)	funcName = "VdDisplayFatalError";
	else if(id == 0x000001B3)	funcName = "VdEnableClosedCaption";
	else if(id == 0x000001B4)	funcName = "VdEnableDisableClockGating";
	else if(id == 0x000001B5)	funcName = "VdEnableDisablePowerSavingMode";
	else if(id == 0x000001B6)	funcName = "VdEnableRingBufferRPtrWriteBack";
	else if(id == 0x000001B7)	funcName = "VdGenerateGPUCSCCoefficients";
	else if(id == 0x000001B8)	funcName = "VdGetClosedCaptionReadyStatus";
	else if(id == 0x000001B9)	funcName = "VdGetCurrentDisplayGamma";
	else if(id == 0x000001BA)	funcName = "VdGetCurrentDisplayInformation";
	else if(id == 0x000001BB)	funcName = "VdGetDisplayModeOverride";
	else if(id == 0x000001BC)	funcName = "VdGetGraphicsAsicID";
	else if(id == 0x000001BD)	funcName = "VdGetSystemCommandBuffer";
	else if(id == 0x000001BE)	funcName = "VdGlobalDevice";
	else if(id == 0x000001BF)	funcName = "VdGlobalXamDevice";
	else if(id == 0x000001C0)	funcName = "VdGpuClockInMHz";
	else if(id == 0x000001C1)	funcName = "VdHSIOCalibrationLock";
	else if(id == 0x000001C2)	funcName = "VdInitializeEngines";
	else if(id == 0x000001C3)	funcName = "VdInitializeRingBuffer";
	else if(id == 0x000001C4)	funcName = "VdInitializeScaler";
	else if(id == 0x000001C5)	funcName = "VdInitializeScalerCommandBuffer";
	else if(id == 0x000001C6)	funcName = "VdIsHSIOTrainingSucceeded";
	else if(id == 0x000001C7)	funcName = "VdPersistDisplay";
	else if(id == 0x000001C8)	funcName = "VdQuerySystemCommandBuffer";
	else if(id == 0x000001C9)	funcName = "VdQueryVideoFlags";
	else if(id == 0x000001CA)	funcName = "VdQueryVideoMode";
	else if(id == 0x000001CB)	funcName = "VdReadDVERegisterUlong";
	else if(id == 0x000001CC)	funcName = "VdReadWriteHSIOCalibrationFlag";
	else if(id == 0x000001CD)	funcName = "VdRegisterGraphicsNotification";
	else if(id == 0x000001CE)	funcName = "VdRegisterXamGraphicsNotification";
	else if(id == 0x000001CF)	funcName = "VdSendClosedCaptionData";
	else if(id == 0x000001D0)	funcName = "VdSetCGMSOption";
	else if(id == 0x000001D1)	funcName = "VdSetColorProfileAdjustment";
	else if(id == 0x000001D2)	funcName = "VdSetCscMatricesOverride";
	else if(id == 0x000001D3)	funcName = "VdSetDisplayMode";
	else if(id == 0x000001D4)	funcName = "VdSetDisplayModeOverride";
	else if(id == 0x000001D5)	funcName = "VdSetGraphicsInterruptCallback";
	else if(id == 0x000001D6)	funcName = "VdSetHDCPOption";
	else if(id == 0x000001D7)	funcName = "VdSetMacrovisionOption";
	else if(id == 0x000001D8)	funcName = "VdSetSystemCommandBuffer";
	else if(id == 0x000001D9)	funcName = "VdSetSystemCommandBufferGpuIdentifierAddress";
	else if(id == 0x000001DA)	funcName = "VdSetWSSData";
	else if(id == 0x000001DB)	funcName = "VdSetWSSOption";
	else if(id == 0x000001DC)	funcName = "VdShutdownEngines";
	else if(id == 0x000001DD)	funcName = "VdTurnDisplayOff";
	else if(id == 0x000001DE)	funcName = "VdTurnDisplayOn";
	else if(id == 0x000001DF)	funcName = "KiApcNormalRoutineNop";
	else if(id == 0x000001E0)	funcName = "VdWriteDVERegisterUlong";
	else if(id == 0x000001E1)	funcName = "XVoicedHeadsetPresent";
	else if(id == 0x000001E2)	funcName = "XVoicedSubmitPacket";
	else if(id == 0x000001E3)	funcName = "XVoicedClose";
	else if(id == 0x000001E4)	funcName = "XVoicedActivate";
	else if(id == 0x000001E5)	funcName = "XInputdGetCapabilities";
	else if(id == 0x000001E6)	funcName = "XInputdReadState";
	else if(id == 0x000001E7)	funcName = "XInputdWriteState";
	else if(id == 0x000001E8)	funcName = "XInputdNotify";
	else if(id == 0x000001E9)	funcName = "XInputdRawState";
	else if(id == 0x000001EA)	funcName = "HidGetCapabilities";
	else if(id == 0x000001EB)	funcName = "HidReadKeys";
	else if(id == 0x000001EC)	funcName = "XInputdGetDeviceStats";
	else if(id == 0x000001ED)	funcName = "XInputdResetDevice";
	else if(id == 0x000001EE)	funcName = "XInputdSetRingOfLight";
	else if(id == 0x000001EF)	funcName = "XInputdSetRFPowerMode";
	else if(id == 0x000001F0)	funcName = "XInputdSetRadioFrequency";
	else if(id == 0x000001F1)	funcName = "HidGetLastInputTime";
	else if(id == 0x000001F2)	funcName = "XAudioRenderDriverInitialize";
	else if(id == 0x000001F3)	funcName = "XAudioRegisterRenderDriverClient";
	else if(id == 0x000001F4)	funcName = "XAudioUnregisterRenderDriverClient";
	else if(id == 0x000001F5)	funcName = "XAudioSubmitRenderDriverFrame";
	else if(id == 0x000001F6)	funcName = "XAudioRenderDriverLock";
	else if(id == 0x000001F7)	funcName = "XAudioGetVoiceCategoryVolumeChangeMask";
	else if(id == 0x000001F8)	funcName = "XAudioGetVoiceCategoryVolume";
	else if(id == 0x000001F9)	funcName = "XAudioSetVoiceCategoryVolume";
	else if(id == 0x000001FA)	funcName = "XAudioBeginDigitalBypassMode";
	else if(id == 0x000001FB)	funcName = "XAudioEndDigitalBypassMode";
	else if(id == 0x000001FC)	funcName = "XAudioSubmitDigitalPacket";
	else if(id == 0x000001FD)	funcName = "XAudioQueryDriverPerformance";
	else if(id == 0x000001FE)	funcName = "XAudioGetRenderDriverThread";
	else if(id == 0x000001FF)	funcName = "XAudioGetSpeakerConfig";
	else if(id == 0x00000200)	funcName = "XAudioSetSpeakerConfig";
	else if(id == 0x00000201)	funcName = "NicSetUnicastAddress";
	else if(id == 0x00000202)	funcName = "NicAttach";
	else if(id == 0x00000203)	funcName = "NicDetach";
	else if(id == 0x00000204)	funcName = "NicXmit";
	else if(id == 0x00000205)	funcName = "NicUpdateMcastMembership";
	else if(id == 0x00000206)	funcName = "NicFlushXmitQueue";
	else if(id == 0x00000207)	funcName = "NicShutdown";
	else if(id == 0x00000208)	funcName = "NicGetLinkState";
	else if(id == 0x00000209)	funcName = "NicGetStats";
	else if(id == 0x0000020A)	funcName = "NicGetOpt";
	else if(id == 0x0000020B)	funcName = "NicSetOpt";
	else if(id == 0x0000020C)	funcName = "DrvSetSysReqCallback";
	else if(id == 0x0000020D)	funcName = "DrvSetUserBindingCallback";
	else if(id == 0x0000020E)	funcName = "DrvSetContentStorageCallback";
	else if(id == 0x0000020F)	funcName = "DrvSetAutobind";
	else if(id == 0x00000210)	funcName = "DrvGetContentStorageNotification";
	else if(id == 0x00000211)	funcName = "MtpdBeginTransaction";
	else if(id == 0x00000212)	funcName = "MtpdCancelTransaction";
	else if(id == 0x00000213)	funcName = "MtpdEndTransaction";
	else if(id == 0x00000214)	funcName = "MtpdGetCurrentDevices";
	else if(id == 0x00000215)	funcName = "MtpdReadData";
	else if(id == 0x00000216)	funcName = "MtpdReadEvent";
	else if(id == 0x00000217)	funcName = "MtpdResetDevice";
	else if(id == 0x00000218)	funcName = "MtpdSendData";
	else if(id == 0x00000219)	funcName = "MtpdVerifyProximity";
	else if(id == 0x0000021A)	funcName = "XUsbcamSetCaptureMode";
	else if(id == 0x0000021B)	funcName = "XUsbcamGetConfig";
	else if(id == 0x0000021C)	funcName = "XUsbcamSetConfig";
	else if(id == 0x0000021D)	funcName = "XUsbcamGetState";
	else if(id == 0x0000021E)	funcName = "XUsbcamReadFrame";
	else if(id == 0x0000021F)	funcName = "XUsbcamSnapshot";
	else if(id == 0x00000220)	funcName = "XUsbcamSetView";
	else if(id == 0x00000221)	funcName = "XUsbcamGetView";
	else if(id == 0x00000222)	funcName = "XUsbcamCreate";
	else if(id == 0x00000223)	funcName = "XUsbcamDestroy";
	else if(id == 0x00000224)	funcName = "XMACreateContext";
	else if(id == 0x00000225)	funcName = "XMAInitializeContext";
	else if(id == 0x00000226)	funcName = "XMAReleaseContext";
	else if(id == 0x00000227)	funcName = "XMAEnableContext";
	else if(id == 0x00000228)	funcName = "XMADisableContext";
	else if(id == 0x00000229)	funcName = "XMAGetOutputBufferWriteOffset";
	else if(id == 0x0000022A)	funcName = "XMASetOutputBufferReadOffset";
	else if(id == 0x0000022B)	funcName = "XMAGetOutputBufferReadOffset";
	else if(id == 0x0000022C)	funcName = "XMASetOutputBufferValid";
	else if(id == 0x0000022D)	funcName = "XMAIsOutputBufferValid";
	else if(id == 0x0000022E)	funcName = "XMASetInputBuffer0Valid";
	else if(id == 0x0000022F)	funcName = "XMAIsInputBuffer0Valid";
	else if(id == 0x00000230)	funcName = "XMASetInputBuffer1Valid";
	else if(id == 0x00000231)	funcName = "XMAIsInputBuffer1Valid";
	else if(id == 0x00000232)	funcName = "XMASetInputBuffer0";
	else if(id == 0x00000233)	funcName = "XMASetInputBuffer1";
	else if(id == 0x00000234)	funcName = "XMAGetPacketMetadata";
	else if(id == 0x00000235)	funcName = "XMABlockWhileInUse";
	else if(id == 0x00000236)	funcName = "XMASetLoopData";
	else if(id == 0x00000237)	funcName = "XMASetInputBufferReadOffset";
	else if(id == 0x00000238)	funcName = "XMAGetInputBufferReadOffset";
	else if(id == 0x00000239)	funcName = "ExIsBetaFeatureEnabled";
	else if(id == 0x0000023A)	funcName = "XeKeysGetFactoryChallenge";
	else if(id == 0x0000023B)	funcName = "XeKeysSetFactoryResponse";
	else if(id == 0x0000023C)	funcName = "XeKeysInitializeFuses";
	else if(id == 0x0000023D)	funcName = "XeKeysSaveBootLoader";
	else if(id == 0x0000023E)	funcName = "XeKeysSaveKeyVault";
	else if(id == 0x0000023F)	funcName = "XeKeysGetStatus";
	else if(id == 0x00000240)	funcName = "XeKeysGeneratePrivateKey";
	else if(id == 0x00000241)	funcName = "XeKeysGetKeyProperties";
	else if(id == 0x00000242)	funcName = "XeKeysSetKey";
	else if(id == 0x00000243)	funcName = "XeKeysGenerateRandomKey";
	else if(id == 0x00000244)	funcName = "XeKeysGetKey";
	else if(id == 0x00000245)	funcName = "XeKeysGetDigest";
	else if(id == 0x00000246)	funcName = "XeKeysGetConsoleID";
	else if(id == 0x00000247)	funcName = "XeKeysGetConsoleType";
	else if(id == 0x00000248)	funcName = "XeKeysQwNeRsaPrvCrypt";
	else if(id == 0x00000249)	funcName = "XeKeysHmacSha";
	else if(id == 0x0000024A)	funcName = "XInputdPassThroughRFCommand";
	else if(id == 0x0000024B)	funcName = "XeKeysAesCbc";
	else if(id == 0x0000024C)	funcName = "XeKeysDes2Cbc";
	else if(id == 0x0000024D)	funcName = "XeKeysDesCbc";
	else if(id == 0x0000024E)	funcName = "XeKeysObscureKey";
	else if(id == 0x0000024F)	funcName = "XeKeysHmacShaUsingKey";
	else if(id == 0x00000250)	funcName = "XeKeysSaveBootLoaderEx";
	else if(id == 0x00000251)	funcName = "XeKeysAesCbcUsingKey";
	else if(id == 0x00000252)	funcName = "XeKeysDes2CbcUsingKey";
	else if(id == 0x00000253)	funcName = "XeKeysDesCbcUsingKey";
	else if(id == 0x00000254)	funcName = "XeKeysObfuscate";
	else if(id == 0x00000255)	funcName = "XeKeysUnObfuscate";
	else if(id == 0x00000256)	funcName = "XeKeysConsolePrivateKeySign";
	else if(id == 0x00000257)	funcName = "XeKeysConsoleSignatureVerification";
	else if(id == 0x00000258)	funcName = "XeKeysVerifyRSASignature";
	else if(id == 0x00000259)	funcName = "StfsCreateDevice";
	else if(id == 0x0000025A)	funcName = "StfsControlDevice";
	else if(id == 0x0000025B)	funcName = "VdSwap";
	else if(id == 0x0000025C)	funcName = "HalFsbInterruptCount";
	else if(id == 0x0000025D)	funcName = "XeKeysSaveSystemUpdate";
	else if(id == 0x0000025E)	funcName = "XeKeysLockSystemUpdate";
	else if(id == 0x0000025F)	funcName = "XeKeysExecute";
	else if(id == 0x00000260)	funcName = "XeKeysGetVersions";
	else if(id == 0x00000261)	funcName = "XInputdPowerDownDevice";
	else if(id == 0x00000262)	funcName = "AniBlockOnAnimation";
	else if(id == 0x00000263)	funcName = "AniTerminateAnimation";
	else if(id == 0x00000264)	funcName = "XUsbcamReset";
	else if(id == 0x00000265)	funcName = "AniSetLogo";
	else if(id == 0x00000266)	funcName = "KeCertMonitorData";
	else if(id == 0x00000267)	funcName = "HalIsExecutingPowerDownDpc";
	else if(id == 0x00000268)	funcName = "VdInitializeEDRAM";
	else if(id == 0x00000269)	funcName = "VdRetrainEDRAM";
	else if(id == 0x0000026A)	funcName = "VdRetrainEDRAMWorker";
	else if(id == 0x0000026B)	funcName = "VdHSIOTrainCount";
	else if(id == 0x0000026C)	funcName = "HalGetPowerUpCause";
	else if(id == 0x0000026D)	funcName = "VdHSIOTrainingStatus";
	else if(id == 0x0000026E)	funcName = "RgcBindInfo";
	else if(id == 0x0000026F)	funcName = "VdReadEEDIDBlock";
	else if(id == 0x00000270)	funcName = "VdEnumerateVideoModes";
	else if(id == 0x00000271)	funcName = "VdEnableHDCP";
	else if(id == 0x00000272)	funcName = "VdRegisterHDCPNotification";
	else if(id == 0x00000273)	funcName = "HidReadMouseChanges";
	else if(id == 0x00000274)	funcName = "DumpSetCollectionFacility";
	else if(id == 0x00000275)	funcName = "XexTransformImageKey";
	else if(id == 0x00000276)	funcName = "XAudioOverrideSpeakerConfig";
	else if(id == 0x00000277)	funcName = "XInputdReadTextKeystroke";
	else if(id == 0x00000278)	funcName = "DrvXenonButtonPressed";
	else if(id == 0x00000279)	funcName = "DrvBindToUser";
	else if(id == 0x0000027A)	funcName = "XexGetModuleImportVersions";
	else if(id == 0x0000027B)	funcName = "RtlComputeCrc32";
	else if(id == 0x0000027C)	funcName = "XeKeysSetRevocationList";
	else if(id == 0x0000027D)	funcName = "HalRegisterPowerDownCallback";
	else if(id == 0x0000027E)	funcName = "VdGetDisplayDiscoveryData";
	else if(id == 0x0000027F)	funcName = "XInputdSendStayAliveRequest";
	else if(id == 0x00000280)	funcName = "XVoicedSendVPort";
	else if(id == 0x00000281)	funcName = "XVoicedGetBatteryStatus";
	else if(id == 0x00000282)	funcName = "XInputdFFGetDeviceInfo";
	else if(id == 0x00000283)	funcName = "XInputdFFSetEffect";
	else if(id == 0x00000284)	funcName = "XInputdFFUpdateEffect";
	else if(id == 0x00000285)	funcName = "XInputdFFEffectOperation";
	else if(id == 0x00000286)	funcName = "XInputdFFDeviceControl";
	else if(id == 0x00000287)	funcName = "XInputdFFSetDeviceGain";
	else if(id == 0x00000288)	funcName = "XInputdFFCancelIo";
	else if(id == 0x00000289)	funcName = "XInputdFFSetRumble";
	else if(id == 0x0000028A)	funcName = "NtAllocateEncryptedMemory";
	else if(id == 0x0000028B)	funcName = "NtFreeEncryptedMemory";
	else if(id == 0x0000028C)	funcName = "XeKeysExSaveKeyVault";
	else if(id == 0x0000028D)	funcName = "XeKeysExSetKey";
	else if(id == 0x0000028E)	funcName = "XeKeysExGetKey";
	else if(id == 0x0000028F)	funcName = "DrvSetDeviceConfigChangeCallback";
	else if(id == 0x00000290)	funcName = "DrvDeviceConfigChange";
	else if(id == 0x00000291)	funcName = "HalRegisterHdDvdRomNotification";
	else if(id == 0x00000292)	funcName = "XeKeysSecurityInitialize";
	else if(id == 0x00000293)	funcName = "XeKeysSecurityLoadSettings";
	else if(id == 0x00000294)	funcName = "XeKeysSecuritySaveSettings";
	else if(id == 0x00000295)	funcName = "XeKeysSecuritySetDetected";
	else if(id == 0x00000296)	funcName = "XeKeysSecurityGetDetected";
	else if(id == 0x00000297)	funcName = "XeKeysSecuritySetActivated";
	else if(id == 0x00000298)	funcName = "XeKeysSecurityGetActivated";
	else if(id == 0x00000299)	funcName = "XeKeysDvdAuthAP25InstallTable";
	else if(id == 0x0000029A)	funcName = "XeKeysDvdAuthAP25GetTableVersion";
	else if(id == 0x0000029B)	funcName = "XeKeysGetProtectedFlag";
	else if(id == 0x0000029C)	funcName = "XeKeysSetProtectedFlag";
	else if(id == 0x0000029D)	funcName = "KeEnablePFMInterrupt";
	else if(id == 0x0000029E)	funcName = "KeDisablePFMInterrupt";
	else if(id == 0x0000029F)	funcName = "KeSetProfilerISR";
	else if(id == 0x000002A0)	funcName = "VdStartDisplayDiscovery";
	else if(id == 0x000002A1)	funcName = "VdSetHDCPRevocationList";
	else if(id == 0x000002A2)	funcName = "XeKeysGetUpdateSequence";
	else if(id == 0x000002A3)	funcName = "XeKeysDvdAuthExActivate";
	else if(id == 0x000002A4)	funcName = "KeGetImagePageTableEntry";
	else if(id == 0x000002A5)	funcName = "HalRegisterBackgroundModeTransitionCallback";
	else if(id == 0x000002A6)	funcName = "AniStartBootAnimation";
	else if(id == 0x000002A7)	funcName = "HalClampUnclampOutputDACs";
	else if(id == 0x000002A8)	funcName = "HalPowerDownToBackgroundMode";
	else if(id == 0x000002A9)	funcName = "HalNotifyAddRemoveBackgroundTask";
	else if(id == 0x000002AA)	funcName = "HalCallBackgroundModeNotificationRoutines";
	else if(id == 0x000002AB)	funcName = "HalFsbResetCount";
	else if(id == 0x000002AC)	funcName = "HalGetMemoryInformation";
	else if(id == 0x000002AD)	funcName = "XInputdGetLastTextInputTime";
	else if(id == 0x000002AE)	funcName = "VdEnableWMAProOverHDMI";
	else if(id == 0x000002AF)	funcName = "XeKeysRevokeSaveSettings";
	else if(id == 0x000002B0)	funcName = "XInputdSetTextMessengerIndicator";
	else if(id == 0x000002B1)	funcName = "MicDeviceRequest";
	else if(id == 0x000002B2)	funcName = "XeKeysGetMediaID";
	else if(id == 0x000002B3)	funcName = "XeKeysLoadKeyVault";
	else if(id == 0x000002B4)	funcName = "KeGetVidInfo";
	else if(id == 0x000002B5)	funcName = "HalNotifyBackgroundModeTransitionComplete";
	else if(id == 0x000002B6)	funcName = "IoAcquireCancelSpinLock";
	else if(id == 0x000002B7)	funcName = "IoReleaseCancelSpinLock";
	else if(id == 0x000002B8)	funcName = "NtCancelIoFile";
	else if(id == 0x000002B9)	funcName = "NtCancelIoFileEx";
	else if(id == 0x000002BA)	funcName = "HalFinalizePowerLossRecovery";
	else if(id == 0x000002BB)	funcName = "HalSetPowerLossRecovery";
	else if(id == 0x000002BC)	funcName = "ExReadModifyWriteXConfigSettingUlong";
	else if(id == 0x000002BD)	funcName = "HalRegisterXamPowerDownCallback";
	else if(id == 0x000002BE)	funcName = "ExCancelAlarm";
	else if(id == 0x000002BF)	funcName = "ExInitializeAlarm";
	else if(id == 0x000002C0)	funcName = "ExSetAlarm";
	else if(id == 0x000002C1)	funcName = "XexActivationGetNonce";
	else if(id == 0x000002C2)	funcName = "XexActivationSetLicense";
	else if(id == 0x000002C3)	funcName = "IptvSetBoundaryKey";
	else if(id == 0x000002C4)	funcName = "IptvSetSessionKey";
	else if(id == 0x000002C5)	funcName = "IptvVerifyOmac1Signature";
	else if(id == 0x000002C6)	funcName = "IptvGetAesCtrTransform";
	else if(id == 0x000002C7)	funcName = "SataCdRomRecordReset";
	else if(id == 0x000002C8)	funcName = "XInputdSetTextDeviceKeyLocks";
	else if(id == 0x000002C9)	funcName = "XInputdGetTextDeviceKeyLocks";
	else if(id == 0x000002CA)	funcName = "XexActivationVerifyOwnership";
	else if(id == 0x000002CB)	funcName = "XexDisableVerboseDbgPrint";
	else if(id == 0x000002CC)	funcName = "SvodCreateDevice";
	else if(id == 0x000002CD)	funcName = "RtlCaptureStackBackTrace";
	else if(id == 0x000002CE)	funcName = "XeKeysRevokeUpdateDynamic";
	else if(id == 0x000002CF)	funcName = "XexImportTraceEnable";
	else if(id == 0x000002D0)	funcName = "ExRegisterXConfigNotification";
	else if(id == 0x000002D1)	funcName = "XeKeysSecuritySetStat";
	else if(id == 0x000002D2)	funcName = "VdQueryRealVideoMode";
	else if(id == 0x000002D3)	funcName = "XexSetExecutablePrivilege";
	else if(id == 0x000002D4)	funcName = "XAudioSuspendRenderDriverClients";
	else if(id == 0x000002D5)	funcName = "IptvGetSessionKeyHash";
	else if(id == 0x000002D6)	funcName = "VdSetCGMSState";
	else if(id == 0x000002D7)	funcName = "VdSetSCMSState";
	else if(id == 0x000002D8)	funcName = "KeFlushMultipleTb";
	else if(id == 0x000002D9)	funcName = "VdGetOption";
	else if(id == 0x000002DA)	funcName = "VdSetOption";
	else if(id == 0x000002DB)	funcName = "UsbdBootEnumerationDoneEvent";
	else if(id == 0x000002DC)	funcName = "StfsDeviceErrorEvent";
	else if(id == 0x000002DD)	funcName = "ExTryToAcquireReadWriteLockExclusive";
	else if(id == 0x000002DE)	funcName = "ExTryToAcquireReadWriteLockShared";
	else if(id == 0x000002DF)	funcName = "XexSetLastKdcTime";
	else if(id == 0x000002E0)	funcName = "XInputdControl";
	else if(id == 0x000002E1)	funcName = "RmcDeviceRequest";
	else if(id == 0x000002E2)	funcName = "LDIResetDecompression";
	else if(id == 0x000002E3)	funcName = "NicRegisterDevice";
	else if(id == 0x000002E4)	funcName = "UsbdAddDeviceComplete";
	else if(id == 0x000002E5)	funcName = "UsbdCancelAsyncTransfer";
	else if(id == 0x000002E6)	funcName = "UsbdGetDeviceSpeed";
	else if(id == 0x000002E7)	funcName = "UsbdGetDeviceTopology";
	else if(id == 0x000002E8)	funcName = "UsbdGetEndpointDescriptor";
	else if(id == 0x000002E9)	funcName = "UsbdIsDeviceAuthenticated";
	else if(id == 0x000002EA)	funcName = "UsbdOpenDefaultEndpoint";
	else if(id == 0x000002EB)	funcName = "UsbdOpenEndpoint";
	else if(id == 0x000002EC)	funcName = "UsbdQueueAsyncTransfer";
	else if(id == 0x000002ED)	funcName = "UsbdQueueCloseDefaultEndpoint";
	else if(id == 0x000002EE)	funcName = "UsbdQueueCloseEndpoint";
	else if(id == 0x000002EF)	funcName = "UsbdRemoveDeviceComplete";
	else if(id == 0x000002F0)	funcName = "KeRemoveQueueApc";
	else if(id == 0x000002F1)	funcName = "UsbdDriverLoadRequiredEvent";
	else if(id == 0x000002F2)	funcName = "UsbdGetRequiredDrivers";
	else if(id == 0x000002F3)	funcName = "UsbdRegisterDriverObject";
	else if(id == 0x000002F4)	funcName = "UsbdUnregisterDriverObject";
	else if(id == 0x000002F5)	funcName = "UsbdCallAndBlockOnDpcRoutine";
	else if(id == 0x000002F6)	funcName = "UsbdResetDevice";
	else if(id == 0x000002F7)	funcName = "UsbdGetDeviceDescriptor";
	else if(id == 0x000002F8)	funcName = "NomnilGetExtension";
	else if(id == 0x000002F9)	funcName = "NomnilStartCloseDevice";
	else if(id == 0x000002FA)	funcName = "WifiBeginAuthentication";
	else if(id == 0x000002FB)	funcName = "WifiCheckCounterMeasures";
	else if(id == 0x000002FC)	funcName = "WifiChooseAuthenCipherSetFromBSSID";
	else if(id == 0x000002FD)	funcName = "WifiCompleteAuthentication";
	else if(id == 0x000002FE)	funcName = "WifiGetAssociationIE";
	else if(id == 0x000002FF)	funcName = "WifiOnMICError";
	else if(id == 0x00000300)	funcName = "WifiPrepareAuthenticationContext";
	else if(id == 0x00000301)	funcName = "WifiRecvEAPOLPacket";
	else if(id == 0x00000302)	funcName = "WifiDeduceNetworkType";
	else if(id == 0x00000303)	funcName = "NicUnregisterDevice";
	else if(id == 0x00000304)	funcName = "DumpXitThread";
	else if(id == 0x00000305)	funcName = "XInputdSetWifiChannel";
	else if(id == 0x00000306)	funcName = "NomnilSetLed";
	else if(id == 0x00000307)	funcName = "WifiCalculateRegulatoryDomain";
	else if(id == 0x00000308)	funcName = "WifiSelectAdHocChannel";
	else if(id == 0x00000309)	funcName = "WifiChannelToFrequency";
	else if(id == 0x0000030A)	funcName = "MmGetPoolPagesType";
	else if(id == 0x0000030B)	funcName = "ExExpansionInstall";
	else if(id == 0x0000030C)	funcName = "ExExpansionCall";
	else if(id == 0x0000030D)	funcName = "PsCamDeviceRequest";
	else if(id == 0x0000030E)	funcName = "McaDeviceRequest";
	else if(id == 0x0000030F)	funcName = "DetroitDeviceRequest";
	else if(id == 0x00000310)	funcName = "XeCryptSha256Init";
	else if(id == 0x00000311)	funcName = "XeCryptSha256Update";
	else if(id == 0x00000312)	funcName = "XeCryptSha256Final";
	else if(id == 0x00000313)	funcName = "XeCryptSha256";
	else if(id == 0x00000314)	funcName = "XeCryptSha384Init";
	else if(id == 0x00000315)	funcName = "XeCryptSha384Update";
	else if(id == 0x00000316)	funcName = "XInputdGetDevicePid";
	else if(id == 0x00000317)	funcName = "HalGetNotedArgonErrors";
	else if(id == 0x00000318)	funcName = "XeCryptSha384Final";
	else if(id == 0x00000319)	funcName = "HalReadArgonEeprom";
	else if(id == 0x0000031A)	funcName = "HalWriteArgonEeprom";
	else if(id == 0x0000031B)	funcName = "XeKeysFcrtLoad";
	else if(id == 0x0000031C)	funcName = "XeKeysFcrtSave";
	else if(id == 0x0000031D)	funcName = "XeKeysFcrtSet";
	else if(id == 0x0000031E)	funcName = "XeCryptSha384";
	else if(id == 0x0000031F)	funcName = "XeCryptSha512Init";
	else if(id == 0x00000320)	funcName = "XAudioRegisterRenderDriverMECClient";
	else if(id == 0x00000321)	funcName = "XAudioUnregisterRenderDriverMECClient";
	else if(id == 0x00000322)	funcName = "XAudioCaptureRenderDriverFrame";
	else if(id == 0x00000323)	funcName = "XeCryptSha512Update";
	else if(id == 0x00000324)	funcName = "XeCryptSha512Final";
	else if(id == 0x00000325)	funcName = "XeCryptSha512";
	else if(id == 0x00000326)	funcName = "XeCryptBnQwNeCompare";
	else if(id == 0x00000327)	funcName = "XVoicedGetDirectionalData";
	else if(id == 0x00000328)	funcName = "DrvSetMicArrayStartCallback";
	else if(id == 0x00000329)	funcName = "DevAuthGetStatistics";
	else if(id == 0x0000032A)	funcName = "NullCableRequest";
	else if(id == 0x0000032B)	funcName = "XeKeysRevokeIsDeviceRevoked";
	else if(id == 0x0000032C)	funcName = "DumpUpdateDumpSettings";
	else if(id == 0x0000032D)	funcName = "EtxConsumerDisableEventType";
	else if(id == 0x0000032E)	funcName = "EtxConsumerEnableEventType";
	else if(id == 0x0000032F)	funcName = "EtxConsumerProcessLogs";
	else if(id == 0x00000330)	funcName = "EtxConsumerRegister";
	else if(id == 0x00000331)	funcName = "EtxConsumerUnregister";
	else if(id == 0x00000332)	funcName = "EtxProducerLog";
	else if(id == 0x00000333)	funcName = "EtxProducerLogV";
	else if(id == 0x00000334)	funcName = "EtxProducerRegister";
	else if(id == 0x00000335)	funcName = "EtxProducerUnregister";
	else if(id == 0x00000336)	funcName = "EtxConsumerFlushBuffers";
	else if(id == 0x00000337)	funcName = "EtxProducerLogXwpp";
	else if(id == 0x00000338)	funcName = "EtxProducerLogXwppV";
	else if(id == 0x00000339)	funcName = "UsbdEnableDisableRootHubPort";
	else if(id == 0x0000033A)	funcName = "EtxBufferRegister";
	else if(id == 0x0000033B)	funcName = "EtxBufferUnregister";
	else if(id == 0x0000033C)	funcName = "DumpRegisterDedicatedDataBlock";
	else if(id == 0x0000033D)	funcName = "XeKeysDvdAuthExSave";
	else if(id == 0x0000033E)	funcName = "XeKeysDvdAuthExInstall";
	else if(id == 0x0000033F)	funcName = "XexShimDisable";
	else if(id == 0x00000340)	funcName = "XexShimEnable";
	else if(id == 0x00000341)	funcName = "XexShimEntryDisable";
	else if(id == 0x00000342)	funcName = "XexShimEntryEnable";
	else if(id == 0x00000343)	funcName = "XexShimEntryRegister";
	else if(id == 0x00000344)	funcName = "XexShimLock";
	else if(id == 0x00000345)	funcName = "XboxKrnlVersion4Digit";
	else if(id == 0x00000346)	funcName = "XeKeysObfuscateEx";
	else if(id == 0x00000347)	funcName = "XeKeysUnObfuscateEx";
	else if(id == 0x00000348)	funcName = "XexTitleHash";
	else if(id == 0x00000349)	funcName = "XexTitleHashClose";
	else if(id == 0x0000034A)	funcName = "XexTitleHashContinue";
	else if(id == 0x0000034B)	funcName = "XexTitleHashOpen";
	else if(id == 0x0000034C)	funcName = "XAudioGetRenderDriverTic";
	else if(id == 0x0000034D)	funcName = "XAudioEnableDucker";
	else if(id == 0x0000034E)	funcName = "XAudioSetDuckerLevel";
	else if(id == 0x0000034F)	funcName = "XAudioIsDuckerEnabled";
	else if(id == 0x00000350)	funcName = "XAudioGetDuckerLevel";
	else if(id == 0x00000351)	funcName = "XAudioGetDuckerThreshold";
	else if(id == 0x00000352)	funcName = "XAudioSetDuckerThreshold";
	else if(id == 0x00000353)	funcName = "XAudioGetDuckerAttackTime";
	else if(id == 0x00000354)	funcName = "XAudioSetDuckerAttackTime";
	else if(id == 0x00000355)	funcName = "XAudioGetDuckerReleaseTime";
	else if(id == 0x00000356)	funcName = "XAudioSetDuckerReleaseTime";
	else if(id == 0x00000357)	funcName = "XAudioGetDuckerHoldTime";
	else if(id == 0x00000358)	funcName = "XAudioSetDuckerHoldTime";
	else if(id == 0x00000359)	funcName = "DevAuthShouldAlwaysEnforce";
	else if(id == 0x0000035A)	funcName = "XAudioGetUnderrunCount";
	else if(id == 0x0000035C)	funcName = "XVoicedIsActiveProcess";
	
	return funcName;
}


static syscallNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	if(		id == 0x00000000)	funcName = "HvxGetVersions";
	else if(id == 0x00000001)	funcName = "HvxStartupProcessors";
	else if(id == 0x00000002)	funcName = "HvxQuiesceProcessor";
	else if(id == 0x00000003)	funcName = "HvxFlushEntireTb";
	else if(id == 0x00000004)	funcName = "HvxFlushSingleTb";
	else if(id == 0x00000005)	funcName = "HvxRelocateAndFlush";
	else if(id == 0x00000006)	funcName = "HvxGetSpecialPurposeRegister";
	else if(id == 0x00000007)	funcName = "HvxSetSpecialPurposeRegister";
	else if(id == 0x00000008)	funcName = "HvxGetSocRegister";
	else if(id == 0x00000009)	funcName = "HvxSetSocRegister";
	else if(id == 0x0000000A)	funcName = "HvxSetTimeBaseToZero";
	else if(id == 0x0000000B)	funcName = "HvxZeroPage";
	else if(id == 0x0000000C)	funcName = "HvxFlushDcacheRange";
	else if(id == 0x0000000D)	funcName = "HvxPostOutput";
	else if(id == 0x0000000E)	funcName = "HvxEnablePPUPerformanceMonitor";
	else if(id == 0x0000000F)	funcName = "HvxGetImagePageTableEntry";
	else if(id == 0x00000010)	funcName = "HvxSetImagePageTableEntry";
	else if(id == 0x00000011)	funcName = "HvxCreateImageMapping";
	else if(id == 0x00000012)	funcName = "HvxMapImagePage";
	else if(id == 0x00000013)	funcName = "HvxCompleteImageMapping";
	else if(id == 0x00000014)	funcName = "HvxLoadImageData";
	else if(id == 0x00000015)	funcName = "HvxFinishImageDataLoad";
	else if(id == 0x00000016)	funcName = "HvxStartResolveImports";
	else if(id == 0x00000017)	funcName = "HvxResolveImports";
	else if(id == 0x00000018)	funcName = "HvxFinishImageLoad";
	else if(id == 0x00000019)	funcName = "HvxAbandonImageLoad";
	else if(id == 0x0000001A)	funcName = "HvxUnmapImagePages";
	else if(id == 0x0000001B)	funcName = "HvxUnmapImage";
	else if(id == 0x0000001C)	funcName = "HvxUnmapImageRange";
	else if(id == 0x0000001D)	funcName = "HvxCreateUserMode";
	else if(id == 0x0000001E)	funcName = "HvxDeleteUserMode";
	else if(id == 0x0000001F)	funcName = "HvxFlushUserModeTb";
	else if(id == 0x00000020)	funcName = "HvxSetPowerMode";
	else if(id == 0x00000021)	funcName = "HvxShadowBoot";
	else if(id == 0x00000022)	funcName = "HvxBlowFuses";
	else if(id == 0x00000023)	funcName = "HvxFsbInterrupt";
	else if(id == 0x00000024)	funcName = "HvxLockL2";
	else if(id == 0x00000025)	funcName = "HvxDvdAuthBuildNVPage";
	else if(id == 0x00000026)	funcName = "HvxDvdAuthVerifyNVPage";
	else if(id == 0x00000027)	funcName = "HvxDvdAuthRecordAuthenticationPage";
	else if(id == 0x00000028)	funcName = "HvxDvdAuthRecordXControl";
	else if(id == 0x00000029)	funcName = "HvxDvdAuthGetAuthPage";
	else if(id == 0x0000002A)	funcName = "HvxDvdAuthVerifyAuthPage";
	else if(id == 0x0000002B)	funcName = "HvxDvdAuthGetNextLBAIndex";
	else if(id == 0x0000002C)	funcName = "HvxDvdAuthVerifyLBA";
	else if(id == 0x0000002D)	funcName = "HvxDvdAuthClearDiscAuthInfo";
	else if(id == 0x0000002E)	funcName = "HvxKeysInitialize";
	else if(id == 0x0000002F)	funcName = "HvxKeysGetKeyProperties";
	else if(id == 0x00000030)	funcName = "HvxKeysGetStatus";
	else if(id == 0x00000031)	funcName = "HvxKeysGenerateRandomKey";
	else if(id == 0x00000032)	funcName = "HvxKeysGetFactoryChallenge";
	else if(id == 0x00000033)	funcName = "HvxKeysSetFactoryResponse";
	else if(id == 0x00000034)	funcName = "HvxKeysSaveBootLoader";
	else if(id == 0x00000035)	funcName = "HvxKeysSaveKeyVault";
	else if(id == 0x00000036)	funcName = "HvxKeysSetKey";
	else if(id == 0x00000037)	funcName = "HvxKeysGetKey";
	else if(id == 0x00000038)	funcName = "HvxKeysGetDigest";
	else if(id == 0x00000039)	funcName = "HvxKeysRsaPrvCrypt";
	else if(id == 0x0000003A)	funcName = "HvxKeysHmacSha";
	else if(id == 0x0000003B)	funcName = "HvxKeysAesCbc";
	else if(id == 0x0000003C)	funcName = "HvxKeysDes2Cbc";
	else if(id == 0x0000003D)	funcName = "HvxKeysDesCbc";
	else if(id == 0x0000003E)	funcName = "HvxKeysObscureKey";
	else if(id == 0x0000003F)	funcName = "HvxKeysSaveSystemUpdate";
	else if(id == 0x00000040)	funcName = "HvxKeysExecute";
	else if(id == 0x00000041)	funcName = "HvxDvdAuthTestMode";
	else if(id == 0x00000042)	funcName = "HvxEnableTimebase";
	else if(id == 0x00000043)	funcName = "HvxHdcpCalculateMi";
	else if(id == 0x00000044)	funcName = "HvxHdcpCalculateAKsvSignature";
	else if(id == 0x00000045)	funcName = "HvxHdcpCalculateBKsvSignature";
	else if(id == 0x00000046)	funcName = "HvxSetRevocationList";
	else if(id == 0x00000047)	funcName = "HvxEncryptedReserveAllocation";
	else if(id == 0x00000048)	funcName = "HvxEncryptedReleaseAllocation";
	else if(id == 0x00000049)	funcName = "HvxEncryptedEncryptAllocation";
	else if(id == 0x0000004A)	funcName = "HvxEncryptedSweepAddressRange";
	else if(id == 0x0000004B)	funcName = "HvxKeysExCreateKeyVault";
	else if(id == 0x0000004C)	funcName = "HvxKeysExLoadKeyVault";
	else if(id == 0x0000004D)	funcName = "HvxKeysExSaveKeyVault";
	else if(id == 0x0000004E)	funcName = "HvxKeysExSetKey";
	else if(id == 0x0000004F)	funcName = "HvxKeysExGetKey";
	else if(id == 0x00000050)	funcName = "HvxGetUpdateSequence";
	else if(id == 0x00000051)	funcName = "HvxSecurityInitialize";
	else if(id == 0x00000052)	funcName = "HvxSecurityLoadSettings";
	else if(id == 0x00000053)	funcName = "HvxSecuritySaveSettings";
	else if(id == 0x00000054)	funcName = "HvxSecuritySetDetected";
	else if(id == 0x00000055)	funcName = "HvxSecurityGetDetected";
	else if(id == 0x00000056)	funcName = "HvxSecuritySetActivated";
	else if(id == 0x00000057)	funcName = "HvxSecurityGetActivated";
	else if(id == 0x00000058)	funcName = "HvxSecuritySetStat";
	else if(id == 0x00000059)	funcName = "HvxGetProtectedFlags";
	else if(id == 0x0000005A)	funcName = "HvxSetProtectedFlag";
	else if(id == 0x0000005B)	funcName = "HvxDvdAuthGetAuthResults";
	else if(id == 0x0000005C)	funcName = "HvxDvdAuthSetDriveAuthResult";
	else if(id == 0x0000005D)	funcName = "HvxDvdAuthSetDiscAuthResult";
	else if(id == 0x0000005E)	funcName = "HvxImageTransformImageKey";
	else if(id == 0x0000005F)	funcName = "HvxImageXexHeader";
	else if(id == 0x00000060)	funcName = "HvxRevokeLoad";
	else if(id == 0x00000061)	funcName = "HvxRevokeSave";
	else if(id == 0x00000062)	funcName = "HvxRevokeUpdate";
	else if(id == 0x00000063)	funcName = "HvxDvdAuthGetMediaId";
	else if(id == 0x00000064)	funcName = "HvxKeysLoadKeyVault";
	else if(id == 0x00000065)	funcName = "HvxXexActivationGetNonce";
	else if(id == 0x00000066)	funcName = "HvxXexActivationSetLicense";
	else if(id == 0x00000067)	funcName = "HvxXexActivationVerifyOwnership";
	else if(id == 0x00000068)	funcName = "HvxIptvSetBoundaryKey";
	else if(id == 0x00000069)	funcName = "HvxIptvSetSessionKey";
	else if(id == 0x0000006A)	funcName = "HvxIptvVerifyOmac1Signature";
	else if(id == 0x0000006B)	funcName = "HvxIptvGetAesCtrTransform";
	else if(id == 0x0000006C)	funcName = "HvxIptvGetSessionKeyHash";
	else if(id == 0x0000006D)	funcName = "HvxImageDvdEmulationMode";
	else if(id == 0x0000006E)	funcName = "HvxImageUserMode";
	else if(id == 0x0000006F)	funcName = "HvxImageShim";
	else if(id == 0x00000070)	funcName = "HvxExpansionInstall";
	else if(id == 0x00000071)	funcName = "HvxExpansionCall";
	else if(id == 0x00000072)	funcName = "HvxDvdAuthFwcr";
	else if(id == 0x00000073)	funcName = "HvxDvdAuthFcrt";
	else if(id == 0x00000074)	funcName = "HvxDvdAuthEx";
	else if(id == 0x00000075)	funcName = "HvxTest";
	
	return funcName;
}


// UNKNOWN
static unknownNameGen(libName, version, id)
{
	auto funcName;
	funcName = form("%s_%08X", libName, id);
	
	return funcName;
}


